/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.log4jutils.logging;

import java.util.ArrayList;
import javax.mail.Message;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.helpers.LogLog;
import se.unlogic.log4jutils.logging.SMTPAppender;

public class ThrottledSMTPAppender
extends SMTPAppender {
    private long timeFrameMillis = 60000L;
    private int maxEmails = 3;
    private long sleepTimeMillis = 300000L;
    private Long enteredSleep;
    private ArrayList<Long> timestamps = new ArrayList(5);
    private String throttledMessage = "Limit reached throttling messages";

    protected boolean checkEntryConditions() {
        if (super.checkEntryConditions()) {
            long timeNowMillis = System.currentTimeMillis();
            if (this.enteredSleep == null || this.enteredSleep < timeNowMillis - this.sleepTimeMillis) {
                if (this.enteredSleep != null) {
                    this.enteredSleep = null;
                }
                if (this.timestamps.size() < this.maxEmails) {
                    this.timestamps.add(timeNowMillis);
                } else {
                    if (this.timestamps.get(0) + this.timeFrameMillis > timeNowMillis) {
                        this.enteredSleep = timeNowMillis;
                        this.timestamps.clear();
                        this.sendThrottledMessage();
                        return false;
                    }
                    this.timestamps.remove(0);
                    this.timestamps.add(timeNowMillis);
                }
                return true;
            }
        }
        return false;
    }

    protected void sendThrottledMessage() {
        try {
            MimeMessage message = new MimeMessage(this.createSession());
            this.addressMessage((Message)message);
            message.setSubject(this.getSubject());
            message.setContent((Object)this.throttledMessage, this.layout.getContentType());
            Transport.send((Message)message);
        }
        catch (Exception e) {
            LogLog.error((String)"Error occured while sending e-mail notification.", (Throwable)e);
        }
    }

    public long getTimeFrameMillis() {
        return this.timeFrameMillis;
    }

    public void setTimeFrameMillis(long timeFrameMillis) {
        this.timeFrameMillis = timeFrameMillis;
    }

    public int getMaxEmails() {
        return this.maxEmails;
    }

    public void setMaxEmails(int maxEmails) {
        this.maxEmails = maxEmails;
    }

    public long getSleepTimeMillis() {
        return this.sleepTimeMillis;
    }

    public void setSleepTimeMillis(long sleepTimeMillis) {
        this.sleepTimeMillis = sleepTimeMillis;
    }

    public Long getEnteredSleep() {
        return this.enteredSleep;
    }

    public void setEnteredSleep(Long enteredSleep) {
        this.enteredSleep = enteredSleep;
    }

    public ArrayList<Long> getTimestamps() {
        return this.timestamps;
    }

    public void setTimestamps(ArrayList<Long> timestamps) {
        this.timestamps = timestamps;
    }

    public String getThrottledMessage() {
        return this.throttledMessage;
    }

    public void setThrottledMessage(String throttledMessage) {
        this.throttledMessage = throttledMessage;
    }
}

