/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.log4jutils.logging;

import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import se.unlogic.log4jutils.logging.AllTriggeringEventEvaluator;

public class SMTPAppender
extends org.apache.log4j.net.SMTPAppender {
    private static final AllTriggeringEventEvaluator EVENT_EVALUATOR = new AllTriggeringEventEvaluator();
    private int timeout = 15000;

    public SMTPAppender() {
        this.setEvaluator(EVENT_EVALUATOR);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected Session createSession() {
        Properties props = null;
        try {
            props = new Properties(System.getProperties());
        }
        catch (SecurityException ex) {
            props = new Properties();
        }
        if (this.timeout > 0) {
            String timeoutStr = Integer.toString(this.timeout);
            props.setProperty("mail.smtp.connectiontimeout", timeoutStr);
            props.setProperty("mail.smtp.timeout", timeoutStr);
        }
        String prefix = "mail.smtp";
        if (this.getSMTPProtocol() != null) {
            props.put("mail.transport.protocol", this.getSMTPProtocol());
            prefix = "mail." + this.getSMTPProtocol();
        }
        if (this.getSMTPHost() != null) {
            props.put(prefix + ".host", this.getSMTPHost());
        }
        if (this.getSMTPPort() > 0) {
            props.put(prefix + ".port", String.valueOf(this.getSMTPPort()));
        }
        Authenticator auth = null;
        if (this.getSMTPPassword() != null && this.getSMTPUsername() != null) {
            props.put(prefix + ".auth", "true");
            auth = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(SMTPAppender.this.getSMTPUsername(), SMTPAppender.this.getSMTPPassword());
                }
            };
        }
        Session session = Session.getInstance((Properties)props, auth);
        if (this.getSMTPProtocol() != null) {
            session.setProtocolForAddress("rfc822", this.getSMTPProtocol());
        }
        if (this.getSMTPDebug()) {
            session.setDebug(this.getSMTPDebug());
        }
        return session;
    }
}

