/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.usersessionadmin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.annotations.WebPublic;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleResponse;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.exceptions.URINotFoundException;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.foregroundmodules.AnnotatedForegroundModule;
import se.unlogic.hierarchy.foregroundmodules.usersessionadmin.UserNameComparator;
import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.RequestUtils;
import se.unlogic.webutils.http.URIParser;

public class UserSessionAdminModule
extends AnnotatedForegroundModule {
    private static final UserNameComparator USERCOMPARATOR = new UserNameComparator();

    @Override
    public SimpleForegroundModuleResponse defaultMethod(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) {
        this.log.info((Object)("User " + user + " listing logged in users"));
        Document doc = this.createDocument(req, uriParser);
        Element loggedInUsers = doc.createElement("LoggedInUsers");
        doc.getFirstChild().appendChild(loggedInUsers);
        ArrayList<User> users = User.getLoggedInUsers();
        Collections.sort(users, USERCOMPARATOR);
        for (User loggedInUser : users) {
            loggedInUsers.appendChild(loggedInUser.toXML(doc));
        }
        return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb());
    }

    @WebPublic
    public SimpleForegroundModuleResponse logoutUser(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws IOException, URINotFoundException {
        Integer userID;
        if (uriParser.size() == 4 && (userID = NumberUtils.toInt((String)uriParser.get(2))) != null) {
            ArrayList<User> users = User.getLoggedInUsers();
            User requestedUser = null;
            for (User loggedInUser : users) {
                if (loggedInUser.getUserID() == null || !loggedInUser.getUserID().equals(userID)) continue;
                try {
                    if (loggedInUser.getSession() == null || !loggedInUser.getSession().getId().equals(uriParser.get(3))) continue;
                    requestedUser = loggedInUser;
                    break;
                }
                catch (IllegalStateException e) {
                    this.log.debug((Object)("Unable to access session for user " + loggedInUser));
                }
            }
            if (requestedUser != null) {
                HttpSession session = requestedUser.getSession();
                if (session != null) {
                    try {
                        session.removeAttribute("user");
                        session.invalidate();
                        this.log.info((Object)("User " + requestedUser + " logged out by user " + user));
                    }
                    catch (IllegalStateException e) {
                        this.log.debug((Object)("User " + requestedUser + " has already been logged out, " + e));
                    }
                } else {
                    this.log.debug((Object)("User " + requestedUser + " has already been logged out"));
                }
            }
            this.redirectToDefaultMethod(req, res);
            return null;
        }
        throw new URINotFoundException(uriParser);
    }

    public Document createDocument(HttpServletRequest req, URIParser uriParser) {
        Document doc = XMLUtils.createDomDocument();
        Element document = doc.createElement("Document");
        document.appendChild(RequestUtils.getRequestInfoAsXML((Document)doc, (HttpServletRequest)req, (URIParser)uriParser));
        document.appendChild(this.sectionInterface.getSectionDescriptor().toXML(doc));
        document.appendChild(((ForegroundModuleDescriptor)this.moduleDescriptor).toXML(doc));
        doc.appendChild(document);
        return doc;
    }
}

