/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.userproviders.daos;

import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.enums.UserField;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.dao.AnnotatedDAO;
import se.unlogic.standardutils.dao.AnnotatedDAOFactory;
import se.unlogic.standardutils.dao.BeanResultSetPopulator;
import se.unlogic.standardutils.dao.HighLevelQuery;
import se.unlogic.standardutils.dao.LowLevelQuery;
import se.unlogic.standardutils.dao.MySQLRowLimiter;
import se.unlogic.standardutils.dao.QueryOperators;
import se.unlogic.standardutils.dao.QueryParameterFactory;
import se.unlogic.standardutils.dao.RelationQuery;
import se.unlogic.standardutils.dao.RowLimiter;
import se.unlogic.standardutils.dao.querys.ArrayListQuery;
import se.unlogic.standardutils.dao.querys.ObjectQuery;
import se.unlogic.standardutils.enums.Order;
import se.unlogic.standardutils.populators.BeanStringPopulator;
import se.unlogic.standardutils.populators.CharacterPopulator;
import se.unlogic.standardutils.populators.IntegerPopulator;
import se.unlogic.standardutils.populators.QueryParameterPopulator;
import se.unlogic.standardutils.string.StringUtils;

public class AnnotatedUserDAO<UserType extends User>
extends AnnotatedDAO<UserType> {
    private final QueryParameterFactory<UserType, Integer> userIDParamFactory = this.getParamFactory("userID", Integer.class);
    private final QueryParameterFactory<UserType, String> usernameParamFactory = this.getParamFactory("username", String.class);
    private final QueryParameterFactory<UserType, String> passwordParamFactory = this.getParamFactory("password", String.class);
    private final QueryParameterFactory<UserType, String> emailParamFactory = this.getParamFactory("email", String.class);
    protected final QueryParameterFactory<UserType, String> firstnameParamFactory = this.getParamFactory("firstname", String.class);
    protected final QueryParameterFactory<UserType, String> lastnameParamFactory = this.getParamFactory("lastname", String.class);
    private final Field groupsRelation;
    private final Field attributesRelation;
    private final String usergroupTableName;
    private final String userAttributesTableName;
    private final String searchSQL;
    private final String emailSearchSQL;
    private final RowLimiter singleRowLimiter;

    public AnnotatedUserDAO(DataSource dataSource, Class<UserType> beanClass, AnnotatedDAOFactory daoFactory, List<QueryParameterPopulator<?>> queryParameterPopulators, List<BeanStringPopulator<?>> typePopulators, String usergroupTableName, Field groupsRelation, String userAttributesTableName, Field attributesRelation) {
        super(dataSource, beanClass, daoFactory, queryParameterPopulators, typePopulators);
        this.groupsRelation = groupsRelation;
        this.attributesRelation = attributesRelation;
        HighLevelQuery query = new HighLevelQuery();
        query.disableAutoRelations(true);
        this.usergroupTableName = usergroupTableName;
        this.userAttributesTableName = userAttributesTableName;
        this.searchSQL = this.getSearchSQL();
        this.emailSearchSQL = this.getEmailSearchSQL();
        this.singleRowLimiter = this.getSingleRowLimiter();
    }

    protected RowLimiter getSingleRowLimiter() {
        return new MySQLRowLimiter(1);
    }

    protected String getSearchSQL() {
        return "SELECT * FROM " + this.getTableName() + " WHERE @ ORDER BY " + this.firstnameParamFactory.getColumnName() + ", " + this.lastnameParamFactory.getColumnName();
    }

    protected String getEmailSearchSQL() {
        return "SELECT * FROM " + this.getTableName() + " WHERE email LIKE ? ORDER BY " + this.firstnameParamFactory.getColumnName() + ", " + this.lastnameParamFactory.getColumnName();
    }

    public UserType getUser(int userID, boolean groups, boolean attributes) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addParameter(this.userIDParamFactory.getParameter((Object)userID));
        query.setRowLimiter(this.singleRowLimiter);
        this.setQueryRelations((RelationQuery)query, groups, attributes);
        return (UserType)((User)this.get(query));
    }

    public List<UserType> getUsers(boolean groups, boolean attributes) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        this.setQueryRelations((RelationQuery)query, groups, attributes);
        return this.getAll(query);
    }

    public UserType findByUsername(String username, boolean groups, boolean attributes) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addParameter(this.usernameParamFactory.getParameter((Object)username));
        query.setRowLimiter(this.singleRowLimiter);
        this.setQueryRelations((RelationQuery)query, groups, attributes);
        return (UserType)((User)this.get(query));
    }

    public UserType findByUsernamePassword(String username, String password, boolean groups, boolean attributes) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addParameter(this.usernameParamFactory.getParameter((Object)username));
        query.addParameter(this.passwordParamFactory.getParameter((Object)password));
        query.setRowLimiter(this.singleRowLimiter);
        this.setQueryRelations((RelationQuery)query, groups, attributes);
        return (UserType)((User)this.get(query));
    }

    public UserType findByEmail(String email, boolean groups, boolean attributes) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addParameter(this.emailParamFactory.getParameter((Object)email));
        query.setRowLimiter(this.singleRowLimiter);
        this.setQueryRelations((RelationQuery)query, groups, attributes);
        return (UserType)((User)this.get(query));
    }

    public UserType findByUserID(int userID, boolean groups, boolean attributes) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addParameter(this.userIDParamFactory.getParameter((Object)userID));
        query.setRowLimiter(this.singleRowLimiter);
        this.setQueryRelations((RelationQuery)query, groups, attributes);
        return (UserType)((User)this.get(query));
    }

    public void update(UserType user, boolean updateGroups, boolean attributes) throws SQLException {
        RelationQuery query = new RelationQuery();
        this.setQueryRelations(query, updateGroups, attributes);
        this.update(user, query);
    }

    public List<UserType> getUsers(Collection<Integer> userIDList, boolean groups, boolean attributes) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addParameter(this.userIDParamFactory.getWhereInParameter(userIDList));
        this.setQueryRelations((RelationQuery)query, groups, attributes);
        return this.getAll(query);
    }

    public UserType findByEmailPassword(String email, String password, boolean groups, boolean attributes) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addParameter(this.emailParamFactory.getParameter((Object)email));
        query.addParameter(this.passwordParamFactory.getParameter((Object)password));
        query.setRowLimiter(this.singleRowLimiter);
        this.setQueryRelations((RelationQuery)query, groups, attributes);
        return (UserType)((User)this.get(query));
    }

    public Integer getDisabledUserCount() throws SQLException {
        return (Integer)new ObjectQuery(this.dataSource, "SELECT COUNT(userID) FROM " + this.getTableName() + " WHERE enabled = false", (BeanResultSetPopulator)IntegerPopulator.getPopulator()).executeQuery();
    }

    public Integer getUserCount() throws SQLException {
        return (Integer)new ObjectQuery(this.dataSource, "SELECT COUNT(userID) FROM " + this.getTableName(), (BeanResultSetPopulator)IntegerPopulator.getPopulator()).executeQuery();
    }

    public int getUserCount(Integer groupID) throws SQLException {
        ObjectQuery query = new ObjectQuery(this.dataSource, "SELECT COUNT(userID) FROM " + this.usergroupTableName + " WHERE groupID = ?", (BeanResultSetPopulator)IntegerPopulator.getPopulator());
        query.setInt(1, groupID.intValue());
        return (Integer)query.executeQuery();
    }

    public List<Character> getUserFirstLetterIndex(UserField filteringField) throws SQLException {
        return new ArrayListQuery(this.dataSource, "SELECT DISTINCT UPPER(LEFT(" + filteringField.toString().toLowerCase() + ", 1)) as letter FROM " + this.getTableName() + " ORDER BY letter ", (BeanResultSetPopulator)CharacterPopulator.getPopulator()).executeQuery();
    }

    public List<UserType> getUsers(UserField sortingField, Order order, boolean groups, boolean attributes) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addOrderByCriteria(this.getOrderByCriteria(sortingField.toString().toLowerCase(), order));
        this.setQueryRelations((RelationQuery)query, groups, attributes);
        return this.getAll(query);
    }

    public List<UserType> getUsers(UserField filteringField, Order order, char startsWith, boolean groups, boolean attributes) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        if (filteringField == UserField.EMAIL) {
            query.addParameter(this.emailParamFactory.getParameter((Object)(startsWith + "%"), QueryOperators.LIKE));
        } else if (filteringField == UserField.FIRSTNAME) {
            query.addParameter(this.firstnameParamFactory.getParameter((Object)(startsWith + "%"), QueryOperators.LIKE));
        } else if (filteringField == UserField.LASTNAME) {
            query.addParameter(this.lastnameParamFactory.getParameter((Object)(startsWith + "%"), QueryOperators.LIKE));
        } else if (filteringField == UserField.USERNAME) {
            query.addParameter(this.usernameParamFactory.getParameter((Object)(startsWith + "%"), QueryOperators.LIKE));
        }
        query.addOrderByCriteria(this.getOrderByCriteria(filteringField.toString().toLowerCase(), order));
        this.setQueryRelations((RelationQuery)query, groups, attributes);
        return this.getAll(query);
    }

    public List<UserType> searchUserEmails(String queryTerm, boolean groups, boolean attributes, Integer maxHits) throws SQLException {
        if (queryTerm.contains(" ")) {
            return null;
        }
        String searchSQL = maxHits != null ? this.emailSearchSQL + " LIMIT " + maxHits : this.emailSearchSQL;
        LowLevelQuery query = new LowLevelQuery(searchSQL);
        query.addParameter((Object)(queryTerm + "%"));
        this.setQueryRelations((RelationQuery)query, groups, attributes);
        return this.getAll(query);
    }

    public List<UserType> searchUsers(String queryTerm, boolean groups, boolean attributes, Integer maxHits) throws SQLException {
        List<UserType> emailUsers;
        String searchSQL = maxHits != null ? this.searchSQL + " LIMIT " + maxHits : this.searchSQL;
        LowLevelQuery query = new LowLevelQuery();
        this.setQueryRelations((RelationQuery)query, groups, attributes);
        String[] terms = queryTerm.split("[ ]+");
        StringBuilder paramBuilder = new StringBuilder();
        for (int i = 0; i < terms.length; ++i) {
            paramBuilder.append("(firstname LIKE ? OR lastname LIKE ?) ");
            query.addParameter((Object)("%" + terms[i] + "%"));
            query.addParameter((Object)("%" + terms[i] + "%"));
            if (terms.length - i <= 1) continue;
            paramBuilder.append(" AND ");
        }
        query.setSql(searchSQL.replaceFirst("@", paramBuilder.toString()));
        ArrayList users = this.getAll(query);
        if (terms.length == 1 && (emailUsers = this.searchUserEmails(queryTerm, groups, attributes, maxHits)) != null) {
            users = new ArrayList(CollectionUtils.combineAsSet((Collection[])new Collection[]{users, emailUsers}));
        }
        return users;
    }

    public List<UserType> getUsersByGroup(Integer groupID, boolean groups, boolean attributes) throws SQLException {
        LowLevelQuery query = new LowLevelQuery();
        query.setSql("SELECT " + this.getTableName() + ".* FROM " + this.getTableName() + " INNER JOIN " + this.usergroupTableName + " ON (" + this.getTableName() + ".userID=" + this.usergroupTableName + ".userID) WHERE " + this.usergroupTableName + ".groupID = ? ORDER BY " + this.firstnameParamFactory.getColumnName() + ", " + this.lastnameParamFactory.getColumnName());
        query.addParameter((Object)groupID);
        this.setQueryRelations((RelationQuery)query, groups, attributes);
        return this.getAll(query);
    }

    public List<UserType> getUsersByGroups(Collection<Integer> groupIDs, boolean attributes) throws SQLException {
        LowLevelQuery query = new LowLevelQuery();
        query.setSql("SELECT " + this.getTableName() + ".* FROM " + this.getTableName() + " INNER JOIN " + this.usergroupTableName + " ON (" + this.getTableName() + ".userID=" + this.usergroupTableName + ".userID) WHERE " + this.usergroupTableName + ".groupID IN (?" + StringUtils.repeatString((String)",?", (int)(groupIDs.size() - 1)) + ") ORDER BY " + this.firstnameParamFactory.getColumnName() + ", " + this.lastnameParamFactory.getColumnName());
        query.addParameters(groupIDs);
        this.setQueryRelations((RelationQuery)query, false, attributes);
        return this.getAll(query);
    }

    public List<UserType> getUsersByPasswordHashLength(int length) throws SQLException {
        LowLevelQuery query = new LowLevelQuery();
        query.setSql("SELECT * FROM " + this.getTableName() + " WHERE LENGTH(" + this.passwordParamFactory.getColumnName() + ") < ?");
        query.addParameter((Object)length);
        return this.getAll(query);
    }

    protected void setQueryRelations(RelationQuery query, boolean groups, boolean attributes) {
        if (groups && this.groupsRelation != null) {
            query.addRelation(this.groupsRelation);
        }
        if (attributes && this.attributesRelation != null) {
            query.addRelation(this.attributesRelation);
        }
    }

    public List<UserType> getUsersByAttribute(String attributeName, String attributeValue, boolean groups, boolean attributes) throws SQLException {
        if (this.userAttributesTableName == null) {
            return null;
        }
        return this.getAll(this.getUserByAttributeQuery(attributeName, attributeValue, "=", groups, attributes, false));
    }

    public UserType getUserByAttribute(String attributeName, String attributeValue, boolean groups, boolean attributes) throws SQLException {
        if (this.userAttributesTableName == null) {
            return null;
        }
        return (UserType)((User)this.get(this.getUserByAttributeQuery(attributeName, attributeValue, "=", groups, attributes, true)));
    }

    public List<UserType> getUsersByAttributeWildcard(String attributeName, String attributeValue, boolean groups, boolean attributes) throws SQLException {
        if (this.userAttributesTableName == null) {
            return null;
        }
        return this.getAll(this.getUserByAttributeQuery(attributeName, attributeValue + "%", "LIKE", groups, attributes, false));
    }

    public List<UserType> getUsersByAttribute(String attributeName, boolean groups, boolean attributes) throws SQLException {
        if (this.userAttributesTableName == null) {
            return null;
        }
        return this.getAll(this.getUsersByAttributeQuery(attributeName, groups, attributes));
    }

    protected LowLevelQuery<UserType> getUserByAttributeQuery(String attributeName, String attributeValue, String valueOperator, boolean groups, boolean attributes, boolean limit) {
        LowLevelQuery query = new LowLevelQuery();
        query.setSql("SELECT " + this.getTableName() + ".* FROM " + this.getTableName() + " INNER JOIN " + this.userAttributesTableName + " ON (" + this.getTableName() + ".userID=" + this.userAttributesTableName + ".userID) WHERE " + this.userAttributesTableName + ".name = ? AND " + this.userAttributesTableName + ".value " + valueOperator + " ?");
        if (limit) {
            query.setSql(query.getSql() + " " + this.singleRowLimiter.getLimitSQL());
        } else {
            query.setSql(query.getSql() + " ORDER BY " + this.firstnameParamFactory.getColumnName() + ", " + this.lastnameParamFactory.getColumnName());
        }
        query.addParameter((Object)attributeName);
        query.addParameter((Object)attributeValue);
        this.setQueryRelations((RelationQuery)query, groups, attributes);
        return query;
    }

    protected LowLevelQuery<UserType> getUsersByAttributeQuery(String attributeName, boolean groups, boolean attributes) {
        LowLevelQuery query = new LowLevelQuery();
        query.setSql("SELECT " + this.getTableName() + ".* FROM " + this.getTableName() + " INNER JOIN " + this.userAttributesTableName + " ON (" + this.getTableName() + ".userID=" + this.userAttributesTableName + ".userID) WHERE " + this.userAttributesTableName + ".name = ? AND " + this.userAttributesTableName + ".value IS NOT NULL ORDER BY " + this.firstnameParamFactory.getColumnName() + ", " + this.lastnameParamFactory.getColumnName());
        query.addParameter((Object)attributeName);
        this.setQueryRelations((RelationQuery)query, groups, attributes);
        return query;
    }

    public List<Character> getAttributeFirstLetterIndex(String attributeName) throws SQLException {
        if (this.userAttributesTableName == null) {
            return null;
        }
        ArrayListQuery query = new ArrayListQuery(this.dataSource, "SELECT DISTINCT UPPER(LEFT(value, 1)) as letter FROM " + this.userAttributesTableName + " WHERE name = ? ORDER BY letter ", (BeanResultSetPopulator)CharacterPopulator.getPopulator());
        query.setString(1, attributeName);
        return query.executeQuery();
    }

    public List<UserType> getUsersWithoutAttribute(String attributeName, boolean groups, boolean attributes) throws SQLException {
        LowLevelQuery query = new LowLevelQuery();
        query.setSql("SELECT * FROM " + this.getTableName() + " WHERE userID NOT IN (SELECT userID FROM " + this.userAttributesTableName + " WHERE name = ?) ORDER BY " + this.firstnameParamFactory.getColumnName() + ", " + this.lastnameParamFactory.getColumnName());
        query.addParameter((Object)attributeName);
        this.setQueryRelations((RelationQuery)query, groups, attributes);
        return this.getAll(query);
    }
}

