/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.userproviders.cruds;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.beans.Group;
import se.unlogic.hierarchy.core.beans.MutableUser;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.interfaces.MutableAttributeHandler;
import se.unlogic.hierarchy.core.interfaces.UserFormCallback;
import se.unlogic.hierarchy.core.utils.AttributeDescriptorUtils;
import se.unlogic.hierarchy.core.utils.GenericFormCRUD;
import se.unlogic.hierarchy.core.utils.ViewFragmentTransformer;
import se.unlogic.hierarchy.foregroundmodules.userproviders.AnnotatedMutableUserFormProviderModule;
import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.validation.ValidationErrorType;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.BeanRequestPopulator;
import se.unlogic.webutils.http.RequestUtils;
import se.unlogic.webutils.http.URIParser;

public class UserFormCRUD<UserType extends MutableUser, ModuleCallback extends AnnotatedMutableUserFormProviderModule<UserType>>
extends GenericFormCRUD<UserType, User, ModuleCallback, UserFormCallback> {
    public UserFormCRUD(BeanRequestPopulator<UserType> populator, String typeElementName, String typeLogName, ModuleCallback moduleCallback, ViewFragmentTransformer viewTransformer) {
        super(populator, typeElementName, typeLogName, moduleCallback, viewTransformer);
    }

    @Override
    protected void appendAddFormData(Document doc, Element addTypeElement, User user, HttpServletRequest req, URIParser uriParser, UserFormCallback formCallback) throws Exception {
        this.appendFormData(doc, addTypeElement, user, req, uriParser, formCallback);
    }

    @Override
    protected void appendUpdateFormData(UserType bean, Document doc, Element updateTypeElement, User user, HttpServletRequest req, URIParser uriParser, UserFormCallback formCallback) throws Exception {
        this.appendFormData(doc, updateTypeElement, user, req, uriParser, formCallback);
    }

    protected void appendFormData(Document doc, Element targetElement, User user, HttpServletRequest req, URIParser uriParser, UserFormCallback formCallback) {
        if (formCallback.allowGroupAdministration()) {
            XMLUtils.append((Document)doc, (Element)targetElement, (String)"Groups", formCallback.getAvailableGroups());
        }
        if (formCallback.allowAdminFlagAccess()) {
            XMLUtils.appendNewElement((Document)doc, (Element)targetElement, (String)"AllowAdminFlagAccess");
        }
        XMLUtils.append((Document)doc, (Element)targetElement, (String)"AttrbuteDescriptors", ((AnnotatedMutableUserFormProviderModule)this.moduleCallback).getSupportedAttributes());
    }

    @Override
    protected void appendShowFormData(UserType bean, Document doc, Element showTypeElement, User user, HttpServletRequest req, URIParser uriParser, UserFormCallback formCallback) throws SQLException, IOException, Exception {
        XMLUtils.append((Document)doc, (Element)showTypeElement, (String)"AttrbuteDescriptors", ((AnnotatedMutableUserFormProviderModule)this.moduleCallback).getSupportedAttributes());
    }

    @Override
    protected void validateAddPopulation(UserType bean, HttpServletRequest req, User user, URIParser uriParser, UserFormCallback formCallback) throws ValidationException, SQLException, Exception {
        if (((AnnotatedMutableUserFormProviderModule)this.moduleCallback).requirePasswordOnAdd() && StringUtils.isEmpty((String)((User)bean).getPassword())) {
            throw new ValidationException(new ValidationError[]{new ValidationError("password", ValidationErrorType.RequiredField)});
        }
        this.validatePopulation(bean, req, user, uriParser, formCallback);
        if (formCallback.allowGroupAdministration()) {
            this.setUserGroups(bean, req, formCallback);
        }
    }

    @Override
    protected void validateUpdatePopulation(UserType bean, HttpServletRequest req, User user, URIParser uriParser, UserFormCallback formCallback) throws ValidationException, SQLException, Exception {
        this.validatePopulation(bean, req, user, uriParser, formCallback);
        if (formCallback.allowGroupAdministration()) {
            this.setUserGroups(bean, req, formCallback);
        }
    }

    protected void validatePopulation(UserType bean, HttpServletRequest req, User user, URIParser uriParser, UserFormCallback formCallback) throws ValidationException {
        User emailMatch;
        User usernameMatch;
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>(3);
        if (((User)bean).getUsername() != null && (usernameMatch = ((AnnotatedMutableUserFormProviderModule)this.moduleCallback).getUserHandler().getUserByUsername(((User)bean).getUsername(), false, false)) != null && !usernameMatch.equals(bean)) {
            validationErrors.add(new ValidationError("UsernameAlreadyTaken"));
        }
        if (((User)bean).getEmail() != null && (emailMatch = ((AnnotatedMutableUserFormProviderModule)this.moduleCallback).getUserHandler().getUserByEmail(((User)bean).getEmail(), false, false)) != null && !emailMatch.equals(bean)) {
            validationErrors.add(new ValidationError("EmailAlreadyTaken"));
        }
        if (req.getParameter("password") != null && ((User)bean).getPassword() != null && !((User)bean).getPassword().equals(req.getParameter("passwordconfirmation"))) {
            validationErrors.add(new ValidationError("PasswordConfirmationMissMatch"));
        }
        this.setAttributes(bean, req, formCallback, validationErrors);
        if (!validationErrors.isEmpty()) {
            throw new ValidationException(validationErrors);
        }
        if (!formCallback.allowAdminFlagAccess()) {
            ((MutableUser)bean).setAdmin(false);
        }
    }

    protected void setUserGroups(UserType bean, HttpServletRequest req, UserFormCallback formCallback) throws SQLException {
        ArrayList groupIDList = NumberUtils.toInt((String[])req.getParameterValues("group"));
        if (groupIDList != null) {
            ArrayList<Group> groups = new ArrayList<Group>(groupIDList.size());
            for (Integer groupID : groupIDList) {
                Group group = formCallback.getGroup(groupID);
                if (group == null) continue;
                groups.add(group);
            }
            if (!groups.isEmpty()) {
                ((MutableUser)bean).setGroups(groups);
                return;
            }
        }
        ((MutableUser)bean).setGroups(null);
    }

    protected void setAttributes(UserType bean, HttpServletRequest req, UserFormCallback formCallback, List<ValidationError> validationErrors) {
        if (((AnnotatedMutableUserFormProviderModule)this.moduleCallback).getSupportedAttributes() == null) {
            return;
        }
        MutableAttributeHandler attributeHandler = ((MutableUser)bean).getAttributeHandler();
        if (attributeHandler == null) {
            return;
        }
        AttributeDescriptorUtils.populateAttributes(attributeHandler, ((AnnotatedMutableUserFormProviderModule)this.moduleCallback).getSupportedAttributes(), req, validationErrors);
    }

    @Override
    public UserType populateFromUpdateRequest(UserType bean, HttpServletRequest req, User user, URIParser uriParser, UserFormCallback formCallback) throws Exception {
        String oldPassword = ((User)bean).getPassword();
        String newPassword = ((User)(bean = (MutableUser)super.populateFromUpdateRequest(bean, req, user, uriParser, formCallback))).getPassword();
        if (newPassword == null) {
            ((MutableUser)bean).setPassword(oldPassword);
        } else if (oldPassword == null || !oldPassword.equals(newPassword)) {
            ((MutableUser)bean).setPassword(((AnnotatedMutableUserFormProviderModule)this.moduleCallback).getHashedPassword(((User)bean).getPassword()));
        }
        return (UserType)bean;
    }

    @Override
    protected void appendBean(UserType bean, Element targetElement, Document doc) {
        Element userElement = ((User)bean).toXML(doc);
        targetElement.appendChild(userElement);
        MutableAttributeHandler attributeHandler = ((MutableUser)bean).getAttributeHandler();
        if (attributeHandler != null && !attributeHandler.isEmpty()) {
            userElement.appendChild(attributeHandler.toXML(doc));
        }
    }

    @Override
    protected Document createDocument(HttpServletRequest req, URIParser uriParser, User user) {
        Document doc = XMLUtils.createDomDocument();
        Element document = doc.createElement("Document");
        document.appendChild(RequestUtils.getRequestInfoAsXML((Document)doc, (HttpServletRequest)req, (URIParser)uriParser));
        document.appendChild(((AnnotatedMutableUserFormProviderModule)this.moduleCallback).getModuleDescriptor().toXML(doc));
        doc.appendChild(document);
        return doc;
    }
}

