/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.userproviders;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import se.unlogic.hierarchy.core.beans.BaseUser;
import se.unlogic.hierarchy.core.beans.Group;
import se.unlogic.hierarchy.core.handlers.SourceAttributeHandler;
import se.unlogic.hierarchy.core.interfaces.AttributeSource;
import se.unlogic.hierarchy.foregroundmodules.userproviders.SimpleUserAttribute;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.dao.annotations.OneToMany;
import se.unlogic.standardutils.dao.annotations.SimplifiedRelation;
import se.unlogic.standardutils.dao.annotations.Table;
import se.unlogic.standardutils.reflection.ReflectionUtils;

@Table(name="simple_users")
public class SimpleUser
extends BaseUser
implements AttributeSource {
    private static final long serialVersionUID = 8229695484564353912L;
    public static final Field GROUPS_RELATION = ReflectionUtils.getField(SimpleUser.class, (String)"groups");
    public static final Field ATTRIBUTES_RELATION = ReflectionUtils.getField(SimpleUser.class, (String)"attributes");
    private SourceAttributeHandler attributeHandler;
    @DAOManaged
    @OneToMany
    @SimplifiedRelation(table="simple_user_groups", remoteKeyColumnName="userID", remoteValueColumnName="groupID")
    private List<Group> groups;
    @DAOManaged
    @OneToMany
    private List<SimpleUserAttribute> attributes;

    public List<Group> getGroups() {
        return this.groups;
    }

    @Override
    public void setGroups(List<Group> groups) {
        this.groups = groups;
    }

    @Override
    public synchronized SourceAttributeHandler getAttributeHandler() {
        if (this.attributeHandler == null) {
            this.attributeHandler = new SourceAttributeHandler(this, 255, 1024);
        }
        return this.attributeHandler;
    }

    public List<SimpleUserAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<SimpleUserAttribute> attributes) {
        this.attributes = attributes;
    }

    @Override
    public void addAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<SimpleUserAttribute>();
        }
        this.attributes.add(new SimpleUserAttribute(name, value));
    }
}

