/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.userproviders;

import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import se.unlogic.hierarchy.core.beans.MutableUser;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.interfaces.MutableUserProvider;
import se.unlogic.hierarchy.foregroundmodules.userproviders.AnnotatedUserProviderModule;
import se.unlogic.standardutils.dao.RelationQuery;
import se.unlogic.standardutils.string.StringUtils;

public abstract class AnnotatedMutableUserProviderModule<UserType extends MutableUser>
extends AnnotatedUserProviderModule<UserType>
implements MutableUserProvider {
    public AnnotatedMutableUserProviderModule(Class<UserType> userClass) {
        super(userClass);
    }

    @Override
    public void addUser(User user) throws SQLException {
        MutableUser castedUser = (MutableUser)user;
        this.preAdd(castedUser);
        this.userDAO.add(castedUser, this.getAddRelations());
        this.postAdd(castedUser);
    }

    protected RelationQuery getAddRelations() {
        RelationQuery relationQuery = new RelationQuery();
        if (this.getGroupsRelation() != null) {
            relationQuery.addRelation(this.getGroupsRelation());
        }
        if (this.getAttributesRelation() != null) {
            relationQuery.addRelation(this.getAttributesRelation());
        }
        return relationQuery;
    }

    protected void preAdd(UserType user) {
        if (((User)user).getPassword() != null) {
            ((MutableUser)user).setPassword(this.getHashedPassword(((User)user).getPassword()));
        }
    }

    protected void postAdd(UserType user) {
        this.setupUser(user, true);
    }

    @Override
    public void updateUser(User user, boolean encryptPassword, boolean updateGroups, boolean updateAttributes) throws SQLException {
        MutableUser castedUser = (MutableUser)user;
        this.preUpdate(castedUser, encryptPassword, updateGroups, updateAttributes);
        this.userDAO.update(castedUser, updateGroups, updateAttributes);
        this.postUpdate(castedUser, encryptPassword, updateGroups, updateAttributes);
    }

    protected void preUpdate(UserType user, boolean encryptPassword, boolean updateGroups, boolean updateAttributes) {
        if (encryptPassword) {
            ((MutableUser)user).setPassword(this.getHashedPassword(((User)user).getPassword()));
        }
    }

    protected void postUpdate(UserType user, boolean encryptPassword, boolean updateGroups, boolean updateAttributes) {
    }

    @Override
    public void deleteUser(User user) throws SQLException {
        this.userDAO.delete((MutableUser)user);
    }

    @Override
    public boolean canAddUserClass(Class<? extends User> userClass) {
        return this.userClass.equals(userClass);
    }

    @Override
    protected void createDAOs(DataSource dataSource) throws Exception {
        super.createDAOs(dataSource);
        this.fixPasswordHashLengths();
    }

    protected void fixPasswordHashLengths() throws SQLException {
        int length;
        if (this.passwordAlgorithm.equals("SHA-1")) {
            length = 40;
        } else if (this.passwordAlgorithm.equals("MD5")) {
            length = 32;
        } else {
            return;
        }
        List users = this.userDAO.getUsersByPasswordHashLength(length);
        if (users != null) {
            for (MutableUser user : users) {
                String password = user.getPassword();
                user.setPassword(StringUtils.repeatString((String)"0", (int)(length - password.length())) + password);
            }
            this.log.info((Object)("Correcting password hash length for " + users.size() + " users..."));
            this.userDAO.update(users, null);
        }
    }
}

