/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.userproviders;

import java.sql.SQLException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import se.unlogic.emailutils.populators.EmailPopulator;
import se.unlogic.hierarchy.core.annotations.CheckboxSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.ModuleSetting;
import se.unlogic.hierarchy.core.annotations.TextAreaSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.TextFieldSettingDescriptor;
import se.unlogic.hierarchy.core.beans.AttributeDescriptor;
import se.unlogic.hierarchy.core.beans.MutableUser;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.beans.UserTypeDescriptor;
import se.unlogic.hierarchy.core.exceptions.ModuleConfigurationException;
import se.unlogic.hierarchy.core.handlers.GroupHandler;
import se.unlogic.hierarchy.core.handlers.UserHandler;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.UserFormCallback;
import se.unlogic.hierarchy.core.interfaces.UserFormProvider;
import se.unlogic.hierarchy.core.interfaces.ViewFragment;
import se.unlogic.hierarchy.core.utils.AttributeDescriptorUtils;
import se.unlogic.hierarchy.core.utils.GenericFormCRUD;
import se.unlogic.hierarchy.core.utils.SimpleViewFragmentTransformer;
import se.unlogic.hierarchy.core.utils.ViewFragmentTransformer;
import se.unlogic.hierarchy.foregroundmodules.userproviders.AnnotatedMutableUserProviderModule;
import se.unlogic.hierarchy.foregroundmodules.userproviders.cruds.UserFormCRUD;
import se.unlogic.standardutils.populators.BeanStringPopulator;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.webutils.http.BeanRequestPopulator;
import se.unlogic.webutils.http.URIParser;
import se.unlogic.webutils.populators.annotated.AnnotatedRequestPopulator;

public abstract class AnnotatedMutableUserFormProviderModule<UserType extends MutableUser>
extends AnnotatedMutableUserProviderModule<UserType>
implements UserFormProvider {
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Form XSL stylesheet", description="The path in classpath relative from this class to the XSL stylesheet used to transform the add and update forms", required=true)
    protected String formStyleSheet = this.getDefaultFormStyleSheet();
    @ModuleSetting
    @CheckboxSettingDescriptor(name="Include debug data", description="Controls whether or not debug data should be included in the view fragments objects")
    protected boolean includeDebugData = false;
    @ModuleSetting
    @CheckboxSettingDescriptor(name="List as addable user type", description="Controls if this user type is listed as a form addable user type in the user handler")
    protected boolean listAsAddableType = true;
    @ModuleSetting
    @TextFieldSettingDescriptor(name="User type name", description="The name of this user type")
    protected String userTypeName = this.userClass.getSimpleName();
    @ModuleSetting(allowsNull=true)
    @TextAreaSettingDescriptor(name="Supported attributes", description="The attributes to show in the form. The format is [name][*/!]:[display name]:[max length]:[StringFormatValidator] (without brackets). Only the name is required. The * sign indicates if the attribute is required or not. The ! sign indicates that the attribute is read only")
    protected String supportedAttributes;
    protected List<AttributeDescriptor> attributes;
    protected UserTypeDescriptor userTypeDescriptor;
    protected GenericFormCRUD<UserType, User, ?, UserFormCallback> userFormCRUD;

    public AnnotatedMutableUserFormProviderModule(Class<UserType> userClass) {
        super(userClass);
    }

    protected abstract String getDefaultFormStyleSheet();

    @Override
    protected void moduleConfigured() throws Exception {
        super.moduleConfigured();
        this.userFormCRUD = this.createUserFormCRUD();
        this.userTypeDescriptor = new UserTypeDescriptor(this.userClass.getSimpleName().toString() + "-" + ((ForegroundModuleDescriptor)this.moduleDescriptor).getModuleID(), this.userTypeName);
        this.attributes = AttributeDescriptorUtils.parseAttributes(this.supportedAttributes);
    }

    protected GenericFormCRUD<UserType, User, ?, UserFormCallback> createUserFormCRUD() {
        SimpleViewFragmentTransformer fragmentTransformer;
        try {
            fragmentTransformer = new SimpleViewFragmentTransformer(this.formStyleSheet, this.systemInterface.getEncoding(), this.getClass(), (ForegroundModuleDescriptor)this.moduleDescriptor, this.sectionInterface);
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to parse XSL stylesheet for user forms in module " + this.moduleDescriptor), (Throwable)e);
            return null;
        }
        fragmentTransformer.setDebugXML(this.includeDebugData);
        BeanRequestPopulator<UserType> populator = this.getPopulator();
        return new UserFormCRUD<UserType, AnnotatedMutableUserFormProviderModule>(populator, "User", "user", this, (ViewFragmentTransformer)fragmentTransformer);
    }

    protected BeanRequestPopulator<UserType> getPopulator() {
        return new AnnotatedRequestPopulator(this.userClass, new BeanStringPopulator[]{new EmailPopulator()});
    }

    @Override
    public UserTypeDescriptor getAddableUserType() {
        if (this.listAsAddableType) {
            return this.userTypeDescriptor;
        }
        return null;
    }

    public void updateUser(UserType user) throws SQLException {
        this.updateUser((User)user, true, true, true);
    }

    public GroupHandler getGroupHandler() {
        return this.systemInterface.getGroupHandler();
    }

    public UserHandler getUserHandler() {
        return this.systemInterface.getUserHandler();
    }

    @Override
    public ViewFragment getAddForm(HttpServletRequest req, User user, URIParser uriParser, ValidationException validationException, UserFormCallback callback) throws Exception {
        this.checkCRUD();
        return this.userFormCRUD.showAddForm(req, user, uriParser, validationException, callback);
    }

    @Override
    public ViewFragment getUpdateForm(User bean, HttpServletRequest req, User user, URIParser uriParser, ValidationException validationException, UserFormCallback callback) throws Exception {
        this.checkCRUD();
        return this.userFormCRUD.showUpdateForm((MutableUser)bean, req, user, uriParser, validationException, callback);
    }

    @Override
    public User populate(HttpServletRequest req, User user, URIParser uriParser, UserFormCallback callback) throws Exception {
        this.checkCRUD();
        return (User)this.userFormCRUD.populateFromAddRequest(req, user, uriParser, callback);
    }

    @Override
    public User populate(User bean, HttpServletRequest req, User user, URIParser uriParser, UserFormCallback callback) throws Exception {
        this.checkCRUD();
        return this.userFormCRUD.populateFromUpdateRequest((MutableUser)bean, req, user, uriParser, callback);
    }

    @Override
    public ViewFragment getBeanView(User requestedUser, HttpServletRequest req, User user, URIParser uriParser, UserFormCallback callback) throws Exception {
        this.checkCRUD();
        return this.userFormCRUD.showBean((MutableUser)requestedUser, req, user, uriParser, null, callback);
    }

    protected void checkCRUD() throws ModuleConfigurationException {
        if (this.userFormCRUD == null) {
            throw new ModuleConfigurationException("Module is not properly configured, check module settings");
        }
    }

    public List<AttributeDescriptor> getSupportedAttributes() {
        return this.attributes;
    }

    @Override
    public void add(User user, UserFormCallback callback) throws Exception {
        this.addUser(user);
    }

    @Override
    public void update(User user, UserFormCallback callback) throws Exception {
        this.updateUser(user, false, callback.allowGroupAdministration(), true);
    }

    public ForegroundModuleDescriptor getModuleDescriptor() {
        return (ForegroundModuleDescriptor)this.moduleDescriptor;
    }

    public boolean requirePasswordOnAdd() {
        return true;
    }
}

