/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.userprofile;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.emailutils.populators.EmailPopulator;
import se.unlogic.hierarchy.core.annotations.CheckboxSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.EnumDropDownSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.ModuleSetting;
import se.unlogic.hierarchy.core.annotations.TextAreaSettingDescriptor;
import se.unlogic.hierarchy.core.beans.AttributeDescriptor;
import se.unlogic.hierarchy.core.beans.MutableUser;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleResponse;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.MutableAttributeHandler;
import se.unlogic.hierarchy.core.utils.AttributeDescriptorUtils;
import se.unlogic.hierarchy.foregroundmodules.AnnotatedForegroundModule;
import se.unlogic.hierarchy.foregroundmodules.userprofile.FieldMode;
import se.unlogic.standardutils.populators.BeanStringPopulator;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.Elementable;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.RequestUtils;
import se.unlogic.webutils.http.URIParser;
import se.unlogic.webutils.validation.ValidationUtils;

public class UserProfileModule
extends AnnotatedForegroundModule {
    @ModuleSetting
    @EnumDropDownSettingDescriptor(name="Username field", description="Controls the behaivor of the username field.", required=true)
    protected FieldMode usernameFieldMode = FieldMode.DISABLED;
    @ModuleSetting
    @EnumDropDownSettingDescriptor(name="Firstname field", description="Controls the behaivor of the firstname field.", required=true)
    protected FieldMode firstnameFieldMode = FieldMode.DISABLED;
    @ModuleSetting
    @EnumDropDownSettingDescriptor(name="Lastname field", description="Controls the behaivor of the lastname field.", required=true)
    protected FieldMode lastnameFieldMode = FieldMode.DISABLED;
    @ModuleSetting
    @EnumDropDownSettingDescriptor(name="E-mail field", description="Controls the behaivor of the email field.", required=true)
    protected FieldMode emailFieldMode = FieldMode.DISABLED;
    @ModuleSetting
    @CheckboxSettingDescriptor(name="Change password", description="Controls if the users can change password")
    protected boolean allowPasswordChanging = false;
    @ModuleSetting(allowsNull=true)
    @TextAreaSettingDescriptor(name="Supported attributes", description="The attributes to show in the form. The format is [name][*/!]:[display name]:[max length]:[StringFormatValidator] (without brackets). Only the name is required. The * sign indicates if the attribute is required or not. The ! sign indicates that the attribute is read only")
    protected String supportedAttributes;
    protected List<AttributeDescriptor> attributes;

    @Override
    protected void moduleConfigured() throws Exception {
        super.moduleConfigured();
        this.attributes = AttributeDescriptorUtils.parseAttributes(this.supportedAttributes);
    }

    @Override
    public SimpleForegroundModuleResponse defaultMethod(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        User requestedUser;
        if (user == null || (requestedUser = this.systemInterface.getUserHandler().getUser(user.getUserID(), true, true)) == null) {
            Document doc = this.createDocument(req, uriParser);
            Element updateUserElement = doc.createElement("UserNotFound");
            doc.getFirstChild().appendChild(updateUserElement);
            return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb());
        }
        boolean mutable = requestedUser instanceof MutableUser;
        MutableAttributeHandler attributeHandler = mutable ? ((MutableUser)requestedUser).getAttributeHandler() : null;
        boolean userUpdated = false;
        ValidationException validationException = null;
        if (mutable && req.getMethod().equalsIgnoreCase("POST")) {
            MutableUser mutableUser = (MutableUser)requestedUser;
            ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
            if (this.isPopulatable(this.usernameFieldMode)) {
                User usernameMatch;
                String username = ValidationUtils.validateParameter((String)"username", (HttpServletRequest)req, (this.usernameFieldMode == FieldMode.REQUIRED ? 1 : 0) != 0, null, (Integer)40, validationErrors);
                if (username != null && (usernameMatch = this.systemInterface.getUserHandler().getUserByUsername(username, false, false)) != null && !usernameMatch.equals(mutableUser)) {
                    validationErrors.add(new ValidationError("UsernameAlreadyTaken"));
                }
                if (validationErrors.isEmpty()) {
                    mutableUser.setUsername(username);
                }
            }
            if (this.isPopulatable(this.emailFieldMode)) {
                User emailMatch;
                String email = (String)ValidationUtils.validateParameter((String)"email", (HttpServletRequest)req, (this.emailFieldMode == FieldMode.REQUIRED ? 1 : 0) != 0, null, (Integer)255, (BeanStringPopulator)new EmailPopulator(), validationErrors);
                if (email != null && (emailMatch = this.systemInterface.getUserHandler().getUserByEmail(email, false, false)) != null && !emailMatch.equals(mutableUser)) {
                    validationErrors.add(new ValidationError("EmailAlreadyTaken"));
                }
                if (validationErrors.isEmpty()) {
                    mutableUser.setEmail(email);
                }
            }
            if (this.isPopulatable(this.firstnameFieldMode)) {
                String firstname = ValidationUtils.validateParameter((String)"firstname", (HttpServletRequest)req, (this.firstnameFieldMode == FieldMode.REQUIRED ? 1 : 0) != 0, null, (Integer)30, validationErrors);
                if (validationErrors.isEmpty()) {
                    mutableUser.setFirstname(firstname);
                }
            }
            if (this.isPopulatable(this.lastnameFieldMode)) {
                String lastname = ValidationUtils.validateParameter((String)"lastname", (HttpServletRequest)req, (this.lastnameFieldMode == FieldMode.REQUIRED ? 1 : 0) != 0, null, (Integer)40, validationErrors);
                if (validationErrors.isEmpty()) {
                    mutableUser.setLastname(lastname);
                }
            }
            boolean passwordChanged = false;
            if (this.allowPasswordChanging && req.getParameter("changepassword") != null) {
                String passwordConfirmation;
                String password = ValidationUtils.validateParameter((String)"password", (HttpServletRequest)req, (boolean)true, null, (Integer)255, validationErrors);
                if (!(password == null || (passwordConfirmation = req.getParameter("passwordconfirmation")) != null && passwordConfirmation.equals(password))) {
                    validationErrors.add(new ValidationError("PasswordConfirmationMissMatch"));
                }
                if (validationErrors.isEmpty()) {
                    mutableUser.setPassword(password);
                    passwordChanged = true;
                }
            }
            AttributeDescriptorUtils.populateAttributes(attributeHandler, this.attributes, req, validationErrors);
            if (!validationErrors.isEmpty()) {
                validationException = new ValidationException(validationErrors);
            } else {
                this.log.info((Object)("User " + user + " updating user profile, new values " + requestedUser));
                req.getSession(true).setAttribute("user", (Object)requestedUser);
                this.systemInterface.getUserHandler().updateUser(mutableUser, passwordChanged, false, true);
                userUpdated = true;
            }
        }
        this.log.info((Object)("User " + requestedUser + " viewing user profile"));
        Document doc = this.createDocument(req, uriParser);
        Element updateUserElement = doc.createElement("UpdateUser");
        doc.getFirstChild().appendChild(updateUserElement);
        if (userUpdated) {
            updateUserElement.appendChild(doc.createElement("UserUpdated"));
        }
        if (!mutable) {
            XMLUtils.appendNewElement((Document)doc, (Element)updateUserElement, (String)"UserNotMutable");
        }
        XMLUtils.appendNewElement((Document)doc, (Element)updateUserElement, (String)"UsernameFieldMode", (Object)((Object)this.usernameFieldMode));
        XMLUtils.appendNewElement((Document)doc, (Element)updateUserElement, (String)"FirstnameFieldMode", (Object)((Object)this.firstnameFieldMode));
        XMLUtils.appendNewElement((Document)doc, (Element)updateUserElement, (String)"LastnameFieldMode", (Object)((Object)this.lastnameFieldMode));
        XMLUtils.appendNewElement((Document)doc, (Element)updateUserElement, (String)"EmailFieldMode", (Object)((Object)this.emailFieldMode));
        if (this.allowPasswordChanging) {
            XMLUtils.appendNewElement((Document)doc, (Element)updateUserElement, (String)"AllowPasswordChanging");
        }
        XMLUtils.append((Document)doc, (Element)updateUserElement, (String)"AttrbuteDescriptors", this.attributes);
        Element userElement = requestedUser.toXML(doc);
        XMLUtils.append((Document)doc, (Element)userElement, (Elementable)attributeHandler);
        updateUserElement.appendChild(userElement);
        if (validationException != null) {
            updateUserElement.appendChild(validationException.toXML(doc));
            updateUserElement.appendChild(RequestUtils.getRequestParameters((HttpServletRequest)req, (Document)doc));
        }
        return new SimpleForegroundModuleResponse(doc, userUpdated, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb());
    }

    private boolean isPopulatable(FieldMode fieldMode) {
        return fieldMode == FieldMode.OPTIONAL || fieldMode == FieldMode.REQUIRED;
    }

    public Document createDocument(HttpServletRequest req, URIParser uriParser) {
        Document doc = XMLUtils.createDomDocument();
        Element document = doc.createElement("Document");
        document.appendChild(RequestUtils.getRequestInfoAsXML((Document)doc, (HttpServletRequest)req, (URIParser)uriParser));
        document.appendChild(((ForegroundModuleDescriptor)this.moduleDescriptor).toXML(doc));
        doc.appendChild(document);
        return doc;
    }
}

