/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.togglemodule;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.annotations.CheckboxSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.GroupMultiListSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.ModuleSetting;
import se.unlogic.hierarchy.core.annotations.TextAreaSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.UserMultiListSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.WebPublic;
import se.unlogic.hierarchy.core.beans.SimpleBackgroundModuleDescriptor;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleResponse;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.enums.ModuleType;
import se.unlogic.hierarchy.core.exceptions.URINotFoundException;
import se.unlogic.hierarchy.core.interfaces.BackgroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleResponse;
import se.unlogic.hierarchy.core.interfaces.ModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.foregroundmodules.AnnotatedForegroundModule;
import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.RequestUtils;
import se.unlogic.webutils.http.URIParser;

public class ToggleModule
extends AnnotatedForegroundModule {
    @ModuleSetting(allowsNull=true)
    @GroupMultiListSettingDescriptor(name="Admin groups", description="Groups allowed to administrate this module")
    protected List<Integer> adminGroupIDs;
    @ModuleSetting(allowsNull=true)
    @UserMultiListSettingDescriptor(name="Admin users", description="Users allowed to administrate this module")
    protected List<Integer> adminUserIDs;
    @ModuleSetting(allowsNull=true)
    @TextAreaSettingDescriptor(description="List of background module IDs, one per row", name="Background Module IDs")
    private List<Integer> backgroundModuleIDs;
    @ModuleSetting(allowsNull=true)
    @TextAreaSettingDescriptor(description="List of foreground module IDs, one per row", name="Foreground Module IDs")
    private List<Integer> foregroundModuleIDs;
    @ModuleSetting
    @CheckboxSettingDescriptor(description="Should changes to module be persistent after server restart", name="Persist changes")
    private boolean persistChanges = true;

    @Override
    public synchronized ForegroundModuleResponse defaultMethod(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        this.log.info((Object)("User " + user + " opened toggle module view"));
        if (this.backgroundModuleIDs == null || this.foregroundModuleIDs == null) {
            Document doc = this.createDocument(req, uriParser, user);
            Element listSettingsElement = doc.createElement("ListModules");
            doc.getFirstChild().appendChild(listSettingsElement);
            listSettingsElement.appendChild(doc.createElement("ModuleNotConfigured"));
            return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb());
        }
        ArrayList<ModuleDescriptor> backgroundModuleDescriptors = new ArrayList<ModuleDescriptor>();
        for (Integer n : this.backgroundModuleIDs) {
            ModuleDescriptor moduleDescriptor = this.getModule(n, ModuleType.BACKGROUND);
            if (moduleDescriptor != null) {
                backgroundModuleDescriptors.add(moduleDescriptor);
                continue;
            }
            this.log.warn((Object)("Background module with id " + n + " not found."));
        }
        ArrayList<ModuleDescriptor> foregroundModuleDescriptors = new ArrayList<ModuleDescriptor>();
        for (Integer foregroundModuleId : this.foregroundModuleIDs) {
            ModuleDescriptor moduleDescriptor = this.getModule(foregroundModuleId, ModuleType.FOREGROUND);
            if (moduleDescriptor != null) {
                foregroundModuleDescriptors.add(moduleDescriptor);
                continue;
            }
            this.log.warn((Object)("Foreground module with id " + foregroundModuleId + " not found."));
        }
        Document document = this.createDocument(req, uriParser, user);
        Element listModulesElement = document.createElement("ListModules");
        document.getFirstChild().appendChild(listModulesElement);
        Element backgroundModulesElement = document.createElement("BackgroundModules");
        for (ModuleDescriptor moduleDescriptor : backgroundModuleDescriptors) {
            Element moduleDescriptorElement = moduleDescriptor.toXML(document);
            SectionInterface sectionInterface = this.systemInterface.getSectionInterface(((BackgroundModuleDescriptor)moduleDescriptor).getSectionID());
            if (sectionInterface == null) {
                moduleDescriptorElement.appendChild(XMLUtils.createElement((String)"SectionNotStarted", (Object)"", (Document)document));
            } else if (!sectionInterface.getBackgroundModuleCache().getCachedModuleDescriptors().contains(moduleDescriptor)) {
                moduleDescriptorElement.appendChild(XMLUtils.createElement((String)"ModuleNotStarted", (Object)"", (Document)document));
            }
            backgroundModulesElement.appendChild(moduleDescriptorElement);
        }
        listModulesElement.appendChild(backgroundModulesElement);
        Element foregroundModulesElement = document.createElement("ForegroundModules");
        for (ModuleDescriptor moduleDescriptor : foregroundModuleDescriptors) {
            Element moduleDescriptorElement = moduleDescriptor.toXML(document);
            SectionInterface sectionInterface = this.systemInterface.getSectionInterface(((ForegroundModuleDescriptor)moduleDescriptor).getSectionID());
            if (sectionInterface == null) {
                moduleDescriptorElement.appendChild(XMLUtils.createElement((String)"SectionNotStarted", (Object)"", (Document)document));
            } else if (!sectionInterface.getForegroundModuleCache().getCachedModuleDescriptors().contains(moduleDescriptor)) {
                moduleDescriptorElement.appendChild(XMLUtils.createElement((String)"ModuleNotStarted", (Object)"", (Document)document));
            }
            foregroundModulesElement.appendChild(moduleDescriptorElement);
        }
        listModulesElement.appendChild(foregroundModulesElement);
        return new SimpleForegroundModuleResponse(document, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb());
    }

    private ModuleDescriptor getModule(Integer moduleID, ModuleType moduleType) throws SQLException {
        if (moduleType.equals((Object)ModuleType.BACKGROUND)) {
            return this.systemInterface.getCoreDaoFactory().getBackgroundModuleDAO().getModule(moduleID);
        }
        if (moduleType.equals((Object)ModuleType.FOREGROUND)) {
            return this.systemInterface.getCoreDaoFactory().getForegroundModuleDAO().getModule(moduleID);
        }
        throw new RuntimeException("Unknown module type " + (Object)((Object)moduleType));
    }

    @WebPublic(alias="startbackgroundmodule")
    public SimpleForegroundModuleResponse startBackgroundModule(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws IOException, SQLException, URINotFoundException {
        SimpleBackgroundModuleDescriptor moduleDescriptor = null;
        if (uriParser.size() == 3 && NumberUtils.isInt((String)uriParser.get(2)) && (moduleDescriptor = (SimpleBackgroundModuleDescriptor)this.getModule(Integer.parseInt(uriParser.get(2)), ModuleType.BACKGROUND)) != null) {
            SectionInterface sectionInterface = this.systemInterface.getSectionInterface(moduleDescriptor.getSectionID());
            if (sectionInterface == null) {
                this.log.info((Object)("User " + user + " tried to cache background module " + moduleDescriptor + " in non-cached section " + this.systemInterface.getCoreDaoFactory().getSectionDAO().getSection((int)moduleDescriptor.getSectionID(), false)));
            } else if (sectionInterface.getBackgroundModuleCache().isCached(moduleDescriptor)) {
                this.log.info((Object)("User " + user + " tried to cache background module " + moduleDescriptor + " which is already cached in section " + sectionInterface.getSectionDescriptor()));
            } else {
                try {
                    this.log.info((Object)("User " + user + " caching background module " + moduleDescriptor + " in section " + sectionInterface.getSectionDescriptor()));
                    sectionInterface.getBackgroundModuleCache().cache(moduleDescriptor);
                    if (this.persistChanges) {
                        moduleDescriptor.setEnabled(true);
                        this.systemInterface.getCoreDaoFactory().getBackgroundModuleDAO().update(moduleDescriptor);
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)("Error caching background module " + moduleDescriptor + " in section " + sectionInterface.getSectionDescriptor() + " requested by user " + user), (Throwable)e);
                }
            }
        }
        res.sendRedirect(this.getModuleURI(req));
        return null;
    }

    @WebPublic(alias="stopbackgroundmodule")
    public SimpleForegroundModuleResponse stopBackgroundModule(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws URINotFoundException, SQLException, IOException {
        SimpleBackgroundModuleDescriptor moduleDescriptor = null;
        if (uriParser.size() == 3 && NumberUtils.isInt((String)uriParser.get(2)) && (moduleDescriptor = (SimpleBackgroundModuleDescriptor)this.getModule(Integer.parseInt(uriParser.get(2)), ModuleType.BACKGROUND)) != null) {
            SectionInterface sectionInterface = this.systemInterface.getSectionInterface(moduleDescriptor.getSectionID());
            if (sectionInterface == null) {
                this.log.info((Object)("User " + user + " tried to unload background module " + moduleDescriptor + " in non-cached section " + this.systemInterface.getCoreDaoFactory().getSectionDAO().getSection((int)moduleDescriptor.getSectionID(), false)));
            } else if (!sectionInterface.getBackgroundModuleCache().isCached(moduleDescriptor)) {
                this.log.info((Object)("User " + user + " tried to unload uncached background module " + moduleDescriptor + " in section " + sectionInterface.getSectionDescriptor()));
            } else {
                try {
                    this.log.info((Object)("User " + user + " unloading background module " + moduleDescriptor + " in section " + sectionInterface.getSectionDescriptor()));
                    sectionInterface.getBackgroundModuleCache().unload(moduleDescriptor);
                    if (this.persistChanges) {
                        moduleDescriptor.setEnabled(false);
                        this.systemInterface.getCoreDaoFactory().getBackgroundModuleDAO().update(moduleDescriptor);
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)("Error unloading background module " + moduleDescriptor + " in section " + sectionInterface.getSectionDescriptor() + " requested by user " + user));
                }
            }
        }
        res.sendRedirect(this.getModuleURI(req));
        return null;
    }

    @WebPublic(alias="startforegroundmodule")
    public SimpleForegroundModuleResponse startForegroundModule(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws IOException, SQLException, URINotFoundException {
        SimpleForegroundModuleDescriptor moduleDescriptor = null;
        if (uriParser.size() == 3 && NumberUtils.isInt((String)uriParser.get(2)) && (moduleDescriptor = (SimpleForegroundModuleDescriptor)this.getModule(Integer.parseInt(uriParser.get(2)), ModuleType.FOREGROUND)) != null) {
            SectionInterface sectionInterface = this.systemInterface.getSectionInterface(moduleDescriptor.getSectionID());
            if (sectionInterface == null) {
                this.log.info((Object)("User " + user + " tried to cache foreground module " + moduleDescriptor + " in non-cached section " + this.systemInterface.getCoreDaoFactory().getSectionDAO().getSection((int)moduleDescriptor.getSectionID(), false)));
            } else if (sectionInterface.getForegroundModuleCache().isCached(moduleDescriptor)) {
                this.log.info((Object)("User " + user + " tried to cache foreground module " + moduleDescriptor + " which is already cached in section " + sectionInterface.getSectionDescriptor()));
            } else {
                try {
                    this.log.info((Object)("User " + user + " caching foreground module " + moduleDescriptor + " in section " + sectionInterface.getSectionDescriptor()));
                    sectionInterface.getForegroundModuleCache().cache(moduleDescriptor);
                    if (this.persistChanges) {
                        moduleDescriptor.setEnabled(true);
                        this.systemInterface.getCoreDaoFactory().getForegroundModuleDAO().update(moduleDescriptor);
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)("Error caching foreground module " + moduleDescriptor + " in section " + sectionInterface.getSectionDescriptor() + " requested by user " + user), (Throwable)e);
                }
            }
        }
        res.sendRedirect(this.getModuleURI(req));
        return null;
    }

    @WebPublic(alias="stopforegroundmodule")
    public SimpleForegroundModuleResponse stopForegroundModule(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws URINotFoundException, SQLException, IOException {
        SimpleForegroundModuleDescriptor moduleDescriptor = null;
        if (uriParser.size() == 3 && NumberUtils.isInt((String)uriParser.get(2)) && (moduleDescriptor = (SimpleForegroundModuleDescriptor)this.getModule(Integer.parseInt(uriParser.get(2)), ModuleType.FOREGROUND)) != null) {
            SectionInterface sectionInterface = this.systemInterface.getSectionInterface(moduleDescriptor.getSectionID());
            if (sectionInterface == null) {
                this.log.info((Object)("User " + user + " tried to unload foreground module " + moduleDescriptor + " in non-cached section " + this.systemInterface.getCoreDaoFactory().getSectionDAO().getSection((int)moduleDescriptor.getSectionID(), false)));
            } else if (!sectionInterface.getForegroundModuleCache().isCached(moduleDescriptor)) {
                this.log.info((Object)("User " + user + " tried to unload uncached foreground module " + moduleDescriptor + " in section " + sectionInterface.getSectionDescriptor()));
            } else {
                try {
                    this.log.info((Object)("User " + user + " unloading foreground module " + moduleDescriptor + " in section " + sectionInterface.getSectionDescriptor()));
                    sectionInterface.getForegroundModuleCache().unload(moduleDescriptor);
                    if (this.persistChanges) {
                        moduleDescriptor.setEnabled(false);
                        this.systemInterface.getCoreDaoFactory().getForegroundModuleDAO().update(moduleDescriptor);
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)("Error unloading foreground module " + moduleDescriptor + " in section " + sectionInterface.getSectionDescriptor() + " requested by user " + user));
                }
            }
        }
        res.sendRedirect(this.getModuleURI(req));
        return null;
    }

    public Document createDocument(HttpServletRequest req, URIParser uriParser, User user) {
        Document doc = XMLUtils.createDomDocument();
        Element documentElement = doc.createElement("Document");
        doc.appendChild(documentElement);
        documentElement.appendChild(RequestUtils.getRequestInfoAsXML((Document)doc, (HttpServletRequest)req, (URIParser)uriParser));
        documentElement.appendChild(((ForegroundModuleDescriptor)this.moduleDescriptor).toXML(doc));
        if (user != null) {
            documentElement.appendChild(user.toXML(doc));
        }
        return doc;
    }
}

