/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.threadinfo;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.annotations.WebPublic;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleResponse;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.foregroundmodules.AnnotatedForegroundModule;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.threads.ThreadUtils;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.RequestUtils;
import se.unlogic.webutils.http.URIParser;

public class ThreadInfoModule
extends AnnotatedForegroundModule {
    protected static final String INTERRUPT_OPERATION = "interrupted";
    protected static final String STOP_OPERATION = "stopped";

    @Override
    public SimpleForegroundModuleResponse defaultMethod(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        return this.list(req, res, user, uriParser, null, null, null);
    }

    public SimpleForegroundModuleResponse list(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser, ValidationError validationError, String operation, String threadName) throws Exception {
        this.log.info((Object)("User " + user + " listing threads"));
        Document doc = XMLUtils.createDomDocument();
        Element documentElement = doc.createElement("document");
        doc.appendChild(documentElement);
        documentElement.appendChild(((ForegroundModuleDescriptor)this.moduleDescriptor).toXML(doc));
        documentElement.appendChild(RequestUtils.getRequestInfoAsXML((Document)doc, (HttpServletRequest)req, (URIParser)uriParser, (boolean)false, (boolean)false));
        if (validationError != null) {
            documentElement.appendChild(validationError.toXML(doc));
        } else if (operation != null) {
            XMLUtils.appendNewCDATAElement((Document)doc, (Element)documentElement, (String)operation, (String)threadName);
        }
        documentElement.appendChild(XMLUtils.createCDATAElement((String)"activeThreads", (Object)(Thread.activeCount() + ""), (Document)doc));
        Element threadsElement = doc.createElement("threads");
        documentElement.appendChild(threadsElement);
        Map<Thread, StackTraceElement[]> threadMap = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : threadMap.entrySet()) {
            Element thread = doc.createElement("thread");
            threadsElement.appendChild(thread);
            thread.appendChild(XMLUtils.createCDATAElement((String)"name", (Object)entry.getKey().getName(), (Document)doc));
            thread.appendChild(XMLUtils.createCDATAElement((String)"priority", (Object)(entry.getKey().getPriority() + ""), (Document)doc));
            thread.appendChild(XMLUtils.createCDATAElement((String)"alive", (Object)(entry.getKey().isAlive() + ""), (Document)doc));
            thread.appendChild(XMLUtils.createCDATAElement((String)"daemon", (Object)(entry.getKey().isDaemon() + ""), (Document)doc));
            thread.appendChild(XMLUtils.createCDATAElement((String)INTERRUPT_OPERATION, (Object)(entry.getKey().isInterrupted() + ""), (Document)doc));
            Element stacktrace = doc.createElement("stacktrace");
            thread.appendChild(stacktrace);
            if (entry.getValue() == null || entry.getValue().length <= 0) continue;
            for (StackTraceElement stackTraceElement : entry.getValue()) {
                Element traceElement = doc.createElement("stackTraceElement");
                stacktrace.appendChild(traceElement);
                traceElement.appendChild(XMLUtils.createCDATAElement((String)"className", (Object)stackTraceElement.getClassName(), (Document)doc));
                traceElement.appendChild(XMLUtils.createCDATAElement((String)"fileName", (Object)(stackTraceElement.getFileName() + ""), (Document)doc));
                traceElement.appendChild(XMLUtils.createCDATAElement((String)"methodName", (Object)(stackTraceElement.getMethodName() + ""), (Document)doc));
                traceElement.appendChild(XMLUtils.createCDATAElement((String)"lineNumber", (Object)(stackTraceElement.getLineNumber() + ""), (Document)doc));
                traceElement.appendChild(XMLUtils.createCDATAElement((String)"native", (Object)(stackTraceElement.isNativeMethod() + ""), (Document)doc));
            }
        }
        return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb());
    }

    @WebPublic(alias="stop")
    public SimpleForegroundModuleResponse stopThread(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        String name = req.getParameter("name");
        if (StringUtils.isEmpty((String)name)) {
            return this.list(req, res, user, uriParser, new ValidationError("UnableToStopThreadNoNameSpecified"), null, null);
        }
        if (ThreadUtils.killThread((String)name)) {
            this.log.info((Object)("User " + user + " killed thread " + name));
            return this.list(req, res, user, uriParser, null, STOP_OPERATION, name);
        }
        this.log.info((Object)("User " + user + " tried to kill non existing thread " + name));
        return this.list(req, res, user, uriParser, new ValidationError("UnableToStopThreadNotFound"), null, null);
    }

    @WebPublic(alias="interrupt")
    public SimpleForegroundModuleResponse interruptThread(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        String name = req.getParameter("name");
        if (StringUtils.isEmpty((String)name)) {
            return this.list(req, res, user, uriParser, new ValidationError("UnableToInterruptThreadNoNameSpecified"), null, null);
        }
        if (ThreadUtils.interruptThread((String)name)) {
            this.log.info((Object)("User " + user + " intrerrupted thread " + name));
            return this.list(req, res, user, uriParser, null, INTERRUPT_OPERATION, name);
        }
        this.log.info((Object)("User " + user + " tried to interrupt non existing thread " + name));
        return this.list(req, res, user, uriParser, new ValidationError("UnableToInterruptThreadNotFound"), null, null);
    }
}

