/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.test.rest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.w3c.dom.Document;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.foregroundmodules.rest.AnnotatedRESTModule;
import se.unlogic.hierarchy.foregroundmodules.rest.RESTMethod;
import se.unlogic.hierarchy.foregroundmodules.rest.URIParam;
import se.unlogic.hierarchy.foregroundmodules.test.rest.StringResponseHandler;
import se.unlogic.hierarchy.foregroundmodules.test.rest.XMLResponseHandler;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.URIParser;

public class RESTTestModule
extends AnnotatedRESTModule {
    private String stringValue;
    private Integer integerValue;

    @Override
    public void init(ForegroundModuleDescriptor moduleDescriptor, SectionInterface sectionInterface, DataSource dataSource) throws Exception {
        this.addResponseHandler(new StringResponseHandler());
        this.addResponseHandler(new XMLResponseHandler(sectionInterface.getSystemInterface().getEncoding()));
        super.init(moduleDescriptor, sectionInterface, dataSource);
    }

    @RESTMethod(alias="string", method="get")
    public String stringGet(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Throwable {
        if (this.stringValue == null) {
            return "No value set";
        }
        return "Current value" + this.stringValue;
    }

    @RESTMethod(alias="string/{value}", method="put")
    public String stringPut(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser, @URIParam(name="value") String value) throws Throwable {
        this.stringValue = value;
        return "Value " + this.stringValue + " saved";
    }

    @RESTMethod(alias="integer", method="get")
    public void intGet(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Throwable {
        res.setContentType("text/html");
        if (this.integerValue == null) {
            res.getWriter().write("No value set");
        } else {
            res.getWriter().write("Current value: " + this.integerValue);
        }
        res.getWriter().flush();
    }

    @RESTMethod(alias="integer/{value}", method="put")
    public void intPut(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser, @URIParam(name="value") Integer value) throws Throwable {
        this.integerValue = value;
        res.setContentType("text/html");
        res.getWriter().write("Value " + this.integerValue + " saved");
        res.getWriter().flush();
    }

    @RESTMethod(alias="calculate/{param1}/{param2}", method="get")
    public String calculate(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser, @URIParam(name="param1") Integer param1, @URIParam(name="param2") Integer param2) throws Throwable {
        return "The sum of the parameters is: " + (param1 + param2);
    }

    @RESTMethod(alias="xml/{element}/{value}", method="get")
    public Document generateXML(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser, @URIParam(name="element") String elementName, @URIParam(name="value") String elementValue) throws Throwable {
        Document doc = XMLUtils.createDomDocument();
        doc.appendChild(XMLUtils.createCDATAElement((String)XMLUtils.toValidElementName((String)elementName), (Object)elementValue, (Document)doc));
        return doc;
    }
}

