/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.systemadmin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import se.unlogic.fileuploadutils.MultipartRequest;
import se.unlogic.hierarchy.core.annotations.ModuleSetting;
import se.unlogic.hierarchy.core.annotations.TextFieldSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.WebPublic;
import se.unlogic.hierarchy.core.annotations.XSLVariable;
import se.unlogic.hierarchy.core.beans.BaseModuleDescriptor;
import se.unlogic.hierarchy.core.beans.BaseVisibleModuleDescriptor;
import se.unlogic.hierarchy.core.beans.Breadcrumb;
import se.unlogic.hierarchy.core.beans.SettingDescriptor;
import se.unlogic.hierarchy.core.beans.SimpleBackgroundModuleDescriptor;
import se.unlogic.hierarchy.core.beans.SimpleDataSourceDescriptor;
import se.unlogic.hierarchy.core.beans.SimpleFilterModuleDescriptor;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleResponse;
import se.unlogic.hierarchy.core.beans.SimpleSectionDescriptor;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.beans.ValueDescriptor;
import se.unlogic.hierarchy.core.cache.BaseModuleCache;
import se.unlogic.hierarchy.core.daos.factories.CoreDaoFactory;
import se.unlogic.hierarchy.core.daos.interfaces.BackgroundModuleDAO;
import se.unlogic.hierarchy.core.daos.interfaces.DataSourceDAO;
import se.unlogic.hierarchy.core.daos.interfaces.FilterModuleDAO;
import se.unlogic.hierarchy.core.daos.interfaces.ForegroundModuleDAO;
import se.unlogic.hierarchy.core.daos.interfaces.ModuleDAO;
import se.unlogic.hierarchy.core.daos.interfaces.SectionDAO;
import se.unlogic.hierarchy.core.enums.CRUDAction;
import se.unlogic.hierarchy.core.enums.DisplayType;
import se.unlogic.hierarchy.core.enums.EventTarget;
import se.unlogic.hierarchy.core.enums.HTTPProtocol;
import se.unlogic.hierarchy.core.enums.ModuleType;
import se.unlogic.hierarchy.core.enums.PathType;
import se.unlogic.hierarchy.core.events.CRUDEvent;
import se.unlogic.hierarchy.core.exceptions.URINotFoundException;
import se.unlogic.hierarchy.core.handlers.SimpleSettingHandler;
import se.unlogic.hierarchy.core.interfaces.BackgroundModule;
import se.unlogic.hierarchy.core.interfaces.BackgroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.FilterModule;
import se.unlogic.hierarchy.core.interfaces.FilterModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.ForegroundModule;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleResponse;
import se.unlogic.hierarchy.core.interfaces.ModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.SectionDescriptor;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.core.utils.AccessUtils;
import se.unlogic.hierarchy.core.utils.usergrouplist.UserGroupListConnector;
import se.unlogic.hierarchy.core.validationerrors.DuplicateModuleAliasValidationError;
import se.unlogic.hierarchy.core.validationerrors.DuplicateModuleIDValidationError;
import se.unlogic.hierarchy.core.validationerrors.FileSizeLimitExceededValidationError;
import se.unlogic.hierarchy.core.validationerrors.InvalidFileExtensionValidationError;
import se.unlogic.hierarchy.core.validationerrors.RequestSizeLimitExceededValidationError;
import se.unlogic.hierarchy.core.validationerrors.UnableToParseFileValidationError;
import se.unlogic.hierarchy.foregroundmodules.AnnotatedForegroundModule;
import se.unlogic.hierarchy.foregroundmodules.systemadmin.ModuleInfoBean;
import se.unlogic.hierarchy.foregroundmodules.systemadmin.ModuleInfoBeanComparator;
import se.unlogic.hierarchy.foregroundmodules.systemadmin.RootSectionUpdater;
import se.unlogic.hierarchy.foregroundmodules.systemadmin.SectionMover;
import se.unlogic.hierarchy.foregroundmodules.systemadmin.SectionUnloader;
import se.unlogic.hierarchy.foregroundmodules.systemadmin.SectionUpdater;
import se.unlogic.hierarchy.foregroundmodules.systemadmin.StartMode;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.collections.KeyNotCachedException;
import se.unlogic.standardutils.enums.EnumUtils;
import se.unlogic.standardutils.io.FileUtils;
import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.streams.StreamUtils;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.validation.PositiveStringIntegerValidator;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.validation.ValidationErrorType;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.XMLParser;
import se.unlogic.standardutils.xml.XMLParserPopulateable;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.RequestUtils;
import se.unlogic.webutils.http.URIParser;
import se.unlogic.webutils.populators.annotated.AnnotatedRequestPopulator;
import se.unlogic.webutils.url.URLRewriter;

public class SystemAdminModule
extends AnnotatedForegroundModule {
    private static final ModuleInfoBeanComparator MODULE_COMPARATOR = new ModuleInfoBeanComparator();
    private static final AnnotatedRequestPopulator<SimpleSectionDescriptor> SECTION_DESCRIPTOR_POPULATOR = new AnnotatedRequestPopulator(SimpleSectionDescriptor.class);
    private static final AnnotatedRequestPopulator<SimpleForegroundModuleDescriptor> FOREGROUND_MODULE_DESCRIPTOR_POPULATOR = new AnnotatedRequestPopulator(SimpleForegroundModuleDescriptor.class);
    private static final AnnotatedRequestPopulator<SimpleBackgroundModuleDescriptor> BACKGROUND_MODULE_DESCRIPTOR_POPULATOR = new AnnotatedRequestPopulator(SimpleBackgroundModuleDescriptor.class);
    private static final AnnotatedRequestPopulator<SimpleFilterModuleDescriptor> FILTER_MODULE_DESCRIPTOR_POPULATOR = new AnnotatedRequestPopulator(SimpleFilterModuleDescriptor.class);
    @ModuleSetting(allowsNull=true)
    @TextFieldSettingDescriptor(name="Editor CSS", description="Path to the desired CSS stylesheet for FCKEditor (relative from the contextpath)", required=false)
    protected String cssPath;
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Max upload size", description="Maxmium upload size in megabytes allowed in a single post request", required=true, formatValidator=PositiveStringIntegerValidator.class)
    protected Integer maxRequestSize = 5;
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Max file size", description="Maxmium file size in megabytes allowed", required=true, formatValidator=PositiveStringIntegerValidator.class)
    protected Integer maxFileSize = 1;
    @ModuleSetting
    @TextFieldSettingDescriptor(name="RAM threshold", description="Maximum size of files in KB to be buffered in RAM during file uploads. Files exceeding the threshold are written to disk instead.", required=true, formatValidator=PositiveStringIntegerValidator.class)
    protected Integer ramThreshold = 500;
    private SectionDAO sectionDAO;
    private ForegroundModuleDAO foregroundModuleDAO;
    private BackgroundModuleDAO backgroundModuleDAO;
    private FilterModuleDAO filterModuleDAO;
    private DataSourceDAO dataSourceDAO;
    private UserGroupListConnector userGroupListConnector;
    @XSLVariable
    protected String addForegroundModuleBreadCrumbText = "Add foreground module";
    @XSLVariable
    protected String updateForegroundModuleBreadCrumbText = "Edit foreground module: ";
    @XSLVariable
    protected String copyForegroundModuleBreadCrumbText = "Copy foreground module: ";
    @XSLVariable
    protected String moveForegroundModuleBreadCrumbText = "Move foreground module: ";
    @XSLVariable
    protected String addBackgroundModuleBreadCrumbText = "Add background module";
    @XSLVariable
    protected String updateBackgroundModuleBreadCrumbText = "Edit background module: ";
    @XSLVariable
    protected String copyBackgroundModuleBreadCrumbText = "Copy background module: ";
    @XSLVariable
    protected String moveBackgroundModuleBreadCrumbText = "Move background module: ";
    @XSLVariable
    private String addFilterModuleBreadCrumbText = "Add filter module";
    @XSLVariable
    private String updateFilterModuleBreadCrumbText = "Update filter module";
    @XSLVariable
    protected String addSectionBreadCrumbText = "Add section";
    @XSLVariable
    protected String updateSectionBreadCrumbText = "Edit section: ";
    @XSLVariable
    protected String moveSectionBreadCrumbText = "Move section: ";
    @XSLVariable
    protected String importModulesBreadCrumbText = "Import modules into section: ";

    @Override
    protected void createDAOs(DataSource dataSource) throws Exception {
        CoreDaoFactory coreDaoFactory = this.systemInterface.getCoreDaoFactory();
        this.sectionDAO = coreDaoFactory.getSectionDAO();
        this.foregroundModuleDAO = coreDaoFactory.getForegroundModuleDAO();
        this.backgroundModuleDAO = coreDaoFactory.getBackgroundModuleDAO();
        this.filterModuleDAO = coreDaoFactory.getFilterModuleDAO();
        this.dataSourceDAO = coreDaoFactory.getDataSourceDAO();
        this.userGroupListConnector = new UserGroupListConnector(this.systemInterface);
    }

    @Override
    public SimpleForegroundModuleResponse defaultMethod(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        this.log.info((Object)("User " + user + " listing system tree"));
        Document doc = this.createDocument(req, uriParser);
        SimpleSectionDescriptor rootSection = this.sectionDAO.getRootSection(true);
        Element sectionsElement = doc.createElement("sections");
        doc.getFirstChild().appendChild(sectionsElement);
        this.appendSection(sectionsElement, doc, rootSection, true);
        return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb());
    }

    private void appendSection(Element parentSection, Document doc, SimpleSectionDescriptor simpleSectionDescriptor, boolean modules) throws SQLException {
        Element sectionElement = simpleSectionDescriptor.toXML(doc);
        parentSection.appendChild(sectionElement);
        SectionInterface sectionInterface = this.systemInterface.getSectionInterface(simpleSectionDescriptor.getSectionID());
        if (sectionInterface == null) {
            Object backgroundModules;
            sectionElement.setAttribute("cached", "false");
            Element modulesElement = doc.createElement("modules");
            sectionElement.appendChild(modulesElement);
            List foregroundModules = this.foregroundModuleDAO.getModules(simpleSectionDescriptor.getSectionID());
            if (foregroundModules != null) {
                for (Object moduleDescriptor : foregroundModules) {
                    modulesElement.appendChild(ModuleInfoBean.toXML(doc, (ModuleDescriptor)moduleDescriptor, ModuleType.FOREGROUND, true, false));
                }
            }
            if ((backgroundModules = this.backgroundModuleDAO.getModules(simpleSectionDescriptor.getSectionID())) != null) {
                Object moduleDescriptor;
                moduleDescriptor = backgroundModules.iterator();
                while (moduleDescriptor.hasNext()) {
                    BackgroundModuleDescriptor moduleDescriptor2 = (BackgroundModuleDescriptor)moduleDescriptor.next();
                    modulesElement.appendChild(ModuleInfoBean.toXML(doc, moduleDescriptor2, ModuleType.FOREGROUND, true, false));
                }
            }
        } else {
            sectionElement.setAttribute("cached", "true");
            if (modules) {
                ArrayList cachedBackgroundModuleList;
                List dbBackgroundModuleList;
                ArrayList cachedForegroundModuleList;
                ArrayList<ModuleInfoBean> moduleInfoList = new ArrayList<ModuleInfoBean>();
                List dbForegroundModuleList = this.foregroundModuleDAO.getModules(simpleSectionDescriptor.getSectionID());
                if (dbForegroundModuleList != null) {
                    for (Object mb : dbForegroundModuleList) {
                        ModuleInfoBean moduleInfoBean = new ModuleInfoBean();
                        moduleInfoBean.setModuleBean((ModuleDescriptor)mb);
                        moduleInfoBean.setInDatabase(true);
                        moduleInfoBean.setModuleType(ModuleType.FOREGROUND);
                        if (sectionInterface.getForegroundModuleCache().getModule(mb) != null) {
                            moduleInfoBean.setCached(true);
                        }
                        moduleInfoList.add(moduleInfoBean);
                    }
                }
                if ((cachedForegroundModuleList = sectionInterface.getForegroundModuleCache().getCachedModuleDescriptors()) != null) {
                    for (Object mb : cachedForegroundModuleList) {
                        if (dbForegroundModuleList != null && dbForegroundModuleList.contains(mb)) continue;
                        ModuleInfoBean moduleInfoBean = new ModuleInfoBean();
                        moduleInfoBean.setModuleBean((ModuleDescriptor)mb);
                        moduleInfoBean.setCached(true);
                        moduleInfoBean.setModuleType(ModuleType.FOREGROUND);
                        moduleInfoList.add(moduleInfoBean);
                    }
                }
                if ((dbBackgroundModuleList = this.backgroundModuleDAO.getModules(simpleSectionDescriptor.getSectionID())) != null) {
                    for (Object mb : dbBackgroundModuleList) {
                        ModuleInfoBean moduleInfoBean = new ModuleInfoBean();
                        moduleInfoBean.setModuleBean((ModuleDescriptor)mb);
                        moduleInfoBean.setInDatabase(true);
                        moduleInfoBean.setModuleType(ModuleType.BACKGROUND);
                        if (sectionInterface.getBackgroundModuleCache().getModule(mb) != null) {
                            moduleInfoBean.setCached(true);
                        }
                        moduleInfoList.add(moduleInfoBean);
                    }
                }
                if ((cachedBackgroundModuleList = sectionInterface.getBackgroundModuleCache().getCachedModuleDescriptors()) != null) {
                    for (Object mb : cachedBackgroundModuleList) {
                        if (dbBackgroundModuleList != null && dbBackgroundModuleList.contains(mb)) continue;
                        ModuleInfoBean moduleInfoBean = new ModuleInfoBean();
                        moduleInfoBean.setModuleBean((ModuleDescriptor)mb);
                        moduleInfoBean.setCached(true);
                        moduleInfoBean.setModuleType(ModuleType.BACKGROUND);
                        moduleInfoList.add(moduleInfoBean);
                    }
                }
                if (simpleSectionDescriptor.getParentSectionID() == null) {
                    ArrayList cachedFilterModuleList;
                    List<SimpleFilterModuleDescriptor> dbFilterModuleList = this.filterModuleDAO.getModules();
                    if (dbFilterModuleList != null) {
                        for (SimpleFilterModuleDescriptor simpleFilterModuleDescriptor : dbFilterModuleList) {
                            ModuleInfoBean moduleInfoBean = new ModuleInfoBean();
                            moduleInfoBean.setModuleBean(simpleFilterModuleDescriptor);
                            moduleInfoBean.setInDatabase(true);
                            moduleInfoBean.setModuleType(ModuleType.FILTER);
                            if (this.systemInterface.getFilterModuleCache().getModule(simpleFilterModuleDescriptor) != null) {
                                moduleInfoBean.setCached(true);
                            }
                            moduleInfoList.add(moduleInfoBean);
                        }
                    }
                    if ((cachedFilterModuleList = this.systemInterface.getFilterModuleCache().getCachedModuleDescriptors()) != null) {
                        for (FilterModuleDescriptor mb : cachedFilterModuleList) {
                            if (dbFilterModuleList != null && dbFilterModuleList.contains(mb)) continue;
                            ModuleInfoBean moduleInfoBean = new ModuleInfoBean();
                            moduleInfoBean.setModuleBean(mb);
                            moduleInfoBean.setCached(true);
                            moduleInfoBean.setModuleType(ModuleType.FILTER);
                            moduleInfoList.add(moduleInfoBean);
                        }
                    }
                }
                Collections.sort(moduleInfoList, MODULE_COMPARATOR);
                Element modulesElement = doc.createElement("modules");
                sectionElement.appendChild(modulesElement);
                for (ModuleInfoBean moduleInfoBean : moduleInfoList) {
                    modulesElement.appendChild(moduleInfoBean.toXML(doc));
                }
            }
        }
        if (simpleSectionDescriptor.getSubSectionsList() != null) {
            Element subSectionsElement = doc.createElement("subsections");
            sectionElement.appendChild(subSectionsElement);
            for (SimpleSectionDescriptor subSectionBean : simpleSectionDescriptor.getSubSectionsList()) {
                this.appendSection(subSectionsElement, doc, subSectionBean, modules);
            }
        }
    }

    public Document createDocument(HttpServletRequest req, URIParser uriParser) {
        Document doc = XMLUtils.createDomDocument();
        Element document = doc.createElement("document");
        document.appendChild(RequestUtils.getRequestInfoAsXML((Document)doc, (HttpServletRequest)req, (URIParser)uriParser));
        document.appendChild(((ForegroundModuleDescriptor)this.moduleDescriptor).toXML(doc));
        XMLUtils.appendNewElement((Document)doc, (Element)document, (String)"cssPath", (String)this.cssPath);
        doc.appendChild(document);
        return doc;
    }

    private Breadcrumb getModuleBreadcrumb(HttpServletRequest req, ModuleDescriptor module, String method, String message) {
        return new Breadcrumb(message + module.getName(), message + module.getName(), this.getFullAlias() + "/" + method + "/" + module.getModuleID());
    }

    private Breadcrumb getSectionBreadcrumb(HttpServletRequest req, SectionDescriptor section, String method, String message) {
        return new Breadcrumb(message + section.getName(), message + section.getName(), this.getFullAlias() + "/" + method + "/" + section.getSectionID());
    }

    @WebPublic(alias="addbmodule")
    public SimpleForegroundModuleResponse addBackgroundModule(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws URINotFoundException, SQLException, IOException {
        SimpleSectionDescriptor simpleSectionDescriptor = null;
        if (uriParser.size() == 3 && NumberUtils.isInt((String)uriParser.get(2)) && (simpleSectionDescriptor = this.sectionDAO.getSection(Integer.parseInt(uriParser.get(2)), false)) != null) {
            ValidationException validationException = null;
            if (req.getMethod().equalsIgnoreCase("POST")) {
                try {
                    SimpleBackgroundModuleDescriptor simpleModuleDescriptor = (SimpleBackgroundModuleDescriptor)BACKGROUND_MODULE_DESCRIPTOR_POPULATOR.populate(req);
                    simpleModuleDescriptor.setSectionID(simpleSectionDescriptor.getSectionID());
                    this.log.info((Object)("User " + user + " adding background module " + simpleModuleDescriptor + " to section " + simpleSectionDescriptor));
                    this.backgroundModuleDAO.add(simpleModuleDescriptor);
                    res.sendRedirect(this.getModuleURI(req));
                    return null;
                }
                catch (ValidationException e) {
                    validationException = e;
                }
            }
            Document doc = this.createDocument(req, uriParser);
            Element addModuleElement = doc.createElement("addBackgroundModule");
            doc.getFirstChild().appendChild(addModuleElement);
            addModuleElement.appendChild(simpleSectionDescriptor.toXML(doc));
            addModuleElement.appendChild(this.getDataSources(doc));
            addModuleElement.appendChild(SystemAdminModule.getPathTypes(doc));
            if (validationException != null) {
                addModuleElement.appendChild(validationException.toXML(doc));
                addModuleElement.appendChild(RequestUtils.getRequestParameters((HttpServletRequest)req, (Document)doc));
            }
            return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb(), new Breadcrumb(this.addBackgroundModuleBreadCrumbText, this.addBackgroundModuleBreadCrumbText, this.getFullAlias() + "/addModule/" + simpleSectionDescriptor.getSectionID()));
        }
        throw new URINotFoundException(uriParser);
    }

    @WebPublic(alias="updatebmodule")
    public SimpleForegroundModuleResponse updateBackgroundModule(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws URINotFoundException, SQLException, IOException {
        SimpleBackgroundModuleDescriptor simpleModuleDescriptor = null;
        if (uriParser.size() == 3 && NumberUtils.isInt((String)uriParser.get(2)) && (simpleModuleDescriptor = (SimpleBackgroundModuleDescriptor)this.backgroundModuleDAO.getModule(Integer.parseInt(uriParser.get(2)))) != null) {
            ValidationException validationException = null;
            if (req.getMethod().equalsIgnoreCase("POST")) {
                ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
                try {
                    simpleModuleDescriptor = (SimpleBackgroundModuleDescriptor)BACKGROUND_MODULE_DESCRIPTOR_POPULATOR.populate((Object)simpleModuleDescriptor, req);
                }
                catch (ValidationException e) {
                    validationErrors.addAll(e.getErrors());
                }
                BackgroundModule moduleInstance = this.getBackgroundModuleInstance(simpleModuleDescriptor);
                HashMap<String, List<String>> settingValues = null;
                if (moduleInstance != null) {
                    settingValues = SystemAdminModule.parseModuleSettings(moduleInstance.getSettings(), req, validationErrors);
                }
                if (validationErrors.isEmpty()) {
                    this.log.info((Object)("User " + user + " updating background module " + simpleModuleDescriptor));
                    if (moduleInstance != null) {
                        simpleModuleDescriptor.setMutableSettingHandler(new SimpleSettingHandler(settingValues));
                    }
                    this.backgroundModuleDAO.update(simpleModuleDescriptor);
                    this.systemInterface.getEventHandler().sendEvent(SimpleBackgroundModuleDescriptor.class, new CRUDEvent<SimpleBackgroundModuleDescriptor>(CRUDAction.UPDATE, simpleModuleDescriptor), EventTarget.ALL);
                    SectionInterface sectionInterface = this.systemInterface.getSectionInterface(simpleModuleDescriptor.getSectionID());
                    if (sectionInterface != null && sectionInterface.getBackgroundModuleCache().isCached(simpleModuleDescriptor)) {
                        try {
                            sectionInterface.getBackgroundModuleCache().update(simpleModuleDescriptor);
                        }
                        catch (Exception e) {
                            this.log.error((Object)("Error updating background module " + simpleModuleDescriptor + " in section " + sectionInterface.getSectionDescriptor() + " while updating module requested by user " + user), (Throwable)e);
                        }
                    }
                    res.sendRedirect(this.getModuleURI(req));
                    return null;
                }
                validationException = new ValidationException(validationErrors);
            }
            Document doc = this.createDocument(req, uriParser);
            Element updateModuleElement = doc.createElement("updateBackgroundModule");
            doc.getFirstChild().appendChild(updateModuleElement);
            BackgroundModule moduleInstance = this.getBackgroundModuleInstance(simpleModuleDescriptor);
            if (moduleInstance != null) {
                updateModuleElement.setAttribute("started", "true");
                List<SettingDescriptor> moduleSettings = moduleInstance.getSettings();
                if (moduleSettings != null && !moduleSettings.isEmpty()) {
                    Element moduleSettingDescriptorsElement = doc.createElement("moduleSettingDescriptors");
                    updateModuleElement.appendChild(moduleSettingDescriptorsElement);
                    for (SettingDescriptor settingDescriptor : moduleSettings) {
                        moduleSettingDescriptorsElement.appendChild(settingDescriptor.toXML(doc));
                        SystemAdminModule.rewriteURLs(simpleModuleDescriptor, settingDescriptor, req);
                    }
                }
            }
            updateModuleElement.appendChild(simpleModuleDescriptor.toXML(doc, true, false));
            updateModuleElement.appendChild(this.getDataSources(doc));
            updateModuleElement.appendChild(SystemAdminModule.getPathTypes(doc));
            if (validationException != null) {
                updateModuleElement.appendChild(validationException.toXML(doc));
                updateModuleElement.appendChild(RequestUtils.getRequestParameters((HttpServletRequest)req, (Document)doc));
            }
            AccessUtils.appendAllowedGroupsAndUsers(doc, updateModuleElement, simpleModuleDescriptor, this.systemInterface.getUserHandler(), this.systemInterface.getGroupHandler());
            return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb(), this.getModuleBreadcrumb(req, simpleModuleDescriptor, "updateModule", this.updateBackgroundModuleBreadCrumbText));
        }
        throw new URINotFoundException(uriParser);
    }

    @WebPublic(alias="deletebmodule")
    public SimpleForegroundModuleResponse deleteBackgroundModule(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws SQLException, URINotFoundException, IOException {
        SimpleBackgroundModuleDescriptor simpleModuleDescriptor = null;
        if (uriParser.size() == 3 && NumberUtils.isInt((String)uriParser.get(2)) && (simpleModuleDescriptor = (SimpleBackgroundModuleDescriptor)this.backgroundModuleDAO.getModule(Integer.parseInt(uriParser.get(2)))) != null) {
            this.log.info((Object)("User " + user + " deleting background module " + simpleModuleDescriptor));
            SectionInterface sectionInterface = this.systemInterface.getSectionInterface(simpleModuleDescriptor.getSectionID());
            if (sectionInterface != null && sectionInterface.getBackgroundModuleCache().isCached(simpleModuleDescriptor)) {
                try {
                    sectionInterface.getBackgroundModuleCache().unload(simpleModuleDescriptor);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error unloading background module " + simpleModuleDescriptor + " from section " + sectionInterface.getSectionDescriptor() + " while deleting module requested by user " + user));
                }
            }
            this.backgroundModuleDAO.delete(simpleModuleDescriptor);
            res.sendRedirect(this.getModuleURI(req));
            return null;
        }
        throw new URINotFoundException(uriParser);
    }

    @WebPublic(alias="movebmodule")
    public SimpleForegroundModuleResponse moveBackgroundModule(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws SQLException, URINotFoundException, IOException {
        SimpleBackgroundModuleDescriptor module = null;
        if ((uriParser.size() == 3 || uriParser.size() == 4) && NumberUtils.isInt((String)uriParser.get(2)) && (module = (SimpleBackgroundModuleDescriptor)this.backgroundModuleDAO.getModule(Integer.parseInt(uriParser.get(2)))) != null) {
            if (uriParser.size() == 3) {
                Document doc = this.createDocument(req, uriParser);
                Element moveModuleElement = doc.createElement("moveBackgroundModule");
                doc.getFirstChild().appendChild(moveModuleElement);
                moveModuleElement.appendChild(module.toXML(doc));
                Element sectionsElement = doc.createElement("sections");
                moveModuleElement.appendChild(sectionsElement);
                this.appendSection(sectionsElement, doc, this.sectionDAO.getRootSection(true), false);
                return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb(), this.getModuleBreadcrumb(req, module, "moveModule", this.moveBackgroundModuleBreadCrumbText));
            }
            SimpleSectionDescriptor simpleSectionDescriptor = null;
            if (NumberUtils.isInt((String)uriParser.get(3)) && (simpleSectionDescriptor = this.sectionDAO.getSection(Integer.parseInt(uriParser.get(3)), true)) != null) {
                SectionInterface newSectionInterface;
                if (module.getSectionID() == simpleSectionDescriptor.getSectionID()) {
                    this.log.info((Object)("User " + user + " trying to move background module " + module + " to the section it already belongs to, ignoring move"));
                    res.sendRedirect(this.getModuleURI(req));
                    return null;
                }
                this.log.info((Object)("User " + user + " moving background module " + module + " to section " + simpleSectionDescriptor));
                Integer oldSectionID = module.getSectionID();
                module.setSectionID(simpleSectionDescriptor.getSectionID());
                this.backgroundModuleDAO.update(module);
                SectionInterface oldSectionInterface = this.systemInterface.getSectionInterface(oldSectionID);
                boolean enabled = false;
                if (oldSectionInterface != null && oldSectionInterface.getBackgroundModuleCache().isCached(module)) {
                    enabled = true;
                    try {
                        oldSectionInterface.getBackgroundModuleCache().unload(module);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Error unloading background module " + module + " from section " + oldSectionInterface.getSectionDescriptor() + " while moving module to section " + simpleSectionDescriptor + " by user " + user), (Throwable)e);
                    }
                }
                if (enabled && (newSectionInterface = this.systemInterface.getSectionInterface(module.getSectionID())) != null) {
                    try {
                        newSectionInterface.getBackgroundModuleCache().cache(module);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Error caching background module " + module + " in section " + simpleSectionDescriptor + " while moving module from section " + oldSectionInterface.getSectionDescriptor() + " by user " + user), (Throwable)e);
                    }
                }
                res.sendRedirect(this.getModuleURI(req));
                return null;
            }
        }
        throw new URINotFoundException(uriParser);
    }

    @WebPublic(alias="copybmodule")
    public SimpleForegroundModuleResponse copyBackgroundModule(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws SQLException, URINotFoundException, IOException {
        SimpleBackgroundModuleDescriptor module = null;
        if ((uriParser.size() == 3 || uriParser.size() == 4) && NumberUtils.isInt((String)uriParser.get(2)) && (module = (SimpleBackgroundModuleDescriptor)this.backgroundModuleDAO.getModule(Integer.parseInt(uriParser.get(2)))) != null) {
            if (uriParser.size() == 3) {
                Document doc = this.createDocument(req, uriParser);
                Element copyModuleElement = doc.createElement("copyBackgroundModule");
                doc.getFirstChild().appendChild(copyModuleElement);
                copyModuleElement.appendChild(module.toXML(doc));
                Element sectionsElement = doc.createElement("sections");
                copyModuleElement.appendChild(sectionsElement);
                this.appendSection(sectionsElement, doc, this.sectionDAO.getRootSection(true), false);
                return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb(), this.getModuleBreadcrumb(req, module, "copyModule", this.copyBackgroundModuleBreadCrumbText));
            }
            SimpleSectionDescriptor simpleSectionDescriptor = null;
            if (NumberUtils.isInt((String)uriParser.get(3)) && (simpleSectionDescriptor = this.sectionDAO.getSection(Integer.parseInt(uriParser.get(3)), true)) != null) {
                this.log.info((Object)("User " + user + " copying background module " + module + " to section " + simpleSectionDescriptor));
                module.setModuleID(null);
                module.setSectionID(simpleSectionDescriptor.getSectionID());
                this.backgroundModuleDAO.add(module);
                res.sendRedirect(this.getModuleURI(req));
                return null;
            }
        }
        throw new URINotFoundException(uriParser);
    }

    @WebPublic(alias="downloadbmodule")
    public SimpleForegroundModuleResponse downloadBackgroundModuleDescriptor(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws URINotFoundException, SQLException, IOException, TransformerFactoryConfigurationError, TransformerException {
        SimpleBackgroundModuleDescriptor simpleModuleDescriptor = null;
        if (uriParser.size() == 3 && NumberUtils.isInt((String)uriParser.get(2)) && (simpleModuleDescriptor = (SimpleBackgroundModuleDescriptor)this.backgroundModuleDAO.getModule(Integer.parseInt(uriParser.get(2)))) != null) {
            this.log.info((Object)("User " + user + " downloading module descriptor for background module " + simpleModuleDescriptor));
            this.sendModuleDescriptor(simpleModuleDescriptor, "bgmodule", res, user);
            return null;
        }
        throw new URINotFoundException(uriParser);
    }

    @WebPublic(alias="downloadfmodule")
    public SimpleForegroundModuleResponse downloadForegroundModuleDescriptor(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws URINotFoundException, SQLException, IOException, TransformerFactoryConfigurationError, TransformerException {
        SimpleForegroundModuleDescriptor simpleModuleDescriptor = null;
        if (uriParser.size() == 3 && NumberUtils.isInt((String)uriParser.get(2)) && (simpleModuleDescriptor = (SimpleForegroundModuleDescriptor)this.foregroundModuleDAO.getModule(Integer.parseInt(uriParser.get(2)))) != null) {
            this.log.info((Object)("User " + user + " downloading module descriptor for foreground module " + simpleModuleDescriptor));
            this.sendModuleDescriptor(simpleModuleDescriptor, "fgmodule", res, user);
            return null;
        }
        throw new URINotFoundException(uriParser);
    }

    @WebPublic(alias="downloadfiltermodule")
    public SimpleForegroundModuleResponse downloadFilterModuleDescriptor(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws URINotFoundException, SQLException, IOException, TransformerFactoryConfigurationError, TransformerException {
        SimpleFilterModuleDescriptor simpleModuleDescriptor = null;
        if (uriParser.size() == 3 && NumberUtils.isInt((String)uriParser.get(2)) && (simpleModuleDescriptor = (SimpleFilterModuleDescriptor)this.filterModuleDAO.getModule(Integer.parseInt(uriParser.get(2)))) != null) {
            this.log.info((Object)("User " + user + " downloading module descriptor for filter module " + simpleModuleDescriptor));
            this.sendModuleDescriptor(simpleModuleDescriptor, "flmodule", res, user);
            return null;
        }
        throw new URINotFoundException(uriParser);
    }

    private void sendModuleDescriptor(BaseModuleDescriptor moduleDescriptor, String fileSuffix, HttpServletResponse res, User user) throws TransformerFactoryConfigurationError, TransformerException, IOException {
        res.setCharacterEncoding(this.systemInterface.getEncoding());
        res.setContentType("text/xml");
        res.setHeader("Content-Disposition", "attachment;filename=\"" + FileUtils.toValidHttpFilename((String)moduleDescriptor.getName()) + "." + fileSuffix + "\"");
        Document doc = XMLUtils.createDomDocument();
        doc.appendChild(moduleDescriptor.toXML(doc, true, true));
        XMLUtils.writeXML((Node)doc, (OutputStream)res.getOutputStream(), (boolean)true, (String)this.systemInterface.getEncoding());
    }

    @WebPublic(alias="addfiltermodule")
    public SimpleForegroundModuleResponse addFilterModule(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws URINotFoundException, SQLException, IOException {
        ValidationException validationException = null;
        if (req.getMethod().equalsIgnoreCase("POST")) {
            try {
                SimpleFilterModuleDescriptor simpleModuleDescriptor = (SimpleFilterModuleDescriptor)FILTER_MODULE_DESCRIPTOR_POPULATOR.populate(req);
                this.log.info((Object)("User " + user + " adding filter module " + simpleModuleDescriptor));
                this.filterModuleDAO.add(simpleModuleDescriptor);
                res.sendRedirect(this.getModuleURI(req));
                return null;
            }
            catch (ValidationException e) {
                validationException = e;
            }
        }
        Document doc = this.createDocument(req, uriParser);
        Element addModuleElement = doc.createElement("addFilterModule");
        doc.getFirstChild().appendChild(addModuleElement);
        addModuleElement.appendChild(this.getDataSources(doc));
        addModuleElement.appendChild(SystemAdminModule.getPathTypes(doc));
        if (validationException != null) {
            addModuleElement.appendChild(validationException.toXML(doc));
            addModuleElement.appendChild(RequestUtils.getRequestParameters((HttpServletRequest)req, (Document)doc));
        }
        return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb(), new Breadcrumb(this.addFilterModuleBreadCrumbText, this.addFilterModuleBreadCrumbText, this.getFullAlias() + "/addfiltermodule/"));
    }

    @WebPublic(alias="updatefiltermodule")
    public SimpleForegroundModuleResponse updateFilterModule(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws URINotFoundException, SQLException, IOException {
        SimpleFilterModuleDescriptor simpleModuleDescriptor = null;
        if (uriParser.size() == 3 && NumberUtils.isInt((String)uriParser.get(2)) && (simpleModuleDescriptor = (SimpleFilterModuleDescriptor)this.filterModuleDAO.getModule(Integer.parseInt(uriParser.get(2)))) != null) {
            ValidationException validationException = null;
            if (req.getMethod().equalsIgnoreCase("POST")) {
                ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
                try {
                    simpleModuleDescriptor = (SimpleFilterModuleDescriptor)FILTER_MODULE_DESCRIPTOR_POPULATOR.populate((Object)simpleModuleDescriptor, req);
                }
                catch (ValidationException e) {
                    validationErrors.addAll(e.getErrors());
                }
                FilterModule moduleInstance = (FilterModule)this.systemInterface.getFilterModuleCache().getModule(simpleModuleDescriptor);
                HashMap<String, List<String>> settingValues = null;
                if (moduleInstance != null) {
                    settingValues = SystemAdminModule.parseModuleSettings(moduleInstance.getSettings(), req, validationErrors);
                }
                if (validationErrors.isEmpty()) {
                    this.log.info((Object)("User " + user + " updating filter module " + simpleModuleDescriptor));
                    if (moduleInstance != null) {
                        simpleModuleDescriptor.setMutableSettingHandler(new SimpleSettingHandler(settingValues));
                    }
                    this.filterModuleDAO.update(simpleModuleDescriptor);
                    if (this.systemInterface.getFilterModuleCache().isCached(simpleModuleDescriptor)) {
                        try {
                            this.systemInterface.getFilterModuleCache().update(simpleModuleDescriptor);
                        }
                        catch (Exception e) {
                            this.log.error((Object)("Error updating filter module while updating module requested by user " + user), (Throwable)e);
                        }
                    }
                    res.sendRedirect(this.getModuleURI(req));
                    return null;
                }
                validationException = new ValidationException(validationErrors);
            }
            Document doc = this.createDocument(req, uriParser);
            Element updateModuleElement = doc.createElement("updateFilterModule");
            doc.getFirstChild().appendChild(updateModuleElement);
            FilterModule moduleInstance = (FilterModule)this.systemInterface.getFilterModuleCache().getModule(simpleModuleDescriptor);
            if (moduleInstance != null) {
                updateModuleElement.setAttribute("started", "true");
                List<SettingDescriptor> moduleSettings = moduleInstance.getSettings();
                if (moduleSettings != null && !moduleSettings.isEmpty()) {
                    Element moduleSettingDescriptorsElement = doc.createElement("moduleSettingDescriptors");
                    updateModuleElement.appendChild(moduleSettingDescriptorsElement);
                    for (SettingDescriptor settingDescriptor : moduleSettings) {
                        moduleSettingDescriptorsElement.appendChild(settingDescriptor.toXML(doc));
                        SystemAdminModule.rewriteURLs(simpleModuleDescriptor, settingDescriptor, req);
                    }
                }
            }
            updateModuleElement.appendChild(simpleModuleDescriptor.toXML(doc, true, false));
            updateModuleElement.appendChild(this.getDataSources(doc));
            updateModuleElement.appendChild(SystemAdminModule.getPathTypes(doc));
            if (validationException != null) {
                updateModuleElement.appendChild(validationException.toXML(doc));
                updateModuleElement.appendChild(RequestUtils.getRequestParameters((HttpServletRequest)req, (Document)doc));
            }
            AccessUtils.appendAllowedGroupsAndUsers(doc, updateModuleElement, simpleModuleDescriptor, this.systemInterface.getUserHandler(), this.systemInterface.getGroupHandler());
            return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb(), this.getModuleBreadcrumb(req, simpleModuleDescriptor, "updatefiltermodule", this.updateFilterModuleBreadCrumbText));
        }
        throw new URINotFoundException(uriParser);
    }

    @WebPublic(alias="deletefiltermodule")
    public SimpleForegroundModuleResponse deleteFilterModule(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws SQLException, URINotFoundException, IOException {
        SimpleFilterModuleDescriptor simpleModuleDescriptor = null;
        if (uriParser.size() == 3 && NumberUtils.isInt((String)uriParser.get(2)) && (simpleModuleDescriptor = (SimpleFilterModuleDescriptor)this.filterModuleDAO.getModule(Integer.parseInt(uriParser.get(2)))) != null) {
            this.log.info((Object)("User " + user + " deleting filter module " + simpleModuleDescriptor));
            if (this.systemInterface.getFilterModuleCache().isCached(simpleModuleDescriptor)) {
                try {
                    this.systemInterface.getFilterModuleCache().unload(simpleModuleDescriptor);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error unloading filter module " + simpleModuleDescriptor + " while deleting module requested by user " + user));
                }
            }
            this.filterModuleDAO.delete(simpleModuleDescriptor);
            res.sendRedirect(this.getModuleURI(req));
            return null;
        }
        throw new URINotFoundException(uriParser);
    }

    @WebPublic(alias="copyfiltermodule")
    public SimpleForegroundModuleResponse copyFilterModule(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws SQLException, URINotFoundException, IOException {
        SimpleFilterModuleDescriptor module = null;
        if ((uriParser.size() == 3 || uriParser.size() == 4) && NumberUtils.isInt((String)uriParser.get(2)) && (module = (SimpleFilterModuleDescriptor)this.filterModuleDAO.getModule(Integer.parseInt(uriParser.get(2)))) != null) {
            this.log.info((Object)("User " + user + " copying filter module " + module));
            module.setModuleID(null);
            this.filterModuleDAO.add(module);
            res.sendRedirect(this.getModuleURI(req));
            return null;
        }
        throw new URINotFoundException(uriParser);
    }

    @WebPublic(alias="addfmodule")
    public SimpleForegroundModuleResponse addForegroundModule(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws URINotFoundException, SQLException, IOException {
        SimpleSectionDescriptor simpleSectionDescriptor = null;
        if (uriParser.size() == 3 && NumberUtils.isInt((String)uriParser.get(2)) && (simpleSectionDescriptor = this.sectionDAO.getSection(Integer.parseInt(uriParser.get(2)), false)) != null) {
            ValidationException validationException = null;
            if (req.getMethod().equalsIgnoreCase("POST")) {
                try {
                    SimpleForegroundModuleDescriptor simpleModuleDescriptor = (SimpleForegroundModuleDescriptor)FOREGROUND_MODULE_DESCRIPTOR_POPULATOR.populate(req);
                    simpleModuleDescriptor.setSectionID(simpleSectionDescriptor.getSectionID());
                    SimpleForegroundModuleDescriptor aliasMatch = this.foregroundModuleDAO.getModule(simpleSectionDescriptor.getSectionID(), simpleModuleDescriptor.getAlias());
                    if (aliasMatch != null) {
                        throw new ValidationException(new ValidationError[]{new ValidationError("alias", ValidationErrorType.Other, "duplicateModuleAlias")});
                    }
                    this.log.info((Object)("User " + user + " adding foreground module " + simpleModuleDescriptor + " to section " + simpleSectionDescriptor));
                    this.foregroundModuleDAO.add(simpleModuleDescriptor);
                    res.sendRedirect(this.getModuleURI(req));
                    return null;
                }
                catch (ValidationException e) {
                    validationException = e;
                }
            }
            Document doc = this.createDocument(req, uriParser);
            Element addModuleElement = doc.createElement("addForegroundModule");
            doc.getFirstChild().appendChild(addModuleElement);
            addModuleElement.appendChild(simpleSectionDescriptor.toXML(doc));
            addModuleElement.appendChild(this.getDataSources(doc));
            addModuleElement.appendChild(SystemAdminModule.getPathTypes(doc));
            addModuleElement.appendChild(HTTPProtocol.getProtocols(doc));
            if (validationException != null) {
                addModuleElement.appendChild(validationException.toXML(doc));
                addModuleElement.appendChild(RequestUtils.getRequestParameters((HttpServletRequest)req, (Document)doc));
            }
            return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb(), new Breadcrumb(this.addForegroundModuleBreadCrumbText, this.addForegroundModuleBreadCrumbText, this.getFullAlias() + "/addModule/" + simpleSectionDescriptor.getSectionID()));
        }
        throw new URINotFoundException(uriParser);
    }

    @WebPublic(alias="updatefmodule")
    public SimpleForegroundModuleResponse updateForegroundModule(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws URINotFoundException, SQLException, IOException {
        SimpleForegroundModuleDescriptor simpleModuleDescriptor = null;
        if (uriParser.size() == 3 && NumberUtils.isInt((String)uriParser.get(2)) && (simpleModuleDescriptor = (SimpleForegroundModuleDescriptor)this.foregroundModuleDAO.getModule(Integer.parseInt(uriParser.get(2)))) != null) {
            ForegroundModule moduleInstance;
            ValidationException validationException = null;
            if (req.getMethod().equalsIgnoreCase("POST")) {
                ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
                try {
                    simpleModuleDescriptor = (SimpleForegroundModuleDescriptor)FOREGROUND_MODULE_DESCRIPTOR_POPULATOR.populate((Object)simpleModuleDescriptor, req);
                }
                catch (ValidationException e) {
                    validationErrors.addAll(e.getErrors());
                }
                SimpleForegroundModuleDescriptor aliasMatch = this.foregroundModuleDAO.getModule(simpleModuleDescriptor.getSectionID(), simpleModuleDescriptor.getAlias());
                if (aliasMatch != null && !aliasMatch.getModuleID().equals(simpleModuleDescriptor.getModuleID())) {
                    validationErrors.add(new ValidationError("alias", ValidationErrorType.Other, "duplicateModuleAlias"));
                }
                moduleInstance = this.getForegroundModuleInstance(simpleModuleDescriptor);
                HashMap<String, List<String>> settingValues = null;
                if (moduleInstance != null) {
                    settingValues = SystemAdminModule.parseModuleSettings(moduleInstance.getSettings(), req, validationErrors);
                }
                if (validationErrors.isEmpty()) {
                    this.log.info((Object)("User " + user + " updating foreground module " + simpleModuleDescriptor));
                    if (moduleInstance != null) {
                        simpleModuleDescriptor.setMutableSettingHandler(new SimpleSettingHandler(settingValues));
                    }
                    this.foregroundModuleDAO.update(simpleModuleDescriptor);
                    this.systemInterface.getEventHandler().sendEvent(SimpleForegroundModuleDescriptor.class, new CRUDEvent<SimpleForegroundModuleDescriptor>(CRUDAction.UPDATE, simpleModuleDescriptor), EventTarget.ALL);
                    SectionInterface sectionInterface = this.systemInterface.getSectionInterface(simpleModuleDescriptor.getSectionID());
                    if (sectionInterface != null && sectionInterface.getForegroundModuleCache().isCached(simpleModuleDescriptor)) {
                        try {
                            sectionInterface.getForegroundModuleCache().update(simpleModuleDescriptor);
                        }
                        catch (Exception e) {
                            this.log.error((Object)("Error updating foreground module " + simpleModuleDescriptor + " in section " + sectionInterface.getSectionDescriptor() + " while updating module requested by user " + user), (Throwable)e);
                        }
                    }
                    res.sendRedirect(this.getModuleURI(req));
                    return null;
                }
                validationException = new ValidationException(validationErrors);
            }
            Document doc = this.createDocument(req, uriParser);
            Element updateModuleElement = doc.createElement("updateForegroundModule");
            doc.getFirstChild().appendChild(updateModuleElement);
            moduleInstance = this.getForegroundModuleInstance(simpleModuleDescriptor);
            if (moduleInstance != null) {
                updateModuleElement.setAttribute("started", "true");
                List<SettingDescriptor> moduleSettings = moduleInstance.getSettings();
                if (moduleSettings != null && !moduleSettings.isEmpty()) {
                    Element moduleSettingDescriptorsElement = doc.createElement("moduleSettingDescriptors");
                    updateModuleElement.appendChild(moduleSettingDescriptorsElement);
                    for (SettingDescriptor settingDescriptor : moduleSettings) {
                        moduleSettingDescriptorsElement.appendChild(settingDescriptor.toXML(doc));
                        SystemAdminModule.rewriteURLs(simpleModuleDescriptor, settingDescriptor, req);
                    }
                }
            }
            updateModuleElement.appendChild(simpleModuleDescriptor.toXML(doc, true, false));
            updateModuleElement.appendChild(this.getDataSources(doc));
            updateModuleElement.appendChild(SystemAdminModule.getPathTypes(doc));
            updateModuleElement.appendChild(HTTPProtocol.getProtocols(doc));
            if (validationException != null) {
                updateModuleElement.appendChild(validationException.toXML(doc));
                updateModuleElement.appendChild(RequestUtils.getRequestParameters((HttpServletRequest)req, (Document)doc));
            }
            AccessUtils.appendAllowedGroupsAndUsers(doc, updateModuleElement, simpleModuleDescriptor, this.systemInterface.getUserHandler(), this.systemInterface.getGroupHandler());
            return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb(), this.getModuleBreadcrumb(req, simpleModuleDescriptor, "updateModule", this.updateForegroundModuleBreadCrumbText));
        }
        throw new URINotFoundException(uriParser);
    }

    public static void rewriteURLs(ModuleDescriptor moduleDescriptor, SettingDescriptor settingDescriptor, HttpServletRequest req) {
        String value;
        if (settingDescriptor.getDisplayType() == DisplayType.HTML_EDITOR && (value = moduleDescriptor.getMutableSettingHandler().getString(settingDescriptor.getId())) != null) {
            value = URLRewriter.setAbsoluteLinkUrls((String)value, (HttpServletRequest)req);
            moduleDescriptor.getMutableSettingHandler().setSetting(settingDescriptor.getId(), value);
        }
    }

    @WebPublic(alias="deletefmodule")
    public SimpleForegroundModuleResponse deleteForegroundModule(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws SQLException, URINotFoundException, IOException {
        SimpleForegroundModuleDescriptor simpleModuleDescriptor = null;
        if (uriParser.size() == 3 && NumberUtils.isInt((String)uriParser.get(2)) && (simpleModuleDescriptor = (SimpleForegroundModuleDescriptor)this.foregroundModuleDAO.getModule(Integer.parseInt(uriParser.get(2)))) != null) {
            this.log.info((Object)("User " + user + " deleting foreground module " + simpleModuleDescriptor));
            SectionInterface sectionInterface = this.systemInterface.getSectionInterface(simpleModuleDescriptor.getSectionID());
            if (sectionInterface != null && sectionInterface.getForegroundModuleCache().isCached(simpleModuleDescriptor)) {
                try {
                    sectionInterface.getForegroundModuleCache().unload(simpleModuleDescriptor);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error unloading foreground module " + simpleModuleDescriptor + " from section " + sectionInterface.getSectionDescriptor() + " while deleting module requested by user " + user));
                }
            }
            this.foregroundModuleDAO.delete(simpleModuleDescriptor);
            res.sendRedirect(this.getModuleURI(req));
            return null;
        }
        throw new URINotFoundException(uriParser);
    }

    @WebPublic(alias="movefmodule")
    public SimpleForegroundModuleResponse moveForegroundModule(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws SQLException, URINotFoundException, IOException {
        SimpleForegroundModuleDescriptor module = null;
        if ((uriParser.size() == 3 || uriParser.size() == 4) && NumberUtils.isInt((String)uriParser.get(2)) && (module = (SimpleForegroundModuleDescriptor)this.foregroundModuleDAO.getModule(Integer.parseInt(uriParser.get(2)))) != null) {
            if (uriParser.size() == 3) {
                Document doc = this.createDocument(req, uriParser);
                Element moveModuleElement = doc.createElement("moveForegroundModule");
                doc.getFirstChild().appendChild(moveModuleElement);
                moveModuleElement.appendChild(module.toXML(doc));
                Element sectionsElement = doc.createElement("sections");
                moveModuleElement.appendChild(sectionsElement);
                this.appendSection(sectionsElement, doc, this.sectionDAO.getRootSection(true), false);
                return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb(), this.getModuleBreadcrumb(req, module, "moveModule", this.moveForegroundModuleBreadCrumbText));
            }
            SimpleSectionDescriptor simpleSectionDescriptor = null;
            if (NumberUtils.isInt((String)uriParser.get(3)) && (simpleSectionDescriptor = this.sectionDAO.getSection(Integer.parseInt(uriParser.get(3)), true)) != null) {
                SectionInterface newSectionInterface;
                if (module.getSectionID() == simpleSectionDescriptor.getSectionID()) {
                    this.log.info((Object)("User " + user + " trying to move foreground module " + module + " to the section it already belongs to, ignoring move"));
                    res.sendRedirect(this.getModuleURI(req));
                    return null;
                }
                this.log.info((Object)("User " + user + " moving foreground module " + module + " to section " + simpleSectionDescriptor));
                Integer oldSectionID = module.getSectionID();
                module.setSectionID(simpleSectionDescriptor.getSectionID());
                this.foregroundModuleDAO.update(module);
                SectionInterface oldSectionInterface = this.systemInterface.getSectionInterface(oldSectionID);
                boolean enabled = false;
                if (oldSectionInterface != null && oldSectionInterface.getForegroundModuleCache().isCached(module)) {
                    enabled = true;
                    try {
                        oldSectionInterface.getForegroundModuleCache().unload(module);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Error unloading foreground module " + module + " from section " + oldSectionInterface.getSectionDescriptor() + " while moving module to section " + simpleSectionDescriptor + " by user " + user), (Throwable)e);
                    }
                }
                if (enabled && (newSectionInterface = this.systemInterface.getSectionInterface(module.getSectionID())) != null) {
                    try {
                        newSectionInterface.getForegroundModuleCache().cache(module);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Error caching foreground module " + module + " in section " + simpleSectionDescriptor + " while moving module from section " + oldSectionInterface.getSectionDescriptor() + " by user " + user), (Throwable)e);
                    }
                }
                res.sendRedirect(this.getModuleURI(req));
                return null;
            }
        }
        throw new URINotFoundException(uriParser);
    }

    @WebPublic(alias="copyfmodule")
    public SimpleForegroundModuleResponse copyForegroundModule(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws SQLException, URINotFoundException, IOException {
        SimpleForegroundModuleDescriptor module = null;
        if ((uriParser.size() == 3 || uriParser.size() == 4) && NumberUtils.isInt((String)uriParser.get(2)) && (module = (SimpleForegroundModuleDescriptor)this.foregroundModuleDAO.getModule(Integer.parseInt(uriParser.get(2)))) != null) {
            if (uriParser.size() == 3) {
                Document doc = this.createDocument(req, uriParser);
                Element copyModuleElement = doc.createElement("copyForegroundModule");
                doc.getFirstChild().appendChild(copyModuleElement);
                copyModuleElement.appendChild(module.toXML(doc));
                Element sectionsElement = doc.createElement("sections");
                copyModuleElement.appendChild(sectionsElement);
                this.appendSection(sectionsElement, doc, this.sectionDAO.getRootSection(true), false);
                return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb(), this.getModuleBreadcrumb(req, module, "copyModule", this.copyForegroundModuleBreadCrumbText));
            }
            SimpleSectionDescriptor simpleSectionDescriptor = null;
            if (NumberUtils.isInt((String)uriParser.get(3)) && (simpleSectionDescriptor = this.sectionDAO.getSection(Integer.parseInt(uriParser.get(3)), true)) != null) {
                this.log.info((Object)("User " + user + " copying foreground module " + module + " to section " + simpleSectionDescriptor));
                module.setModuleID(null);
                module.setSectionID(simpleSectionDescriptor.getSectionID());
                if (this.foregroundModuleDAO.getModule(module.getSectionID(), module.getAlias()) != null) {
                    for (int copyNumber = 1; copyNumber < Integer.MAX_VALUE; ++copyNumber) {
                        if (this.foregroundModuleDAO.getModule(module.getSectionID(), module.getAlias() + copyNumber) != null) continue;
                        module.setAlias(module.getAlias() + copyNumber);
                        break;
                    }
                }
                this.foregroundModuleDAO.add(module);
                res.sendRedirect(this.getModuleURI(req));
                return null;
            }
        }
        throw new URINotFoundException(uriParser);
    }

    public static HashMap<String, List<String>> parseModuleSettings(List<? extends SettingDescriptor> settings, HttpServletRequest req, List<ValidationError> validationErrors) {
        if (settings != null && !settings.isEmpty()) {
            HashMap<String, List<String>> settingValues = new HashMap<String, List<String>>();
            for (SettingDescriptor settingDescriptor : settings) {
                if (settingDescriptor.getDisplayType() == DisplayType.MULTILIST) {
                    String[] values = req.getParameterValues("modulesetting." + settingDescriptor.getId());
                    if (values == null) {
                        if (!settingDescriptor.isRequired()) continue;
                        validationErrors.add(new ValidationError(settingDescriptor.getName(), ValidationErrorType.RequiredField));
                        continue;
                    }
                    ArrayList<String> validValues = new ArrayList<String>();
                    block1: for (String value : values) {
                        for (ValueDescriptor valueDescriptor : settingDescriptor.getAllowedValues()) {
                            if (!valueDescriptor.getValue().equals(value)) continue;
                            validValues.add(value);
                            continue block1;
                        }
                    }
                    if (validValues.isEmpty() && settingDescriptor.isRequired()) {
                        validationErrors.add(new ValidationError(settingDescriptor.getName(), ValidationErrorType.InvalidFormat));
                        continue;
                    }
                    settingValues.put(settingDescriptor.getId(), validValues);
                    continue;
                }
                if (settingDescriptor.getDisplayType() == DisplayType.TEXTAREA && settingDescriptor.isSplitOnLineBreak()) {
                    String unsplitValue = req.getParameter("modulesetting." + settingDescriptor.getId());
                    if (StringUtils.isEmpty((String)unsplitValue)) {
                        if (!settingDescriptor.isRequired()) continue;
                        validationErrors.add(new ValidationError(settingDescriptor.getName(), ValidationErrorType.RequiredField));
                        continue;
                    }
                    ArrayList values = StringUtils.splitOnLineBreak((String)unsplitValue, (boolean)false);
                    if (values == null) {
                        if (!settingDescriptor.isRequired()) continue;
                        validationErrors.add(new ValidationError(settingDescriptor.getName(), ValidationErrorType.RequiredField));
                        continue;
                    }
                    if (settingDescriptor.getFormatValidator() != null) {
                        for (String value : values) {
                            if (settingDescriptor.getFormatValidator().validateFormat(value)) continue;
                            validationErrors.add(new ValidationError(settingDescriptor.getName(), ValidationErrorType.InvalidFormat));
                        }
                    }
                    settingValues.put(settingDescriptor.getId(), values);
                    continue;
                }
                String value = req.getParameter("modulesetting." + settingDescriptor.getId());
                if (StringUtils.isEmpty((String)value)) {
                    if (settingDescriptor.isRequired() && settingDescriptor.getDisplayType() != DisplayType.CHECKBOX) {
                        validationErrors.add(new ValidationError(settingDescriptor.getName(), ValidationErrorType.RequiredField));
                        continue;
                    }
                    if (settingDescriptor.getDisplayType() != DisplayType.CHECKBOX) continue;
                    value = "false";
                } else if (settingDescriptor.getAllowedValues() != null && !settingDescriptor.getAllowedValues().isEmpty()) {
                    boolean match = false;
                    for (ValueDescriptor valueDescriptor : settingDescriptor.getAllowedValues()) {
                        if (!valueDescriptor.getValue().equals(value)) continue;
                        match = true;
                        break;
                    }
                    if (!match) {
                        validationErrors.add(new ValidationError(settingDescriptor.getName(), ValidationErrorType.InvalidFormat));
                        continue;
                    }
                } else if (settingDescriptor.getFormatValidator() != null && !settingDescriptor.getFormatValidator().validateFormat(value)) {
                    validationErrors.add(new ValidationError(settingDescriptor.getName(), ValidationErrorType.InvalidFormat));
                    continue;
                }
                if (settingDescriptor.getDisplayType() == DisplayType.HTML_EDITOR) {
                    value = URLRewriter.removeAbsoluteLinkUrls((String)value, (HttpServletRequest)req);
                }
                settingValues.put(settingDescriptor.getId(), Collections.singletonList(value));
            }
            return settingValues;
        }
        return null;
    }

    @WebPublic(alias="startbmodule")
    public SimpleForegroundModuleResponse startBackgroundModule(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws IOException, SQLException, URINotFoundException {
        SimpleBackgroundModuleDescriptor simpleModuleDescriptor = null;
        if (uriParser.size() == 3 && NumberUtils.isInt((String)uriParser.get(2)) && (simpleModuleDescriptor = (SimpleBackgroundModuleDescriptor)this.backgroundModuleDAO.getModule(Integer.parseInt(uriParser.get(2)))) != null) {
            SectionInterface sectionInterface = this.systemInterface.getSectionInterface(simpleModuleDescriptor.getSectionID());
            if (sectionInterface == null) {
                this.log.info((Object)("User " + user + " tried to cache background module " + simpleModuleDescriptor + " in non-cached section " + this.sectionDAO.getSection((int)simpleModuleDescriptor.getSectionID(), false)));
            } else if (sectionInterface.getBackgroundModuleCache().isCached(simpleModuleDescriptor)) {
                this.log.info((Object)("User " + user + " tried to cache background module " + simpleModuleDescriptor + " which is already cached in section " + sectionInterface.getSectionDescriptor()));
            } else {
                try {
                    this.log.info((Object)("User " + user + " caching background module " + simpleModuleDescriptor + " in section " + sectionInterface.getSectionDescriptor()));
                    sectionInterface.getBackgroundModuleCache().cache(simpleModuleDescriptor);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error caching background module " + simpleModuleDescriptor + " in section " + sectionInterface.getSectionDescriptor() + " requested by user " + user), (Throwable)e);
                }
            }
            res.sendRedirect(this.getModuleURI(req));
            return null;
        }
        throw new URINotFoundException(uriParser);
    }

    @WebPublic(alias="stopbmodule")
    public SimpleForegroundModuleResponse stopBackgroundModule(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws URINotFoundException, SQLException, IOException {
        SimpleBackgroundModuleDescriptor simpleModuleDescriptor = null;
        if (uriParser.size() == 3 && NumberUtils.isInt((String)uriParser.get(2)) && (simpleModuleDescriptor = (SimpleBackgroundModuleDescriptor)this.backgroundModuleDAO.getModule(Integer.parseInt(uriParser.get(2)))) != null) {
            SectionInterface sectionInterface = this.systemInterface.getSectionInterface(simpleModuleDescriptor.getSectionID());
            if (sectionInterface == null) {
                this.log.info((Object)("User " + user + " tried to unload background module " + simpleModuleDescriptor + " in non-cached section " + this.sectionDAO.getSection((int)simpleModuleDescriptor.getSectionID(), false)));
            } else if (!sectionInterface.getBackgroundModuleCache().isCached(simpleModuleDescriptor)) {
                this.log.info((Object)("User " + user + " tried to unload uncached background module " + simpleModuleDescriptor + " in section " + sectionInterface.getSectionDescriptor()));
            } else {
                try {
                    this.log.info((Object)("User " + user + " unloading background module " + simpleModuleDescriptor + " in section " + sectionInterface.getSectionDescriptor()));
                    sectionInterface.getBackgroundModuleCache().unload(simpleModuleDescriptor);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error unloading background module " + simpleModuleDescriptor + " in section " + sectionInterface.getSectionDescriptor() + " requested by user " + user));
                }
            }
            res.sendRedirect(this.getModuleURI(req));
            return null;
        }
        throw new URINotFoundException(uriParser);
    }

    @WebPublic(alias="startfiltermodule")
    public SimpleForegroundModuleResponse startFilterModule(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws IOException, SQLException, URINotFoundException {
        SimpleFilterModuleDescriptor simpleModuleDescriptor = null;
        if (uriParser.size() == 3 && NumberUtils.isInt((String)uriParser.get(2)) && (simpleModuleDescriptor = (SimpleFilterModuleDescriptor)this.filterModuleDAO.getModule(Integer.parseInt(uriParser.get(2)))) != null) {
            if (this.systemInterface.getFilterModuleCache().isCached(simpleModuleDescriptor)) {
                this.log.info((Object)("User " + user + " tried to cache filter module " + simpleModuleDescriptor + " which is already cached in section " + this.sectionInterface.getSectionDescriptor()));
            } else {
                try {
                    this.log.info((Object)("User " + user + " caching filter module " + simpleModuleDescriptor + " in section " + this.sectionInterface.getSectionDescriptor()));
                    this.systemInterface.getFilterModuleCache().cache(simpleModuleDescriptor);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error caching filter module " + simpleModuleDescriptor + " in section " + this.sectionInterface.getSectionDescriptor() + " requested by user " + user), (Throwable)e);
                }
            }
            res.sendRedirect(this.getModuleURI(req));
            return null;
        }
        throw new URINotFoundException(uriParser);
    }

    @WebPublic(alias="stopfiltermodule")
    public SimpleForegroundModuleResponse stopFilterModule(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws URINotFoundException, SQLException, IOException {
        SimpleFilterModuleDescriptor simpleModuleDescriptor = null;
        if (uriParser.size() == 3 && NumberUtils.isInt((String)uriParser.get(2)) && (simpleModuleDescriptor = (SimpleFilterModuleDescriptor)this.filterModuleDAO.getModule(Integer.parseInt(uriParser.get(2)))) != null) {
            if (!this.systemInterface.getFilterModuleCache().isCached(simpleModuleDescriptor)) {
                this.log.info((Object)("User " + user + " tried to unload uncached filter module " + simpleModuleDescriptor + " in section " + this.sectionInterface.getSectionDescriptor()));
            } else {
                try {
                    this.log.info((Object)("User " + user + " unloading filter module " + simpleModuleDescriptor + " in section " + this.sectionInterface.getSectionDescriptor()));
                    this.systemInterface.getFilterModuleCache().unload(simpleModuleDescriptor);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error unloading filter module " + simpleModuleDescriptor + " in section " + this.sectionInterface.getSectionDescriptor() + " requested by user " + user));
                }
            }
            res.sendRedirect(this.getModuleURI(req));
            return null;
        }
        throw new URINotFoundException(uriParser);
    }

    @WebPublic(alias="startfmodule")
    public SimpleForegroundModuleResponse startForegroundModule(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws IOException, SQLException, URINotFoundException {
        SimpleForegroundModuleDescriptor simpleModuleDescriptor = null;
        if (uriParser.size() == 3 && NumberUtils.isInt((String)uriParser.get(2)) && (simpleModuleDescriptor = (SimpleForegroundModuleDescriptor)this.foregroundModuleDAO.getModule(Integer.parseInt(uriParser.get(2)))) != null) {
            SectionInterface sectionInterface = this.systemInterface.getSectionInterface(simpleModuleDescriptor.getSectionID());
            if (sectionInterface == null) {
                this.log.info((Object)("User " + user + " tried to cache foreground module " + simpleModuleDescriptor + " in non-cached section " + this.sectionDAO.getSection((int)simpleModuleDescriptor.getSectionID(), false)));
            } else if (sectionInterface.getForegroundModuleCache().isCached(simpleModuleDescriptor)) {
                this.log.info((Object)("User " + user + " tried to cache foreground module " + simpleModuleDescriptor + " which is already cached in section " + sectionInterface.getSectionDescriptor()));
            } else {
                try {
                    this.log.info((Object)("User " + user + " caching foreground module " + simpleModuleDescriptor + " in section " + sectionInterface.getSectionDescriptor()));
                    sectionInterface.getForegroundModuleCache().cache(simpleModuleDescriptor);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error caching foreground module " + simpleModuleDescriptor + " in section " + sectionInterface.getSectionDescriptor() + " requested by user " + user), (Throwable)e);
                }
            }
            res.sendRedirect(this.getModuleURI(req));
            return null;
        }
        throw new URINotFoundException(uriParser);
    }

    @WebPublic(alias="stopfmodule")
    public SimpleForegroundModuleResponse stopForegroundModule(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws URINotFoundException, SQLException, IOException {
        SimpleForegroundModuleDescriptor simpleModuleDescriptor = null;
        if (uriParser.size() == 3 && NumberUtils.isInt((String)uriParser.get(2)) && (simpleModuleDescriptor = (SimpleForegroundModuleDescriptor)this.foregroundModuleDAO.getModule(Integer.parseInt(uriParser.get(2)))) != null) {
            SectionInterface sectionInterface = this.systemInterface.getSectionInterface(simpleModuleDescriptor.getSectionID());
            if (sectionInterface == null) {
                this.log.info((Object)("User " + user + " tried to unload foreground module " + simpleModuleDescriptor + " in non-cached section " + this.sectionDAO.getSection((int)simpleModuleDescriptor.getSectionID(), false)));
            } else if (!sectionInterface.getForegroundModuleCache().isCached(simpleModuleDescriptor)) {
                this.log.info((Object)("User " + user + " tried to unload uncached foreground module " + simpleModuleDescriptor + " in section " + sectionInterface.getSectionDescriptor()));
            } else {
                try {
                    this.log.info((Object)("User " + user + " unloading foreground module " + simpleModuleDescriptor + " in section " + sectionInterface.getSectionDescriptor()));
                    sectionInterface.getForegroundModuleCache().unload(simpleModuleDescriptor);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error unloading foreground module " + simpleModuleDescriptor + " in section " + sectionInterface.getSectionDescriptor() + " requested by user " + user));
                }
            }
            res.sendRedirect(this.getModuleURI(req));
            return null;
        }
        throw new URINotFoundException(uriParser);
    }

    @WebPublic(alias="stopvfmodule")
    public SimpleForegroundModuleResponse stopVirtualForegroundModule(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws URINotFoundException, SQLException, IOException {
        Integer sectionID;
        if (uriParser.size() == 4 && (sectionID = NumberUtils.toInt((String)uriParser.get(2))) != null) {
            SectionInterface sectionInterface = this.systemInterface.getSectionInterface(sectionID);
            if (sectionInterface == null) {
                this.log.info((Object)("User " + user + " tried to unload a virtual foreground module in non-cached section " + this.sectionDAO.getSection((int)sectionID, false)));
            } else {
                Map.Entry<ForegroundModuleDescriptor, ForegroundModule> moduleEntry = sectionInterface.getForegroundModuleCache().getEntry(uriParser.get(3));
                if (moduleEntry == null) {
                    this.log.info((Object)("User " + user + " tried to unload unknown virtual foreground module with alias " + uriParser.get(3) + " in section " + sectionInterface.getSectionDescriptor()));
                } else {
                    try {
                        this.log.info((Object)("User " + user + " unloading virtual foreground module " + moduleEntry.getKey() + " from section " + sectionInterface.getSectionDescriptor()));
                        sectionInterface.getForegroundModuleCache().unload((ModuleDescriptor)moduleEntry.getKey());
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Error unloading virtual foreground module " + moduleEntry.getKey() + " in section " + sectionInterface.getSectionDescriptor() + " requested by user " + user));
                    }
                }
            }
            res.sendRedirect(this.getModuleURI(req));
            return null;
        }
        throw new URINotFoundException(uriParser);
    }

    @WebPublic
    public SimpleForegroundModuleResponse addSection(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws URINotFoundException, SQLException, IOException {
        SimpleSectionDescriptor parentSectionBean = null;
        if (uriParser.size() == 3 && NumberUtils.isInt((String)uriParser.get(2)) && (parentSectionBean = this.sectionDAO.getSection(Integer.parseInt(uriParser.get(2)), false)) != null) {
            ValidationException validationException = null;
            if (req.getMethod().equalsIgnoreCase("POST")) {
                try {
                    SimpleSectionDescriptor newSectionBean = (SimpleSectionDescriptor)SECTION_DESCRIPTOR_POPULATOR.populate(req);
                    newSectionBean.setParentSectionID(parentSectionBean.getSectionID());
                    SimpleSectionDescriptor sectionMatch = this.sectionDAO.getSection(parentSectionBean.getSectionID(), newSectionBean.getAlias());
                    if (sectionMatch != null) {
                        throw new ValidationException(new ValidationError[]{new ValidationError("alias", ValidationErrorType.Other, "duplicateSectionAlias")});
                    }
                    this.log.info((Object)("User " + user + " adding section " + newSectionBean + " to section " + parentSectionBean));
                    this.sectionDAO.add(newSectionBean);
                    res.sendRedirect(this.getModuleURI(req));
                    return null;
                }
                catch (ValidationException e) {
                    validationException = e;
                }
            }
            Document doc = this.createDocument(req, uriParser);
            Element addSectionElement = doc.createElement("addSection");
            doc.getFirstChild().appendChild(addSectionElement);
            addSectionElement.appendChild(parentSectionBean.toXML(doc));
            if (validationException != null) {
                addSectionElement.appendChild(validationException.toXML(doc));
                addSectionElement.appendChild(RequestUtils.getRequestParameters((HttpServletRequest)req, (Document)doc));
            }
            addSectionElement.appendChild(HTTPProtocol.getProtocols(doc));
            return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb(), new Breadcrumb(this.addSectionBreadCrumbText, this.addSectionBreadCrumbText, this.getFullAlias() + "/addSection/" + parentSectionBean.getSectionID()));
        }
        throw new URINotFoundException(uriParser);
    }

    @WebPublic
    public SimpleForegroundModuleResponse updateSection(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws URINotFoundException, SQLException, IOException {
        SimpleSectionDescriptor simpleSectionDescriptor = null;
        if (uriParser.size() == 3 && NumberUtils.isInt((String)uriParser.get(2)) && (simpleSectionDescriptor = this.sectionDAO.getSection(Integer.parseInt(uriParser.get(2)), true)) != null) {
            ValidationException validationException = null;
            if (req.getMethod().equalsIgnoreCase("POST")) {
                try {
                    simpleSectionDescriptor = (SimpleSectionDescriptor)SECTION_DESCRIPTOR_POPULATOR.populate((Object)simpleSectionDescriptor, req);
                    SimpleSectionDescriptor sectionMatch = this.sectionDAO.getSection(simpleSectionDescriptor.getParentSectionID(), simpleSectionDescriptor.getAlias());
                    if (sectionMatch != null && !sectionMatch.getSectionID().equals(simpleSectionDescriptor.getSectionID())) {
                        throw new ValidationException(new ValidationError[]{new ValidationError("alias", ValidationErrorType.Other, "duplicateSectionAlias")});
                    }
                    this.log.info((Object)("User " + user + " updating section " + simpleSectionDescriptor));
                    this.sectionDAO.update(simpleSectionDescriptor);
                    this.sectionDAO.getReverseFullAlias(simpleSectionDescriptor);
                    if (simpleSectionDescriptor.getParentSectionID() == null) {
                        RootSectionUpdater rootSectionUpdater = new RootSectionUpdater(this.sectionInterface.getSystemInterface().getRootSection(), simpleSectionDescriptor);
                        rootSectionUpdater.setDaemon(true);
                        rootSectionUpdater.start();
                    } else {
                        SectionInterface sectionInterface = this.systemInterface.getSectionInterface(simpleSectionDescriptor.getParentSectionID());
                        if (sectionInterface != null && sectionInterface.getSectionCache().isCached(simpleSectionDescriptor)) {
                            if (this.isParentSection(simpleSectionDescriptor.getSectionID())) {
                                SectionUpdater sectionUpdater = new SectionUpdater(sectionInterface.getSectionCache(), simpleSectionDescriptor, user);
                                sectionUpdater.isDaemon();
                                sectionUpdater.start();
                            } else {
                                try {
                                    sectionInterface.getSectionCache().update(simpleSectionDescriptor);
                                }
                                catch (KeyNotCachedException e) {
                                    this.log.debug((Object)("Unable to update section " + simpleSectionDescriptor + " requested by user " + user + ", section unloaded."));
                                }
                            }
                        }
                    }
                    res.sendRedirect(this.getModuleURI(req));
                    return null;
                }
                catch (ValidationException e) {
                    validationException = e;
                }
            }
            Document doc = this.createDocument(req, uriParser);
            Element updateSectionElement = doc.createElement("updateSection");
            doc.getFirstChild().appendChild(updateSectionElement);
            updateSectionElement.appendChild(simpleSectionDescriptor.toXML(doc));
            if (validationException != null) {
                updateSectionElement.appendChild(validationException.toXML(doc));
                updateSectionElement.appendChild(RequestUtils.getRequestParameters((HttpServletRequest)req, (Document)doc));
            }
            AccessUtils.appendAllowedGroupsAndUsers(doc, updateSectionElement, simpleSectionDescriptor, this.systemInterface.getUserHandler(), this.systemInterface.getGroupHandler());
            updateSectionElement.appendChild(HTTPProtocol.getProtocols(doc));
            return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb(), this.getSectionBreadcrumb(req, simpleSectionDescriptor, "updateSection", this.updateSectionBreadCrumbText));
        }
        throw new URINotFoundException(uriParser);
    }

    private boolean isParentSection(Integer sectionID) {
        for (SectionInterface parentSectionInterface = this.sectionInterface; parentSectionInterface != null; parentSectionInterface = parentSectionInterface.getParentSectionInterface()) {
            if (!parentSectionInterface.getSectionDescriptor().getSectionID().equals(sectionID)) continue;
            return true;
        }
        return false;
    }

    @WebPublic
    public SimpleForegroundModuleResponse deleteSection(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws NumberFormatException, SQLException, URINotFoundException, IOException {
        SimpleSectionDescriptor simpleSectionDescriptor = null;
        if (uriParser.size() == 3 && NumberUtils.isInt((String)uriParser.get(2)) && (simpleSectionDescriptor = this.sectionDAO.getSection(Integer.parseInt(uriParser.get(2)), false)) != null) {
            if (simpleSectionDescriptor.getParentSectionID() == null) {
                this.log.warn((Object)("User " + user + " tried to delete root section " + simpleSectionDescriptor));
            } else {
                this.log.info((Object)("User " + user + " deleting section " + simpleSectionDescriptor));
                SectionInterface sectionInterface = this.systemInterface.getSectionInterface(simpleSectionDescriptor.getParentSectionID());
                if (sectionInterface != null && sectionInterface.getSectionCache().isCached(simpleSectionDescriptor)) {
                    if (this.isParentSection(simpleSectionDescriptor.getSectionID())) {
                        SectionUnloader sectionUnloader = new SectionUnloader(sectionInterface.getSectionCache(), simpleSectionDescriptor, user);
                        sectionUnloader.isDaemon();
                        sectionUnloader.start();
                    } else {
                        try {
                            sectionInterface.getSectionCache().unload(simpleSectionDescriptor);
                        }
                        catch (KeyNotCachedException e) {
                            this.log.debug((Object)("Unable to unload section " + simpleSectionDescriptor + " requested by user " + user + ", section already unloaded"));
                        }
                    }
                }
                this.sectionDAO.delete(simpleSectionDescriptor);
                this.systemInterface.getEventHandler().sendEvent(SimpleSectionDescriptor.class, new CRUDEvent<SimpleSectionDescriptor>(CRUDAction.DELETE, simpleSectionDescriptor), EventTarget.ALL);
            }
            res.sendRedirect(this.getModuleURI(req));
            return null;
        }
        throw new URINotFoundException(uriParser);
    }

    @WebPublic
    public SimpleForegroundModuleResponse startSection(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws SQLException, IOException, URINotFoundException {
        SimpleSectionDescriptor simpleSectionDescriptor = null;
        if (uriParser.size() == 3 && NumberUtils.isInt((String)uriParser.get(2)) && (simpleSectionDescriptor = this.sectionDAO.getSection(Integer.parseInt(uriParser.get(2)), true)) != null) {
            if (simpleSectionDescriptor.getParentSectionID() == null) {
                this.log.warn((Object)("User " + user + " tried to cache root section " + simpleSectionDescriptor));
            } else if (this.systemInterface.getSectionInterface(simpleSectionDescriptor.getSectionID()) != null) {
                this.log.info((Object)("User " + user + " tried to cache section " + simpleSectionDescriptor + " which is already cached"));
            } else {
                SectionInterface sectionInterface = this.systemInterface.getSectionInterface(simpleSectionDescriptor.getParentSectionID());
                if (sectionInterface == null) {
                    this.log.info((Object)("User " + user + " tried to cache section " + simpleSectionDescriptor + " which has a non cached parent section"));
                } else {
                    this.log.info((Object)("User " + user + " caching section " + simpleSectionDescriptor + " in section " + sectionInterface.getSectionDescriptor()));
                    sectionInterface.getSectionCache().cache(simpleSectionDescriptor);
                }
            }
            res.sendRedirect(this.getModuleURI(req));
            return null;
        }
        throw new URINotFoundException(uriParser);
    }

    @WebPublic
    public SimpleForegroundModuleResponse stopSection(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws IOException, NumberFormatException, SQLException, URINotFoundException {
        SimpleSectionDescriptor simpleSectionDescriptor = null;
        if (uriParser.size() == 3 && NumberUtils.isInt((String)uriParser.get(2)) && (simpleSectionDescriptor = this.sectionDAO.getSection(Integer.parseInt(uriParser.get(2)), false)) != null) {
            if (simpleSectionDescriptor.getParentSectionID() == null) {
                this.log.warn((Object)("User " + user + " tried to unload root section " + simpleSectionDescriptor));
            } else if (this.systemInterface.getSectionInterface(simpleSectionDescriptor.getSectionID()) == null) {
                this.log.warn((Object)("User " + user + " tried to unload section " + simpleSectionDescriptor + " which is already stopped"));
            } else {
                SectionInterface sectionInterface = this.systemInterface.getSectionInterface(simpleSectionDescriptor.getParentSectionID());
                if (sectionInterface == null) {
                    this.log.warn((Object)("Unable to unload section " + simpleSectionDescriptor + " because it's parent section is not cached"));
                } else if (this.isParentSection(simpleSectionDescriptor.getSectionID())) {
                    SectionUnloader sectionUnloader = new SectionUnloader(sectionInterface.getSectionCache(), simpleSectionDescriptor, user);
                    sectionUnloader.isDaemon();
                    sectionUnloader.start();
                } else {
                    try {
                        this.log.info((Object)("User " + user + " unloading section " + simpleSectionDescriptor + " from section " + sectionInterface.getSectionDescriptor()));
                        sectionInterface.getSectionCache().unload(simpleSectionDescriptor);
                    }
                    catch (KeyNotCachedException e) {
                        this.log.debug((Object)("Unable to unload section " + simpleSectionDescriptor + " requested by user " + user + ", section already unloaded"));
                    }
                }
            }
            res.sendRedirect(this.getModuleURI(req));
            return null;
        }
        throw new URINotFoundException(uriParser);
    }

    @WebPublic
    public SimpleForegroundModuleResponse moveSection(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws SQLException, URINotFoundException, IOException {
        SimpleSectionDescriptor simpleSectionDescriptor = null;
        if ((uriParser.size() == 3 || uriParser.size() == 4) && NumberUtils.isInt((String)uriParser.get(2)) && (simpleSectionDescriptor = this.sectionDAO.getSection(Integer.parseInt(uriParser.get(2)), false)) != null) {
            if (uriParser.size() == 3) {
                Document doc = this.createDocument(req, uriParser);
                Element moveModuleElement = doc.createElement("moveSection");
                doc.getFirstChild().appendChild(moveModuleElement);
                moveModuleElement.appendChild(simpleSectionDescriptor.toXML(doc));
                Element sectionsElement = doc.createElement("sections");
                moveModuleElement.appendChild(sectionsElement);
                this.appendSection(sectionsElement, doc, this.sectionDAO.getRootSection(true), false);
                return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb(), this.getSectionBreadcrumb(req, simpleSectionDescriptor, "moveSection", this.moveSectionBreadCrumbText));
            }
            SimpleSectionDescriptor newParentSectionBean = null;
            if (NumberUtils.isInt((String)uriParser.get(3)) && (newParentSectionBean = this.sectionDAO.getSection(Integer.parseInt(uriParser.get(3)), true)) != null) {
                if (simpleSectionDescriptor.getParentSectionID() == newParentSectionBean.getSectionID()) {
                    this.log.info((Object)("User " + user + " trying to move section " + simpleSectionDescriptor + " to the section it already belongs to, ignoring move"));
                    res.sendRedirect(this.getModuleURI(req));
                    return null;
                }
                this.log.info((Object)("User " + user + " moving section " + simpleSectionDescriptor + " to section " + newParentSectionBean));
                Integer oldParentSectionID = simpleSectionDescriptor.getParentSectionID();
                simpleSectionDescriptor.setParentSectionID(newParentSectionBean.getSectionID());
                this.sectionDAO.update(simpleSectionDescriptor);
                simpleSectionDescriptor.setFullAlias(newParentSectionBean.getFullAlias() + "/" + simpleSectionDescriptor.getAlias());
                if (this.isParentSection(simpleSectionDescriptor.getSectionID())) {
                    SectionInterface targetSectionInterface = this.systemInterface.getSectionInterface(simpleSectionDescriptor.getParentSectionID());
                    if (targetSectionInterface != null) {
                        SectionMover sectionMover = new SectionMover(this.systemInterface.getSectionInterface(oldParentSectionID).getSectionCache(), targetSectionInterface.getSectionCache(), simpleSectionDescriptor, user);
                        sectionMover.start();
                    } else {
                        SectionUnloader sectionUnloader = new SectionUnloader(this.systemInterface.getSectionInterface(oldParentSectionID).getSectionCache(), simpleSectionDescriptor, user);
                        sectionUnloader.start();
                    }
                } else {
                    SectionInterface newParentSectionInterface;
                    SectionInterface oldSectionInterface = this.systemInterface.getSectionInterface(oldParentSectionID);
                    boolean enabled = false;
                    if (oldSectionInterface != null && oldSectionInterface.getSectionCache().isCached(simpleSectionDescriptor)) {
                        enabled = true;
                        try {
                            oldSectionInterface.getSectionCache().unload(simpleSectionDescriptor);
                        }
                        catch (KeyNotCachedException e) {
                            this.log.debug((Object)("Error unloading section " + simpleSectionDescriptor + " from section " + oldSectionInterface.getSectionDescriptor() + " during module move to section " + newParentSectionBean + " requested by user " + user + ", sectiond already unloaded"));
                        }
                    }
                    if (enabled && (newParentSectionInterface = this.systemInterface.getSectionInterface(simpleSectionDescriptor.getParentSectionID())) != null) {
                        try {
                            newParentSectionInterface.getSectionCache().cache(simpleSectionDescriptor);
                        }
                        catch (Exception e) {
                            this.log.error((Object)("Error caching section " + simpleSectionDescriptor + " in section " + newParentSectionInterface.getSectionDescriptor() + " during section move from section " + oldSectionInterface.getSectionDescriptor() + " by user " + user), (Throwable)e);
                        }
                    }
                }
                res.sendRedirect(this.getModuleURI(req));
                return null;
            }
        }
        throw new URINotFoundException(uriParser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebPublic(alias="import")
    public SimpleForegroundModuleResponse importModules(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws URINotFoundException, SQLException, IOException, InstantiationException, IllegalAccessException {
        SimpleSectionDescriptor sectionDescriptor = null;
        if (uriParser.size() == 3 && NumberUtils.isInt((String)uriParser.get(2)) && (sectionDescriptor = this.sectionDAO.getSection(Integer.parseInt(uriParser.get(2)), true)) != null) {
            ValidationException validationException = null;
            if (req.getMethod().equalsIgnoreCase("POST") && MultipartRequest.isMultipartRequest((HttpServletRequest)req)) {
                MultipartRequest multipartRequest = null;
                try {
                    SectionInterface sectionInterface;
                    multipartRequest = new MultipartRequest(this.ramThreshold * 1024, (long)(this.maxRequestSize * 0x100000), (long)(this.maxFileSize * 0x100000), req);
                    List foregroundModuleDescriptors = null;
                    List backgroundModuleDescriptors = null;
                    List filterModuleDescriptors = null;
                    List<Object> errors = new ArrayList<ValidationError>();
                    for (FileItem fileItem : multipartRequest.getFiles()) {
                        if (StringUtils.isEmpty((String)fileItem.getName()) || fileItem.getSize() == 0L) continue;
                        if (fileItem.getName().endsWith(".fgmodule")) {
                            try {
                                foregroundModuleDescriptors = CollectionUtils.addAndInstantiateIfNeeded(foregroundModuleDescriptors, (Object)this.parseModuleDescriptor(fileItem, SimpleForegroundModuleDescriptor.class));
                            }
                            catch (ValidationException e) {
                                errors.addAll(e.getErrors());
                            }
                            continue;
                        }
                        if (fileItem.getName().endsWith(".bgmodule")) {
                            try {
                                backgroundModuleDescriptors = CollectionUtils.addAndInstantiateIfNeeded(backgroundModuleDescriptors, (Object)this.parseModuleDescriptor(fileItem, SimpleBackgroundModuleDescriptor.class));
                            }
                            catch (ValidationException e) {
                                errors.addAll(e.getErrors());
                            }
                            continue;
                        }
                        if (fileItem.getName().endsWith(".flmodule")) {
                            if (sectionDescriptor.getParentSectionID() != null) {
                                errors = CollectionUtils.addAndInstantiateIfNeeded(errors, (Object)new ValidationError("FilterModuleImportInSubsection"));
                                continue;
                            }
                            try {
                                filterModuleDescriptors = CollectionUtils.addAndInstantiateIfNeeded(filterModuleDescriptors, (Object)this.parseModuleDescriptor(fileItem, SimpleFilterModuleDescriptor.class));
                            }
                            catch (ValidationException e) {
                                errors.addAll(e.getErrors());
                            }
                            continue;
                        }
                        errors.add((ValidationError)new InvalidFileExtensionValidationError(fileItem.getName()));
                    }
                    if (!errors.isEmpty()) {
                        throw new ValidationException(errors);
                    }
                    if (foregroundModuleDescriptors == null && backgroundModuleDescriptors == null && filterModuleDescriptors == null) {
                        throw new ValidationException(new ValidationError[]{new ValidationError("NoDescriptorsfound")});
                    }
                    boolean preserveModuleIDs = multipartRequest.getParameter("preserveModuleIDs") != null;
                    boolean preserveDataSourceIDs = multipartRequest.getParameter("preserveDataSourceIDs") != null;
                    StartMode startMode = (StartMode)EnumUtils.toEnum(StartMode.class, (String)multipartRequest.getParameter("startMode"));
                    if (!preserveModuleIDs) {
                        this.clearModuleIDs(foregroundModuleDescriptors);
                        this.clearModuleIDs(backgroundModuleDescriptors);
                        this.clearModuleIDs(filterModuleDescriptors);
                    } else {
                        this.checkModuleIDs(foregroundModuleDescriptors, this.foregroundModuleDAO, errors);
                        this.checkModuleIDs(backgroundModuleDescriptors, this.backgroundModuleDAO, errors);
                        this.checkModuleIDs(filterModuleDescriptors, this.filterModuleDAO, errors);
                    }
                    if (!preserveDataSourceIDs) {
                        this.clearDataSourceIDs(foregroundModuleDescriptors);
                        this.clearDataSourceIDs(backgroundModuleDescriptors);
                        this.clearDataSourceIDs(filterModuleDescriptors);
                    }
                    if (foregroundModuleDescriptors != null) {
                        for (ForegroundModuleDescriptor moduleDescriptor : foregroundModuleDescriptors) {
                            SimpleForegroundModuleDescriptor conflictingDescriptor = this.foregroundModuleDAO.getModule(sectionDescriptor.getSectionID(), moduleDescriptor.getAlias());
                            if (conflictingDescriptor == null) continue;
                            errors.add((Object)new DuplicateModuleAliasValidationError(moduleDescriptor, conflictingDescriptor, ModuleType.FOREGROUND));
                        }
                    }
                    if (!errors.isEmpty()) {
                        throw new ValidationException(errors);
                    }
                    this.setSectionID(foregroundModuleDescriptors, sectionDescriptor.getSectionID());
                    this.setSectionID(backgroundModuleDescriptors, sectionDescriptor.getSectionID());
                    this.log.info((Object)("User " + user + " importing " + CollectionUtils.getSize((Collection[])new Collection[]{foregroundModuleDescriptors, backgroundModuleDescriptors, filterModuleDescriptors}) + " modules into section " + sectionDescriptor));
                    this.addModules(foregroundModuleDescriptors, this.foregroundModuleDAO);
                    this.addModules(backgroundModuleDescriptors, this.backgroundModuleDAO);
                    this.addModules(filterModuleDescriptors, this.filterModuleDAO);
                    if (startMode != null && (sectionInterface = this.systemInterface.getSectionInterface(sectionDescriptor.getSectionID())) != null) {
                        this.cacheModules(foregroundModuleDescriptors, sectionInterface.getForegroundModuleCache(), startMode, sectionDescriptor, user);
                        this.cacheModules(backgroundModuleDescriptors, sectionInterface.getBackgroundModuleCache(), startMode, sectionDescriptor, user);
                        this.cacheModules(filterModuleDescriptors, this.systemInterface.getFilterModuleCache(), startMode, sectionDescriptor, user);
                    }
                    res.sendRedirect(this.getModuleURI(req));
                    Iterator iterator = null;
                    return iterator;
                }
                catch (ValidationException e) {
                    validationException = e;
                }
                catch (FileUploadBase.SizeLimitExceededException e) {
                    validationException = new ValidationException(new ValidationError[]{new RequestSizeLimitExceededValidationError(e.getActualSize(), e.getPermittedSize())});
                }
                catch (FileUploadBase.FileSizeLimitExceededException e) {
                    validationException = new ValidationException(new ValidationError[]{new FileSizeLimitExceededValidationError(e.getFileName(), e.getActualSize(), e.getPermittedSize())});
                }
                catch (FileUploadException e) {
                    validationException = new ValidationException(new ValidationError[]{new ValidationError("UnableToParseRequest")});
                }
                finally {
                    if (multipartRequest != null) {
                        multipartRequest.deleteFiles();
                    }
                }
            }
            this.log.info((Object)("User " + user + " requesting import modules form in section " + sectionDescriptor));
            Document doc = this.createDocument(req, uriParser);
            Element importModulesElement = doc.createElement("ImportModules");
            doc.getFirstChild().appendChild(importModulesElement);
            importModulesElement.appendChild(sectionDescriptor.toXML(doc));
            XMLUtils.appendNewElement((Document)doc, (Element)importModulesElement, (String)"Started", (Object)(this.systemInterface.getSectionInterface(sectionDescriptor.getSectionID()) != null ? 1 : 0));
            if (validationException != null) {
                importModulesElement.appendChild(validationException.toXML(doc));
            }
            return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb(), this.getSectionBreadcrumb(req, sectionDescriptor, "importModules", this.importModulesBreadCrumbText));
        }
        throw new URINotFoundException(uriParser);
    }

    private <T extends ModuleDescriptor> void cacheModules(List<? extends T> moduleDescriptors, BaseModuleCache<T, ?, ?> moduleCache, StartMode startMode, SectionDescriptor sectionDescriptor, User user) {
        if (moduleDescriptors != null) {
            for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
                String typeName = moduleDescriptor.getType().toString().toLowerCase();
                if (startMode != StartMode.ALL && !moduleDescriptor.isEnabled()) continue;
                this.log.info((Object)("User " + user + " caching " + typeName + " module " + moduleDescriptor + " in section " + sectionDescriptor));
                try {
                    moduleCache.cache(moduleDescriptor);
                }
                catch (Throwable t) {
                    this.log.error((Object)("Error caching " + typeName + " module " + moduleDescriptor + " in section " + sectionDescriptor + " requested by user " + user), t);
                }
            }
        }
    }

    private void setSectionID(List<? extends BaseVisibleModuleDescriptor> moduleDescriptors, Integer sectionID) {
        if (moduleDescriptors != null) {
            for (BaseVisibleModuleDescriptor baseVisibleModuleDescriptor : moduleDescriptors) {
                baseVisibleModuleDescriptor.setSectionID(sectionID);
            }
        }
    }

    private <T extends ModuleDescriptor> void addModules(List<T> moduleDescriptors, ModuleDAO<T> moduleDAO) throws SQLException {
        if (moduleDescriptors != null) {
            String typeName = ((ForegroundModuleDescriptor)this.moduleDescriptor).getType().toString().toLowerCase();
            for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
                this.log.info((Object)("Importing " + typeName + " module " + moduleDescriptor));
                moduleDAO.add(moduleDescriptor);
            }
        }
    }

    private void checkModuleIDs(List<? extends BaseModuleDescriptor> moduleDescriptors, ModuleDAO<?> moduleDAO, List<ValidationError> errors) throws SQLException {
        if (moduleDescriptors != null) {
            for (BaseModuleDescriptor baseModuleDescriptor : moduleDescriptors) {
                Object conflictingDescriptor;
                if (baseModuleDescriptor.getModuleID() == null || (conflictingDescriptor = moduleDAO.getModule(baseModuleDescriptor.getModuleID())) == null) continue;
                errors.add(new DuplicateModuleIDValidationError(baseModuleDescriptor, (ModuleDescriptor)conflictingDescriptor, baseModuleDescriptor.getType()));
            }
        }
    }

    private void clearModuleIDs(List<? extends BaseModuleDescriptor> moduleDescriptors) {
        if (moduleDescriptors != null) {
            for (BaseModuleDescriptor baseModuleDescriptor : moduleDescriptors) {
                baseModuleDescriptor.setModuleID(null);
            }
        }
    }

    private void clearDataSourceIDs(List<? extends BaseModuleDescriptor> moduleDescriptors) {
        if (moduleDescriptors != null) {
            for (BaseModuleDescriptor baseModuleDescriptor : moduleDescriptors) {
                baseModuleDescriptor.setDataSourceID(null);
            }
        }
    }

    private <T extends XMLParserPopulateable> T parseModuleDescriptor(FileItem fileItem, Class<T> descriptorClazz) throws ValidationException, InstantiationException, IllegalAccessException {
        InputStream inputStream = null;
        try {
            inputStream = fileItem.getInputStream();
            Document doc = XMLUtils.parseXML((InputStream)inputStream, (boolean)false, (boolean)false);
            XMLParserPopulateable descriptor = (XMLParserPopulateable)descriptorClazz.newInstance();
            Element docElement = doc.getDocumentElement();
            if (!docElement.getTagName().equals("module")) {
                this.log.info((Object)("Error parsing descriptor " + fileItem.getName() + ", unable to find module element"));
                throw new ValidationException(new ValidationError[]{new UnableToParseFileValidationError(fileItem.getName())});
            }
            descriptor.populate(new XMLParser(docElement));
            XMLParserPopulateable xMLParserPopulateable = descriptor;
            return (T)xMLParserPopulateable;
        }
        catch (SAXException e) {
            this.log.info((Object)("Error parsing descriptor " + fileItem.getName()), (Throwable)e);
            throw new ValidationException(new ValidationError[]{new UnableToParseFileValidationError(fileItem.getName())});
        }
        catch (IOException e) {
            this.log.info((Object)("Error parsing descriptor " + fileItem.getName()), (Throwable)e);
            throw new ValidationException(new ValidationError[]{new UnableToParseFileValidationError(fileItem.getName())});
        }
        catch (ParserConfigurationException e) {
            this.log.info((Object)("Error parsing descriptor " + fileItem.getName()), (Throwable)e);
            throw new ValidationException(new ValidationError[]{new UnableToParseFileValidationError(fileItem.getName())});
        }
        catch (ValidationException e) {
            this.log.info((Object)("Error parsing descriptor " + fileItem.getName()), (Throwable)e);
            throw new ValidationException(new ValidationError[]{new UnableToParseFileValidationError(fileItem.getName())});
        }
        finally {
            StreamUtils.closeStream((InputStream)inputStream);
        }
    }

    private static Element getPathTypes(Document doc) {
        Element pathTypes = doc.createElement("pathTypes");
        for (PathType pathType : PathType.values()) {
            pathTypes.appendChild(XMLUtils.createElement((String)"pathType", (Object)pathType.toString(), (Document)doc));
        }
        return pathTypes;
    }

    private Element getDataSources(Document doc) throws SQLException {
        Element dataSources = doc.createElement("dataSources");
        ArrayList<SimpleDataSourceDescriptor> dataSourceList = this.dataSourceDAO.getAll();
        if (dataSourceList != null) {
            for (SimpleDataSourceDescriptor dataSourceBean : dataSourceList) {
                dataSources.appendChild(dataSourceBean.toXML(doc));
            }
        }
        return dataSources;
    }

    protected ForegroundModule getForegroundModuleInstance(ForegroundModuleDescriptor moduleDescriptor) {
        SectionInterface sectionInterface = this.systemInterface.getSectionInterface(moduleDescriptor.getSectionID());
        if (sectionInterface != null) {
            return (ForegroundModule)sectionInterface.getForegroundModuleCache().getModule(moduleDescriptor);
        }
        return null;
    }

    protected BackgroundModule getBackgroundModuleInstance(BackgroundModuleDescriptor moduleDescriptor) {
        SectionInterface sectionInterface = this.systemInterface.getSectionInterface(moduleDescriptor.getSectionID());
        if (sectionInterface != null) {
            return (BackgroundModule)sectionInterface.getBackgroundModuleCache().getModule(moduleDescriptor);
        }
        return null;
    }

    @WebPublic(alias="users")
    public ForegroundModuleResponse getUsers(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Throwable {
        return this.userGroupListConnector.getUsers(req, res, user, uriParser);
    }

    @WebPublic(alias="groups")
    public ForegroundModuleResponse getGroups(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Throwable {
        return this.userGroupListConnector.getGroups(req, res, user, uriParser);
    }
}

