/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.systemadmin;

import se.unlogic.hierarchy.core.beans.SimpleSectionDescriptor;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.cache.SectionCache;
import se.unlogic.hierarchy.foregroundmodules.systemadmin.SectionBackgroundTask;
import se.unlogic.standardutils.collections.KeyNotCachedException;
import se.unlogic.standardutils.time.TimeUtils;

public class SectionUnloader
extends SectionBackgroundTask {
    public SectionUnloader(SectionCache sectionCache, SimpleSectionDescriptor simpleSectionDescriptor, User user) {
        super(sectionCache, simpleSectionDescriptor, user);
    }

    @Override
    public void run() {
        try {
            long starttime = System.currentTimeMillis();
            this.log.info((Object)("Section unload thread for section " + this.getSectionDescriptorBean() + " started..."));
            this.sectionCache.unload(this.getSectionDescriptorBean());
            this.log.info((Object)("Section " + this.getSectionDescriptorBean() + " unloaded by user " + this.getUser() + " using background thread after waiting " + TimeUtils.millisecondsToString((long)(System.currentTimeMillis() - starttime)) + " ms"));
        }
        catch (KeyNotCachedException e) {
            this.log.info((Object)("Unable to unload section " + this.getSectionDescriptorBean() + " requested by user " + this.getUser() + ", section already unloaded"));
        }
    }
}

