/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.systemadmin;

import se.unlogic.hierarchy.core.beans.SimpleSectionDescriptor;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.cache.SectionCache;
import se.unlogic.hierarchy.foregroundmodules.systemadmin.SectionBackgroundTask;
import se.unlogic.standardutils.collections.KeyAlreadyCachedException;
import se.unlogic.standardutils.collections.KeyNotCachedException;
import se.unlogic.standardutils.time.TimeUtils;

public class SectionMover
extends SectionBackgroundTask {
    private SectionCache targetSectionCache;

    public SectionMover(SectionCache sourceSectionCache, SectionCache targetSectionCache, SimpleSectionDescriptor simpleSectionDescriptor, User user) {
        super(sourceSectionCache, simpleSectionDescriptor, user);
        this.targetSectionCache = targetSectionCache;
    }

    @Override
    public void run() {
        try {
            long starttime = System.currentTimeMillis();
            this.log.info((Object)("Section mover thread for section " + this.getSectionDescriptorBean() + " started..."));
            this.sectionCache.unload(this.simpleSectionDescriptor);
            this.targetSectionCache.cache(this.simpleSectionDescriptor);
            this.log.info((Object)("Section " + this.getSectionDescriptorBean() + " moved by user " + this.getUser() + " using background thread in " + TimeUtils.millisecondsToString((long)(System.currentTimeMillis() - starttime)) + " ms"));
        }
        catch (KeyNotCachedException e) {
            this.log.info((Object)("Unable to move section " + this.getSectionDescriptorBean() + " requested by user " + this.getUser() + ", section not cached in source section"));
        }
        catch (KeyAlreadyCachedException e) {
            this.log.info((Object)("Unable to move section " + this.getSectionDescriptorBean() + " requested by user " + this.getUser() + ", section already cached in target section"));
        }
    }
}

