/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.staticcontent;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import se.unlogic.hierarchy.core.annotations.CheckboxSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.ModuleSetting;
import se.unlogic.hierarchy.core.annotations.TextFieldSettingDescriptor;
import se.unlogic.hierarchy.core.beans.SettingDescriptor;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleResponse;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.exceptions.AccessDeniedException;
import se.unlogic.hierarchy.core.exceptions.URINotFoundException;
import se.unlogic.hierarchy.core.interfaces.BundleDescriptor;
import se.unlogic.hierarchy.core.interfaces.ForegroundModule;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.MenuItemDescriptor;
import se.unlogic.hierarchy.core.interfaces.Module;
import se.unlogic.hierarchy.core.interfaces.ModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.core.interfaces.SystemInterface;
import se.unlogic.hierarchy.core.interfaces.VisibleModuleDescriptor;
import se.unlogic.hierarchy.core.utils.AccessUtils;
import se.unlogic.hierarchy.core.utils.ModuleUtils;
import se.unlogic.standardutils.date.PooledSimpleDateFormat;
import se.unlogic.standardutils.io.FileUtils;
import se.unlogic.standardutils.mime.MimeUtils;
import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.streams.StreamUtils;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.webutils.http.URIParser;

public class StaticContentModule
implements ForegroundModule {
    private static final PooledSimpleDateFormat RFC1123_DATE_FORMATTER = new PooledSimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US, TimeZone.getTimeZone("GMT"));
    protected Logger log = Logger.getLogger(this.getClass());
    private SystemInterface systemInterface;
    private SectionInterface sectionInterface;
    private ForegroundModuleDescriptor moduleDescriptor;
    @ModuleSetting
    @CheckboxSettingDescriptor(name="Enable global links", description="Controls whether or not global links are enabled")
    protected boolean enableGlobalContentLinks = true;
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Global content links file", description="The path to the file containing the definitions of global links (the file must be in classpath)")
    protected String globalContentLinksFile = "defaultGlobalContentLinks.properties";
    @ModuleSetting
    @CheckboxSettingDescriptor(name="Register in instance handler", description="Controls if this module should register itself in the global instance handler.")
    boolean registerInInstanceHandler = true;
    protected Properties globalContentLinks;

    @Override
    public void init(ForegroundModuleDescriptor moduleDescriptor, SectionInterface sectionInterface, DataSource dataSource) throws Exception {
        this.sectionInterface = sectionInterface;
        this.systemInterface = sectionInterface.getSystemInterface();
        this.moduleDescriptor = moduleDescriptor;
        ModuleUtils.setModuleSettings(this, StaticContentModule.class, moduleDescriptor.getMutableSettingHandler(), sectionInterface.getSystemInterface());
        this.loadGlobalContentLinks();
        this.checkInstanceHandlerRegistration(this.registerInInstanceHandler);
    }

    @Override
    public void update(ForegroundModuleDescriptor moduleDescriptor, DataSource dataSource) throws Exception {
        this.moduleDescriptor = moduleDescriptor;
        ModuleUtils.setModuleSettings(this, StaticContentModule.class, moduleDescriptor.getMutableSettingHandler(), this.sectionInterface.getSystemInterface());
        this.loadGlobalContentLinks();
        this.checkInstanceHandlerRegistration(this.registerInInstanceHandler);
    }

    @Override
    public void unload() throws Exception {
        this.checkInstanceHandlerRegistration(false);
    }

    protected void checkInstanceHandlerRegistration(boolean register) {
        if (register) {
            if (!this.systemInterface.getInstanceHandler().addInstance(StaticContentModule.class, this)) {
                this.log.warn((Object)("Another instance has already been registered in instance handler for class " + StaticContentModule.class.getName()));
            }
        } else if (this.systemInterface.getInstanceHandler().getInstance(StaticContentModule.class) == this) {
            this.systemInterface.getInstanceHandler().removeInstance(StaticContentModule.class);
        }
    }

    private void loadGlobalContentLinks() {
        InputStream fileStream;
        if (this.enableGlobalContentLinks && this.globalContentLinksFile != null && (fileStream = this.getClass().getResourceAsStream(this.globalContentLinksFile)) != null) {
            Properties links = new Properties();
            try {
                links.load(fileStream);
                if (links.size() > 0) {
                    this.log.debug((Object)("Succesfully parsed " + links.size() + " global content links"));
                    this.globalContentLinks = links;
                    return;
                }
            }
            catch (IOException e) {
                this.log.error((Object)("Error parsing global content links from definition file: " + this.globalContentLinksFile), (Throwable)e);
            }
            StreamUtils.closeStream((InputStream)fileStream);
        }
        this.globalContentLinks = null;
    }

    @Override
    public List<SettingDescriptor> getSettings() {
        try {
            return ModuleUtils.getAnnotatedSettingDescriptors(this, Object.class, this.sectionInterface.getSystemInterface());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SimpleForegroundModuleResponse processRequest(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws AccessDeniedException, URINotFoundException {
        Integer sectionID;
        if (uriParser.size() >= 3 && uriParser.get(1).equals("global")) {
            if (!this.enableGlobalContentLinks) {
                throw new AccessDeniedException("Global content links are disabled");
            }
            Properties globalContentLinks = this.globalContentLinks;
            if (globalContentLinks == null) {
                throw new URINotFoundException(uriParser);
            }
            if (globalContentLinks.isEmpty()) throw new URINotFoundException(uriParser);
            String filePath = this.getFilePath(uriParser, 1);
            for (Map.Entry<Object, Object> linkEntry : globalContentLinks.entrySet()) {
                URL linkedURL;
                if (!filePath.startsWith(linkEntry.getKey().toString()) || (linkedURL = this.getClass().getResource(linkEntry.getValue() + filePath)) == null) continue;
                try {
                    InputStream inputStream = linkedURL.openStream();
                    if (inputStream == null) continue;
                    this.sendFile(req, res, uriParser, linkedURL, inputStream, user, linkEntry.getValue().toString(), filePath, null, null);
                    return null;
                }
                catch (IOException iOException) {
                    this.log.error((Object)("Unable to load file from url " + linkedURL + " belonging to global content links"), (Throwable)iOException);
                }
            }
            throw new URINotFoundException(uriParser);
        }
        if (uriParser.size() >= 5 && (uriParser.get(1).equals("f") || uriParser.get(1).equals("b")) && !uriParser.getFormattedURI().contains("..") && (sectionID = NumberUtils.toInt((String)uriParser.get(2))) != null) {
            void var11_24;
            void var11_21;
            SectionInterface sectionInterface = this.systemInterface.getSectionInterface(sectionID);
            if (sectionInterface == null) {
                throw new AccessDeniedException("The requested section ID was not found in cache (URI: " + uriParser.getFormattedURI() + ")");
            }
            if (!AccessUtils.checkAccess(user, sectionInterface.getSectionDescriptor())) {
                throw new AccessDeniedException("User does not have access to section " + sectionInterface.getSectionDescriptor() + " (URI: " + uriParser.getFormattedURI() + ")");
            }
            for (SectionInterface parentSection = sectionInterface.getParentSectionInterface(); parentSection != null; parentSection = parentSection.getParentSectionInterface()) {
                if (AccessUtils.checkAccess(user, parentSection.getSectionDescriptor())) continue;
                throw new AccessDeniedException("User does not have access to section " + sectionInterface.getSectionDescriptor() + " (URI: " + uriParser.getFormattedURI() + ")");
            }
            boolean foreground = uriParser.get(1).equals("f");
            String moduletype = foreground ? "foreground module" : "background module";
            Integer moduleID = NumberUtils.toInt((String)uriParser.get(3));
            Object var11_18 = null;
            if (moduleID != null) {
                if (foreground) {
                    Map.Entry entry = sectionInterface.getForegroundModuleCache().getEntry(moduleID);
                } else {
                    Map.Entry entry = sectionInterface.getBackgroundModuleCache().getEntry(moduleID);
                }
            }
            if (var11_21 == null) {
                if (foreground) {
                    String alias = uriParser.get(3);
                    Map.Entry<ForegroundModuleDescriptor, ForegroundModule> entry = sectionInterface.getForegroundModuleCache().getEntry(alias);
                } else if (moduleID != null) {
                    Map.Entry entry = sectionInterface.getBackgroundModuleCache().getEntryByHashCode(moduleID);
                }
            }
            if (var11_24 != null) {
                VisibleModuleDescriptor moduleDescriptor = (VisibleModuleDescriptor)var11_24.getKey();
                if (!AccessUtils.checkAccess(user, moduleDescriptor)) throw new AccessDeniedException("User does not have access to " + moduletype + " " + var11_24.getKey() + " (URI: " + uriParser.getFormattedURI() + ")");
                if (!StringUtils.isEmpty((String)moduleDescriptor.getStaticContentPackage())) {
                    String filePath = this.getFilePath(uriParser, 3);
                    URL url = ((Module)var11_24.getValue()).getClass().getResource(moduleDescriptor.getStaticContentPackage() + filePath);
                    InputStream fileStream = null;
                    if (url != null) {
                        try {
                            fileStream = url.openStream();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (fileStream != null) {
                        this.log.debug((Object)("Sending file " + moduleDescriptor.getStaticContentPackage() + filePath + " from " + moduletype + " " + moduleDescriptor + " reqested using URI " + uriParser.getFormattedURI() + " to user " + user));
                        this.sendFile(req, res, uriParser, url, fileStream, user, moduleDescriptor.getStaticContentPackage(), filePath, moduleDescriptor, moduletype);
                        return null;
                    }
                    fileStream = ((Module)var11_24.getValue()).getClass().getResourceAsStream(moduleDescriptor.getStaticContentPackage() + "/StaticContentLinks.properties");
                    if (fileStream != null) {
                        Properties links = new Properties();
                        try {
                            links.load(fileStream);
                        }
                        catch (IOException e) {
                            this.log.error((Object)("Unable to load static content links belonging to " + moduletype + " " + moduleDescriptor), (Throwable)e);
                        }
                        finally {
                            StreamUtils.closeStream((InputStream)fileStream);
                        }
                        if (links.isEmpty()) throw new URINotFoundException(uriParser);
                        for (Map.Entry<Object, Object> linkEntry : links.entrySet()) {
                            URL linkedURL;
                            if (!filePath.startsWith(linkEntry.getKey().toString()) || (linkedURL = ((Module)var11_24.getValue()).getClass().getResource(linkEntry.getValue() + filePath)) == null) continue;
                            try {
                                fileStream = linkedURL.openStream();
                                if (fileStream == null) continue;
                                this.sendFile(req, res, uriParser, linkedURL, fileStream, user, linkEntry.getValue().toString(), filePath, moduleDescriptor, moduletype);
                                return null;
                            }
                            catch (IOException e) {
                                this.log.error((Object)("Unable to load file from url " + linkedURL + " belonging to " + moduletype + " " + moduleDescriptor), (Throwable)e);
                            }
                        }
                        throw new URINotFoundException(uriParser);
                    }
                    this.log.info((Object)("File " + uriParser.getFormattedURI() + " requested from " + moduletype + " " + moduleDescriptor + " by user " + user + " not found"));
                    throw new URINotFoundException(uriParser);
                }
                this.log.info((Object)("User " + user + " requested static content from " + moduletype + " " + moduleDescriptor + " which has no static content package set, using URI " + uriParser.getFormattedURI()));
                throw new URINotFoundException(uriParser);
            }
            this.log.info((Object)("Invalid sectionID or moduleID in URI " + uriParser.getFormattedURI() + " requested by user " + user));
            throw new URINotFoundException(uriParser);
        }
        this.log.info((Object)("Invalid URI " + uriParser.getFormattedURI() + " requested by user " + user));
        throw new URINotFoundException(uriParser);
    }

    private String getFilePath(URIParser uriParser, int startIndex) {
        if (uriParser.size() > startIndex + 1) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = startIndex + 1; i < uriParser.size(); ++i) {
                stringBuilder.append("/" + uriParser.get(i));
            }
            return stringBuilder.toString();
        }
        return "/" + uriParser.get(startIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void sendFile(HttpServletRequest req, HttpServletResponse res, URIParser uriParser, URL url, InputStream fileStream, User user, String staticContentPackage, String filePath, ModuleDescriptor moduleDescriptor, String moduletype) {
        block24: {
            outstream = null;
            try {
                lastModified = this.getLastModified(url, uriParser);
                if (lastModified != null) {
                    lastModifiedString = StaticContentModule.RFC1123_DATE_FORMATTER.format(lastModified);
                    modifiedSinceString = req.getHeader("If-Modified-Since");
                    if (modifiedSinceString != null && lastModifiedString.equalsIgnoreCase(modifiedSinceString)) {
                        res.setStatus(304);
                        res.flushBuffer();
                        return;
                    }
                    res.setHeader("Last-Modified", lastModifiedString);
                }
                filename = FileUtils.toValidHttpFilename((String)uriParser.get(uriParser.size() - 1));
                res.setStatus(200);
                res.setHeader("Content-Disposition", "inline; filename=\"" + filename + "\"");
                contentType = MimeUtils.getMimeType((String)filename);
                if (contentType != null) {
                    res.setContentType(contentType);
                } else {
                    res.setContentType("application/x-unknown-mime-type");
                }
                outstream = res.getOutputStream();
                StreamUtils.transfer((InputStream)fileStream, (OutputStream)outstream);
                if (this.log.isDebugEnabled()) {
                    if (moduleDescriptor != null) {
                        this.log.debug((Object)("Sent file " + staticContentPackage + filePath + " from " + moduletype + " " + moduleDescriptor + " to user " + user));
                    } else {
                        this.log.debug((Object)("Sent file " + staticContentPackage + filePath + " from global content links to user " + user));
                    }
                }
                ** try [egrp 3[TRYBLOCK] [1 : 318->326)] { 
            }
            catch (IOException e) {
                if (this.log.isDebugEnabled()) {
                    if (moduleDescriptor != null) {
                        this.log.info((Object)("Error sending file " + staticContentPackage + filePath + " from " + moduletype + " " + moduleDescriptor + " to user " + user + ", " + e));
                    } else {
                        this.log.info((Object)("Error sending file " + staticContentPackage + filePath + " from global content links to user " + user + ", " + e));
                    }
                }
                break block24;
            }
            finally {
                try {
                    StreamUtils.closeStream((InputStream)fileStream);
                }
                catch (NullPointerException var12_15) {}
                StreamUtils.closeStream(outstream);
            }
lbl-1000:
            // 1 sources

            {
                StreamUtils.closeStream((InputStream)fileStream);
            }
lbl30:
            // 1 sources

            catch (NullPointerException lastModified) {
                // empty catch block
            }
            StreamUtils.closeStream((OutputStream)outstream);
        }
    }

    protected Date getLastModified(URL url, URIParser uriParser) {
        try {
            return new Date(url.openConnection().getLastModified());
        }
        catch (IOException e) {
            this.log.warn((Object)("Unable to get last modified date for url " + url + "," + e));
        }
        catch (RuntimeException e) {
            this.log.warn((Object)("Unable to get last modified date for url " + url + "," + e));
        }
        return null;
    }

    public List<BundleDescriptor> getVisibleBundles() {
        return null;
    }

    public List<MenuItemDescriptor> getAllMenuItems() {
        return null;
    }

    public List<MenuItemDescriptor> getVisibleMenuItems() {
        return null;
    }

    public List<BundleDescriptor> getAllBundles() {
        return null;
    }

    public String getModuleContentURL(ForegroundModuleDescriptor moduleDescriptor, HttpServletRequest req) {
        String moduleIdentifier = moduleDescriptor.getModuleID() != null ? moduleDescriptor.getModuleID().toString() : moduleDescriptor.getAlias();
        return req.getContextPath() + this.sectionInterface.getSectionDescriptor().getFullAlias() + "/" + this.moduleDescriptor.getAlias() + "/f/" + moduleDescriptor.getSectionID() + "/" + moduleIdentifier;
    }
}

