/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.runtimeinfo;

import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.unlogic.hierarchy.core.annotations.WebPublic;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleResponse;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.exceptions.URINotFoundException;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleResponse;
import se.unlogic.hierarchy.foregroundmodules.AnnotatedForegroundModule;
import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.time.TimeUtils;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.RequestUtils;
import se.unlogic.webutils.http.URIParser;
import se.unlogic.webutils.image.GaugeGenerator;

public class RuntimeInfoModule
extends AnnotatedForegroundModule {
    @Override
    public SimpleForegroundModuleResponse defaultMethod(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        this.log.info((Object)("User " + user + " viewing runtime info"));
        Document doc = XMLUtils.createDomDocument();
        Element documentElement = doc.createElement("Document");
        doc.appendChild(documentElement);
        documentElement.appendChild(RequestUtils.getRequestInfoAsXML((Document)doc, (HttpServletRequest)req, (URIParser)uriParser));
        documentElement.appendChild(((ForegroundModuleDescriptor)this.moduleDescriptor).toXML(doc));
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        documentElement.appendChild(XMLUtils.createElement((String)"AvailableProcessors", (Object)operatingSystemMXBean.getAvailableProcessors(), (Document)doc));
        documentElement.appendChild(XMLUtils.createElement((String)"Arch", (Object)operatingSystemMXBean.getArch(), (Document)doc));
        documentElement.appendChild(XMLUtils.createElement((String)"Name", (Object)operatingSystemMXBean.getName(), (Document)doc));
        documentElement.appendChild(XMLUtils.createElement((String)"Version", (Object)operatingSystemMXBean.getVersion(), (Document)doc));
        ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
        documentElement.appendChild(XMLUtils.createElement((String)"LoadedClassCount", (Object)classLoadingMXBean.getLoadedClassCount(), (Document)doc));
        documentElement.appendChild(XMLUtils.createElement((String)"UnloadedClassCount", (Object)classLoadingMXBean.getUnloadedClassCount(), (Document)doc));
        documentElement.appendChild(XMLUtils.createElement((String)"TotalLoadedClassCount", (Object)classLoadingMXBean.getTotalLoadedClassCount(), (Document)doc));
        documentElement.appendChild(this.toXML(doc, ManagementFactory.getMemoryMXBean().getHeapMemoryUsage(), "Heap Memory Usage", null));
        documentElement.appendChild(this.toXML(doc, ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage(), "Non Heap Memory Usage", null));
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            documentElement.appendChild(this.toXML(doc, memoryPoolMXBean.getUsage(), memoryPoolMXBean.getName(), memoryPoolMXBean.getType().toString()));
        }
        return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb());
    }

    private Node toXML(Document doc, MemoryUsage memoryUsage, String name, String type) {
        Element memoryUsageElement = doc.createElement("MemoryUsage");
        XMLUtils.appendNewCDATAElement((Document)doc, (Element)memoryUsageElement, (String)"Name", (String)name);
        XMLUtils.appendNewCDATAElement((Document)doc, (Element)memoryUsageElement, (String)"Type", (String)type);
        XMLUtils.appendNewElement((Document)doc, (Element)memoryUsageElement, (String)"Init", (Object)(memoryUsage.getInit() / 0x100000L));
        XMLUtils.appendNewElement((Document)doc, (Element)memoryUsageElement, (String)"Used", (Object)(memoryUsage.getUsed() / 0x100000L));
        XMLUtils.appendNewElement((Document)doc, (Element)memoryUsageElement, (String)"Committed", (Object)(memoryUsage.getCommitted() / 0x100000L));
        XMLUtils.appendNewElement((Document)doc, (Element)memoryUsageElement, (String)"Max", (Object)(memoryUsage.getMax() / 0x100000L));
        return memoryUsageElement;
    }

    @WebPublic(alias="gauage")
    public ForegroundModuleResponse generateGauge(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws IOException, URINotFoundException {
        Float percent;
        if (uriParser.size() == 3 && (percent = NumberUtils.toFloat((String)uriParser.get(2))) != null) {
            try {
                GaugeGenerator.getPercentGauge((float)percent.floatValue(), (HttpServletResponse)res, (Integer)150);
            }
            catch (Exception e) {
                this.log.info((Object)("Error " + e + " sending generated gauage to user " + user + " requesting from " + req.getRemoteAddr()));
            }
            return null;
        }
        throw new URINotFoundException(uriParser);
    }

    @WebPublic(alias="gc")
    public ForegroundModuleResponse runGC(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws IOException, URINotFoundException {
        this.log.info((Object)("User " + user + " invoking gargabe collector..."));
        long startTime = System.currentTimeMillis();
        System.gc();
        this.log.info((Object)("GC executed in " + TimeUtils.millisecondsToString((long)(System.currentTimeMillis() - startTime)) + " ms"));
        this.redirectToDefaultMethod(req, res);
        return null;
    }
}

