/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.rest;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleResponse;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.foregroundmodules.AnnotatedForegroundModule;
import se.unlogic.hierarchy.foregroundmodules.rest.DynamicURIComponent;
import se.unlogic.hierarchy.foregroundmodules.rest.ParamMapping;
import se.unlogic.hierarchy.foregroundmodules.rest.RESTMapping;
import se.unlogic.hierarchy.foregroundmodules.rest.RESTMethod;
import se.unlogic.hierarchy.foregroundmodules.rest.ResponseHandler;
import se.unlogic.hierarchy.foregroundmodules.rest.StaticURIComponent;
import se.unlogic.hierarchy.foregroundmodules.rest.URIComponent;
import se.unlogic.hierarchy.foregroundmodules.rest.URIComponentHandler;
import se.unlogic.hierarchy.foregroundmodules.rest.URIParam;
import se.unlogic.standardutils.populators.BeanStringPopulator;
import se.unlogic.standardutils.populators.BeanStringPopulatorRegistery;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.webutils.http.URIParser;

public class AnnotatedRESTModule
extends AnnotatedForegroundModule {
    private final List<ResponseHandler<?>> responseHandlers = new ArrayList();
    private final HashMap<String, List<RESTMapping>> restMethodMap = new HashMap();

    @Override
    public void init(ForegroundModuleDescriptor moduleDescriptor, SectionInterface sectionInterface, DataSource dataSource) throws Exception {
        Method[] methods;
        block0: for (Method method : methods = this.getClass().getMethods()) {
            RESTMethod annotation = method.getAnnotation(RESTMethod.class);
            if (annotation == null) continue;
            Class<?>[] parameters = method.getParameterTypes();
            if (parameters.length < 4 || !this.checkInitialParams(parameters)) {
                this.log.error((Object)("Method " + method.getName() + " has invalid parametertypes, skipping method."));
                continue;
            }
            HashMap<String, ParamMapping> paramMap = null;
            if (parameters.length > 4) {
                paramMap = new HashMap<String, ParamMapping>();
                Annotation[][] paramAnnotations = method.getParameterAnnotations();
                for (int paramIndex = 4; paramIndex < parameters.length; ++paramIndex) {
                    URIParam uriParam = this.getURIParamAnnotation(paramIndex, paramAnnotations);
                    if (uriParam == null) {
                        this.log.error((Object)("The " + (paramIndex + 1) + "th parameter of method " + method.getName() + " is missing the @" + URIParam.class.getSimpleName() + " annotation, skipping method."));
                        continue block0;
                    }
                    if (paramMap.containsKey(uriParam.name())) {
                        this.log.error((Object)("Method " + method.getName() + " has multiple @" + URIParam.class.getSimpleName() + " annotated parameters using the same name (" + uriParam.name() + "), skipping method."));
                        continue block0;
                    }
                    BeanStringPopulator populator = BeanStringPopulatorRegistery.getBeanStringPopulator(parameters[paramIndex]);
                    if (populator == null) {
                        this.log.error((Object)("The " + (paramIndex + 1) + "th parameter of method " + method.getName() + " is of the unsupported type " + parameters[paramIndex].getClass() + ", skipping method."));
                        continue block0;
                    }
                    paramMap.put(uriParam.name(), new ParamMapping(uriParam, populator, paramIndex));
                }
            }
            if (StringUtils.isEmpty((String)annotation.alias())) {
                if (paramMap != null) {
                    this.log.error((Object)("Method " + method.getName() + " has " + paramMap.size() + " @" + URIParam.class.getSimpleName() + " annotated parameter(s) which are not included in the alias, skipping method."));
                    continue;
                }
                List<URIComponent> components = Collections.singletonList(new StaticURIComponent(method.getName()));
                URIComponentHandler uriComponentHandler = new URIComponentHandler(components);
                this.addMapping(new RESTMapping(method, annotation, uriComponentHandler));
                continue;
            }
            if (annotation.alias().startsWith("/")) {
                this.log.error((Object)("Method " + method.getName() + " has an invalid alias starting with /, skipping method."));
                continue;
            }
            if (annotation.alias().contains("//")) {
                this.log.error((Object)("Method " + method.getName() + " has an invalid alias containing with //, skipping method."));
                continue;
            }
            String[] splitAlias = annotation.alias().split("/");
            ArrayList<URIComponent> uriComponents = new ArrayList<URIComponent>(splitAlias.length);
            for (String aliasPart : splitAlias) {
                if (aliasPart.contains("{") || aliasPart.contains("}")) {
                    if (aliasPart.length() < 3 || !aliasPart.startsWith("{") || !aliasPart.endsWith("}")) {
                        this.log.error((Object)("Method " + method.getName() + " has an invalid alias syntax near " + aliasPart + ", skipping method."));
                        continue block0;
                    }
                    String paramName = aliasPart.substring(1, aliasPart.length() - 1);
                    if (paramMap == null) {
                        this.log.error((Object)("Alias of method " + method.getName() + " refers to unknown URI parameter " + paramName + ", skipping method"));
                        continue block0;
                    }
                    ParamMapping paramMapping = (ParamMapping)paramMap.get(paramName);
                    if (paramMapping == null) {
                        this.log.error((Object)("Alias of method " + method.getName() + " refers to unknown URI parameter " + paramName + ", skipping method"));
                        continue block0;
                    }
                    paramMap.remove(paramName);
                    uriComponents.add(new DynamicURIComponent(paramMapping));
                    continue;
                }
                uriComponents.add(new StaticURIComponent(aliasPart));
            }
            if (paramMap != null && !paramMap.isEmpty()) {
                this.log.error((Object)("Method " + method.getName() + " has " + paramMap.size() + " @" + URIParam.class.getSimpleName() + " annotated parameter(s) which are not included in the alias, skipping method."));
                continue;
            }
            this.addMapping(new RESTMapping(method, annotation, new URIComponentHandler(uriComponents)));
        }
        super.init(moduleDescriptor, sectionInterface, dataSource);
    }

    private final void addMapping(RESTMapping restMapping) {
        String method = restMapping.getAnnotation().method().toUpperCase();
        List<RESTMapping> mappings = this.restMethodMap.get(method);
        if (mappings == null) {
            mappings = new ArrayList<RESTMapping>(3);
            this.restMethodMap.put(method, mappings);
        }
        mappings.add(restMapping);
    }

    protected final void addResponseHandler(ResponseHandler<?> responseHandler) {
        Class<?> type = responseHandler.getType();
        if (type == null) {
            throw new NullPointerException("Response handler cannot return null as type");
        }
        this.responseHandlers.add(responseHandler);
    }

    private final boolean checkInitialParams(Class<?>[] parameters) {
        for (int i = 0; i < 4; ++i) {
            if (parameters[i].equals(PARAMETER_TYPES[i])) continue;
            return false;
        }
        return true;
    }

    private final URIParam getURIParamAnnotation(int paramIndex, Annotation[][] paramAnnotations) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = paramAnnotations[paramIndex]) {
            if (!(annotation instanceof URIParam)) continue;
            return (URIParam)annotation;
        }
        return null;
    }

    @Override
    protected ForegroundModuleResponse processForegroundRequest(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Throwable {
        List<RESTMapping> mappings;
        if (uriParser.size() > 1 && (mappings = this.restMethodMap.get(req.getMethod())) != null) {
            int requiredComponentCount = uriParser.size() - 1;
            URIParser nextLevelURIParser = uriParser.getNextLevel();
            for (RESTMapping mapping : mappings) {
                if (mapping.getComponentHandler().getComponentCount() != requiredComponentCount) continue;
                Object[] paramArray = new Object[mapping.getParamCount()];
                if (!mapping.getComponentHandler().matches(nextLevelURIParser, paramArray)) continue;
                paramArray[0] = req;
                paramArray[1] = res;
                paramArray[2] = user;
                paramArray[3] = uriParser;
                try {
                    Object response = mapping.getMethod().invoke((Object)this, paramArray);
                    if (response == null) {
                        return null;
                    }
                    for (ResponseHandler<?> responseHandler : this.responseHandlers) {
                        if (!responseHandler.getType().isAssignableFrom(response.getClass())) continue;
                        responseHandler.handleResponse(response, res);
                        return null;
                    }
                    throw new RuntimeException("Unable to find response handler for response of type " + response.getClass());
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() != null && e.getCause() instanceof Exception) {
                        throw (Exception)e.getCause();
                    }
                    throw e;
                }
            }
        }
        return super.processForegroundRequest(req, res, user, uriParser);
    }
}

