/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.resolver;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleResponse;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleResponse;
import se.unlogic.hierarchy.foregroundmodules.SimpleForegroundModule;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.RequestUtils;
import se.unlogic.webutils.http.URIParser;

public class ResolverModule
extends SimpleForegroundModule {
    @Override
    public ForegroundModuleResponse processRequest(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) {
        Document doc;
        block10: {
            doc = XMLUtils.createDomDocument();
            Element document = doc.createElement("Document");
            document.appendChild(RequestUtils.getRequestInfoAsXML((Document)doc, (HttpServletRequest)req, (URIParser)uriParser));
            document.appendChild(this.sectionInterface.getSectionDescriptor().toXML(doc));
            document.appendChild(((ForegroundModuleDescriptor)this.moduleDescriptor).toXML(doc));
            doc.appendChild(document);
            String value = req.getParameter("host");
            if (!StringUtils.isEmpty((String)value)) {
                value = value.trim();
                this.log.info((Object)("User " + user + " resolving host " + value));
                document.appendChild(XMLUtils.createCDATAElement((String)"Host", (Object)value, (Document)doc));
                try {
                    InetAddress inetAddress = InetAddress.getByName(value);
                    String resolvedHost = inetAddress.getHostAddress();
                    if (!resolvedHost.equals(value)) {
                        document.appendChild(XMLUtils.createCDATAElement((String)"ResolvedHost", (Object)resolvedHost, (Document)doc));
                        break block10;
                    }
                    document.appendChild(doc.createElement("UnableToResolveHost"));
                }
                catch (UnknownHostException e) {
                    document.appendChild(doc.createElement("UnableToResolveHost"));
                }
            } else {
                value = req.getParameter("ip");
                if (value != null) {
                    value = value.trim();
                    this.log.info((Object)("User " + user + " resolving ip " + value));
                    document.appendChild(XMLUtils.createCDATAElement((String)"IP", (Object)value, (Document)doc));
                    try {
                        InetAddress inetAddress = InetAddress.getByName(value);
                        String resolvedIP = inetAddress.getHostName();
                        if (!resolvedIP.equals(value)) {
                            document.appendChild(XMLUtils.createCDATAElement((String)"ResolvedIP", (Object)resolvedIP, (Document)doc));
                            break block10;
                        }
                        document.appendChild(doc.createElement("UnableToResolveIP"));
                    }
                    catch (UnknownHostException e) {
                        document.appendChild(doc.createElement("UnableToResolveIP"));
                    }
                } else {
                    this.log.info((Object)("User " + user + " requesting resolver form"));
                }
            }
        }
        return new SimpleForegroundModuleResponse(doc, this.getDefaultBreadcrumb());
    }
}

