/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.registration;

import java.sql.SQLException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import se.unlogic.hierarchy.core.annotations.GroupMultiListSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.ModuleSetting;
import se.unlogic.hierarchy.core.beans.MutableUser;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.exceptions.UnableToAddUserException;
import se.unlogic.hierarchy.core.exceptions.UnableToDeleteUserException;
import se.unlogic.hierarchy.core.exceptions.UnableToUpdateUserException;
import se.unlogic.hierarchy.core.handlers.UserHandler;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.foregroundmodules.registration.AnnotatedConfirmationRegistrationModule;

public abstract class UserProviderRegistrationModule<UserType extends MutableUser>
extends AnnotatedConfirmationRegistrationModule<UserType> {
    @ModuleSetting(allowsNull=true)
    @GroupMultiListSettingDescriptor(name="Default groups", description="The default groups assigned to new users")
    protected List<Integer> deafultGroupIDs;
    protected UserHandler userHandler;

    @Override
    public void init(ForegroundModuleDescriptor moduleDescriptor, SectionInterface sectionInterface, DataSource dataSource) throws Exception {
        super.init(moduleDescriptor, sectionInterface, dataSource);
        this.userHandler = this.systemInterface.getUserHandler();
    }

    @Override
    protected void addUser(UserType newUser) throws SQLException, UnableToAddUserException {
        this.userHandler.addUser((User)newUser, this.dataSource);
    }

    @Override
    protected void deleteUser(UserType newUser) throws SQLException, UnableToDeleteUserException {
        this.userHandler.deleteUser((User)newUser);
    }

    @Override
    protected void enableUserAccount(UserType newUser) throws SQLException, UnableToUpdateUserException {
        ((MutableUser)newUser).setEnabled(true);
        this.userHandler.updateUser((User)newUser, false, false, false);
    }

    @Override
    protected User findUserByEmail(String email) throws SQLException {
        return this.userHandler.getUserByEmail(email, false, false);
    }

    @Override
    protected UserType findUserByID(Integer userID) throws SQLException {
        return (UserType)((MutableUser)this.userHandler.getUser(userID, false, false));
    }

    @Override
    protected User findUserByUsername(String username) throws SQLException {
        return this.userHandler.getUserByUsername(username, false, false);
    }

    @Override
    protected void setUserDefaultAccess(UserType newUser, HttpServletRequest req) {
        if (this.deafultGroupIDs != null) {
            ((MutableUser)newUser).setGroups(this.systemInterface.getGroupHandler().getGroups(this.deafultGroupIDs, false));
        }
    }
}

