/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.registration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.interfaces.ViewFragment;
import se.unlogic.hierarchy.foregroundmodules.registration.RegistrationPlugin;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.webutils.http.URIParser;

public class RegistrationPluginHandler {
    private Logger log = Logger.getLogger(this.getClass());
    private final List<RegistrationPlugin> registrationPlugins;
    private final Map<RegistrationPlugin, ValidationException> validationErrorMap;
    private final Map<RegistrationPlugin, Object> pluginDataMap;

    public RegistrationPluginHandler(List<RegistrationPlugin> registrationPlugins) {
        this.registrationPlugins = registrationPlugins;
        this.validationErrorMap = new HashMap<RegistrationPlugin, ValidationException>(registrationPlugins.size());
        this.pluginDataMap = new HashMap<RegistrationPlugin, Object>(registrationPlugins.size());
    }

    public void populate(HttpServletRequest req) {
        for (RegistrationPlugin registrationPlugin : this.registrationPlugins) {
            try {
                Object data = registrationPlugin.populate(req);
                if (data == null) continue;
                this.pluginDataMap.put(registrationPlugin, data);
            }
            catch (ValidationException e) {
                this.validationErrorMap.put(registrationPlugin, e);
            }
            catch (Exception e) {
                this.log.error((Object)("Error populating registration plugin " + registrationPlugin), (Throwable)e);
            }
        }
    }

    public boolean hasValidationErrors() {
        return !this.validationErrorMap.isEmpty();
    }

    public List<ViewFragment> getViewFragments(HttpServletRequest req, URIParser uriParser) {
        ArrayList<ViewFragment> viewFragments = new ArrayList<ViewFragment>(this.registrationPlugins.size());
        for (RegistrationPlugin registrationPlugin : this.registrationPlugins) {
            try {
                ViewFragment viewFragment = registrationPlugin.getForm(req, uriParser, this.validationErrorMap.get(registrationPlugin));
                if (viewFragment == null) continue;
                viewFragments.add(viewFragment);
            }
            catch (Exception e) {
                this.log.error((Object)("Error getting view fragment from registration plugin " + registrationPlugin), (Throwable)e);
            }
        }
        return viewFragments;
    }

    public void userAdded(User user) {
        for (RegistrationPlugin registrationPlugin : this.registrationPlugins) {
            try {
                registrationPlugin.userAdded(user, this.pluginDataMap.get(registrationPlugin));
            }
            catch (Exception e) {
                this.log.error((Object)("Error in registration plugin " + registrationPlugin), (Throwable)e);
            }
        }
    }
}

