/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.registration;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.emailutils.framework.Email;
import se.unlogic.emailutils.framework.InvalidEmailAddressException;
import se.unlogic.emailutils.framework.NoEmailSendersFoundException;
import se.unlogic.emailutils.framework.SimpleEmail;
import se.unlogic.emailutils.framework.UnableToProcessEmailException;
import se.unlogic.hierarchy.core.annotations.CheckboxSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.GroupMultiListSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.HTMLEditorSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.ModuleSetting;
import se.unlogic.hierarchy.core.annotations.TextAreaSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.TextFieldSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.UserMultiListSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.WebPublic;
import se.unlogic.hierarchy.core.annotations.XSLVariable;
import se.unlogic.hierarchy.core.beans.AttributeDescriptor;
import se.unlogic.hierarchy.core.beans.Breadcrumb;
import se.unlogic.hierarchy.core.beans.SettingDescriptor;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleResponse;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.comparators.PriorityComparator;
import se.unlogic.hierarchy.core.enums.CRUDAction;
import se.unlogic.hierarchy.core.enums.EventTarget;
import se.unlogic.hierarchy.core.events.CRUDEvent;
import se.unlogic.hierarchy.core.exceptions.URINotFoundException;
import se.unlogic.hierarchy.core.exceptions.UnableToAddUserException;
import se.unlogic.hierarchy.core.exceptions.UnableToDeleteUserException;
import se.unlogic.hierarchy.core.exceptions.UnableToUpdateUserException;
import se.unlogic.hierarchy.core.interfaces.AttributeHandler;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleResponse;
import se.unlogic.hierarchy.core.interfaces.MutableAttributeHandler;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.core.interfaces.ViewFragment;
import se.unlogic.hierarchy.core.utils.AttributeDescriptorUtils;
import se.unlogic.hierarchy.core.utils.ModuleUtils;
import se.unlogic.hierarchy.core.utils.ViewFragmentUtils;
import se.unlogic.hierarchy.foregroundmodules.AnnotatedForegroundModule;
import se.unlogic.hierarchy.foregroundmodules.registration.Confirmation;
import se.unlogic.hierarchy.foregroundmodules.registration.PluginValidationException;
import se.unlogic.hierarchy.foregroundmodules.registration.RegistrationPlugin;
import se.unlogic.hierarchy.foregroundmodules.registration.RegistrationPluginHandler;
import se.unlogic.purecaptcha.CaptchaHandler;
import se.unlogic.purecaptcha.DefaultCaptchaHandler;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.enums.Order;
import se.unlogic.standardutils.string.AnnotatedBeanTagSourceFactory;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.string.TagReplacer;
import se.unlogic.standardutils.string.TagSource;
import se.unlogic.standardutils.string.TagSourceFactory;
import se.unlogic.standardutils.timer.RunnableTimerTask;
import se.unlogic.standardutils.validation.PositiveStringIntegerValidator;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.validation.ValidationErrorType;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.RequestUtils;
import se.unlogic.webutils.http.SessionUtils;
import se.unlogic.webutils.http.URIParser;
import se.unlogic.webutils.url.URLRewriter;

public abstract class BaseRegistrationModule<UserType extends User, ConfirmationType extends Confirmation>
extends AnnotatedForegroundModule
implements Runnable {
    protected static final String CAPTCHA_PASSED_SESSION_PREFIX = BaseRegistrationModule.class + "_captcha_passed_";
    protected static final PriorityComparator PRIORITY_COMPARATOR = new PriorityComparator(Order.ASC);
    protected static final String DEAFULT_SENDER_EMAIL_ADDRESS = "someone@somesite";
    protected static final String DEAFULT_SENDER_EMAIL_NAME = "John Doe";
    protected static final String CONFIRMATION_LINK = "$confirmation-link";
    protected static final String CONFIRMATION_TIMEOUT = "$confirmation-timeout";
    protected final ReentrantReadWriteLock pluginReadWriteLock = new ReentrantReadWriteLock();
    protected final Lock pluginReadLock = this.pluginReadWriteLock.readLock();
    protected final Lock pluginWriteLock = this.pluginReadWriteLock.writeLock();
    @ModuleSetting
    @CheckboxSettingDescriptor(name="Require manual confirmation", description="Controls whether or not new accounts have to be manually enabled (note that this setting disables e-mail confirmation)")
    protected boolean requireManualConfirmation = false;
    @ModuleSetting
    @CheckboxSettingDescriptor(name="Require e-mail confirmation", description="Controls whether or not new accounts have to be verified thru an e-mail confirmation")
    protected boolean requireEmailConfirmation = true;
    @ModuleSetting
    @CheckboxSettingDescriptor(name="Require captcha confirmation", description="Controls whether account creation requires captcha confirmation")
    protected boolean requireCaptchaConfirmation = true;
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Captcha characters", description="The number of characters used when generating captcha images", required=false, formatValidator=PositiveStringIntegerValidator.class)
    protected int captchaCharacters = 5;
    @ModuleSetting
    @HTMLEditorSettingDescriptor(name="Registration message", description="The message that is displayed above the registration form", required=true)
    @XSLVariable(name="defaultRegistrationMessage")
    protected String registrationMessage = "This string should be set by your XSL stylesheet";
    @ModuleSetting
    @HTMLEditorSettingDescriptor(name="Registered message", description="The message that is displayed after registration", required=true)
    @XSLVariable(name="defaultRegisteredMessage")
    protected String registereredMessage = "This string should be set by your XSL stylesheet";
    @ModuleSetting
    @HTMLEditorSettingDescriptor(name="Account enabled message", description="The text that is displayed after the user has confirmed his account", required=true)
    @XSLVariable(name="defaultAccountEnabledMessage")
    protected String accountEnabledMessage = "This string should be set by your XSL stylesheet";
    @ModuleSetting(allowsNull=true)
    @TextAreaSettingDescriptor(name="Supported attributes", description="The attributes to show in the form. The format is [name][*/!]:[display name]:[max length]:[StringFormatValidator] (without brackets). Only the name is required. The * sign indicates if the attribute is required or not. The ! sign indicates that the attribute is read only")
    protected String supportedAttributes;
    @ModuleSetting
    @CheckboxSettingDescriptor(name="Require user conditions confirmation", description="Controls whether or not new accounts have to confirmate user conditions")
    protected boolean requireUserConditionConfirmation;
    @ModuleSetting
    @HTMLEditorSettingDescriptor(name="User conditions", description="The text that is displayed as user conditions", required=false)
    @XSLVariable(name="defaultUserConditions")
    protected String userConditions = "This string should be set by your XSL stylesheet";
    @XSLVariable
    protected String defaultEmailSubject = "This string should be set by your XSL stylesheet";
    @XSLVariable
    protected String defaultEmailText = "This string should be set by your XSL stylesheet";
    @ModuleSetting
    @XSLVariable(name="defaultEmailSubject")
    protected String emailSubject = "This string should be set by your XSL stylesheet";
    @ModuleSetting
    @XSLVariable(name="defaultEmailText")
    protected String emailText = "This string should be set by your XSL stylesheet";
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Email address", description="The address from which emails from this module are said to be sent from", required=true)
    protected String emailSenderAddress = "someone@somesite";
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Email sender name", description="The name of the sender from which emails from this module are said to be sent from", required=true)
    protected String emailSenderName = "John Doe";
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Confirmation timeout", description="The amount of time in days before unanswered confirmations are deleted", required=true)
    protected int confirmationTimeout = 7;
    @ModuleSetting
    @CheckboxSettingDescriptor(name="Enable new account notification", description="Controls whether or not new account notification is enabled.")
    protected boolean newAccountNotification;
    @ModuleSetting(allowsNull=true)
    @UserMultiListSettingDescriptor(name="Users to notify", description="Users to be notified when new accounts are activated")
    protected List<Integer> newAccountSubscriberUsers;
    @ModuleSetting(allowsNull=true)
    @GroupMultiListSettingDescriptor(name="Groups to notify", description="Groups to be notified when new accounts are activated")
    protected List<Integer> newAccountSubscriberGroups;
    @XSLVariable
    protected String defaultNewAccountNotificationSubject = "This string should be set by your XSL stylesheet";
    @XSLVariable
    protected String defaultNewAccountNotificationText = "This string should be set by your XSL stylesheet";
    @ModuleSetting
    @XSLVariable(name="defaultNewAccountNotificationSubject")
    protected String newAccountNotificationSubject = "This string should be set by your XSL stylesheet";
    @ModuleSetting
    @XSLVariable(name="defaultNewAccountNotificationText")
    protected String newAccountNotificationText = "This string should be set by your XSL stylesheet";
    protected Timer timer;
    protected CaptchaHandler captchaHandler;
    protected TagSourceFactory<? super UserType> userTagSourceFactory;
    protected TagSourceFactory<User> subscriberTagSourceFactory;
    protected List<AttributeDescriptor> attributes;
    protected List<RegistrationPlugin> registrationPlugins;

    @Override
    public void init(ForegroundModuleDescriptor moduleDescriptor, SectionInterface sectionInterface, DataSource dataSource) throws Exception {
        super.init(moduleDescriptor, sectionInterface, dataSource);
        this.timer = new Timer("Timer for foreground module " + moduleDescriptor, true);
        this.timer.schedule((TimerTask)new RunnableTimerTask((Runnable)this), 30000L, 60000L);
        this.userTagSourceFactory = this.createUserTagSourceFactory();
        this.subscriberTagSourceFactory = this.createSubscriberTagSourceFactory();
    }

    @Override
    protected void moduleConfigured() throws Exception {
        super.moduleConfigured();
        this.captchaHandler = this.createCaptchaHandler();
        this.attributes = AttributeDescriptorUtils.parseAttributes(this.supportedAttributes);
    }

    protected TagSourceFactory<? super UserType> createUserTagSourceFactory() {
        return new AnnotatedBeanTagSourceFactory(User.class, "$user.");
    }

    protected TagSourceFactory<User> createSubscriberTagSourceFactory() {
        return new AnnotatedBeanTagSourceFactory(User.class, "$subscriber.");
    }

    protected CaptchaHandler createCaptchaHandler() {
        this.captchaHandler = new DefaultCaptchaHandler(this.getClass().getName() + ":" + ((ForegroundModuleDescriptor)this.moduleDescriptor).getModuleID(), 300000L, false, this.captchaCharacters);
        return this.captchaHandler;
    }

    @Override
    public void unload() throws Exception {
        this.timer.cancel();
        if (this.registrationPlugins != null) {
            this.registrationPlugins.clear();
        }
        super.unload();
    }

    @Override
    public void run() {
        this.deleteOldConfirmations();
    }

    protected abstract void deleteOldConfirmations();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public SimpleForegroundModuleResponse defaultMethod(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        try {
            block34: {
                this.pluginReadLock.lock();
                validationException = null;
                pluginHandler = this.registrationPlugins != null ? new RegistrationPluginHandler(this.registrationPlugins) : null;
                if (!req.getMethod().equalsIgnoreCase("POST")) ** GOTO lbl74
                newUser = this.populate(req);
                this.populateAttributes(newUser, req);
                this.validatePopulation(newUser, req);
                if (pluginHandler != null) {
                    pluginHandler.populate(req);
                    if (pluginHandler.hasValidationErrors()) {
                        throw new PluginValidationException();
                    }
                }
                this.setUserDefaultAccess(newUser, req);
                this.log.info((Object)("Registering user " + newUser + " requesting from " + req.getRemoteAddr()));
                confirmation = null;
                validationErrors = new ArrayList<ValidationError>();
                this.addUser(newUser);
                SessionUtils.removeAttribute((String)(BaseRegistrationModule.CAPTCHA_PASSED_SESSION_PREFIX + ((ForegroundModuleDescriptor)this.moduleDescriptor).getModuleID()), (HttpServletRequest)req);
                if (this.requireManualConfirmation) {
                    if (pluginHandler != null) {
                        pluginHandler.userAdded((User)newUser);
                    }
                    this.systemInterface.getEventHandler().sendEvent(User.class, new CRUDEvent<UserType>(CRUDAction.ADD, newUser), EventTarget.ALL);
                    if (this.newAccountNotification) {
                        this.sendNewAccountNotifcations(newUser);
                    }
                    var10_12 = this.showRegisteredMessage(req, uriParser, (User)newUser);
                    return var10_12;
                }
                if (!this.requireEmailConfirmation) break block34;
                confirmation = this.createConfirmation(newUser.getUserID(), UUID.randomUUID().toString(), req.getRemoteHost());
                this.addConfirmation(confirmation);
                this.sendEmailConfirmation(newUser, confirmation, req, uriParser);
                if (pluginHandler != null) {
                    pluginHandler.userAdded((User)newUser);
                }
                this.systemInterface.getEventHandler().sendEvent(User.class, new CRUDEvent<UserType>(CRUDAction.ADD, newUser), EventTarget.ALL);
                var10_13 = this.showRegisteredMessage(req, uriParser, (User)newUser);
                return var10_13;
            }
            this.enableUserAccount(newUser);
            if (pluginHandler != null) {
                pluginHandler.userAdded((User)newUser);
            }
            this.systemInterface.getEventHandler().sendEvent(User.class, new CRUDEvent<UserType>(CRUDAction.ADD, newUser), EventTarget.ALL);
            var10_14 = this.accountActivated(req, res, uriParser, newUser, false);
            return var10_14;
            {
                catch (Exception e) {
                    try {
                        this.deleteUser(newUser);
                        if (confirmation != null) {
                            this.deleteConfirmation(confirmation);
                        }
                        if (e instanceof UnableToProcessEmailException) {
                            validationErrors.add(new ValidationError("UnableToProcessEmail"));
                            this.log.error((Object)"Error adding user", (Throwable)e);
                        } else if (e instanceof InvalidEmailAddressException) {
                            validationErrors.add(new ValidationError("InvalidEmailAddress"));
                            this.log.error((Object)"Error adding user", (Throwable)e);
                        } else if (e instanceof NoEmailSendersFoundException) {
                            validationErrors.add(new ValidationError("NoEmailSendersFound"));
                            this.log.error((Object)"Error adding user", (Throwable)e);
                        } else {
                            throw e;
                        }
                        if (!validationErrors.isEmpty()) {
                            throw new ValidationException(validationErrors);
                        }
                    }
                    catch (ValidationException e) {
                        validationException = e;
                    }
                    catch (PluginValidationException e) {
                        // empty catch block
                    }
                    this.log.info((Object)("User " + user + " requesting registration form"));
                    doc = this.createDocument(req, uriParser);
                    addUserElement = doc.createElement("AddUser");
                    doc.getFirstChild().appendChild(addUserElement);
                    addUserElement.appendChild(XMLUtils.createElement((String)"registrationMessage", (Object)URLRewriter.setAbsoluteLinkUrls((String)this.registrationMessage, (HttpServletRequest)req), (Document)doc));
                    if (this.requireCaptchaConfirmation && SessionUtils.getAttribute((String)(BaseRegistrationModule.CAPTCHA_PASSED_SESSION_PREFIX + ((ForegroundModuleDescriptor)this.moduleDescriptor).getModuleID()), (HttpServletRequest)req) == null) {
                        addUserElement.appendChild(doc.createElement("requireCaptchaConfirmation"));
                    }
                    if (this.requireUserConditionConfirmation) {
                        addUserElement.appendChild(doc.createElement("requireUserConditionConfirmation"));
                    }
                    this.appendRegistrationFormData(doc, addUserElement);
                    XMLUtils.append((Document)doc, (Element)addUserElement, (String)"AttrbuteDescriptors", this.attributes);
                    if (validationException != null) {
                        addUserElement.appendChild(validationException.toXML(doc));
                        addUserElement.appendChild(RequestUtils.getRequestParameters((HttpServletRequest)req, (Document)doc));
                    } else if (pluginHandler != null && pluginHandler.hasValidationErrors()) {
                        addUserElement.appendChild(RequestUtils.getRequestParameters((HttpServletRequest)req, (Document)doc));
                    }
                    moduleResponse = new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), new Breadcrumb[]{this.getDefaultBreadcrumb()});
                    if (pluginHandler != null) {
                        viewFragments = pluginHandler.getViewFragments(req, uriParser);
                        pluginsElement = XMLUtils.appendNewElement((Document)doc, (Element)addUserElement, (String)"PluginFragments");
                        for (ViewFragment viewFragment : viewFragments) {
                            ViewFragmentUtils.appendLinksAndScripts(moduleResponse, viewFragment);
                            pluginsElement.appendChild(viewFragment.toXML(doc));
                        }
                    }
                    var10_16 = moduleResponse;
                }
            }
            return var10_16;
        }
        finally {
            this.pluginReadLock.unlock();
        }
    }

    private SimpleForegroundModuleResponse showRegisteredMessage(HttpServletRequest req, URIParser uriParser, User newUser) {
        Document doc = this.createDocument(req, uriParser);
        Element userAddedElement = doc.createElement("UserAdded");
        doc.getFirstChild().appendChild(userAddedElement);
        userAddedElement.appendChild(XMLUtils.createElement((String)"registereredMessage", (Object)URLRewriter.setAbsoluteLinkUrls((String)this.registereredMessage, (HttpServletRequest)req), (Document)doc));
        userAddedElement.appendChild(newUser.toXML(doc));
        return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb());
    }

    protected void populateAttributes(UserType newUser, HttpServletRequest req) throws ValidationException {
        AttributeHandler attributeHandler;
        if (this.attributes != null && (attributeHandler = ((User)newUser).getAttributeHandler()) != null && attributeHandler instanceof MutableAttributeHandler) {
            ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>(this.attributes.size());
            AttributeDescriptorUtils.populateAttributes((MutableAttributeHandler)attributeHandler, this.attributes, req, validationErrors);
            if (!validationErrors.isEmpty()) {
                throw new ValidationException(validationErrors);
            }
        }
    }

    public void appendRegistrationFormData(Document doc, Element addUserElement) {
    }

    @WebPublic(alias="userconditions")
    public ForegroundModuleResponse showUserConditions(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        if (this.requireUserConditionConfirmation) {
            res.getWriter().write("<html><body>" + this.userConditions + "</body></html>");
            res.getWriter().close();
            return null;
        }
        throw new URINotFoundException(uriParser);
    }

    protected abstract ConfirmationType createConfirmation(Integer var1, String var2, String var3);

    protected abstract void deleteUser(UserType var1) throws SQLException, UnableToDeleteUserException;

    protected abstract void addConfirmation(ConfirmationType var1) throws SQLException;

    protected abstract void addUser(UserType var1) throws SQLException, UnableToAddUserException;

    protected void validatePopulation(UserType newUser, HttpServletRequest req) throws ValidationException, SQLException {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        if (this.findUserByUsername(((User)newUser).getUsername()) != null) {
            validationErrors.add(new ValidationError("UsernameAlreadyTaken"));
        }
        this.validateEmailFields(validationErrors, req, newUser);
        String passwordConfirmation = req.getParameter("passwordConfirmation");
        if (StringUtils.isEmpty((String)req.getParameter("password"))) {
            validationErrors.add(new ValidationError("password", ValidationErrorType.RequiredField));
        } else if (StringUtils.isEmpty((String)passwordConfirmation) || !((User)newUser).getPassword().equalsIgnoreCase(passwordConfirmation.trim())) {
            validationErrors.add(new ValidationError("PasswordConfirmationMismatch"));
        }
        if (this.requireCaptchaConfirmation && SessionUtils.getAttribute((String)(CAPTCHA_PASSED_SESSION_PREFIX + ((ForegroundModuleDescriptor)this.moduleDescriptor).getModuleID()), (HttpServletRequest)req) == null) {
            String captchaConfirmation = req.getParameter("captchaConfirmation");
            if (StringUtils.isEmpty((String)captchaConfirmation) || !this.captchaHandler.isValidCode(req, captchaConfirmation)) {
                validationErrors.add(new ValidationError("InvalidCaptchaConfirmation"));
            } else {
                SessionUtils.setAttribute((String)(CAPTCHA_PASSED_SESSION_PREFIX + ((ForegroundModuleDescriptor)this.moduleDescriptor).getModuleID()), (Object)true, (HttpServletRequest)req);
            }
        }
        if (this.requireUserConditionConfirmation && !Boolean.valueOf(req.getParameter("userConditionConfirmation")).booleanValue()) {
            validationErrors.add(new ValidationError("NoUserConditionConfirmation"));
        }
        if (!validationErrors.isEmpty()) {
            throw new ValidationException(validationErrors);
        }
    }

    protected void validateEmailFields(ArrayList<ValidationError> validationErrors, HttpServletRequest req, UserType newUser) throws SQLException {
        String emailConfirmation = req.getParameter("emailConfirmation");
        if (((User)newUser).getEmail() != null && (StringUtils.isEmpty((String)emailConfirmation) || !((User)newUser).getEmail().equalsIgnoreCase(emailConfirmation.trim()))) {
            validationErrors.add(new ValidationError("EmailConfirmationMismatch"));
        } else if (((User)newUser).getEmail() == null && !StringUtils.isEmpty((String)emailConfirmation)) {
            validationErrors.add(new ValidationError("EmailConfirmationMismatch"));
        } else if (((User)newUser).getEmail() != null && this.findUserByEmail(((User)newUser).getEmail()) != null) {
            validationErrors.add(new ValidationError("EmailAlreadyTaken"));
        }
    }

    protected abstract User findUserByEmail(String var1) throws SQLException;

    protected abstract User findUserByUsername(String var1) throws SQLException;

    protected abstract UserType populate(HttpServletRequest var1) throws ValidationException;

    @WebPublic
    public SimpleForegroundModuleResponse confirm(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        if (uriParser.size() != 3) {
            throw new URINotFoundException(uriParser);
        }
        ConfirmationType confirmation = this.getConfirmation(uriParser.get(2));
        if (confirmation != null) {
            UserType newUser = this.findUserByID(confirmation.getUserID());
            this.log.info((Object)("User " + newUser + " activating account from address " + req.getRemoteAddr()));
            if (!((User)newUser).isEnabled()) {
                this.enableUserAccount(newUser);
            }
            this.deleteConfirmation(confirmation);
            return this.accountActivated(req, res, uriParser, newUser, false);
        }
        throw new URINotFoundException(uriParser);
    }

    protected SimpleForegroundModuleResponse accountActivated(HttpServletRequest req, HttpServletResponse res, URIParser uriParser, UserType newUser, boolean userChanged) throws Exception {
        if (this.newAccountNotification) {
            this.sendNewAccountNotifcations(newUser);
        }
        Document doc = this.createDocument(req, uriParser);
        Element userEnabledElement = doc.createElement("AccountEnabled");
        doc.getFirstChild().appendChild(userEnabledElement);
        userEnabledElement.appendChild(((User)newUser).toXML(doc));
        userEnabledElement.appendChild(XMLUtils.createElement((String)"accountEnabledMessage", (Object)URLRewriter.setAbsoluteLinkUrls((String)this.accountEnabledMessage, (HttpServletRequest)req), (Document)doc));
        SimpleForegroundModuleResponse moduleRespone = new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb());
        moduleRespone.setUserChanged(userChanged);
        return moduleRespone;
    }

    private void sendNewAccountNotifcations(UserType newUser) {
        Collection<User> users = null;
        if (this.newAccountSubscriberUsers != null) {
            users = this.systemInterface.getUserHandler().getUsers(this.newAccountSubscriberUsers, false, false);
        }
        if (this.newAccountSubscriberGroups != null) {
            if (users == null) {
                users = this.systemInterface.getUserHandler().getUsersByGroups(this.newAccountSubscriberGroups, false);
            } else {
                List<User> groupUsers = this.systemInterface.getUserHandler().getUsersByGroups(this.newAccountSubscriberGroups, false);
                if (groupUsers != null) {
                    users = new HashSet<User>(users);
                    users.addAll(groupUsers);
                }
            }
        }
        if (CollectionUtils.isEmpty(users)) {
            return;
        }
        for (User subscriber : users) {
            try {
                TagReplacer tagReplacer = this.getNewAccountNotificationTagReplacer(newUser, subscriber);
                SimpleEmail email = new SimpleEmail();
                email.setSenderName(this.emailSenderName);
                email.setSenderAddress(this.emailSenderAddress);
                email.setSubject(tagReplacer.replace(this.newAccountNotificationSubject));
                email.setMessage(tagReplacer.replace(this.newAccountNotificationText));
                email.addRecipient(subscriber.getEmail());
                this.systemInterface.getEmailHandler().send((Email)email);
            }
            catch (InvalidEmailAddressException e) {
                this.log.error((Object)("Error sending new account notification to user " + subscriber), (Throwable)e);
            }
            catch (NoEmailSendersFoundException e) {
                this.log.error((Object)("Error sending new account notification to user " + subscriber), (Throwable)e);
            }
            catch (UnableToProcessEmailException e) {
                this.log.error((Object)("Error sending new account notification to user " + subscriber), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TagReplacer getNewAccountNotificationTagReplacer(UserType user, User subscriber) {
        this.pluginReadLock.lock();
        try {
            if (this.registrationPlugins != null) {
                ArrayList<TagSource> tagSources = new ArrayList<TagSource>(this.registrationPlugins.size() + 2);
                tagSources.add(this.userTagSourceFactory.getTagSource(user));
                tagSources.add(this.subscriberTagSourceFactory.getTagSource((Object)subscriber));
                for (RegistrationPlugin registrationPlugin : this.registrationPlugins) {
                    try {
                        List<TagSource> pluginTagSources = registrationPlugin.getTagSources((User)user);
                        if (pluginTagSources == null) continue;
                        tagSources.addAll(pluginTagSources);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Error getting tag source from registration plugin " + registrationPlugin), (Throwable)e);
                    }
                }
                TagReplacer tagReplacer = new TagReplacer(tagSources);
                return tagReplacer;
            }
        }
        finally {
            this.pluginReadLock.unlock();
        }
        return new TagReplacer(new TagSource[]{this.userTagSourceFactory.getTagSource(user), this.subscriberTagSourceFactory.getTagSource((Object)subscriber)});
    }

    protected abstract void deleteConfirmation(ConfirmationType var1) throws SQLException;

    protected abstract void enableUserAccount(UserType var1) throws SQLException, UnableToUpdateUserException;

    protected abstract UserType findUserByID(Integer var1) throws SQLException;

    protected abstract ConfirmationType getConfirmation(String var1) throws SQLException;

    @WebPublic(alias="captcha")
    public SimpleForegroundModuleResponse getCaptchaImage(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        this.captchaHandler.getCaptchaImage(req, res);
        return null;
    }

    protected void sendEmailConfirmation(UserType newUser, ConfirmationType confirmation, HttpServletRequest req, URIParser uriParser) throws InvalidEmailAddressException, NoEmailSendersFoundException, UnableToProcessEmailException {
        TagReplacer tagReplacer = this.getConfirmationTagReplacer(newUser, confirmation, req);
        SimpleEmail email = new SimpleEmail();
        email.setSenderName(this.emailSenderName);
        email.setSenderAddress(this.emailSenderAddress);
        email.setSubject(tagReplacer.replace(this.emailSubject));
        email.addRecipient(((User)newUser).getEmail());
        String message = tagReplacer.replace(this.emailText);
        message = message.replace(CONFIRMATION_LINK, uriParser.getRequestURL() + "/confirm/" + confirmation.getLinkID());
        message = message.replace(CONFIRMATION_TIMEOUT, this.confirmationTimeout + "");
        email.setMessage(message);
        this.sectionInterface.getSystemInterface().getEmailHandler().send((Email)email);
    }

    protected abstract TagReplacer getConfirmationTagReplacer(UserType var1, ConfirmationType var2, HttpServletRequest var3);

    protected void setUserDefaultAccess(UserType newUser, HttpServletRequest req) {
    }

    public Document createDocument(HttpServletRequest req, URIParser uriParser) {
        Document doc = XMLUtils.createDomDocument();
        Element document = doc.createElement("Document");
        document.appendChild(RequestUtils.getRequestInfoAsXML((Document)doc, (HttpServletRequest)req, (URIParser)uriParser));
        document.appendChild(((ForegroundModuleDescriptor)this.moduleDescriptor).toXML(doc));
        doc.appendChild(document);
        return doc;
    }

    @Override
    public List<SettingDescriptor> getSettings() {
        ArrayList<SettingDescriptor> combinedSettings = new ArrayList<SettingDescriptor>();
        ModuleUtils.addSettings(combinedSettings, super.getSettings());
        combinedSettings.add(SettingDescriptor.createTextFieldSetting("emailSubject", "Confirmation email subject", "The subject of the confirmation email. The following tags can be used: " + this.getConfirmationTags(), true, this.defaultEmailSubject, null));
        combinedSettings.add(SettingDescriptor.createTextAreaSetting("emailText", "Email text", "The text of the confirmation e-mail. The following tags can be used: " + this.getConfirmationTags(), true, this.defaultEmailText, null));
        combinedSettings.add(SettingDescriptor.createTextFieldSetting("newAccountNotificationSubject", "New account notification subject", "The subject of the new account notification email. The following tags can be used: " + this.getNewAccountNotificationTags(), true, this.defaultNewAccountNotificationSubject, null));
        combinedSettings.add(SettingDescriptor.createTextAreaSetting("newAccountNotificationText", "New account notification text", "The text of the new account notification e-mail. The following tags can be used: " + this.getNewAccountNotificationTags(), true, this.defaultNewAccountNotificationText, null));
        return combinedSettings;
    }

    protected String getNewAccountNotificationTags() {
        return this.userTagSourceFactory.getAvailableTags() + ", " + this.subscriberTagSourceFactory.getAvailableTags();
    }

    protected abstract String getConfirmationTags();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRegistrationPlugin(RegistrationPlugin<?> registrationPlugin) {
        try {
            boolean added;
            this.pluginWriteLock.lock();
            if (this.registrationPlugins == null) {
                this.registrationPlugins = new ArrayList<RegistrationPlugin>();
                added = this.registrationPlugins.add(registrationPlugin);
            } else if (!this.registrationPlugins.contains(registrationPlugin)) {
                added = this.registrationPlugins.add(registrationPlugin);
            } else {
                boolean bl = false;
                return bl;
            }
            if (added) {
                this.log.info((Object)("Registration plugin " + registrationPlugin + " added to module " + this.moduleDescriptor));
                Collections.sort(this.registrationPlugins, PRIORITY_COMPARATOR);
            }
            boolean bl = added;
            return bl;
        }
        finally {
            this.pluginWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRegistrationPlugin(RegistrationPlugin<?> registrationPlugin) {
        try {
            this.pluginWriteLock.lock();
            if (this.registrationPlugins == null) {
                boolean bl = false;
                return bl;
            }
            boolean removed = this.registrationPlugins.remove(registrationPlugin);
            if (removed) {
                this.log.info((Object)("Registration plugin " + registrationPlugin + " removed from module " + this.moduleDescriptor));
                if (this.registrationPlugins.isEmpty()) {
                    this.registrationPlugins = null;
                }
            }
            boolean bl = removed;
            return bl;
        }
        finally {
            this.pluginWriteLock.unlock();
        }
    }
}

