/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.registration;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.exceptions.UnableToDeleteUserException;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.foregroundmodules.registration.AnnotatedConfirmation;
import se.unlogic.hierarchy.foregroundmodules.registration.BaseRegistrationModule;
import se.unlogic.standardutils.dao.AnnotatedDAO;
import se.unlogic.standardutils.dao.HighLevelQuery;
import se.unlogic.standardutils.dao.QueryOperators;
import se.unlogic.standardutils.dao.QueryParameterFactory;
import se.unlogic.standardutils.dao.SimpleAnnotatedDAOFactory;
import se.unlogic.standardutils.dao.querys.UpdateQuery;
import se.unlogic.standardutils.db.DBUtils;
import se.unlogic.standardutils.db.tableversionhandler.DBScriptProvider;
import se.unlogic.standardutils.db.tableversionhandler.TableUpgradeException;
import se.unlogic.standardutils.db.tableversionhandler.TableVersionHandler;
import se.unlogic.standardutils.db.tableversionhandler.UpgradeResult;
import se.unlogic.standardutils.db.tableversionhandler.XMLDBScriptProvider;
import se.unlogic.standardutils.string.BeanTagSourceFactory;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.string.TagReplacer;
import se.unlogic.standardutils.string.TagSource;

public abstract class AnnotatedConfirmationRegistrationModule<UserType extends User>
extends BaseRegistrationModule<UserType, AnnotatedConfirmation> {
    protected String availableConfirmationTags;
    protected BeanTagSourceFactory<AnnotatedConfirmation> confirmationTagSourceFactory = new BeanTagSourceFactory(AnnotatedConfirmation.class);
    private AnnotatedDAO<AnnotatedConfirmation> confirmationDAO;
    private QueryParameterFactory<AnnotatedConfirmation, Timestamp> addedQueryParameterFactory;
    private QueryParameterFactory<AnnotatedConfirmation, String> linkIDQueryParameterFactory;

    @Override
    public void init(ForegroundModuleDescriptor moduleDescriptor, SectionInterface sectionInterface, DataSource dataSource) throws Exception {
        super.init(moduleDescriptor, sectionInterface, dataSource);
        this.confirmationTagSourceFactory.addAllFields("$confirmation.", new String[0]);
        this.availableConfirmationTags = this.userTagSourceFactory.getAvailableTags() + ", " + this.confirmationTagSourceFactory.getAvailableTags() + ", " + "$confirmation-link" + ", " + "$confirmation-timeout";
    }

    @Override
    protected void createDAOs(DataSource dataSource) throws Exception {
        this.createDBTables(dataSource);
        SimpleAnnotatedDAOFactory annotatedDAOFactory = new SimpleAnnotatedDAOFactory(dataSource);
        this.confirmationDAO = annotatedDAOFactory.getDAO(AnnotatedConfirmation.class);
        this.addedQueryParameterFactory = this.confirmationDAO.getParamFactory("added", Timestamp.class);
        this.linkIDQueryParameterFactory = this.confirmationDAO.getParamFactory("linkID", String.class);
    }

    protected void createDBTables(DataSource dataSource) throws SQLException, IOException, TableUpgradeException, SAXException, ParserConfigurationException {
        UpgradeResult upgradeResult;
        if (TableVersionHandler.getTableGroupVersion((DataSource)dataSource, (String)AnnotatedConfirmationRegistrationModule.class.getName()) == null) {
            String sql;
            if (!DBUtils.tableExists((DataSource)dataSource, (String)"registrationcofirmations")) {
                this.log.info((Object)("Creating registrationcofirmations table in datasource " + dataSource));
                sql = StringUtils.readStreamAsString((InputStream)AnnotatedConfirmationRegistrationModule.class.getResourceAsStream("dbscripts/RegistrationCofirmationsTable.sql"));
                new UpdateQuery(dataSource.getConnection(), true, sql).executeUpdate();
            } else if (DBUtils.getTableColumnCount((DataSource)dataSource, (String)"registrationcofirmations") == 3) {
                this.log.info((Object)("Applying upgrade script 1 to registrationcofirmations table in datasource " + dataSource));
                sql = StringUtils.readStreamAsString((InputStream)AnnotatedConfirmationRegistrationModule.class.getResourceAsStream("dbscripts/UpgradeScript-1.sql"));
                new UpdateQuery(dataSource.getConnection(), true, sql).executeUpdate();
            }
        }
        if ((upgradeResult = TableVersionHandler.upgradeDBTables((DataSource)dataSource, (String)AnnotatedConfirmationRegistrationModule.class.getName(), (DBScriptProvider)new XMLDBScriptProvider(AnnotatedConfirmationRegistrationModule.class.getResourceAsStream("dbscripts/DB script.xml")))).isUpgrade()) {
            this.log.info((Object)upgradeResult.toString());
        }
    }

    protected abstract BeanTagSourceFactory<UserType> createUserBeanTagSourceFactory();

    @Override
    protected void addConfirmation(AnnotatedConfirmation confirmation) throws SQLException {
        this.confirmationDAO.add((Object)confirmation);
    }

    @Override
    protected void deleteConfirmation(AnnotatedConfirmation confirmation) throws SQLException {
        this.confirmationDAO.delete((Object)confirmation);
    }

    @Override
    protected void deleteOldConfirmations() {
        HighLevelQuery query = new HighLevelQuery();
        query.addParameter(this.addedQueryParameterFactory.getParameter((Object)new Timestamp(System.currentTimeMillis() - (long)(this.confirmationTimeout * 86400000)), QueryOperators.SMALLER_THAN));
        try {
            List oldConfirmations = this.confirmationDAO.getAll(query);
            if (oldConfirmations != null) {
                for (AnnotatedConfirmation confirmation : oldConfirmations) {
                    this.log.info((Object)("Deleting timed out confirmation " + confirmation));
                    this.confirmationDAO.delete((Object)confirmation);
                    Object user = this.findUserByID(confirmation.getUserID());
                    if (user == null || ((User)user).isEnabled()) continue;
                    this.log.info((Object)("Deleting disabled user " + user));
                    try {
                        this.deleteUser(user);
                    }
                    catch (UnableToDeleteUserException e) {
                        this.log.error((Object)("Error deleting disabled user " + user), (Throwable)e);
                    }
                }
            }
        }
        catch (SQLException e) {
            this.log.error((Object)"Error deleting old confirmations", (Throwable)e);
        }
    }

    @Override
    protected AnnotatedConfirmation getConfirmation(String id) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addParameter(this.linkIDQueryParameterFactory.getParameter((Object)id));
        return (AnnotatedConfirmation)this.confirmationDAO.get(query);
    }

    @Override
    protected TagReplacer getConfirmationTagReplacer(UserType newUser, AnnotatedConfirmation confirmation, HttpServletRequest req) {
        TagReplacer tagReplacer = new TagReplacer();
        tagReplacer.addTagSource(this.userTagSourceFactory.getTagSource(newUser));
        tagReplacer.addTagSource((TagSource)this.confirmationTagSourceFactory.getTagSource((Object)confirmation));
        return tagReplacer;
    }

    @Override
    protected String getConfirmationTags() {
        return this.availableConfirmationTags;
    }

    @Override
    protected AnnotatedConfirmation createConfirmation(Integer userID, String linkID, String remoteHost) {
        return new AnnotatedConfirmation(userID, linkID, remoteHost);
    }
}

