/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.pagemodules.daos.annotated;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;
import se.unlogic.hierarchy.foregroundmodules.pagemodules.daos.PageDAO;
import se.unlogic.hierarchy.foregroundmodules.pagemodules.daos.PageDAOFactory;
import se.unlogic.hierarchy.foregroundmodules.pagemodules.daos.annotated.AnnotatedPageDAO;
import se.unlogic.standardutils.dao.querys.UpdateQuery;
import se.unlogic.standardutils.db.DBUtils;
import se.unlogic.standardutils.db.tableversionhandler.DBScriptProvider;
import se.unlogic.standardutils.db.tableversionhandler.TableUpgradeException;
import se.unlogic.standardutils.db.tableversionhandler.TableVersionHandler;
import se.unlogic.standardutils.db.tableversionhandler.UpgradeResult;
import se.unlogic.standardutils.db.tableversionhandler.XMLDBScriptProvider;
import se.unlogic.standardutils.string.StringUtils;

public class AnnotatedPageDAOFactory
extends PageDAOFactory {
    private static Logger log = Logger.getLogger(AnnotatedPageDAOFactory.class);
    private AnnotatedPageDAO pageDAO;

    @Override
    public void init(DataSource dataSource) throws SQLException, IOException, TableUpgradeException, SAXException, ParserConfigurationException {
        UpgradeResult upgradeResult;
        log.debug((Object)("Checking for page tables in datasource " + dataSource));
        if (TableVersionHandler.getTableGroupVersion((DataSource)dataSource, (String)AnnotatedPageDAOFactory.class.getName()) == null) {
            String sql;
            if (!DBUtils.tableExists((DataSource)dataSource, (String)"pages")) {
                log.info((Object)("Creating pages table in datasource " + dataSource));
                sql = StringUtils.readStreamAsString((InputStream)this.getClass().getResourceAsStream("dbscripts/PagesTable.sql"));
                new UpdateQuery(dataSource.getConnection(), true, sql).executeUpdate();
            } else if (DBUtils.getTableColumnCount((DataSource)dataSource, (String)"pages") == 11) {
                log.info((Object)("Adding breadCrumb column to page table in datasource " + dataSource));
                new UpdateQuery(dataSource.getConnection(), true, "ALTER TABLE `pages` ADD COLUMN `breadCrumb` BOOLEAN NOT NULL DEFAULT 1 AFTER `alias`;").executeUpdate();
            }
            if (!DBUtils.tableExists((DataSource)dataSource, (String)"pagegroups")) {
                log.info((Object)("Creating pagegroups table in datasource " + dataSource));
                sql = StringUtils.readStreamAsString((InputStream)this.getClass().getResourceAsStream("dbscripts/PageGroupsTable.sql"));
                new UpdateQuery(dataSource.getConnection(), true, sql).executeUpdate();
            }
            if (!DBUtils.tableExists((DataSource)dataSource, (String)"pageusers")) {
                log.info((Object)("Creating pageusers table in datasource " + dataSource));
                sql = StringUtils.readStreamAsString((InputStream)this.getClass().getResourceAsStream("dbscripts/PageUsersTable.sql"));
                new UpdateQuery(dataSource.getConnection(), true, sql).executeUpdate();
            }
        }
        if ((upgradeResult = TableVersionHandler.upgradeDBTables((DataSource)dataSource, (String)AnnotatedPageDAOFactory.class.getName(), (DBScriptProvider)new XMLDBScriptProvider(AnnotatedPageDAOFactory.class.getResourceAsStream("dbscripts/DB script.xml")))).isUpgrade()) {
            log.info((Object)upgradeResult.toString());
        }
        this.pageDAO = new AnnotatedPageDAO(dataSource);
    }

    @Override
    public PageDAO getPageDAO() {
        return this.pageDAO;
    }
}

