/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.pagemodules.daos.annotated;

import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import se.unlogic.hierarchy.foregroundmodules.pagemodules.Page;
import se.unlogic.hierarchy.foregroundmodules.pagemodules.daos.PageDAO;
import se.unlogic.standardutils.dao.AnnotatedDAO;
import se.unlogic.standardutils.dao.AnnotatedDAOFactory;
import se.unlogic.standardutils.dao.HighLevelQuery;
import se.unlogic.standardutils.dao.QueryParameter;
import se.unlogic.standardutils.dao.QueryParameterFactory;
import se.unlogic.standardutils.dao.SimpleAnnotatedDAOFactory;

public class AnnotatedPageDAO
extends AnnotatedDAO<Page>
implements PageDAO {
    private QueryParameterFactory<Page, Integer> pageIDParamFactory = this.getParamFactory("pageID", Integer.class);
    private QueryParameterFactory<Page, Integer> sectionIDParamFactory = this.getParamFactory("sectionID", Integer.class);
    private QueryParameterFactory<Page, String> aliasParamFactory = this.getParamFactory("alias", String.class);
    private QueryParameter<Page, Boolean> enabledParameter = this.getParamFactory("enabled", Boolean.TYPE).getParameter((Object)true);
    private QueryParameter<Page, Boolean> visibleInMenuParameter = this.getParamFactory("visibleInMenu", Boolean.TYPE).getParameter((Object)true);

    public AnnotatedPageDAO(DataSource dataSource) {
        super(dataSource, Page.class, (AnnotatedDAOFactory)new SimpleAnnotatedDAOFactory(dataSource));
    }

    @Override
    public List<Page> getEnabledPages(int sectionID) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addParameter(this.enabledParameter);
        query.addParameter(this.sectionIDParamFactory.getParameter((Object)sectionID));
        return this.getAll(query);
    }

    @Override
    public Page getPage(int pageID, int sectionID) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addParameter(this.pageIDParamFactory.getParameter((Object)pageID));
        query.addParameter(this.sectionIDParamFactory.getParameter((Object)sectionID));
        return (Page)this.get(query);
    }

    @Override
    public Page getPage(int pageID) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addParameter(this.pageIDParamFactory.getParameter((Object)pageID));
        return (Page)this.get(query);
    }

    @Override
    public Page getPage(String alias, int sectionID) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addParameter(this.aliasParamFactory.getParameter((Object)alias));
        query.addParameter(this.sectionIDParamFactory.getParameter((Object)sectionID));
        return (Page)this.get(query);
    }

    @Override
    public List<Page> getPages(int sectionID) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addParameter(this.sectionIDParamFactory.getParameter((Object)sectionID));
        return this.getAll(query);
    }

    @Override
    public List<Page> getVisibleEnabledPages(int sectionID) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addParameter(this.enabledParameter);
        query.addParameter(this.visibleInMenuParameter);
        query.addParameter(this.sectionIDParamFactory.getParameter((Object)sectionID));
        return this.getAll(query);
    }

    @Override
    public boolean sectionHasEnabledPages(int sectionID) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addParameter(this.sectionIDParamFactory.getParameter((Object)sectionID));
        query.addParameter(this.enabledParameter);
        return this.getBoolean(query);
    }
}

