/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.pagemodules;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import se.unlogic.hierarchy.foregroundmodules.pagemodules.Page;
import se.unlogic.standardutils.dao.BeanResultSetPopulator;
import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.webutils.http.BeanRequestPopulator;
import se.unlogic.webutils.validation.ValidationUtils;

public class PagePopulator
implements BeanResultSetPopulator<Page>,
BeanRequestPopulator<Page> {
    public Page populate(ResultSet rs) throws SQLException {
        Page page = new Page();
        page.setPageID(rs.getInt("pageID"));
        page.setAdminAccess(rs.getBoolean("adminAccess"));
        page.setAnonymousAccess(rs.getBoolean("anonymousAccess"));
        page.setDescription(rs.getString("description"));
        page.setEnabled(rs.getBoolean("enabled"));
        page.setName(rs.getString("name"));
        page.setAlias(rs.getString("alias"));
        page.setText(rs.getString("text"));
        page.setUserAccess(rs.getBoolean("userAccess"));
        page.setVisibleInMenu(rs.getBoolean("visibleInMenu"));
        page.setBreadCrumb(rs.getBoolean("breadCrumb"));
        Long sectionID = (Long)rs.getObject("sectionID");
        if (sectionID != null) {
            page.setSectionID(sectionID.intValue());
        }
        return page;
    }

    public Page populate(Page page, HttpServletRequest req) throws ValidationException {
        ArrayList validationErrors = new ArrayList();
        String alias = ValidationUtils.validateNotEmptyParameter((String)"alias", (HttpServletRequest)req, validationErrors);
        String name = ValidationUtils.validateNotEmptyParameter((String)"name", (HttpServletRequest)req, validationErrors);
        String description = ValidationUtils.validateNotEmptyParameter((String)"description", (HttpServletRequest)req, validationErrors);
        String text = ValidationUtils.validateNotEmptyParameter((String)"text", (HttpServletRequest)req, validationErrors);
        if (!validationErrors.isEmpty()) {
            throw new ValidationException(validationErrors);
        }
        page.setAlias(alias);
        page.setName(name);
        page.setDescription(description);
        page.setText(text);
        page.setAdminAccess(req.getParameter("adminAccess") != null);
        page.setAnonymousAccess(req.getParameter("anonymousAccess") != null);
        page.setUserAccess(req.getParameter("userAccess") != null);
        page.setVisibleInMenu(req.getParameter("visibleInMenu") != null);
        page.setEnabled(req.getParameter("enabled") != null);
        page.setBreadCrumb(req.getParameter("breadCrumb") != null);
        String[] allowedUserIDs = req.getParameterValues("user");
        ArrayList userIDs = null;
        if (allowedUserIDs != null) {
            userIDs = NumberUtils.toInt((String[])allowedUserIDs);
        }
        page.setAllowedUserIDs(userIDs);
        String[] allowedGroupIDs = req.getParameterValues("group");
        ArrayList groupIDs = null;
        if (allowedGroupIDs != null) {
            groupIDs = NumberUtils.toInt((String[])allowedGroupIDs);
        }
        page.setAllowedGroupIDs(groupIDs);
        return page;
    }

    public Page populate(HttpServletRequest req) throws ValidationException {
        Page page = new Page();
        return this.populate(page, req);
    }
}

