/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.pagemodules;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.annotations.CheckboxSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.ModuleSetting;
import se.unlogic.hierarchy.core.annotations.TextFieldSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.WebPublic;
import se.unlogic.hierarchy.core.beans.Breadcrumb;
import se.unlogic.hierarchy.core.beans.SettingDescriptor;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleResponse;
import se.unlogic.hierarchy.core.beans.SimpleSectionDescriptor;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.daos.interfaces.SectionDAO;
import se.unlogic.hierarchy.core.enums.PathType;
import se.unlogic.hierarchy.core.enums.SystemStatus;
import se.unlogic.hierarchy.core.enums.URLType;
import se.unlogic.hierarchy.core.exceptions.URINotFoundException;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleResponse;
import se.unlogic.hierarchy.core.interfaces.ModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.RootSectionInterface;
import se.unlogic.hierarchy.core.interfaces.SectionCacheListener;
import se.unlogic.hierarchy.core.interfaces.SectionDescriptor;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.core.sections.Section;
import se.unlogic.hierarchy.core.utils.AccessUtils;
import se.unlogic.hierarchy.core.utils.BaseFileAccessValidator;
import se.unlogic.hierarchy.core.utils.FCKConnector;
import se.unlogic.hierarchy.core.utils.ModuleUtils;
import se.unlogic.hierarchy.core.utils.usergrouplist.UserGroupListConnector;
import se.unlogic.hierarchy.foregroundmodules.AnnotatedForegroundModule;
import se.unlogic.hierarchy.foregroundmodules.pagemodules.Page;
import se.unlogic.hierarchy.foregroundmodules.pagemodules.PagePopulator;
import se.unlogic.hierarchy.foregroundmodules.pagemodules.PageViewModule;
import se.unlogic.hierarchy.foregroundmodules.pagemodules.daos.PageDAO;
import se.unlogic.hierarchy.foregroundmodules.pagemodules.daos.PageDAOFactory;
import se.unlogic.hierarchy.foregroundmodules.pagemodules.daos.annotated.AnnotatedPageDAOFactory;
import se.unlogic.hierarchy.foregroundmodules.systemadmin.RootSectionUpdater;
import se.unlogic.hierarchy.foregroundmodules.systemadmin.SectionUpdater;
import se.unlogic.standardutils.collections.KeyAlreadyCachedException;
import se.unlogic.standardutils.collections.KeyNotCachedException;
import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.validation.PositiveStringIntegerValidator;
import se.unlogic.standardutils.validation.StringFormatValidator;
import se.unlogic.standardutils.validation.StringIntegerValidator;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.validation.ValidationErrorType;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.RequestUtils;
import se.unlogic.webutils.http.URIParser;
import se.unlogic.webutils.url.URLRewriter;

public class PageAdminModule
extends AnnotatedForegroundModule
implements SectionCacheListener {
    private static HashMap<DataSource, ForegroundModuleDescriptor> dataSourceInstanceMap = new HashMap();
    private static final ReentrantReadWriteLock mapLock = new ReentrantReadWriteLock();
    private static final Lock mapReadLock = mapLock.readLock();
    private static final Lock mapWriteLock = mapLock.writeLock();
    private static final ArrayList<SettingDescriptor> SETTINGDESCRIPTORS = new ArrayList(4);
    @ModuleSetting
    @CheckboxSettingDescriptor(name="Disable preview", description="Show pages in their corresponding section instead of preview if possible")
    private boolean disablePreview = true;
    private static final PagePopulator POPULATOR;
    private ConcurrentHashMap<Integer, PageViewModule> viewerModuleMap = new ConcurrentHashMap();
    private PageDAO pageDAO;
    private SectionDAO sectionDAO;
    private FCKConnector connector;
    @ModuleSetting(allowsNull=true)
    protected String filestore;
    @ModuleSetting(allowsNull=true)
    protected String csspath;
    @ModuleSetting
    protected Integer diskThreshold = 100;
    @ModuleSetting
    @TextFieldSettingDescriptor(name="RAM threshold", description="Maximum size of files in KB to be buffered in RAM during file uploads. Files exceeding the threshold are written to disk instead.", required=true, formatValidator=PositiveStringIntegerValidator.class)
    protected Integer ramThreshold = 500;
    @ModuleSetting
    protected String pageViewModuleName = "Page viewer";
    @ModuleSetting
    protected String pageViewModuleAlias = "page";
    @ModuleSetting
    protected String pageViewModuleXSLPathType = PathType.Classpath.toString();
    @ModuleSetting
    protected String pageViewModuleXSLPath = "PageViewModule.en.xsl";
    private UserGroupListConnector userGroupListConnector;

    private void addInstanceToMap() {
        mapWriteLock.lock();
        try {
            dataSourceInstanceMap.put(this.dataSource, (ForegroundModuleDescriptor)this.moduleDescriptor);
        }
        finally {
            mapWriteLock.unlock();
        }
    }

    private void removeInstanceFromMap() {
        mapWriteLock.lock();
        try {
            dataSourceInstanceMap.remove(this.dataSource);
        }
        finally {
            mapWriteLock.unlock();
        }
    }

    public static ForegroundModuleDescriptor getPageAdminModule(DataSource dataSource) {
        mapReadLock.lock();
        try {
            ForegroundModuleDescriptor foregroundModuleDescriptor = dataSourceInstanceMap.get(dataSource);
            return foregroundModuleDescriptor;
        }
        finally {
            mapReadLock.unlock();
        }
    }

    @Override
    public void init(ForegroundModuleDescriptor moduleDescriptor, SectionInterface sectionInterface, DataSource dataSource) throws Exception {
        super.init(moduleDescriptor, sectionInterface, dataSource);
        this.sectionDAO = this.sectionInterface.getSystemInterface().getCoreDaoFactory().getSectionDAO();
        this.connector = new FCKConnector(this.filestore, this.diskThreshold, this.ramThreshold);
        this.addInstanceToMap();
        ((ForegroundModuleDescriptor)this.moduleDescriptor).getMutableSettingHandler().setSetting(PageAdminModule.class.toString(), moduleDescriptor.getModuleID());
        this.createViewModules(this.systemInterface.getRootSection(), true);
        this.systemInterface.addSectionCacheListener(this);
    }

    @Override
    public void update(ForegroundModuleDescriptor moduleDescriptor, DataSource dataSource) throws Exception {
        super.update(moduleDescriptor, dataSource);
        this.connector.setDiskThreshold(this.diskThreshold);
        this.connector.setRamThreshold(this.ramThreshold);
        this.connector.setFilestorePath(this.filestore);
        this.addInstanceToMap();
        ((ForegroundModuleDescriptor)this.moduleDescriptor).getMutableSettingHandler().setSetting(PageAdminModule.class.toString(), moduleDescriptor.getModuleID());
        this.updateViewModules(this.systemInterface.getRootSection());
    }

    @Override
    public void unload() throws Exception {
        super.unload();
        this.removeInstanceFromMap();
        if (this.systemInterface.getSystemStatus() != SystemStatus.STOPPING) {
            this.unloadViewModules();
        }
        this.systemInterface.removeSectionCacheListener(this);
    }

    @Override
    protected void createDAOs(DataSource dataSource) throws Exception {
        super.createDAOs(dataSource);
        AnnotatedPageDAOFactory daoFactory = new AnnotatedPageDAOFactory();
        ((PageDAOFactory)daoFactory).init(dataSource);
        this.pageDAO = ((PageDAOFactory)daoFactory).getPageDAO();
        this.userGroupListConnector = new UserGroupListConnector(this.systemInterface);
    }

    private void createViewModules(SectionInterface sectionInterface, boolean recursive) {
        try {
            if (this.pageDAO.sectionHasEnabledPages(sectionInterface.getSectionDescriptor().getSectionID())) {
                this.log.info((Object)("Adding page view module to section " + sectionInterface.getSectionDescriptor()));
                SimpleForegroundModuleDescriptor descriptor = new SimpleForegroundModuleDescriptor();
                descriptor.setAdminAccess(true);
                descriptor.setUserAccess(true);
                descriptor.setAnonymousAccess(true);
                descriptor.setAlias(this.pageViewModuleAlias);
                descriptor.setXslPathType(PathType.valueOf(this.pageViewModuleXSLPathType));
                descriptor.setXslPath(this.pageViewModuleXSLPath);
                descriptor.setName(this.pageViewModuleName);
                descriptor.setDescription(this.pageViewModuleName);
                descriptor.setClassname(PageViewModule.class.getName());
                descriptor.setMutableSettingHandler(((ForegroundModuleDescriptor)this.moduleDescriptor).getMutableSettingHandler());
                descriptor.setVisibleInMenu(true);
                descriptor.setEnabled(true);
                descriptor.setSectionID(sectionInterface.getSectionDescriptor().getSectionID());
                descriptor.setStaticContentPackage("staticcontent");
                descriptor.setDataSourceID(((ForegroundModuleDescriptor)this.moduleDescriptor).getDataSourceID());
                PageViewModule pageViewModule = (PageViewModule)sectionInterface.getForegroundModuleCache().cache(descriptor);
                this.viewerModuleMap.put(sectionInterface.getSectionDescriptor().getSectionID(), pageViewModule);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Error adding page view module to section " + sectionInterface.getSectionDescriptor()), (Throwable)e);
        }
        if (recursive) {
            for (SectionInterface sectionInterface2 : sectionInterface.getSectionCache().getSectionMap().values()) {
                this.createViewModules(sectionInterface2, recursive);
            }
        }
    }

    private void updateViewModules(RootSectionInterface rootSection) {
        for (PageViewModule pageViewModule : this.viewerModuleMap.values()) {
            try {
                SimpleForegroundModuleDescriptor descriptor = (SimpleForegroundModuleDescriptor)pageViewModule.getForegroundModuleDescriptor();
                descriptor.setAlias(this.pageViewModuleAlias);
                descriptor.setXslPathType(PathType.valueOf(this.pageViewModuleXSLPathType));
                descriptor.setXslPath(this.pageViewModuleXSLPath);
                descriptor.setName(this.pageViewModuleName);
                descriptor.setDescription(this.pageViewModuleName);
                descriptor.setMutableSettingHandler(((ForegroundModuleDescriptor)this.moduleDescriptor).getMutableSettingHandler());
                descriptor.setDataSourceID(((ForegroundModuleDescriptor)this.moduleDescriptor).getDataSourceID());
                pageViewModule.getSectionInterface().getForegroundModuleCache().update(descriptor);
            }
            catch (KeyNotCachedException e) {
                this.log.debug((Object)("Unable to update page view module in section " + this.sectionInterface.getSectionDescriptor() + ", module not cached"), (Throwable)e);
                this.viewerModuleMap.remove(this.sectionInterface.getSectionDescriptor().getSectionID());
            }
            catch (Exception e) {
                this.log.error((Object)("Error updating page view module in section " + this.sectionInterface.getSectionDescriptor()), (Throwable)e);
            }
        }
    }

    private void unloadViewModules() {
        for (PageViewModule pageViewModule : this.viewerModuleMap.values()) {
            try {
                pageViewModule.getSectionInterface().getForegroundModuleCache().unload(pageViewModule.getForegroundModuleDescriptor());
            }
            catch (KeyNotCachedException e) {
                this.log.debug((Object)("Unable to unload page view module in section " + pageViewModule.getSectionInterface().getSectionDescriptor() + ", module not cached"), (Throwable)e);
            }
            catch (Exception e) {
                this.log.error((Object)("Error unloading page view module in section " + pageViewModule.getSectionInterface().getSectionDescriptor()), (Throwable)e);
            }
        }
    }

    @Override
    public SimpleForegroundModuleResponse defaultMethod(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws SQLException {
        Document doc = this.createDocument(req, uriParser);
        SimpleSectionDescriptor rootSection = this.sectionDAO.getRootSection(true);
        Element sectionsElement = doc.createElement("sections");
        doc.getFirstChild().appendChild(sectionsElement);
        this.appendSection(sectionsElement, doc, rootSection, true);
        return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb());
    }

    private void appendSection(Element parentSection, Document doc, SimpleSectionDescriptor simpleSectionDescriptor, boolean includePages) throws SQLException {
        List<Page> pages;
        Element sectionElement = simpleSectionDescriptor.toXML(doc);
        parentSection.appendChild(sectionElement);
        if (includePages && (pages = this.pageDAO.getPages(simpleSectionDescriptor.getSectionID())) != null) {
            Element pagesElement = doc.createElement("pages");
            sectionElement.appendChild(pagesElement);
            for (Page page : pages) {
                pagesElement.appendChild(page.toXML(doc));
            }
        }
        if (simpleSectionDescriptor.getSubSectionsList() != null) {
            Element subSectionsElement = doc.createElement("subsections");
            sectionElement.appendChild(subSectionsElement);
            for (SimpleSectionDescriptor subSectionBean : simpleSectionDescriptor.getSubSectionsList()) {
                this.appendSection(subSectionsElement, doc, subSectionBean, includePages);
            }
        }
    }

    public Document createDocument(HttpServletRequest req, URIParser uriParser) {
        Document doc = XMLUtils.createDomDocument();
        Element document = doc.createElement("document");
        document.appendChild(RequestUtils.getRequestInfoAsXML((Document)doc, (HttpServletRequest)req, (URIParser)uriParser));
        document.appendChild(((ForegroundModuleDescriptor)this.moduleDescriptor).toXML(doc));
        doc.appendChild(document);
        return doc;
    }

    @WebPublic
    public SimpleForegroundModuleResponse add(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws KeyNotCachedException, KeyAlreadyCachedException, SQLException, URINotFoundException, IOException {
        SimpleSectionDescriptor section = null;
        if (uriParser.size() != 3 || !NumberUtils.isInt((String)uriParser.get(2)) || (section = this.sectionDAO.getSection(Integer.parseInt(uriParser.get(2)), false)) == null) {
            throw new URINotFoundException(uriParser);
        }
        ValidationException validationException = null;
        if (req.getMethod().equalsIgnoreCase("POST")) {
            try {
                Page page = POPULATOR.populate(req);
                if (this.pageDAO.getPage(page.getAlias(), (int)section.getSectionID()) != null) {
                    throw new ValidationException(new ValidationError[]{new ValidationError("alias", ValidationErrorType.Other, "duplicatePageAlias")});
                }
                this.log.info((Object)("User " + user + " adding page " + page + " in section " + section));
                this.removeAbsoluteFileUrls(page, uriParser);
                URLRewriter.removeAbsoluteLinkUrls((Object)page, (HttpServletRequest)req);
                page.setSectionID(section.getSectionID());
                this.pageDAO.add(page);
                this.pageAdded(page);
                res.sendRedirect(this.getModuleURI(req) + "/show/" + page.getPageID());
                return null;
            }
            catch (ValidationException e) {
                validationException = e;
            }
        }
        Document doc = this.createDocument(req, uriParser);
        Element document = (Element)doc.getFirstChild();
        Element addPageForm = doc.createElement("addPageForm");
        document.appendChild(addPageForm);
        addPageForm.appendChild(section.toXML(doc));
        AccessUtils.appendAllowedGroupsAndUsers(doc, addPageForm, section, this.systemInterface.getUserHandler(), this.systemInterface.getGroupHandler());
        if (this.csspath != null) {
            addPageForm.appendChild(XMLUtils.createCDATAElement((String)"cssPath", (Object)this.csspath, (Document)doc));
        }
        if (validationException != null) {
            addPageForm.appendChild(validationException.toXML(doc));
            addPageForm.appendChild(RequestUtils.getRequestParameters((HttpServletRequest)req, (Document)doc));
        }
        return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb());
    }

    private Page getPage(URIParser uriParser, User user) throws NumberFormatException, URINotFoundException, SQLException {
        Page page = null;
        if (NumberUtils.isInt((String)uriParser.get(2)) && (page = this.pageDAO.getPage(Integer.parseInt(uriParser.get(2)))) != null) {
            return page;
        }
        throw new URINotFoundException(uriParser);
    }

    private Breadcrumb getPageBreadcrumb(HttpServletRequest req, Page page, String method) {
        return new Breadcrumb(page.getName(), page.getDescription(), this.getFullAlias() + "/" + method + "/" + page.getPageID(), URLType.RELATIVE_FROM_CONTEXTPATH);
    }

    @WebPublic(alias="firstpage")
    public SimpleForegroundModuleResponse setFirstpage(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        Page page = this.getPage(uriParser, user);
        SectionDAO sectionDAO = this.systemInterface.getCoreDaoFactory().getSectionDAO();
        SimpleSectionDescriptor sectionDescriptor = sectionDAO.getSection((int)page.getSectionID(), true);
        this.log.info((Object)("User " + user + " making page " + page + " firstpage in section " + sectionDescriptor));
        String pageAlias = "/" + this.pageViewModuleAlias + "/" + page.getAlias();
        sectionDescriptor.setAnonymousDefaultURI(pageAlias);
        sectionDescriptor.setUserDefaultURI(pageAlias);
        sectionDAO.update(sectionDescriptor);
        if (sectionDescriptor.getParentSectionID() == null) {
            RootSectionUpdater rootSectionUpdater = new RootSectionUpdater(this.sectionInterface.getSystemInterface().getRootSection(), sectionDescriptor);
            rootSectionUpdater.setDaemon(true);
            rootSectionUpdater.start();
            res.sendRedirect(req.getContextPath() + sectionDescriptor.getFullAlias() + pageAlias);
            return null;
        }
        SectionInterface sectionInterface = this.systemInterface.getSectionInterface(sectionDescriptor.getParentSectionID());
        if (sectionInterface != null && sectionInterface.getSectionCache().isCached(sectionDescriptor)) {
            SectionUpdater sectionUpdater = new SectionUpdater(sectionInterface.getSectionCache(), sectionDescriptor, user);
            sectionUpdater.isDaemon();
            sectionUpdater.start();
            if (AccessUtils.checkAccess(user, sectionDescriptor)) {
                res.sendRedirect(req.getContextPath() + sectionDescriptor.getFullAlias() + pageAlias);
                return null;
            }
        }
        this.redirectToDefaultMethod(req, res);
        return null;
    }

    @WebPublic
    public SimpleForegroundModuleResponse show(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        Page page = this.getPage(uriParser, user);
        this.log.info((Object)("User " + user + " viewing page " + page));
        this.setAbsoluteFileUrls(page, uriParser);
        URLRewriter.setAbsoluteLinkUrls((Object)page, (HttpServletRequest)req);
        Document doc = this.createDocument(req, uriParser);
        Element preview = doc.createElement("preview");
        doc.getFirstChild().appendChild(preview);
        preview.appendChild(page.toXML(doc));
        PageViewModule pageViewModule = this.viewerModuleMap.get(page.getSectionID());
        if (pageViewModule != null) {
            if (this.disablePreview && page.isEnabled() && AccessUtils.checkAccess(user, page) && AccessUtils.checkRecursiveModuleAccess(user, pageViewModule.getForegroundModuleDescriptor(), this.systemInterface)) {
                res.sendRedirect(req.getContextPath() + pageViewModule.getSectionInterface().getSectionDescriptor().getFullAlias() + "/" + pageViewModule.getForegroundModuleDescriptor().getAlias() + "/" + page.getAlias());
                return null;
            }
            preview.appendChild(pageViewModule.getForegroundModuleDescriptor().toXML(doc));
            preview.appendChild(pageViewModule.getSectionInterface().getSectionDescriptor().toXML(doc));
        } else {
            preview.appendChild(this.sectionDAO.getSection((int)page.getSectionID(), false).toXML(doc));
        }
        return new SimpleForegroundModuleResponse(doc, page.getName(), this.getDefaultBreadcrumb(), this.getPageBreadcrumb(req, page, "show"));
    }

    @WebPublic
    public SimpleForegroundModuleResponse move(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        Page page = this.getPage(uriParser, user);
        SimpleSectionDescriptor section = null;
        if (uriParser.size() == 3) {
            Document doc = this.createDocument(req, uriParser);
            Element movePage = doc.createElement("movePageForm");
            doc.getFirstChild().appendChild(movePage);
            movePage.appendChild(page.toXML(doc));
            SimpleSectionDescriptor rootSection = this.sectionDAO.getRootSection(true);
            Element sectionsElement = doc.createElement("sections");
            movePage.appendChild(sectionsElement);
            this.appendSection(sectionsElement, doc, rootSection, false);
            return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb(), this.getPageBreadcrumb(req, page, "show"));
        }
        if (uriParser.size() == 4 && NumberUtils.isInt((String)uriParser.get(3)) && (section = this.sectionDAO.getSection(Integer.parseInt(uriParser.get(3)), false)) != null) {
            Integer oldSectionID = page.getSectionID();
            this.log.info((Object)("User " + user + " moving page " + page + " to section " + section));
            page.setSectionID(section.getSectionID());
            this.pageDAO.update(page);
            this.pageRemoved(page, oldSectionID, page.isEnabled(), page.isVisibleInMenu());
            this.pageAdded(page);
            res.sendRedirect(this.getModuleURI(req));
            return null;
        }
        throw new URINotFoundException(uriParser);
    }

    @WebPublic
    public SimpleForegroundModuleResponse copy(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        Page page = this.getPage(uriParser, user);
        SimpleSectionDescriptor section = null;
        if (uriParser.size() == 3) {
            Document doc = this.createDocument(req, uriParser);
            Element movePage = doc.createElement("copyPageForm");
            doc.getFirstChild().appendChild(movePage);
            movePage.appendChild(page.toXML(doc));
            SimpleSectionDescriptor rootSection = this.sectionDAO.getRootSection(true);
            Element sectionsElement = doc.createElement("sections");
            movePage.appendChild(sectionsElement);
            this.appendSection(sectionsElement, doc, rootSection, false);
            return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb(), this.getPageBreadcrumb(req, page, "show"));
        }
        if (uriParser.size() == 4 && NumberUtils.isInt((String)uriParser.get(3)) && (section = this.sectionDAO.getSection(Integer.parseInt(uriParser.get(3)), false)) != null) {
            this.log.info((Object)("User " + user + " copying page " + page + " to section " + section));
            page.setPageID(null);
            page.setSectionID(section.getSectionID());
            if (this.pageDAO.getPage(page.getAlias(), (int)page.getSectionID()) != null) {
                for (int copyNumber = 1; copyNumber < Integer.MAX_VALUE; ++copyNumber) {
                    if (this.pageDAO.getPage(page.getAlias() + copyNumber, (int)page.getSectionID()) != null) continue;
                    page.setAlias(page.getAlias() + copyNumber);
                    page.setName(page.getName() + " (" + copyNumber + ")");
                    break;
                }
            }
            this.pageDAO.add(page);
            this.pageAdded(page);
            res.sendRedirect(this.getModuleURI(req));
            return null;
        }
        throw new URINotFoundException(uriParser);
    }

    @WebPublic
    public SimpleForegroundModuleResponse update(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        Page page = this.getPage(uriParser, user);
        ValidationException validationException = null;
        if (req.getMethod().equalsIgnoreCase("POST")) {
            try {
                boolean wasEanbled = page.isEnabled();
                boolean wasVisibleInMenu = page.isVisibleInMenu();
                page = POPULATOR.populate(page, req);
                Page aliasMatch = this.pageDAO.getPage(page.getAlias(), (int)page.getSectionID());
                if (aliasMatch != null && !aliasMatch.getPageID().equals(page.getPageID())) {
                    throw new ValidationException(new ValidationError[]{new ValidationError("alias", ValidationErrorType.Other, "duplicatePageAlias")});
                }
                this.log.info((Object)("User " + user + " updating page " + page));
                this.removeAbsoluteFileUrls(page, uriParser);
                URLRewriter.removeAbsoluteLinkUrls((Object)page, (HttpServletRequest)req);
                this.pageDAO.update(page);
                this.pageUpdated(page, wasEanbled, wasVisibleInMenu);
                res.sendRedirect(this.getModuleURI(req) + "/show/" + page.getPageID());
                return null;
            }
            catch (ValidationException e) {
                validationException = e;
            }
        }
        Document doc = this.createDocument(req, uriParser);
        Element document = (Element)doc.getFirstChild();
        Element updatePageForm = doc.createElement("updatePageForm");
        document.appendChild(updatePageForm);
        AccessUtils.appendAllowedGroupsAndUsers(doc, updatePageForm, page, this.systemInterface.getUserHandler(), this.systemInterface.getGroupHandler());
        if (validationException != null) {
            updatePageForm.appendChild(validationException.toXML(doc));
            updatePageForm.appendChild(RequestUtils.getRequestParameters((HttpServletRequest)req, (Document)doc));
        }
        this.setAbsoluteFileUrls(page, uriParser);
        URLRewriter.setAbsoluteLinkUrls((Object)page, (HttpServletRequest)req);
        updatePageForm.appendChild(page.toXML(doc));
        updatePageForm.appendChild(this.sectionDAO.getSection((int)page.getSectionID(), false).toXML(doc));
        if (this.csspath != null) {
            updatePageForm.appendChild(XMLUtils.createCDATAElement((String)"cssPath", (Object)this.csspath, (Document)doc));
        }
        return new SimpleForegroundModuleResponse(doc, page.getName(), this.getDefaultBreadcrumb(), this.getPageBreadcrumb(req, page, "show"));
    }

    @WebPublic
    public SimpleForegroundModuleResponse delete(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        SectionInterface sectionInterface;
        Page page = this.getPage(uriParser, user);
        this.log.info((Object)("User " + user + " deleting page " + page));
        this.pageDAO.delete(page);
        this.pageRemoved(page, page.getSectionID(), page.isEnabled(), page.isVisibleInMenu());
        if (req.getParameter("returnto") != null && (sectionInterface = this.systemInterface.getSectionInterface(page.getSectionID())) != null) {
            res.sendRedirect(req.getContextPath() + sectionInterface.getSectionDescriptor().getFullAlias());
            return null;
        }
        res.sendRedirect(this.getModuleURI(req));
        return null;
    }

    @WebPublic
    public SimpleForegroundModuleResponse connector(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws TransformerFactoryConfigurationError, TransformerException, IOException {
        this.connector.processRequest(req, res, uriParser, user, (ForegroundModuleDescriptor)this.moduleDescriptor);
        return null;
    }

    @WebPublic
    public SimpleForegroundModuleResponse file(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        this.connector.processFileRequest(req, res, user, uriParser, (ForegroundModuleDescriptor)this.moduleDescriptor, this.sectionInterface, 2, null);
        return null;
    }

    private String getAbsoluteFileURL(URIParser uriParser) {
        return uriParser.getCurrentURI(true) + "/" + ((ForegroundModuleDescriptor)this.moduleDescriptor).getAlias() + "/file";
    }

    public void removeAbsoluteFileUrls(Page page, URIParser uriParser) {
        String text = page.getText();
        String absoluteFileURL = this.getAbsoluteFileURL(uriParser);
        for (String attribute : BaseFileAccessValidator.TAG_ATTRIBUTES) {
            text = text.replace(attribute + "=\"" + absoluteFileURL, attribute + "=\"" + "/@");
            text = text.replace(attribute + "='" + absoluteFileURL, attribute + "='" + "/@");
        }
        page.setText(text);
    }

    public void setAbsoluteFileUrls(Page page, URIParser uriParser) {
        String text = page.getText();
        String absoluteFileURL = this.getAbsoluteFileURL(uriParser);
        for (String attribute : BaseFileAccessValidator.TAG_ATTRIBUTES) {
            text = text.replace(attribute + "=\"" + "/@", attribute + "=\"" + absoluteFileURL);
            text = text.replace(attribute + "='" + "/@", attribute + "='" + absoluteFileURL);
        }
        page.setText(text);
    }

    @Override
    public List<SettingDescriptor> getSettings() {
        List<SettingDescriptor> settings = super.getSettings();
        settings.addAll(SETTINGDESCRIPTORS);
        return settings;
    }

    @Override
    public synchronized void sectionCached(SectionDescriptor sectionDescriptor, Section sectionInstance) throws KeyAlreadyCachedException {
        this.createViewModules(sectionInstance, false);
    }

    @Override
    public void sectionUpdated(SectionDescriptor sectionDescriptor, Section sectionInstance) throws KeyNotCachedException {
    }

    @Override
    public synchronized void sectionUnloaded(SectionDescriptor sectionDescriptor, Section sectionInstance) throws KeyNotCachedException {
        this.viewerModuleMap.remove(sectionDescriptor.getSectionID());
    }

    public synchronized void pageAdded(Page page) {
        if (!page.isEnabled()) {
            return;
        }
        PageViewModule viewModule = this.viewerModuleMap.get(page.getSectionID());
        if (viewModule == null) {
            SectionInterface sectionInterface = this.systemInterface.getSectionInterface(page.getSectionID());
            if (sectionInterface != null) {
                this.createViewModules(sectionInterface, false);
            }
        } else {
            viewModule.addPage(page);
            if (page.isVisibleInMenu()) {
                viewModule.reloadMenuitems();
            }
        }
    }

    public synchronized void pageUpdated(Page page, boolean wasEnabled, boolean wasVisibleInMenu) throws Exception {
        if (!page.isEnabled() && !wasEnabled) {
            return;
        }
        if (page.isEnabled() && !wasEnabled) {
            this.pageAdded(page);
        } else if (page.isEnabled() && wasEnabled) {
            PageViewModule viewModule = this.viewerModuleMap.get(page.getSectionID());
            if (viewModule != null) {
                viewModule.updatePage(page);
                if (page.isVisibleInMenu() || wasVisibleInMenu) {
                    viewModule.reloadMenuitems();
                }
            }
        } else if (!page.isEnabled() && wasEnabled) {
            this.pageRemoved(page, page.getSectionID(), wasEnabled, wasVisibleInMenu);
        }
    }

    public synchronized void pageRemoved(Page page, Integer sectionID, boolean wasEnabled, boolean wasVisibleInMenu) throws Exception {
        if (!wasEnabled) {
            return;
        }
        PageViewModule viewModule = this.viewerModuleMap.get(sectionID);
        if (viewModule != null) {
            if (this.pageDAO.sectionHasEnabledPages(sectionID)) {
                viewModule.removePage(page);
                if (wasVisibleInMenu) {
                    viewModule.reloadMenuitems();
                }
            } else {
                this.log.info((Object)("Removing page view module from section " + viewModule.getSectionInterface().getSectionDescriptor()));
                viewModule.getSectionInterface().getForegroundModuleCache().unload(viewModule.getForegroundModuleDescriptor());
                this.viewerModuleMap.remove(viewModule);
            }
        }
    }

    public ModuleDescriptor getModuleDescriptor() {
        return (ModuleDescriptor)this.moduleDescriptor;
    }

    @WebPublic(alias="users")
    public ForegroundModuleResponse getUsers(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Throwable {
        return this.userGroupListConnector.getUsers(req, res, user, uriParser);
    }

    @WebPublic(alias="groups")
    public ForegroundModuleResponse getGroups(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Throwable {
        return this.userGroupListConnector.getGroups(req, res, user, uriParser);
    }

    static {
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("csspath", "Editor CSS", "Path to the desired CSS stylesheet for FCKEditor (relative from the contextpath)", false, null, null));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("filestore", "Filestore path", "Path to the directory to be used as filestore", false, null, null));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("diskThreshold", "Max upload size", "Maxmium upload size in megabytes allowed in a single post request", false, "100", (StringFormatValidator)new StringIntegerValidator(Integer.valueOf(1), null)));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("pageViewModuleName", "View module name", "The name used for page view modules created by this module", true, "Page viewer", null));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("pageViewModuleAlias", "View module alias", "The alias used for page view modules created by this module", true, "page", null));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createDropDownSetting("pageViewModuleXSLPathType", "View module XSL path type", "The path type used for page view modules created by this module", true, PathType.Classpath.toString(), ModuleUtils.getValueDescriptors((Enum[])PathType.values())));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("pageViewModuleXSLPath", "View module XSL path", "Path to the XSL stylesheet used by the page view modules created by this module", true, "PageViewModule.en.xsl", null));
        POPULATOR = new PagePopulator();
    }
}

