/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.pagemodules;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.interfaces.AccessInterface;
import se.unlogic.hierarchy.core.interfaces.SearchableItem;
import se.unlogic.hierarchy.core.utils.AccessUtils;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.dao.annotations.Key;
import se.unlogic.standardutils.dao.annotations.OneToMany;
import se.unlogic.standardutils.dao.annotations.OrderBy;
import se.unlogic.standardutils.dao.annotations.SimplifiedRelation;
import se.unlogic.standardutils.dao.annotations.Table;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.annotations.URLRewrite;

@Table(name="pages")
public class Page
implements AccessInterface,
SearchableItem {
    private static final Pattern PERCENT_PATTERN = Pattern.compile("%(?![0-9a-fA-F]{2})");
    public static final String RELATIVE_PATH_MARKER = "/@";
    @DAOManaged(autoGenerated=true)
    @Key
    private Integer pageID;
    @DAOManaged
    @OrderBy
    private String name;
    @DAOManaged
    private String description;
    @DAOManaged
    @URLRewrite
    private String text;
    @DAOManaged
    private boolean enabled;
    @DAOManaged
    private boolean visibleInMenu;
    @DAOManaged
    private boolean breadCrumb;
    @DAOManaged
    private boolean anonymousAccess;
    @DAOManaged
    private boolean userAccess;
    @DAOManaged
    private boolean adminAccess;
    @DAOManaged
    private String alias;
    @DAOManaged
    private Integer sectionID;
    @DAOManaged
    @OneToMany(autoAdd=true, autoGet=true, autoUpdate=true)
    @SimplifiedRelation(table="page_groups", remoteValueColumnName="groupID")
    private List<Integer> allowedGroupIDs;
    @DAOManaged
    @OneToMany(autoAdd=true, autoGet=true, autoUpdate=true)
    @SimplifiedRelation(table="page_users", remoteValueColumnName="userID")
    private List<Integer> allowedUserIDs;
    private String unescapedText;

    public Integer getSectionID() {
        return this.sectionID;
    }

    public void setSectionID(Integer sectionID) {
        this.sectionID = sectionID;
    }

    public Integer getPageID() {
        return this.pageID;
    }

    public void setPageID(Integer pageID) {
        this.pageID = pageID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public boolean allowsAnonymousAccess() {
        return this.anonymousAccess;
    }

    public void setAnonymousAccess(boolean anonymousAccess) {
        this.anonymousAccess = anonymousAccess;
    }

    @Override
    public boolean allowsUserAccess() {
        return this.userAccess;
    }

    public void setUserAccess(boolean userAccess) {
        this.userAccess = userAccess;
    }

    @Override
    public boolean allowsAdminAccess() {
        return this.adminAccess;
    }

    public void setAdminAccess(boolean adminAccess) {
        this.adminAccess = adminAccess;
    }

    public boolean isVisibleInMenu() {
        return this.visibleInMenu;
    }

    public void setVisibleInMenu(boolean visibleInMenu) {
        this.visibleInMenu = visibleInMenu;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String toString() {
        return this.getName() + " (pageID: " + this.getPageID() + ")";
    }

    public Element toXML(Document doc) {
        return this.toXML(doc, null);
    }

    public Element toXML(Document doc, String text) {
        Element page = doc.createElement("page");
        if (this.pageID != null) {
            page.appendChild(XMLUtils.createElement((String)"pageID", (Object)Integer.toString(this.pageID), (Document)doc));
        }
        if (this.sectionID != null) {
            page.appendChild(XMLUtils.createElement((String)"sectionID", (Object)Integer.toString(this.sectionID), (Document)doc));
        }
        if (this.name != null) {
            page.appendChild(XMLUtils.createCDATAElement((String)"name", (Object)this.name, (Document)doc));
        }
        if (text != null) {
            page.appendChild(XMLUtils.createCDATAElement((String)"text", (Object)text, (Document)doc));
        } else {
            page.appendChild(XMLUtils.createCDATAElement((String)"text", (Object)this.text, (Document)doc));
        }
        if (this.description != null) {
            page.appendChild(XMLUtils.createCDATAElement((String)"description", (Object)this.description, (Document)doc));
        }
        if (this.alias != null) {
            page.appendChild(XMLUtils.createCDATAElement((String)"alias", (Object)this.alias, (Document)doc));
        }
        page.appendChild(XMLUtils.createElement((String)"anonymousAccess", (Object)Boolean.toString(this.anonymousAccess), (Document)doc));
        page.appendChild(XMLUtils.createElement((String)"userAccess", (Object)Boolean.toString(this.userAccess), (Document)doc));
        page.appendChild(XMLUtils.createElement((String)"adminAccess", (Object)Boolean.toString(this.adminAccess), (Document)doc));
        page.appendChild(XMLUtils.createElement((String)"enabled", (Object)Boolean.toString(this.enabled), (Document)doc));
        page.appendChild(XMLUtils.createElement((String)"visibleInMenu", (Object)Boolean.toString(this.visibleInMenu), (Document)doc));
        page.appendChild(XMLUtils.createElement((String)"breadCrumb", (Object)Boolean.toString(this.breadCrumb), (Document)doc));
        AccessUtils.appendAllowedGroupAndUserIDs(doc, page, this);
        return page;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public List<Integer> getAllowedGroupIDs() {
        return this.allowedGroupIDs;
    }

    public void setAllowedGroupIDs(List<Integer> allowedGroupIDs) {
        this.allowedGroupIDs = allowedGroupIDs;
    }

    public List<Integer> getAllowedUserIDs() {
        return this.allowedUserIDs;
    }

    public void setAllowedUserIDs(List<Integer> allowedUserIDs) {
        this.allowedUserIDs = allowedUserIDs;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pageID == null ? 0 : this.pageID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Page other = (Page)obj;
        return !(this.pageID == null ? other.pageID != null : !this.pageID.equals(other.pageID));
    }

    public String getUnescapedText() {
        if (this.unescapedText == null) {
            this.unescapedText = PERCENT_PATTERN.matcher(this.text).replaceAll("%25");
            try {
                this.unescapedText = URLDecoder.decode(this.unescapedText, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return this.unescapedText;
    }

    public boolean hasBreadCrumb() {
        return this.breadCrumb;
    }

    public void setBreadCrumb(boolean breadCrumb) {
        this.breadCrumb = breadCrumb;
    }

    @Override
    public String getID() {
        return this.pageID.toString();
    }

    @Override
    public String getTitle() {
        return this.name;
    }

    @Override
    public String getContentType() {
        return "text/html";
    }

    @Override
    public InputStream getData() {
        return StringUtils.getInputStream((String)this.text);
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    public AccessInterface getAccessInterface() {
        return this;
    }
}

