/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.newpassword;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.emailutils.framework.Email;
import se.unlogic.emailutils.framework.InvalidEmailAddressException;
import se.unlogic.emailutils.framework.NoEmailSendersFoundException;
import se.unlogic.emailutils.framework.SimpleEmail;
import se.unlogic.emailutils.framework.UnableToProcessEmailException;
import se.unlogic.emailutils.populators.EmailPopulator;
import se.unlogic.hierarchy.core.annotations.CheckboxSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.HTMLEditorSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.ModuleSetting;
import se.unlogic.hierarchy.core.annotations.TextAreaSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.TextFieldSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.WebPublic;
import se.unlogic.hierarchy.core.annotations.XSLVariable;
import se.unlogic.hierarchy.core.beans.MutableUser;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleResponse;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.exceptions.UnableToUpdateUserException;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleResponse;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.foregroundmodules.AnnotatedForegroundModule;
import se.unlogic.purecaptcha.CaptchaHandler;
import se.unlogic.purecaptcha.DefaultCaptchaHandler;
import se.unlogic.standardutils.populators.BeanStringPopulator;
import se.unlogic.standardutils.populators.StringPopulator;
import se.unlogic.standardutils.random.RandomUtils;
import se.unlogic.standardutils.string.AnnotatedBeanTagSourceFactory;
import se.unlogic.standardutils.string.SingleTagSourceFactory;
import se.unlogic.standardutils.string.TagReplacer;
import se.unlogic.standardutils.string.TagSource;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.RequestUtils;
import se.unlogic.webutils.http.URIParser;
import se.unlogic.webutils.validation.ValidationUtils;

public class NewPasswordModule
extends AnnotatedForegroundModule {
    protected AnnotatedBeanTagSourceFactory<User> USER_TAG_SOURCE_FACTORY = new AnnotatedBeanTagSourceFactory(User.class, "$user.");
    protected SingleTagSourceFactory<String> PASSWORD_TAG_SOURCE_FACTORY = new SingleTagSourceFactory("$password");
    @ModuleSetting
    @CheckboxSettingDescriptor(name="Require username", description="Controls if username is required along with e-mail address in order to request a new password")
    protected boolean requireUsername;
    @ModuleSetting
    @CheckboxSettingDescriptor(name="Require captcha confirmation", description="Controls whether account creation requires captcha confirmation")
    protected boolean requireCaptchaConfirmation = true;
    @XSLVariable
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Email subject", description="The subject of the e-mails sent.")
    protected String subject = "New password";
    @XSLVariable
    @ModuleSetting
    @TextAreaSettingDescriptor(name="Email message", description="The body of the e-mails sent.")
    protected String message = "Hello $user.firstname,\n\nHere is your new password for mysite: $password\n\n/Mysite";
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Email sender address", description="The sender address of the e-mails sent.", formatValidator=EmailPopulator.class)
    protected String senderAddress = "not@set.foo";
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Email sender name", description="The sender name of the e-mails sent.")
    protected String senderName = "John Doe";
    @ModuleSetting
    @HTMLEditorSettingDescriptor(name="New password message", description="The message displayed above the new password form")
    @XSLVariable
    protected String newPasswordFormMessage = "Fill in the form below to get a new password e-mailed to you";
    @ModuleSetting
    @HTMLEditorSettingDescriptor(name="Password sent message", description="The message displayed after a new password has been e-mailed to the user")
    @XSLVariable
    protected String newPasswordSentMessage = "A new password has been e-mailed to you";
    protected CaptchaHandler captchaHandler;

    @Override
    public void init(ForegroundModuleDescriptor moduleDescriptor, SectionInterface sectionInterface, DataSource dataSource) throws Exception {
        super.init(moduleDescriptor, sectionInterface, dataSource);
        this.captchaHandler = new DefaultCaptchaHandler(this.getClass().getName() + ":" + ((ForegroundModuleDescriptor)this.moduleDescriptor).getModuleID(), 120000L, false);
    }

    @Override
    public ForegroundModuleResponse defaultMethod(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) {
        ValidationException validationException = null;
        if (req.getMethod().equalsIgnoreCase("POST")) {
            try {
                ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
                String email = (String)ValidationUtils.validateParameter((String)"email", (HttpServletRequest)req, (boolean)true, (Integer)6, (Integer)255, (BeanStringPopulator)StringPopulator.getPopulator(), validationErrors);
                String username = null;
                if (this.requireUsername) {
                    username = (String)ValidationUtils.validateParameter((String)"username", (HttpServletRequest)req, (boolean)true, (Integer)1, (Integer)20, (BeanStringPopulator)StringPopulator.getPopulator(), validationErrors);
                }
                String captchaConfirmation = req.getParameter("captchaConfirmation");
                if (this.requireCaptchaConfirmation && !this.captchaHandler.isValidCode(req, captchaConfirmation)) {
                    validationErrors.add(new ValidationError("InvalidCaptchaConfirmation"));
                }
                if (!validationErrors.isEmpty()) {
                    throw new ValidationException(validationErrors);
                }
                User requestedUser = this.systemInterface.getUserHandler().getUserByEmail(email, false, true);
                if (requestedUser == null || this.requireUsername && !requestedUser.getUsername().equalsIgnoreCase(username)) {
                    throw new ValidationException(new ValidationError[]{new ValidationError("UserNotFound")});
                }
                if (!(requestedUser instanceof MutableUser)) {
                    throw new ValidationException(new ValidationError[]{new ValidationError("UserNotMutable")});
                }
                if (!requestedUser.isEnabled()) {
                    throw new ValidationException(new ValidationError[]{new ValidationError("UserNotEnabled")});
                }
                String newPassword = RandomUtils.getRandomString((int)7, (int)10);
                ((MutableUser)requestedUser).setPassword(newPassword);
                try {
                    this.systemInterface.getUserHandler().updateUser(requestedUser, true, false, false);
                }
                catch (UnableToUpdateUserException e) {
                    throw new ValidationException(new ValidationError[]{new ValidationError("UnableToUpdateUser")});
                }
                this.log.info((Object)("Sending new password to user " + user));
                if (!this.sendNewPasswordMail(requestedUser, newPassword)) {
                    throw new ValidationException(new ValidationError[]{new ValidationError("ErrorSendingMail")});
                }
                Document doc = this.createDocument(req, uriParser);
                Element newPasswordSentElement = doc.createElement("NewPasswordSent");
                doc.getFirstChild().appendChild(newPasswordSentElement);
                XMLUtils.appendNewCDATAElement((Document)doc, (Element)newPasswordSentElement, (String)"newPasswordSentMessage", (String)this.newPasswordSentMessage);
                return new SimpleForegroundModuleResponse(doc, this.getDefaultBreadcrumb());
            }
            catch (ValidationException e) {
                validationException = e;
            }
        }
        this.log.info((Object)("User " + user + " requesting new password form"));
        Document doc = this.createDocument(req, uriParser);
        Element newPasswordFormElement = doc.createElement("NewPasswordForm");
        doc.getFirstChild().appendChild(newPasswordFormElement);
        if (validationException != null) {
            newPasswordFormElement.appendChild(validationException.toXML(doc));
            newPasswordFormElement.appendChild(RequestUtils.getRequestParameters((HttpServletRequest)req, (Document)doc, (String[])new String[]{"username", "email", "captchaConfirmation"}));
        }
        XMLUtils.appendNewCDATAElement((Document)doc, (Element)newPasswordFormElement, (String)"newPasswordFormMessage", (String)this.newPasswordFormMessage);
        if (this.requireUsername) {
            newPasswordFormElement.appendChild(doc.createElement("requireUsername"));
        }
        if (this.requireCaptchaConfirmation) {
            newPasswordFormElement.appendChild(doc.createElement("requireCaptchaConfirmation"));
        }
        return new SimpleForegroundModuleResponse(doc, this.getDefaultBreadcrumb());
    }

    protected Document createDocument(HttpServletRequest req, URIParser uriParser) {
        Document doc = XMLUtils.createDomDocument();
        Element document = doc.createElement("Document");
        doc.appendChild(document);
        document.appendChild(RequestUtils.getRequestInfoAsXML((Document)doc, (HttpServletRequest)req, (URIParser)uriParser));
        document.appendChild(((ForegroundModuleDescriptor)this.moduleDescriptor).toXML(doc));
        return doc;
    }

    protected boolean sendNewPasswordMail(User user, String newPassword) {
        TagReplacer tagReplacer = new TagReplacer(new TagSource[]{this.USER_TAG_SOURCE_FACTORY.getTagSource((Object)user), this.PASSWORD_TAG_SOURCE_FACTORY.getTagSource((Object)newPassword)});
        try {
            SimpleEmail email = new SimpleEmail();
            email.setSenderName(this.senderName);
            email.setSenderAddress(this.senderAddress);
            email.addRecipient(user.getEmail());
            email.setSubject(tagReplacer.replace(this.subject));
            email.setMessage(tagReplacer.replace(this.message));
            email.setMessageContentType("text/plain");
            this.systemInterface.getEmailHandler().send((Email)email);
            return true;
        }
        catch (InvalidEmailAddressException e) {
            this.log.error((Object)("Error sending new password to user " + user), (Throwable)e);
        }
        catch (NoEmailSendersFoundException e) {
            this.log.error((Object)("Error sending new password to user " + user), (Throwable)e);
        }
        catch (UnableToProcessEmailException e) {
            this.log.error((Object)("Error sending new password to user " + user), (Throwable)e);
        }
        return false;
    }

    @WebPublic(alias="captcha")
    public SimpleForegroundModuleResponse getCaptchaImage(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        this.captchaHandler.getCaptchaImage(req, res);
        return null;
    }
}

