/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.menuadmin;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.annotations.WebPublic;
import se.unlogic.hierarchy.core.beans.Bundle;
import se.unlogic.hierarchy.core.beans.MenuItem;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleResponse;
import se.unlogic.hierarchy.core.beans.SimpleSectionDescriptor;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.beans.VirtualMenuItem;
import se.unlogic.hierarchy.core.daos.factories.CoreDaoFactory;
import se.unlogic.hierarchy.core.daos.interfaces.SectionDAO;
import se.unlogic.hierarchy.core.daos.interfaces.VirtualMenuItemDAO;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleResponse;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.core.populators.VirtualMenuItemPopulator;
import se.unlogic.hierarchy.core.utils.usergrouplist.UserGroupListConnector;
import se.unlogic.hierarchy.foregroundmodules.AnnotatedForegroundModule;
import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.RequestUtils;
import se.unlogic.webutils.http.URIParser;

public class MenuAdminModule
extends AnnotatedForegroundModule {
    private static final VirtualMenuItemPopulator POPULATOR = new VirtualMenuItemPopulator();
    private SectionDAO sectionDAO;
    private VirtualMenuItemDAO virtualMenuItemDAO;
    protected UserGroupListConnector userGroupListConnector;

    @Override
    public void init(ForegroundModuleDescriptor moduleDescriptorBean, SectionInterface sectionInterface, DataSource dataSource) throws Exception {
        super.init(moduleDescriptorBean, sectionInterface, dataSource);
        CoreDaoFactory coreDaoFactory = this.systemInterface.getCoreDaoFactory();
        this.sectionDAO = coreDaoFactory.getSectionDAO();
        this.virtualMenuItemDAO = coreDaoFactory.getVirtualMenuItemDAO();
        this.userGroupListConnector = new UserGroupListConnector(this.systemInterface);
    }

    @Override
    public void update(ForegroundModuleDescriptor moduleDescriptor, DataSource dataSource) throws Exception {
        super.update(moduleDescriptor, dataSource);
    }

    @Override
    public SimpleForegroundModuleResponse defaultMethod(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        this.log.info((Object)("User " + user + " listing menu tree"));
        Document doc = this.createDocument(req, uriParser);
        SimpleSectionDescriptor rootSection = this.sectionDAO.getRootSection(true);
        Element sectionsElement = doc.createElement("sections");
        doc.getFirstChild().appendChild(sectionsElement);
        this.appendSection(sectionsElement, doc, rootSection, true);
        return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb());
    }

    @WebPublic
    public SimpleForegroundModuleResponse addMenuItem(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws SQLException, IOException {
        Integer sectionID = null;
        if (uriParser.size() == 3 && (sectionID = NumberUtils.toInt((String)uriParser.get(2))) != null) {
            SimpleSectionDescriptor simpleSectionDescriptor = this.sectionDAO.getSection((int)sectionID, false);
            if (simpleSectionDescriptor != null) {
                ValidationException validationException = null;
                if (req.getMethod().equalsIgnoreCase("POST")) {
                    try {
                        VirtualMenuItem virtualMenuItem = POPULATOR.populate(req);
                        virtualMenuItem.setSectionID(sectionID);
                        this.log.info((Object)("User " + user + " adding virtual menuitem " + virtualMenuItem));
                        this.virtualMenuItemDAO.add(virtualMenuItem);
                        this.reloadVirtualMenuItemCache(sectionID);
                        this.redirectToDefaultMethod(req, res);
                        return null;
                    }
                    catch (ValidationException e) {
                        validationException = e;
                    }
                }
                Document doc = this.createDocument(req, uriParser);
                Element addMenuItem = doc.createElement("addMenuItem");
                doc.getFirstChild().appendChild(addMenuItem);
                addMenuItem.appendChild(simpleSectionDescriptor.toXML(doc));
                if (validationException != null) {
                    addMenuItem.appendChild(validationException.toXML(doc));
                    addMenuItem.appendChild(RequestUtils.getRequestParameters((HttpServletRequest)req, (Document)doc));
                }
                return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb());
            }
            this.log.info((Object)("Section with sectionID \"" + uriParser.get(1) + "\" not found, requested by user " + user));
            this.redirectToDefaultMethod(req, res);
            return null;
        }
        this.log.warn((Object)("Bad sectionID \"" + uriParser.get(1) + "\" provided by user " + user));
        this.redirectToDefaultMethod(req, res);
        return null;
    }

    private void reloadVirtualMenuItemCache(Integer sectionID) throws SQLException {
        SectionInterface sectionInterface = this.systemInterface.getSectionInterface(sectionID);
        if (sectionInterface != null) {
            sectionInterface.getMenuCache().cacheVirtualMenuItems();
        }
    }

    @WebPublic
    public SimpleForegroundModuleResponse updateMenuItem(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws SQLException, IOException {
        Integer menuItemID = null;
        if (uriParser.size() == 3 && (menuItemID = NumberUtils.toInt((String)uriParser.get(2))) != null) {
            VirtualMenuItem virtualMenuItem = this.virtualMenuItemDAO.getMenuItem(menuItemID);
            if (virtualMenuItem != null) {
                ValidationException validationException = null;
                if (req.getMethod().equalsIgnoreCase("POST")) {
                    try {
                        virtualMenuItem = POPULATOR.populate(virtualMenuItem, req);
                        this.log.info((Object)("User " + user + " updating virtual menuitem " + virtualMenuItem));
                        this.virtualMenuItemDAO.update(virtualMenuItem);
                        this.reloadVirtualMenuItemCache(virtualMenuItem.getSectionID());
                        this.redirectToDefaultMethod(req, res);
                        return null;
                    }
                    catch (ValidationException e) {
                        validationException = e;
                    }
                }
                Document doc = this.createDocument(req, uriParser);
                Element updateMenuItem = doc.createElement("updateMenuItem");
                doc.getFirstChild().appendChild(updateMenuItem);
                updateMenuItem.appendChild(virtualMenuItem.getFullXML(doc));
                if (validationException != null) {
                    updateMenuItem.appendChild(validationException.toXML(doc));
                    updateMenuItem.appendChild(RequestUtils.getRequestParameters((HttpServletRequest)req, (Document)doc));
                }
                if (virtualMenuItem.getAllowedUserIDs() != null) {
                    XMLUtils.append((Document)doc, (Element)updateMenuItem, (String)"Users", this.systemInterface.getUserHandler().getUsers(virtualMenuItem.getAllowedUserIDs(), false, true));
                }
                if (virtualMenuItem.getAllowedGroupIDs() != null) {
                    XMLUtils.append((Document)doc, (Element)updateMenuItem, (String)"Groups", this.systemInterface.getGroupHandler().getGroups(virtualMenuItem.getAllowedGroupIDs(), false));
                }
                return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb());
            }
            this.log.info((Object)("Virtual menuitem with menuItemID \"" + uriParser.get(2) + "\" not found, requested by user " + user));
            this.redirectToDefaultMethod(req, res);
            return null;
        }
        this.log.warn((Object)("Bad menuItemID \"" + uriParser.get(2) + "\" requested by user " + user));
        this.redirectToDefaultMethod(req, res);
        return null;
    }

    @WebPublic
    public SimpleForegroundModuleResponse deleteMenuItem(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws SQLException, IOException {
        Integer menuItemID = null;
        if (uriParser.size() == 3 && (menuItemID = NumberUtils.toInt((String)uriParser.get(2))) != null) {
            VirtualMenuItem virtualMenuItem = this.virtualMenuItemDAO.getMenuItem(menuItemID);
            if (virtualMenuItem != null) {
                this.log.info((Object)("User " + user + " deleting virtual menuitem " + virtualMenuItem));
                this.virtualMenuItemDAO.delete(virtualMenuItem);
                this.reloadVirtualMenuItemCache(virtualMenuItem.getSectionID());
                this.redirectToDefaultMethod(req, res);
                return null;
            }
            this.log.info((Object)("Virtual menuitem with menuItemID \"" + uriParser.get(2) + "\" not found, requested by user " + user));
            this.redirectToDefaultMethod(req, res);
            return null;
        }
        this.log.warn((Object)("Bad menuItemID \"" + uriParser.get(2) + "\" requested by user " + user));
        this.redirectToDefaultMethod(req, res);
        return null;
    }

    @WebPublic
    public SimpleForegroundModuleResponse moveMenuItem(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws IOException, SQLException {
        Integer menuItemID = null;
        if ((uriParser.size() == 3 || uriParser.size() == 4) && (menuItemID = NumberUtils.toInt((String)uriParser.get(2))) != null) {
            VirtualMenuItem virtualMenuItem = this.virtualMenuItemDAO.getMenuItem(menuItemID);
            if (virtualMenuItem != null) {
                if (uriParser.size() == 4) {
                    Integer sectionID = NumberUtils.toInt((String)uriParser.get(3));
                    if (sectionID != null) {
                        if (virtualMenuItem.getSectionID().equals(sectionID)) {
                            this.log.debug((Object)("User " + user + " trying to move virtual menuitem " + virtualMenuItem + " to the section it already belongs to, ignoring move"));
                        } else {
                            SimpleSectionDescriptor simpleSectionDescriptor = this.sectionDAO.getSection((int)sectionID, false);
                            if (simpleSectionDescriptor != null) {
                                this.log.info((Object)("User " + user + " moving virtual menuitem " + virtualMenuItem + " to section " + simpleSectionDescriptor));
                                Integer oldSectionID = virtualMenuItem.getSectionID();
                                virtualMenuItem.setSectionID(sectionID);
                                this.virtualMenuItemDAO.update(virtualMenuItem);
                                this.reloadVirtualMenuItemCache(oldSectionID);
                                this.reloadVirtualMenuItemCache(sectionID);
                                this.redirectToDefaultMethod(req, res);
                                return null;
                            }
                            this.log.warn((Object)("User " + user + " trying to move virtual menuitem " + virtualMenuItem + " to non existing section with sectionID " + sectionID));
                        }
                    } else {
                        this.log.warn((Object)("Bad sectionID \"" + uriParser.get(3) + "\" provided for virtual menuitem " + virtualMenuItem + " by user " + user));
                    }
                }
                Document doc = this.createDocument(req, uriParser);
                SimpleSectionDescriptor rootSection = this.sectionDAO.getRootSection(true);
                Element moveMenuItemElement = doc.createElement("moveMenuItem");
                doc.getFirstChild().appendChild(moveMenuItemElement);
                moveMenuItemElement.appendChild(virtualMenuItem.getFullXML(doc));
                this.appendSection(moveMenuItemElement, doc, rootSection, false);
                return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb());
            }
            this.log.info((Object)("Virtual menuitem with menuItemID \"" + uriParser.get(2) + "\" not found, requested by user " + user));
            this.redirectToDefaultMethod(req, res);
            return null;
        }
        this.log.warn((Object)("Bad menuItemID \"" + uriParser.get(2) + "\" requested by user " + user));
        this.redirectToDefaultMethod(req, res);
        return null;
    }

    @WebPublic
    public SimpleForegroundModuleResponse sortMenu(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws SQLException, IOException {
        Integer sectionID = null;
        if (uriParser.size() == 3 && (sectionID = NumberUtils.toInt((String)uriParser.get(2))) != null) {
            SectionInterface sectionInterface = this.systemInterface.getSectionInterface(sectionID);
            if (sectionInterface != null) {
                if (req.getMethod().equalsIgnoreCase("POST") && req.getParameter("itempositions") != null) {
                    int i;
                    this.log.info((Object)("User " + user + " updating menuinex for section " + sectionInterface.getSectionDescriptor()));
                    Object[] itemPositions = req.getParameter("itempositions").replaceAll("menusorter=", "").replaceAll("-", "").replaceAll("[+]", "").split(",");
                    this.log.debug((Object)("Itempositions: " + StringUtils.toCommaSeparatedString((Object[])itemPositions)));
                    MenuItem[] menuItemArray = sectionInterface.getMenuCache().getMenuItemSet().toArray(new MenuItem[sectionInterface.getMenuCache().getMenuItemSet().size()]);
                    int[] menuIndexArray = new int[menuItemArray.length];
                    for (i = 0; i < menuItemArray.length; ++i) {
                        menuIndexArray[i] = menuItemArray[i].getMenuIndex();
                    }
                    for (i = 0; i < itemPositions.length && i < menuItemArray.length; ++i) {
                        this.log.debug((Object)("TextFieldSettingDescriptor " + menuItemArray[Integer.parseInt((String)itemPositions[i])].toString() + " menuindex to " + menuIndexArray[i] + " (" + menuItemArray[Integer.parseInt((String)itemPositions[i])].getMenuIndex() + ")"));
                        menuItemArray[Integer.parseInt((String)itemPositions[i])].setMenuIndex(menuIndexArray[i]);
                    }
                    sectionInterface.getMenuCache().rebuildIndex();
                    sectionInterface.getMenuCache().saveIndex();
                    this.redirectToDefaultMethod(req, res);
                    return null;
                }
                Document doc = this.createDocument(req, uriParser);
                Element sortMenuElement = doc.createElement("sortMenu");
                doc.getFirstChild().appendChild(sortMenuElement);
                sortMenuElement.appendChild(sectionInterface.getSectionDescriptor().toXML(doc));
                Element menuitemsElement = doc.createElement("menuitems");
                sortMenuElement.appendChild(menuitemsElement);
                for (MenuItem menuItem : sectionInterface.getMenuCache().getMenuItemSet()) {
                    if (menuItem instanceof Bundle) {
                        menuitemsElement.appendChild(((Bundle)menuItem).toFullXML(doc));
                        continue;
                    }
                    menuitemsElement.appendChild(menuItem.toXML(doc));
                }
                return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb());
            }
            this.log.info((Object)("Non existing- or not cache section requested using sectionID \"" + uriParser.get(2) + "\" by user " + user));
            this.redirectToDefaultMethod(req, res);
            return null;
        }
        this.log.warn((Object)("Bad sectionID \"" + uriParser.get(2) + "\" requested by user " + user));
        this.redirectToDefaultMethod(req, res);
        return null;
    }

    private void appendSection(Element parentSection, Document doc, SimpleSectionDescriptor simpleSectionDescriptor, boolean menu) throws SQLException {
        Element sectionElement = simpleSectionDescriptor.toXML(doc);
        parentSection.appendChild(sectionElement);
        SectionInterface sectionInterface = this.systemInterface.getSectionInterface(simpleSectionDescriptor.getSectionID());
        if (sectionInterface == null) {
            sectionElement.setAttribute("cached", "false");
        } else {
            sectionElement.setAttribute("cached", "true");
            if (menu) {
                Element menuElement = doc.createElement("menuitems");
                sectionElement.appendChild(menuElement);
                for (MenuItem menuItem : sectionInterface.getMenuCache().getMenuItemSet()) {
                    if (menuItem instanceof Bundle) {
                        menuElement.appendChild(((Bundle)menuItem).toFullXML(doc));
                        continue;
                    }
                    menuElement.appendChild(menuItem.toXML(doc));
                }
                Element modules = doc.createElement("modules");
                sectionElement.appendChild(modules);
                for (ForegroundModuleDescriptor moduleDescriptor : sectionInterface.getForegroundModuleCache().getCachedModuleDescriptors()) {
                    modules.appendChild(moduleDescriptor.toXML(doc));
                }
            }
        }
        if (simpleSectionDescriptor.getSubSectionsList() != null) {
            Element subSectionsElement = doc.createElement("subsections");
            sectionElement.appendChild(subSectionsElement);
            for (SimpleSectionDescriptor simpleSectionDescriptor2 : simpleSectionDescriptor.getSubSectionsList()) {
                this.appendSection(subSectionsElement, doc, simpleSectionDescriptor2, menu);
            }
        }
    }

    public Document createDocument(HttpServletRequest req, URIParser uriParser) {
        Document doc = XMLUtils.createDomDocument();
        Element document = doc.createElement("document");
        document.appendChild(RequestUtils.getRequestInfoAsXML((Document)doc, (HttpServletRequest)req, (URIParser)uriParser));
        document.appendChild(this.sectionInterface.getSectionDescriptor().toXML(doc));
        document.appendChild(((ForegroundModuleDescriptor)this.moduleDescriptor).toXML(doc));
        doc.appendChild(document);
        return doc;
    }

    @WebPublic(alias="users")
    public ForegroundModuleResponse getUsers(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Throwable {
        return this.userGroupListConnector.getUsers(req, res, user, uriParser);
    }

    @WebPublic(alias="groups")
    public ForegroundModuleResponse getGroups(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Throwable {
        return this.userGroupListConnector.getGroups(req, res, user, uriParser);
    }
}

