/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.mailsenders.persisting.daos.mysql;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;
import se.unlogic.hierarchy.foregroundmodules.mailsenders.persisting.daos.MailDAOFactory;
import se.unlogic.hierarchy.foregroundmodules.mailsenders.persisting.daos.mysql.MySQLMailDAO;
import se.unlogic.standardutils.dao.querys.UpdateQuery;
import se.unlogic.standardutils.db.DBUtils;
import se.unlogic.standardutils.db.tableversionhandler.DBScriptProvider;
import se.unlogic.standardutils.db.tableversionhandler.TableUpgradeException;
import se.unlogic.standardutils.db.tableversionhandler.TableVersionHandler;
import se.unlogic.standardutils.db.tableversionhandler.UpgradeResult;
import se.unlogic.standardutils.db.tableversionhandler.XMLDBScriptProvider;
import se.unlogic.standardutils.string.StringUtils;

public class MySQLMailDAOFactory
extends MailDAOFactory {
    private static Logger log = Logger.getLogger(MySQLMailDAOFactory.class);
    private MySQLMailDAO mailDAO;

    @Override
    public MySQLMailDAO getMailDAO() {
        return this.mailDAO;
    }

    @Override
    public void init(DataSource dataSource) throws SQLException, IOException, TableUpgradeException, SAXException, ParserConfigurationException {
        UpgradeResult upgradeResult;
        log.debug((Object)("Checking for email tables in datasource " + dataSource));
        if (TableVersionHandler.getTableGroupVersion((DataSource)dataSource, (String)MySQLMailDAOFactory.class.getName()) == null) {
            String sql;
            if (!DBUtils.tableExists((DataSource)dataSource, (String)"emails")) {
                log.info((Object)("Creating email table in datasource " + dataSource));
                sql = StringUtils.readStreamAsString((InputStream)this.getClass().getResourceAsStream("dbscripts/emails.sql"));
                new UpdateQuery(dataSource.getConnection(), true, sql).executeUpdate();
            }
            if (!DBUtils.tableExists((DataSource)dataSource, (String)"attachments")) {
                log.info((Object)("Creating attachments table in datasource " + dataSource));
                sql = StringUtils.readStreamAsString((InputStream)this.getClass().getResourceAsStream("dbscripts/attachments.sql"));
                new UpdateQuery(dataSource.getConnection(), true, sql).executeUpdate();
            }
            if (!DBUtils.tableExists((DataSource)dataSource, (String)"bccrecipients")) {
                log.info((Object)("Creating bccrecipients table in datasource " + dataSource));
                sql = StringUtils.readStreamAsString((InputStream)this.getClass().getResourceAsStream("dbscripts/bccrecipients.sql"));
                new UpdateQuery(dataSource.getConnection(), true, sql).executeUpdate();
            }
            if (!DBUtils.tableExists((DataSource)dataSource, (String)"ccrecipients")) {
                log.info((Object)("Creating ccrecipients table in datasource " + dataSource));
                sql = StringUtils.readStreamAsString((InputStream)this.getClass().getResourceAsStream("dbscripts/ccrecipients.sql"));
                new UpdateQuery(dataSource.getConnection(), true, sql).executeUpdate();
            }
            if (!DBUtils.tableExists((DataSource)dataSource, (String)"recipients")) {
                log.info((Object)("Creating recipients table in datasource " + dataSource));
                sql = StringUtils.readStreamAsString((InputStream)this.getClass().getResourceAsStream("dbscripts/recipients.sql"));
                new UpdateQuery(dataSource.getConnection(), true, sql).executeUpdate();
            }
            if (!DBUtils.tableExists((DataSource)dataSource, (String)"replyto")) {
                log.info((Object)("Creating replyto table in datasource " + dataSource));
                sql = StringUtils.readStreamAsString((InputStream)this.getClass().getResourceAsStream("dbscripts/replyto.sql"));
                new UpdateQuery(dataSource.getConnection(), true, sql).executeUpdate();
            }
        }
        if ((upgradeResult = TableVersionHandler.upgradeDBTables((DataSource)dataSource, (String)MySQLMailDAOFactory.class.getName(), (DBScriptProvider)new XMLDBScriptProvider(MySQLMailDAOFactory.class.getResourceAsStream("dbscripts/DB script.xml")))).isUpgrade()) {
            log.info((Object)upgradeResult.toString());
        }
        this.mailDAO = new MySQLMailDAO(dataSource);
    }
}

