/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.mailsenders.persisting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import se.unlogic.emailutils.framework.Attachment;
import se.unlogic.emailutils.framework.Email;
import se.unlogic.emailutils.framework.EmailUtils;
import se.unlogic.emailutils.framework.InvalidEmailAddressException;
import se.unlogic.standardutils.dao.annotations.DAOManaged;

public class QueuedEmail
implements Email {
    @DAOManaged
    private UUID emailID;
    @DAOManaged
    private int resendCount;
    @DAOManaged
    private String senderName;
    @DAOManaged
    private String senderAddress;
    @DAOManaged
    private String charset;
    @DAOManaged
    private String messageContentType;
    @DAOManaged
    private String subject;
    @DAOManaged
    private String message;
    private ArrayList<Attachment> attachments;
    private ArrayList<String> bccRecipients;
    private ArrayList<String> ccRecipients;
    private ArrayList<String> recipients;
    private ArrayList<String> replyTo;

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getMessage() {
        return this.message;
    }

    public ArrayList<String> getReplyTo() {
        return this.replyTo;
    }

    public String getMessageContentType() {
        return this.messageContentType;
    }

    public List<String> getRecipients() {
        return this.recipients;
    }

    public void addRecipient(String address) throws InvalidEmailAddressException {
        if (!EmailUtils.isValidEmailAddress((String)address)) {
            throw new InvalidEmailAddressException(address);
        }
        this.recipients.add(address);
    }

    public boolean addRecipients(Collection<String> addresses) throws InvalidEmailAddressException {
        return this.recipients.addAll(addresses);
    }

    public String getSenderName() {
        return this.senderName;
    }

    public String getSenderAddress() {
        return this.senderAddress;
    }

    public String getSubject() {
        return this.subject;
    }

    public boolean add(Attachment o) {
        return this.attachments.add(o);
    }

    public boolean addAll(Collection<? extends Attachment> c) {
        return this.attachments.addAll(c);
    }

    public List<String> getBccRecipients() {
        return this.bccRecipients;
    }

    public void addBccRecipient(String address) throws InvalidEmailAddressException {
        if (!EmailUtils.isValidEmailAddress((String)address)) {
            throw new InvalidEmailAddressException(address);
        }
        this.bccRecipients.add(address);
    }

    public boolean addBccRecipients(Collection<String> addresses) throws InvalidEmailAddressException {
        return this.bccRecipients.addAll(addresses);
    }

    public List<String> getCcRecipients() {
        return this.ccRecipients;
    }

    public void addCcRecipient(String address) throws InvalidEmailAddressException {
        if (!EmailUtils.isValidEmailAddress((String)address)) {
            throw new InvalidEmailAddressException(address);
        }
        this.ccRecipients.add(address);
    }

    public boolean addCcRecipients(Collection<String> addresses) throws InvalidEmailAddressException {
        return this.ccRecipients.addAll(addresses);
    }

    public void setSenderAddress(String senderAdress) throws InvalidEmailAddressException {
        if (!EmailUtils.isValidEmailAddress((String)senderAdress)) {
            throw new InvalidEmailAddressException(senderAdress);
        }
        this.senderAddress = senderAdress;
    }

    public void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setMessageContentType(String messageContentType) {
        this.messageContentType = messageContentType;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public UUID getEmailID() {
        return this.emailID;
    }

    public void setEmailID(UUID emailID) {
        this.emailID = emailID;
    }

    public int getResendCount() {
        return this.resendCount;
    }

    public void setResendCount(int retryCount) {
        this.resendCount = retryCount;
    }

    public String toString() {
        if (this.recipients != null && this.recipients.size() == 1 && this.bccRecipients == null && this.ccRecipients == null) {
            return this.subject + " (to: " + this.recipients.get(0) + ")";
        }
        int recipientCount = 0;
        if (this.recipients != null) {
            recipientCount += this.recipients.size();
        }
        if (this.ccRecipients != null) {
            recipientCount += this.ccRecipients.size();
        }
        if (this.bccRecipients != null) {
            recipientCount += this.bccRecipients.size();
        }
        return this.subject + " (to: " + recipientCount + " recipient(s))";
    }

    public void setAttachments(ArrayList<Attachment> attachments) {
        this.attachments = attachments;
    }

    public void setBccRecipients(ArrayList<String> bccRecipients) {
        this.bccRecipients = bccRecipients;
    }

    public void setCcRecipients(ArrayList<String> ccRecipients) {
        this.ccRecipients = ccRecipients;
    }

    public void setRecipients(ArrayList<String> recipients) {
        this.recipients = recipients;
    }

    public void setReplyTo(ArrayList<String> replyTo) {
        this.replyTo = replyTo;
    }

    public Date getSentDate() {
        return null;
    }
}

