/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.mailsenders.persisting;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.mail.Authenticator;
import javax.mail.Session;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import se.unlogic.emailutils.framework.Email;
import se.unlogic.emailutils.framework.EmailSender;
import se.unlogic.emailutils.framework.SimpleAuthenticator;
import se.unlogic.hierarchy.core.annotations.ModuleSetting;
import se.unlogic.hierarchy.core.beans.SettingDescriptor;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleResponse;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.foregroundmodules.AnnotatedForegroundModule;
import se.unlogic.hierarchy.foregroundmodules.mailsenders.direct.EmailCounter;
import se.unlogic.hierarchy.foregroundmodules.mailsenders.persisting.EmailJob;
import se.unlogic.hierarchy.foregroundmodules.mailsenders.persisting.QueuedEmail;
import se.unlogic.hierarchy.foregroundmodules.mailsenders.persisting.daos.MailDAO;
import se.unlogic.hierarchy.foregroundmodules.mailsenders.persisting.daos.MailDAOFactory;
import se.unlogic.standardutils.db.tableversionhandler.TableUpgradeException;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.validation.StringFormatValidator;
import se.unlogic.standardutils.validation.StringIntegerValidator;
import se.unlogic.standardutils.validation.StringLongValidator;
import se.unlogic.webutils.http.URIParser;

public class PersistingMailSender
extends AnnotatedForegroundModule
implements Runnable,
EmailSender,
EmailCounter {
    private static final String DEFAULT_DAO_FACTORY_CLASS = "se.unlogic.hierarchy.foregroundmodules.mailsenders.persisting.daos.mysql.MySQLMailDAOFactory";
    private static final ArrayList<SettingDescriptor> SETTINGDESCRIPTORS = new ArrayList();
    private String daoFactoryClass = "se.unlogic.hierarchy.foregroundmodules.mailsenders.persisting.daos.mysql.MySQLMailDAOFactory";
    private ThreadPoolExecutor threadPoolExecutor;
    private MailDAO mailDAO;
    private Thread workFetcherThread;
    private boolean started;
    protected Session session;
    protected long mailsSent;
    @ModuleSetting
    protected String host;
    @ModuleSetting
    protected int port = 25;
    @ModuleSetting
    protected boolean useAuth;
    @ModuleSetting
    protected String username;
    @ModuleSetting
    protected String password;
    @ModuleSetting
    protected int connectionTimeout = 10000;
    @ModuleSetting
    protected Integer socketTimeout = 600000;
    @ModuleSetting
    protected int priority = 0;
    @ModuleSetting
    protected int poolSize = 10;
    @ModuleSetting
    protected int maxQueueSize = 50;
    @ModuleSetting
    protected long queueFullInterval = 3000L;
    @ModuleSetting
    protected long noWorkInterval = 10000L;
    @ModuleSetting
    protected long exceptionInterval = 60000L;
    @ModuleSetting
    protected int maxExceptionCount = 5;
    private int exceptionCount = 0;
    @ModuleSetting
    protected int maxResendCount = 3;
    @ModuleSetting
    protected int warningResendCount = 2;
    @ModuleSetting
    protected int resendInterval = 30;
    @ModuleSetting
    protected long shutdownTimeout = 60000L;
    @ModuleSetting
    protected Integer databaseID;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();

    @Override
    public void init(ForegroundModuleDescriptor moduleDescriptor, SectionInterface sectionInterface, DataSource dataSource) throws Exception {
        this.databaseID = moduleDescriptor.getModuleID();
        super.init(moduleDescriptor, sectionInterface, dataSource);
        this.setup();
    }

    @Override
    public void update(ForegroundModuleDescriptor moduleDescriptor, DataSource dataSource) throws Exception {
        try {
            this.writeLock.lock();
            this.daoFactoryClass = moduleDescriptor.getMutableSettingHandler().getString("daoFactoryClass");
            if ((!this.databaseID.equals(moduleDescriptor.getMutableSettingHandler().getInt("databaseID")) || this.maxQueueSize != moduleDescriptor.getMutableSettingHandler().getInt("maxQueueSize") || dataSource != this.dataSource || this.daoFactoryClass == null && !this.daoFactoryClass.equals(DEFAULT_DAO_FACTORY_CLASS) || this.daoFactoryClass != null && !this.daoFactoryClass.equals(this.daoFactoryClass)) && this.started) {
                this.shutDown();
            }
            super.update(moduleDescriptor, dataSource);
            this.setup();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void unload() throws Exception {
        try {
            this.writeLock.lock();
            if (this.started) {
                this.shutDown();
            }
            super.unload();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void shutDown() {
        this.log.info((Object)"Shutting down worker fethcer thread and thread pool...");
        this.sectionInterface.getSystemInterface().getEmailHandler().removeSender((EmailSender)this);
        this.started = false;
        if (this.workFetcherThread.isAlive() && Thread.currentThread() != this.workFetcherThread) {
            try {
                this.workFetcherThread.interrupt();
                this.workFetcherThread.join();
            }
            catch (InterruptedException e) {
                this.log.error((Object)"Interrupted while waiting for work fetcher thread to stop");
            }
        }
        this.threadPoolExecutor.purge();
        this.threadPoolExecutor.shutdown();
        try {
            this.threadPoolExecutor.awaitTermination(this.shutdownTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.log.error((Object)"Error waiting for thread pool to shutdown", (Throwable)e);
        }
        try {
            this.mailDAO.releaseAll(this.databaseID);
        }
        catch (SQLException e) {
            this.log.error((Object)"Unable to release taken mails", (Throwable)e);
        }
        this.exceptionCount = 0;
        this.log.info((Object)"Work fether thread and thread pool stopped, all queued jobs released");
    }

    protected void setup() throws TableUpgradeException, SAXException, ParserConfigurationException {
        if (StringUtils.isEmpty((String)this.host)) {
            if (this.started) {
                this.shutDown();
            }
            this.log.warn((Object)("Module " + this.moduleDescriptor + " not properly configured (no SMTP server host set), not accepting mail"));
        } else {
            try {
                Properties props = new Properties();
                props.put("mail.smtp.host", this.host);
                props.put("mail.smtp.port", (Object)this.port);
                props.put("mail.smtp.connectiontimeout", (Object)this.connectionTimeout);
                if (this.socketTimeout != null) {
                    props.put("mail.smtp.timeout", this.socketTimeout);
                }
                this.session = !this.useAuth ? Session.getInstance((Properties)props) : Session.getInstance((Properties)props, (Authenticator)new SimpleAuthenticator(this.username, this.password));
                if (this.started) {
                    this.threadPoolExecutor.setCorePoolSize(this.poolSize);
                    this.threadPoolExecutor.setMaximumPoolSize(this.poolSize);
                } else {
                    Class<?> daoFactoryClass = Class.forName(this.daoFactoryClass);
                    MailDAOFactory daoFactory = (MailDAOFactory)daoFactoryClass.newInstance();
                    daoFactory.init(this.dataSource);
                    this.mailDAO = daoFactory.getMailDAO();
                    try {
                        this.mailDAO.releaseAll(this.databaseID);
                    }
                    catch (SQLException e) {
                        this.log.error((Object)"Unable to release taken e-mails", (Throwable)e);
                    }
                    this.threadPoolExecutor = new ThreadPoolExecutor(this.poolSize, this.poolSize, 5000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(this.maxQueueSize));
                    this.started = true;
                    this.workFetcherThread = new Thread((Runnable)this, "Work fetcher thread for module " + ((ForegroundModuleDescriptor)this.moduleDescriptor).toString());
                    this.workFetcherThread.start();
                }
                this.sectionInterface.getSystemInterface().getEmailHandler().addSender((EmailSender)this);
                this.log.info((Object)("Module " + this.moduleDescriptor + " ready to process mail"));
            }
            catch (ClassNotFoundException e) {
                this.log.error((Object)"Unable to create MailDAOFactory", (Throwable)e);
            }
            catch (InstantiationException e) {
                this.log.error((Object)"Unable to create MailDAOFactory", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.log.error((Object)"Unable to create MailDAOFactory", (Throwable)e);
            }
            catch (SQLException e) {
                this.log.error((Object)"Unable to create MailDAOFactory", (Throwable)e);
            }
            catch (IOException e) {
                this.log.error((Object)"Unable to create MailDAOFactory", (Throwable)e);
            }
        }
    }

    @Override
    public List<SettingDescriptor> getSettings() {
        List<SettingDescriptor> superSettings = super.getSettings();
        if (superSettings != null) {
            ArrayList<SettingDescriptor> combinedSettings = new ArrayList<SettingDescriptor>();
            combinedSettings.addAll(superSettings);
            combinedSettings.addAll(SETTINGDESCRIPTORS);
            combinedSettings.add(SettingDescriptor.createTextFieldSetting("databaseID", "Database ID", "The ID that this module uses to lock e-mails in the database (note don't change unless know what you're doing!)", true, "3", (StringFormatValidator)new StringIntegerValidator(Integer.valueOf(1), null)));
            return combinedSettings;
        }
        return SETTINGDESCRIPTORS;
    }

    public boolean send(Email email) {
        block8: {
            try {
                this.readLock.lock();
                if (this.started) {
                    try {
                        this.log.info((Object)("Adding email " + email + " to DB"));
                        this.mailDAO.add(email);
                        boolean bl = true;
                        return bl;
                    }
                    catch (SQLException e) {
                        this.log.error((Object)("Unable to queue email " + email), (Throwable)e);
                        break block8;
                    }
                    catch (RuntimeException e) {
                        this.log.error((Object)("Unable to queue email " + email), (Throwable)e);
                        break block8;
                    }
                }
                this.log.warn((Object)("Module " + this.moduleDescriptor + " is not properly configured, refusing to send mail " + email));
            }
            finally {
                this.readLock.unlock();
            }
        }
        return false;
    }

    @Override
    public void run() {
        this.log.info((Object)"Work fetcher thread started");
        boolean wasFull = false;
        while (this.started) {
            int queueSize = this.threadPoolExecutor.getQueue().size();
            if (queueSize >= this.maxQueueSize) {
                wasFull = true;
                try {
                    this.log.debug((Object)("Queue is full, sleeping " + this.queueFullInterval + " ms"));
                    Thread.sleep(this.queueFullInterval);
                }
                catch (InterruptedException e) {
                    this.log.debug((Object)"Work fetcher thread interrupted while sleeping due to full queue");
                }
                continue;
            }
            try {
                QueuedEmail email;
                if (wasFull && this.threadPoolExecutor.getQueue().isEmpty()) {
                    this.log.warn((Object)"Queue starvation, increase queue size, reduce thread pool size or lower queue full sleep Interval for optimum performance");
                }
                if (wasFull) {
                    wasFull = false;
                }
                if ((email = this.mailDAO.get((long)this.resendInterval * 60000L, this.databaseID)) == null) {
                    try {
                        this.log.debug((Object)("No jobs found in DB, sleeping " + this.noWorkInterval + " ms"));
                        Thread.sleep(this.noWorkInterval);
                    }
                    catch (InterruptedException e) {
                        this.log.debug((Object)"Work fetcher thread interrupted while sleeping due to no jobs in DB");
                    }
                    continue;
                }
                this.log.debug((Object)("Putting email " + email + " on queue"));
                try {
                    this.threadPoolExecutor.execute(new EmailJob(email, this.session, this.maxResendCount, this.warningResendCount, this.mailDAO, this));
                }
                catch (RejectedExecutionException e) {
                    this.log.warn((Object)("Error putting email " + email + " on queue."), (Throwable)e);
                    try {
                        this.mailDAO.updateAndRelease(email);
                    }
                    catch (Exception e2) {
                        this.log.error((Object)("Error releasing email " + email), (Throwable)e2);
                    }
                }
            }
            catch (Throwable e) {
                this.log.error((Object)"Unable to get emails from database", e);
                ++this.exceptionCount;
                if (this.exceptionCount >= this.maxExceptionCount) {
                    this.log.error((Object)("Maximum number of allowed exceptions (" + this.maxExceptionCount + ") in work fethcer thread has been reached, killing worker thread and shutting down thread pool"));
                    this.shutDown();
                    continue;
                }
                try {
                    Thread.sleep(this.exceptionInterval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.log.info((Object)"Work fetcher thread stopping");
    }

    @Override
    public synchronized void incrementMailsSent() {
        ++this.mailsSent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleForegroundModuleResponse defaultMethod(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        try {
            this.readLock.lock();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<div class=\"contentitem\">");
            stringBuilder.append("<h1>" + ((ForegroundModuleDescriptor)this.moduleDescriptor).getName() + "</h1>");
            stringBuilder.append("<p>Mails sent: " + this.mailsSent + "</p>");
            if (this.started) {
                stringBuilder.append("<p>Current status: ready!</p>");
                stringBuilder.append("<p>Active threads: " + this.threadPoolExecutor.getActiveCount() + "</p>");
                stringBuilder.append("<p>Pool size: " + this.threadPoolExecutor.getCorePoolSize() + "</p>");
                stringBuilder.append("<p>Queue size: " + this.threadPoolExecutor.getQueue().size() + "</p>");
                stringBuilder.append("<p>Mails in DB: " + this.mailDAO.getMailCount() + "</p>");
            } else {
                stringBuilder.append("<p>Current status: <b>not ready</b></p>");
            }
            stringBuilder.append("</div>");
            SimpleForegroundModuleResponse simpleForegroundModuleResponse = new SimpleForegroundModuleResponse(stringBuilder.toString(), ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb());
            return simpleForegroundModuleResponse;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getPriority() {
        return this.priority;
    }

    static {
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("daoFactoryClass", "DAO Factory", "The class of the DAO factory to use", true, DEFAULT_DAO_FACTORY_CLASS, null));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("host", "Server", "The hostname of your SMTP mail server ex. \"smtp.myisp.com\"", true, "", null));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("port", "Port", "The port number of your SMTP mail server usally 25 (allowed values are 1 - 65535)", true, "25", (StringFormatValidator)new StringIntegerValidator(Integer.valueOf(1), Integer.valueOf(65535))));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createCheckboxSetting("useAuth", "Use authentication", "Controls wheter or not username and password should be used when sending mails to the SMTP mail server", false));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("username", "Username", "The username to be used when authentication with the SMTP server", false, "", null));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("password", "Password", "The password to be used when authentication with the SMTP server", false, "", null));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("connectionTimeout", "Connection timeout", "The connection timeout in milliseconds when connecting to the SMTP mail server (default is 10000 ms)", true, "10000", (StringFormatValidator)new StringIntegerValidator(Integer.valueOf(1), null)));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("socketTimeout", "Socket timeout", "The socket timeout in milliseconds when sending mails (default is 600000 ms, 10 minutes)", false, "600000", (StringFormatValidator)new StringIntegerValidator(Integer.valueOf(1), null)));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("priority", "Priority", "Sets the priority of this e-mail sender compared to other e-mail senders (higher value means higher priority)", true, "0", (StringFormatValidator)new StringIntegerValidator(Integer.valueOf(0), null)));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("poolSize", "Max pool size", "The maximum number of threads to allow in the pool", true, "10", (StringFormatValidator)new StringIntegerValidator(Integer.valueOf(1), null)));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("maxQueueSize", "Queue size", "The size of the queue in RAM where emails are cached from DB waiting to be sent. The thread pool gets it jobs from this queue so it should always be bigger than the maximum number allowed threads in the threadpool (default is 50 emails)", true, "50", (StringFormatValidator)new StringIntegerValidator(Integer.valueOf(1), null)));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("queueFullInterval", "Queue full Interval", "Controls many ms the thread that fetches e-mails from DB should wait when the queue in RAM is full (default is 3000 ms)", true, "3000", (StringFormatValidator)new StringLongValidator(Long.valueOf(0L), null)));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("noWorkInterval", "No work interval", "Controls many ms the thread that fetches e-mails from DB should wait when there are no jobs in the DB (default is 10000 ms)", true, "10000", (StringFormatValidator)new StringLongValidator(Long.valueOf(0L), null)));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("exceptionInterval", "DB error interval", "Controls many ms the thread that fetches e-mails from DB should wait when there is a problem reading from the databse (default is 60000 ms)", true, "60000", (StringFormatValidator)new StringLongValidator(Long.valueOf(0L), null)));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("maxExceptionCount", "DB error count", "Controls many errors reading from the DB that are allowed before the module stops sending mails and shuts down the thread pool", true, "5", (StringFormatValidator)new StringIntegerValidator(Integer.valueOf(0), null)));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("maxResendCount", "Resend count", "Controls how many times e-mails are resent in case of failed delivery", true, "3", (StringFormatValidator)new StringIntegerValidator(Integer.valueOf(0), null)));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("warningResendCount", "Warning resend count", "Controls after how many retries sms sender should send error log message", true, "2", (StringFormatValidator)new StringIntegerValidator(Integer.valueOf(0), null)));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("resendInterval", "Resend interval", "Controls how many minutes to wait before resending e-mails in case of failed delivery", true, "30", (StringFormatValidator)new StringIntegerValidator(Integer.valueOf(0), null)));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("shutdownTimeout", "Shutdown timeout", "How many ms to wait for the thread pool to finish on shutdown", true, "60000", (StringFormatValidator)new StringIntegerValidator(Integer.valueOf(0), null)));
    }
}

