/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.mailsenders.persisting;

import java.sql.SQLException;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;
import se.unlogic.emailutils.framework.Email;
import se.unlogic.emailutils.framework.EmailConverter;
import se.unlogic.hierarchy.foregroundmodules.mailsenders.direct.EmailCounter;
import se.unlogic.hierarchy.foregroundmodules.mailsenders.persisting.QueuedEmail;
import se.unlogic.hierarchy.foregroundmodules.mailsenders.persisting.daos.MailDAO;

public class EmailJob
implements Runnable {
    private static Logger log = Logger.getLogger(EmailJob.class);
    private final QueuedEmail email;
    private final Session session;
    private final int maxResendCount;
    private final int warningResendCount;
    private final MailDAO mailDAO;
    private final EmailCounter emailCounter;

    public EmailJob(QueuedEmail email, Session session, int maxResendCount, int warningResendCount, MailDAO mailDAO, EmailCounter emailCounter) {
        this.email = email;
        this.session = session;
        this.maxResendCount = maxResendCount;
        this.warningResendCount = warningResendCount;
        this.mailDAO = mailDAO;
        this.emailCounter = emailCounter;
    }

    @Override
    public void run() {
        block7: {
            if (this.checkResendCount(this.email)) {
                try {
                    MimeMessage message = EmailConverter.convert((Email)this.email, (Session)this.session);
                    log.info((Object)("Sending email " + this.email));
                    Transport.send((Message)message);
                    log.debug((Object)("Sent mail " + this.email));
                    this.emailCounter.incrementMailsSent();
                    try {
                        this.mailDAO.delete(this.email);
                    }
                    catch (SQLException e) {
                        log.error((Object)("Unable to delete email " + this.email + " after sending"), (Throwable)e);
                    }
                }
                catch (Throwable e) {
                    log.warn((Object)("Error sending email " + this.email), e);
                    this.email.setResendCount(this.email.getResendCount() + 1);
                    if (!this.checkResendCount(this.email)) break block7;
                    try {
                        this.mailDAO.updateAndRelease(this.email);
                    }
                    catch (SQLException e1) {
                        log.error((Object)("Error updating resend count of email " + this.email), e);
                    }
                }
            }
        }
    }

    private boolean checkResendCount(QueuedEmail email) {
        if (email.getResendCount() == this.warningResendCount) {
            log.error((Object)("Unable to send email " + email + " after " + email.getResendCount() + " retries"));
        }
        if (email.getResendCount() >= this.maxResendCount) {
            log.info((Object)("Email " + email + " has been resent " + email.getResendCount() + " time(s), deleting..."));
            try {
                this.mailDAO.delete(email);
            }
            catch (SQLException e) {
                log.error((Object)("Unable to delete email " + email), (Throwable)e);
            }
            return false;
        }
        return true;
    }
}

