/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.mailsenders.dummy;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import se.unlogic.emailutils.framework.Attachment;
import se.unlogic.emailutils.framework.Email;
import se.unlogic.emailutils.framework.EmailSender;
import se.unlogic.hierarchy.core.annotations.WebPublic;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleResponse;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.foregroundmodules.AnnotatedForegroundModule;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.webutils.http.URIParser;

public class DummyEmailSenderModule
extends AnnotatedForegroundModule
implements EmailSender {
    private Email email;

    @Override
    public SimpleForegroundModuleResponse defaultMethod(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<div class=\"contentitem\">");
        stringBuilder.append("<h1>" + ((ForegroundModuleDescriptor)this.moduleDescriptor).getName() + "</h1>");
        if (this.email == null) {
            stringBuilder.append("<p>No emails received</p>");
        } else {
            stringBuilder.append("<p>Latest received e-mail</p>");
            stringBuilder.append("<p><a href=\"" + this.getModuleURI(req) + "/rawMessage\">Click here to view raw message</a></p>");
            stringBuilder.append("<table>");
            stringBuilder.append("<tr>");
            stringBuilder.append("<td>Sender name:</td>");
            stringBuilder.append("<td>" + this.email.getSenderName() + "</td>");
            stringBuilder.append("</tr>");
            stringBuilder.append("<tr>");
            stringBuilder.append("<td>Sender address:</td>");
            stringBuilder.append("<td>" + this.email.getSenderAddress() + "</td>");
            stringBuilder.append("</tr>");
            stringBuilder.append("<tr>");
            stringBuilder.append("<td>Reply to:</td>");
            stringBuilder.append("<td>" + this.email.getReplyTo() + "</td>");
            stringBuilder.append("</tr>");
            stringBuilder.append("<tr>");
            stringBuilder.append("<td>Recipients:</td>");
            stringBuilder.append("<td>" + StringUtils.toCommaSeparatedString((Collection)this.email.getRecipients()) + "</td>");
            stringBuilder.append("</tr>");
            stringBuilder.append("<tr>");
            stringBuilder.append("<td>BCCRecipients:</td>");
            stringBuilder.append("<td>" + StringUtils.toCommaSeparatedString((Collection)this.email.getBccRecipients()) + "</td>");
            stringBuilder.append("</tr>");
            stringBuilder.append("<tr>");
            stringBuilder.append("<td>CCRecipients:</td>");
            stringBuilder.append("<td>" + StringUtils.toCommaSeparatedString((Collection)this.email.getCcRecipients()) + "</td>");
            stringBuilder.append("</tr>");
            stringBuilder.append("<tr>");
            stringBuilder.append("<td>Subject:</td>");
            stringBuilder.append("<td>" + this.email.getSubject() + "</td>");
            stringBuilder.append("</tr>");
            stringBuilder.append("<tr>");
            stringBuilder.append("<td colspan=\"2\">Message:</td>");
            stringBuilder.append("</tr>");
            stringBuilder.append("<tr>");
            stringBuilder.append("<td colspan=\"2\"><pre>" + this.email.getMessage() + "</pre></td>");
            stringBuilder.append("</tr>");
            if (!CollectionUtils.isEmpty((Collection)this.email.getAttachments())) {
                stringBuilder.append("<tr>");
                stringBuilder.append("<td colspan=\"2\">Attachments:</td>");
                stringBuilder.append("</tr>");
                for (Attachment attachment : this.email.getAttachments()) {
                    stringBuilder.append("<tr>");
                    stringBuilder.append("<td colspan=\"2\"><pre>" + attachment.toString() + "</pre></td>");
                    stringBuilder.append("</tr>");
                }
            }
            stringBuilder.append("</table>");
        }
        stringBuilder.append("</div>");
        return new SimpleForegroundModuleResponse(stringBuilder.toString(), ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb());
    }

    @Override
    public void init(ForegroundModuleDescriptor moduleDescriptor, SectionInterface sectionInterface, DataSource dataSource) throws Exception {
        super.init(moduleDescriptor, sectionInterface, dataSource);
        this.sectionInterface.getSystemInterface().getEmailHandler().addSender((EmailSender)this);
    }

    @Override
    public void unload() throws Exception {
        this.sectionInterface.getSystemInterface().getEmailHandler().removeSender((EmailSender)this);
        super.unload();
    }

    @WebPublic
    public SimpleForegroundModuleResponse rawMessage(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        if (this.email == null) {
            this.redirectToDefaultMethod(req, res);
            return null;
        }
        res.setContentType(this.email.getMessageContentType());
        res.getWriter().write(this.email.getMessage());
        res.flushBuffer();
        return null;
    }

    public int getPriority() {
        return 0;
    }

    public boolean send(Email email) {
        this.log.info((Object)("Received email " + email));
        this.email = email;
        return true;
    }
}

