/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.mailsenders.direct;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.mail.Authenticator;
import javax.mail.Session;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import se.unlogic.emailutils.framework.Email;
import se.unlogic.emailutils.framework.EmailSender;
import se.unlogic.emailutils.framework.SimpleAuthenticator;
import se.unlogic.hierarchy.core.annotations.ModuleSetting;
import se.unlogic.hierarchy.core.beans.SettingDescriptor;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleResponse;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.MutableSettingHandler;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.foregroundmodules.AnnotatedForegroundModule;
import se.unlogic.hierarchy.foregroundmodules.mailsenders.direct.EmailCounter;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.validation.StringFormatValidator;
import se.unlogic.standardutils.validation.StringIntegerValidator;
import se.unlogic.webutils.http.URIParser;

public class DirectMailSender
extends AnnotatedForegroundModule
implements EmailSender,
EmailCounter {
    private static final ArrayList<SettingDescriptor> SETTINGDESCRIPTORS = new ArrayList();
    protected long mailsSent;
    @ModuleSetting
    protected String host;
    @ModuleSetting
    protected Integer port = 25;
    @ModuleSetting
    protected Boolean useAuth;
    @ModuleSetting
    protected String username;
    @ModuleSetting
    protected String password;
    @ModuleSetting
    protected Integer connectionTimeout = 10000;
    @ModuleSetting
    protected Integer socketTimeout;
    @ModuleSetting
    protected int priority = 0;
    @ModuleSetting
    protected Boolean secure = false;
    @ModuleSetting
    protected Boolean startTLS = false;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
    protected Session session;

    @Override
    public void init(ForegroundModuleDescriptor moduleDescriptor, SectionInterface sectionInterface, DataSource dataSource) throws Exception {
        super.init(moduleDescriptor, sectionInterface, dataSource);
        this.setup(moduleDescriptor.getMutableSettingHandler());
    }

    @Override
    public void update(ForegroundModuleDescriptor moduleDescriptor, DataSource dataSource) throws Exception {
        super.update(moduleDescriptor, dataSource);
        this.setup(moduleDescriptor.getMutableSettingHandler());
    }

    protected void setup(MutableSettingHandler mutableSettingHandler) {
        try {
            this.writeLock.lock();
        }
        finally {
            if (StringUtils.isEmpty((String)this.host)) {
                this.session = null;
                this.sectionInterface.getSystemInterface().getEmailHandler().removeSender((EmailSender)this);
                this.log.info((Object)("Module " + this.moduleDescriptor + " not properly configured, not accepting mail"));
            } else {
                Properties props = new Properties();
                props.put("mail.smtp.host", this.host);
                props.put("mail.smtp.port", this.port);
                props.put("mail.smtp.connectiontimeout", this.connectionTimeout);
                if (this.socketTimeout != null) {
                    props.put("mail.smtp.timeout", this.socketTimeout);
                }
                if (this.secure.booleanValue()) {
                    props.put("mail.smtp.ssl", "true");
                }
                if (this.startTLS.booleanValue()) {
                    props.put("mail.smtp.starttls.enable", "true");
                }
                if (!this.useAuth.booleanValue()) {
                    this.session = Session.getInstance((Properties)props);
                } else {
                    props.put("mail.smtp.auth", "true");
                    this.session = Session.getInstance((Properties)props, (Authenticator)new SimpleAuthenticator(this.username, this.password));
                }
                this.sectionInterface.getSystemInterface().getEmailHandler().addSender((EmailSender)this);
                this.log.info((Object)("Module " + this.moduleDescriptor + " ready to process mail"));
            }
            this.writeLock.unlock();
        }
    }

    @Override
    public void unload() throws Exception {
        try {
            this.writeLock.lock();
            this.sectionInterface.getSystemInterface().getEmailHandler().removeSender((EmailSender)this);
            super.unload();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public List<SettingDescriptor> getSettings() {
        List<SettingDescriptor> superSettings = super.getSettings();
        if (superSettings != null) {
            ArrayList<SettingDescriptor> combinedSettings = new ArrayList<SettingDescriptor>();
            combinedSettings.addAll(superSettings);
            combinedSettings.addAll(SETTINGDESCRIPTORS);
            return combinedSettings;
        }
        return SETTINGDESCRIPTORS;
    }

    /*
     * Exception decompiling
     */
    public boolean send(Email email) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public synchronized void incrementMailsSent() {
        ++this.mailsSent;
    }

    @Override
    public SimpleForegroundModuleResponse defaultMethod(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<div class=\"contentitem\">");
        stringBuilder.append("<h1>" + ((ForegroundModuleDescriptor)this.moduleDescriptor).getName() + "</h1>");
        stringBuilder.append("<p>Mails sent: " + this.mailsSent + "</p>");
        if (this.session != null) {
            stringBuilder.append("<p>Current status: ready!</p>");
        } else {
            stringBuilder.append("<p>Current status: <b>not ready</b></p>");
        }
        stringBuilder.append("</div>");
        return new SimpleForegroundModuleResponse(stringBuilder.toString(), ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb());
    }

    public int getPriority() {
        return this.priority;
    }

    static {
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("host", "Server", "The hostname of your SMTP mail server ex. \"smtp.myisp.com\"", true, "", null));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("port", "Port", "The port number of your SMTP mail server usally 25 (allowed values are 1 - 65535)", true, "25", (StringFormatValidator)new StringIntegerValidator(Integer.valueOf(1), Integer.valueOf(65535))));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createCheckboxSetting("secure", "Secure channel", "Use a secure connection", false));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createCheckboxSetting("startTLS", "TLS", "Start TLS", false));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createCheckboxSetting("useAuth", "Use authentication", "Controls wheter or not username and password should be used when sending mails to the SMTP mail server", false));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("username", "Username", "The username to be used when authentication with the SMTP server", false, "", null));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createPasswordFieldSetting("password", "Password", "The password to be used when authentication with the SMTP server", false, "", null));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("connectionTimeout", "Connection timeout", "The connection timeout in milliseconds when connecting to the SMTP mail server (default is 10000 ms)", true, "10000", (StringFormatValidator)new StringIntegerValidator(Integer.valueOf(1), null)));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("socketTimeout", "Socket timeout", "The socket timeout in milliseconds when sending mails", false, "", (StringFormatValidator)new StringIntegerValidator(Integer.valueOf(1), null)));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("priority", "Priority", "Sets the priority of this E-mail sender compared to other E-mail senders (higher value means higher priority)", true, "0", (StringFormatValidator)new StringIntegerValidator(Integer.valueOf(0), null)));
    }
}

