/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.logout;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.annotations.HTMLEditorSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.ModuleSetting;
import se.unlogic.hierarchy.core.annotations.TextFieldSettingDescriptor;
import se.unlogic.hierarchy.core.beans.Breadcrumb;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleResponse;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.foregroundmodules.AnnotatedForegroundModule;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.URIParser;
import se.unlogic.webutils.url.URLRewriter;

public class LogoutModule
extends AnnotatedForegroundModule {
    @ModuleSetting(allowsNull=true)
    @TextFieldSettingDescriptor(name="Redirect URL", description="If this field is set then users will be redirected on logout. If the url does not begin with http:// or https:// then the contextpath will be appended to the beginning of the given url.")
    protected String redirectURL;
    @ModuleSetting(allowsNull=true)
    @HTMLEditorSettingDescriptor(name="Logout message", description="An optional logout message which overrides the default logout message if no redirect URL is set")
    protected String logoutMessage;
    protected boolean relativeRedirectURL;

    @Override
    protected void moduleConfigured() throws Exception {
        super.moduleConfigured();
        this.checkSettings();
    }

    protected void checkSettings() {
        String redirectURL = this.redirectURL;
        if (redirectURL != null) {
            this.relativeRedirectURL = !(redirectURL = redirectURL.toLowerCase()).startsWith("http://") && !redirectURL.startsWith("https://");
        }
    }

    @Override
    public SimpleForegroundModuleResponse defaultMethod(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws IOException {
        if (user != null) {
            HttpSession session = req.getSession();
            if (session != null) {
                try {
                    session.removeAttribute("user");
                    session.invalidate();
                    this.log.info((Object)("User " + user + " logged out!"));
                }
                catch (IllegalStateException e) {
                    this.log.info((Object)("Unable to logout user " + user + " session already invalidated"));
                }
            }
        } else {
            this.log.info((Object)"User is not logged in, displaying logged out message");
        }
        if (this.redirectURL != null) {
            if (this.relativeRedirectURL) {
                res.sendRedirect(req.getContextPath() + this.redirectURL);
            } else {
                res.sendRedirect(this.redirectURL);
            }
        }
        Document doc = XMLUtils.createDomDocument();
        Element document = doc.createElement("Document");
        doc.appendChild(document);
        Element logoutElement = doc.createElement("LoggedOut");
        document.appendChild(logoutElement);
        if (this.logoutMessage != null) {
            XMLUtils.appendNewElement((Document)doc, (Element)logoutElement, (String)"Message", (String)URLRewriter.setAbsoluteLinkUrls((String)this.logoutMessage, (HttpServletRequest)req));
        }
        return new SimpleForegroundModuleResponse(doc, true, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), new Breadcrumb[0]);
    }
}

