/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.login;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import se.unlogic.hierarchy.core.annotations.CheckboxSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.ModuleSetting;
import se.unlogic.hierarchy.core.beans.MutableUser;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.enums.EventTarget;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleResponse;
import se.unlogic.hierarchy.foregroundmodules.AnnotatedForegroundModule;
import se.unlogic.hierarchy.foregroundmodules.login.LoginEvent;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.URIParser;

public class XMLLoginModule
extends AnnotatedForegroundModule {
    @ModuleSetting
    @CheckboxSettingDescriptor(name="Update last login", description="Controls if the last login field of the user should be updated")
    protected boolean updateLastLogin;
    @ModuleSetting
    @CheckboxSettingDescriptor(name="Include attributes", description="Controls if the user attributes are included in the XML")
    protected boolean includeAttributes;

    @Override
    public ForegroundModuleResponse processRequest(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Throwable {
        User requestedUser;
        String username = this.getUsername(req);
        String password = this.getPassword(req);
        if (!StringUtils.isEmpty((String)username) && !StringUtils.isEmpty((String)password) && (requestedUser = this.systemInterface.getUserHandler().getUserByUsernamePassword(username, password, true, true)) != null) {
            if (this.updateLastLogin) {
                this.setLastLogin(requestedUser);
            }
            req.getSession(true).setAttribute("user", (Object)requestedUser);
            this.log.info((Object)("User " + requestedUser + " logged in from address " + req.getRemoteHost()));
            this.systemInterface.getEventHandler().sendEvent(User.class, new LoginEvent(requestedUser, req.getSession()), EventTarget.ALL);
            user = requestedUser;
            Document doc = XMLUtils.createDomDocument();
            doc.appendChild(user.toXML(doc));
            if (user.getAttributeHandler() != null && !user.getAttributeHandler().isEmpty()) {
                doc.getDocumentElement().appendChild(user.getAttributeHandler().toXML(doc));
            }
            this.sendResponse(doc, res);
            return null;
        }
        this.log.warn((Object)("Failed login attempt using username " + username + " from address " + req.getRemoteHost()));
        res.setStatus(400);
        Document doc = XMLUtils.createDomDocument();
        doc.appendChild(doc.createElement("LoginFailed"));
        this.sendResponse(doc, res);
        return null;
    }

    protected void sendResponse(Document doc, HttpServletResponse res) {
        res.setCharacterEncoding(this.systemInterface.getEncoding());
        res.setContentType("text/xml");
        try {
            XMLUtils.writeXML((Node)doc, (OutputStream)res.getOutputStream(), (boolean)false, (String)this.systemInterface.getEncoding());
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
        }
        catch (TransformerException transformerException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected String getUsername(HttpServletRequest req) {
        return req.getParameter("username");
    }

    protected String getPassword(HttpServletRequest req) {
        return req.getParameter("password");
    }

    protected void setLastLogin(User user) throws SQLException {
        user.setCurrentLogin(new Timestamp(System.currentTimeMillis()));
        if (user instanceof MutableUser) {
            MutableUser mutableUser = (MutableUser)user;
            Timestamp lastLogin = user.getLastLogin();
            mutableUser.setLastLogin(user.getCurrentLogin());
            try {
                this.systemInterface.getUserHandler().updateUser(mutableUser, false, false, false);
            }
            catch (Exception e) {
                this.log.error((Object)("Unable to update last login for user " + user), (Throwable)e);
            }
            mutableUser.setLastLogin(lastLogin);
        }
    }
}

