/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.login;

import java.sql.SQLException;
import java.sql.Timestamp;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import se.unlogic.hierarchy.core.beans.MutableUser;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.handlers.UserHandler;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.foregroundmodules.login.BaseLoginModule;
import se.unlogic.webutils.http.URIParser;

public class UserProviderLoginModule
extends BaseLoginModule<User> {
    private UserHandler userHandler;

    @Override
    public void init(ForegroundModuleDescriptor moduleDescriptor, SectionInterface sectionInterface, DataSource dataSource) throws Exception {
        super.init(moduleDescriptor, sectionInterface, dataSource);
        this.userHandler = this.systemInterface.getUserHandler();
    }

    @Override
    protected User findByUsernamePassword(String username, String password) throws SQLException {
        return this.userHandler.getUserByUsernamePassword(username, password, true, true);
    }

    @Override
    protected void setLastLogin(User user) throws SQLException {
        user.setCurrentLogin(new Timestamp(System.currentTimeMillis()));
        if (user instanceof MutableUser) {
            MutableUser mutableUser = (MutableUser)user;
            Timestamp lastLogin = user.getLastLogin();
            mutableUser.setLastLogin(user.getCurrentLogin());
            try {
                this.userHandler.updateUser(mutableUser, false, false, false);
            }
            catch (Exception e) {
                this.log.error((Object)("Unable to update last login for user " + user), (Throwable)e);
            }
            mutableUser.setLastLogin(lastLogin);
        }
    }

    @Override
    public boolean loginUser(HttpServletRequest req, URIParser uriParser, User user) throws Exception {
        this.setLoggedIn(req, uriParser, user);
        return true;
    }
}

