/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.login;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class RetryLimiter {
    private long lockoutTime;
    private int retries;
    private int retryInterval;
    protected Map<String, LockRecord> failedUsers = null;

    public RetryLimiter(boolean activated, int lockoutTime, int retries, int retryInterval) {
        this.lockoutTime = lockoutTime * 1000;
        this.retries = retries;
        this.retryInterval = retryInterval;
        this.failedUsers = new HashMap<String, LockRecord>();
    }

    public synchronized void registerAuthSuccess(String username) {
        this.failedUsers.remove(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerAuthFailure(String username) {
        LockRecord lockRecord = null;
        RetryLimiter retryLimiter = this;
        synchronized (retryLimiter) {
            if (!this.failedUsers.containsKey(username)) {
                lockRecord = new LockRecord();
                this.failedUsers.put(username, lockRecord);
            } else {
                lockRecord = this.failedUsers.get(username);
            }
        }
        return lockRecord.registerFailure(System.currentTimeMillis(), this.retries, this.retryInterval, this.lockoutTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked(String username) {
        LockRecord lockRecord = null;
        RetryLimiter retryLimiter = this;
        synchronized (retryLimiter) {
            if (!this.failedUsers.containsKey(username)) {
                lockRecord = new LockRecord();
                this.failedUsers.put(username, lockRecord);
            } else {
                lockRecord = this.failedUsers.get(username);
            }
        }
        return lockRecord.isLocked(System.currentTimeMillis(), this.lockoutTime);
    }

    public long getLockoutTime() {
        return this.lockoutTime;
    }

    public void setLockoutTime(int lockoutTime) {
        this.lockoutTime = lockoutTime * 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRemainingLockoutTime(String username) {
        LockRecord lockRecord = null;
        RetryLimiter retryLimiter = this;
        synchronized (retryLimiter) {
            lockRecord = this.failedUsers.get(username);
        }
        return lockRecord.getRemainingLockoutTime(this.lockoutTime, System.currentTimeMillis());
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    protected static class LockRecord {
        private ArrayList<Long> failureTimes = new ArrayList();
        private long lockTime = 0L;

        protected LockRecord() {
        }

        public ArrayList<Long> getFailureTimes() {
            return this.failureTimes;
        }

        public boolean registerFailure(long currentTime, int retries, int retryInterval, long lockoutTime) {
            this.failureTimes.add(currentTime);
            return this.purgeAndCheck(currentTime, retries, retryInterval, lockoutTime);
        }

        public boolean isLocked(long currentTime, long lockoutTime) {
            return currentTime - this.lockTime <= lockoutTime;
        }

        public int getRemainingLockoutTime(long lockoutTime, long currentTime) {
            long timePassed = currentTime - this.lockTime;
            long timeLeft = lockoutTime - timePassed;
            int timeLeftMinutes = (int)(timeLeft / 1000L / 60L);
            if (timeLeftMinutes == 0) {
                timeLeftMinutes = 1;
            }
            return timeLeftMinutes;
        }

        private boolean purgeAndCheck(long currentTime, int retries, int retryInterval, long lockoutTime) {
            if (this.isLocked(currentTime, lockoutTime)) {
                return true;
            }
            for (int i = 0; i < this.failureTimes.size(); ++i) {
                if ((long)(retryInterval * 1000) >= currentTime - this.failureTimes.get(i)) continue;
                this.failureTimes.remove(i);
            }
            if (retries <= this.failureTimes.size()) {
                this.lockTime = System.currentTimeMillis();
                return true;
            }
            return false;
        }
    }
}

