/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.invitation.cruds;

import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.exceptions.AccessDeniedException;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleResponse;
import se.unlogic.hierarchy.core.utils.IntegerBasedCRUD;
import se.unlogic.hierarchy.foregroundmodules.invitation.BaseInvitationAdminModule;
import se.unlogic.hierarchy.foregroundmodules.invitation.beans.BaseInvitation;
import se.unlogic.hierarchy.foregroundmodules.invitation.beans.BaseInvitationType;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.dao.CRUDDAO;
import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.validation.ValidationErrorType;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.BeanRequestPopulator;
import se.unlogic.webutils.http.URIParser;

public abstract class BaseInvitationCRUD<I extends BaseInvitation, IT extends BaseInvitationType, C extends BaseInvitationAdminModule<I, IT>>
extends IntegerBasedCRUD<I, C> {
    public BaseInvitationCRUD(CRUDDAO<I, Integer> crudDAO, BeanRequestPopulator<I> populator, String typeElementName, String typeLogName, String listMethodAlias, C callback) {
        super(crudDAO, populator, typeElementName, typeLogName, listMethodAlias, callback);
    }

    @Override
    protected void appendAddFormData(Document doc, Element addTypeElement, User user, HttpServletRequest req, URIParser uriParser) throws SQLException {
        XMLUtils.append((Document)doc, (Element)addTypeElement, (String)"InvitationTypes", ((BaseInvitationAdminModule)this.callback).getInvitationTypes());
    }

    @Override
    protected void appendUpdateFormData(I invitation, Document doc, Element updateTypeElement, User user, HttpServletRequest req, URIParser uriParser) throws SQLException {
        XMLUtils.append((Document)doc, (Element)updateTypeElement, (String)"InvitationTypes", ((BaseInvitationAdminModule)this.callback).getInvitationTypes());
        XMLUtils.appendNewElement((Document)doc, (Element)updateTypeElement, (String)"invitationURL", (String)((BaseInvitationAdminModule)this.callback).getInvitationURL(invitation, req));
    }

    @Override
    protected void validateAddPopulation(I invitation, HttpServletRequest req, User user, URIParser uriParser) throws ValidationException, SQLException, AccessDeniedException {
        IT invitationType;
        List validationErrors;
        block7: {
            block6: {
                validationErrors = null;
                invitationType = null;
                if (!NumberUtils.isInt((String)req.getParameter("invitationType"))) break block6;
                Object IT = ((BaseInvitationAdminModule)this.callback).getInvitationType(NumberUtils.toInt((String)req.getParameter("invitationType")));
                invitationType = IT;
                if (IT != null) break block7;
            }
            validationErrors = CollectionUtils.addAndInstantiateIfNeeded(validationErrors, (Object)new ValidationError("invitationType", ValidationErrorType.RequiredField));
        }
        if (((BaseInvitationAdminModule)this.callback).checkIfEmailInUse(invitation)) {
            validationErrors = CollectionUtils.addAndInstantiateIfNeeded((List)validationErrors, (Object)new ValidationError("EmailAlreadyTaken"));
        }
        if (validationErrors != null) {
            throw new ValidationException(validationErrors);
        }
        if (((BaseInvitation)((Object)invitation)).getLinkID() == null) {
            ((BaseInvitation)((Object)invitation)).setLinkID(UUID.randomUUID());
        }
        this.setInvitationType(invitation, invitationType);
    }

    protected abstract void setInvitationType(I var1, IT var2);

    @Override
    protected void validateUpdatePopulation(I invitation, HttpServletRequest req, User user, URIParser uriParser) throws ValidationException, SQLException, AccessDeniedException {
        this.validateAddPopulation(invitation, req, user, uriParser);
    }

    @Override
    protected ForegroundModuleResponse beanAdded(I invitation, HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        if (req.getParameter("send") != null) {
            try {
                ((BaseInvitationAdminModule)this.callback).sendInvitation(invitation, user, req);
            }
            catch (SQLException e) {
                throw new RuntimeException();
            }
        }
        return super.beanAdded(invitation, req, res, user, uriParser);
    }

    @Override
    protected ForegroundModuleResponse beanUpdated(I invitation, HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        if (req.getParameter("send") != null) {
            ((BaseInvitationAdminModule)this.callback).sendInvitation(invitation, user, req);
        }
        return super.beanUpdated(invitation, req, res, user, uriParser);
    }

    @Override
    public ForegroundModuleResponse list(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser, List<ValidationError> validationErrors) throws Exception {
        return ((BaseInvitationAdminModule)this.callback).list(req, res, user, uriParser, validationErrors);
    }
}

