/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.invitation;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import se.unlogic.hierarchy.core.annotations.CheckboxSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.ModuleSetting;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.core.utils.HierarchyAnnotatedDAOFactory;
import se.unlogic.hierarchy.core.utils.IntegerBasedCRUD;
import se.unlogic.hierarchy.foregroundmodules.invitation.BaseInvitationAdminModule;
import se.unlogic.hierarchy.foregroundmodules.invitation.SimpleInvitationModule;
import se.unlogic.hierarchy.foregroundmodules.invitation.beans.SimpleInvitation;
import se.unlogic.hierarchy.foregroundmodules.invitation.beans.SimpleInvitationType;
import se.unlogic.hierarchy.foregroundmodules.invitation.cruds.SimpleInvitationCRUD;
import se.unlogic.hierarchy.foregroundmodules.invitation.cruds.SimpleInvitationTypeCRUD;
import se.unlogic.standardutils.dao.AnnotatedDAO;
import se.unlogic.standardutils.dao.CRUDDAO;
import se.unlogic.standardutils.dao.HighLevelQuery;
import se.unlogic.standardutils.dao.QueryParameterFactory;
import se.unlogic.standardutils.dao.TransactionHandler;
import se.unlogic.standardutils.db.DBUtils;
import se.unlogic.standardutils.db.tableversionhandler.DBScriptProvider;
import se.unlogic.standardutils.db.tableversionhandler.TableVersionHandler;
import se.unlogic.standardutils.db.tableversionhandler.UpgradeResult;
import se.unlogic.standardutils.db.tableversionhandler.XMLDBScriptProvider;
import se.unlogic.standardutils.string.StringUtils;

public class SimpleInvitationAdminModule
extends BaseInvitationAdminModule<SimpleInvitation, SimpleInvitationType> {
    @ModuleSetting
    @CheckboxSettingDescriptor(name="Register in instance handler", description="Controls if this module should register itself in the global instance handler.")
    boolean registerInInstanceHandler = true;
    protected AnnotatedDAO<SimpleInvitation> invitationDAO;
    protected AnnotatedDAO<SimpleInvitationType> invitationTypeDAO;
    protected QueryParameterFactory<SimpleInvitation, String> invitationEmailParamFactory;
    protected SimpleInvitationCRUD invitationCRUD;
    protected SimpleInvitationTypeCRUD invitationTypeCRUD;

    @Override
    public void init(ForegroundModuleDescriptor moduleDescriptor, SectionInterface sectionInterface, DataSource dataSource) throws Exception {
        super.init(moduleDescriptor, sectionInterface, dataSource);
        if (this.registerInInstanceHandler && !this.systemInterface.getInstanceHandler().addInstance(SimpleInvitationAdminModule.class, this)) {
            this.log.warn((Object)("Another instance has already been registered in instance handler for class " + SimpleInvitationAdminModule.class.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createDAOs(DataSource dataSource) throws Exception {
        TransactionHandler transactionHandler;
        block6: {
            transactionHandler = null;
            try {
                String sql;
                transactionHandler = new TransactionHandler(dataSource);
                if (TableVersionHandler.getTableGroupVersion((TransactionHandler)transactionHandler, (String)SimpleInvitationAdminModule.class.getName()) != null) break block6;
                if (!DBUtils.tableExists((DataSource)dataSource, (String)"invitationtypes")) {
                    this.log.info((Object)("Creating invitationtypes table in datasource " + dataSource));
                    sql = StringUtils.readStreamAsString((InputStream)SimpleInvitationAdminModule.class.getResourceAsStream("dbscripts/InvitationTypesTable.sql"));
                    transactionHandler.getUpdateQuery(sql).executeUpdate();
                }
                if (!DBUtils.tableExists((DataSource)dataSource, (String)"invitationtypegroups")) {
                    this.log.info((Object)("Creating invitationtypegroups table in datasource " + dataSource));
                    sql = StringUtils.readStreamAsString((InputStream)SimpleInvitationAdminModule.class.getResourceAsStream("dbscripts/InvitationTypeGroupsTable.sql"));
                    transactionHandler.getUpdateQuery(sql).executeUpdate();
                }
                if (!DBUtils.tableExists((DataSource)dataSource, (String)"invitations")) {
                    this.log.info((Object)("Creating invitations table in datasource " + dataSource));
                    sql = StringUtils.readStreamAsString((InputStream)SimpleInvitationAdminModule.class.getResourceAsStream("dbscripts/InvitationsTable.sql"));
                    transactionHandler.getUpdateQuery(sql).executeUpdate();
                }
            }
            catch (Throwable throwable) {
                TransactionHandler.autoClose(transactionHandler);
                throw throwable;
            }
        }
        TransactionHandler.autoClose((TransactionHandler)transactionHandler);
        UpgradeResult upgradeResult = TableVersionHandler.upgradeDBTables((DataSource)dataSource, (String)SimpleInvitationAdminModule.class.getName(), (DBScriptProvider)new XMLDBScriptProvider(SimpleInvitationAdminModule.class.getResourceAsStream("dbscripts/DB script.xml")));
        if (upgradeResult.isUpgrade()) {
            this.log.info((Object)upgradeResult.toString());
        }
        HierarchyAnnotatedDAOFactory daoFactory = new HierarchyAnnotatedDAOFactory(dataSource, this.systemInterface.getUserHandler(), this.systemInterface.getGroupHandler());
        this.invitationDAO = daoFactory.getDAO(SimpleInvitation.class);
        this.invitationTypeDAO = daoFactory.getDAO(SimpleInvitationType.class);
        this.invitationEmailParamFactory = this.invitationDAO.getParamFactory("email", String.class);
        this.invitationCRUD = new SimpleInvitationCRUD((CRUDDAO<SimpleInvitation, Integer>)this.invitationDAO.getWrapper(Integer.class), this);
        this.invitationTypeCRUD = new SimpleInvitationTypeCRUD((CRUDDAO<SimpleInvitationType, Integer>)this.invitationTypeDAO.getWrapper(Integer.class), this, this.systemInterface.getGroupHandler());
    }

    @Override
    public List<SimpleInvitationType> getInvitationTypes() throws SQLException {
        return this.invitationTypeDAO.getAll();
    }

    @Override
    public List<SimpleInvitation> getInvitations() throws SQLException {
        return this.invitationDAO.getAll();
    }

    @Override
    protected IntegerBasedCRUD<SimpleInvitationType, ?> getInvitationTypeCRUD() {
        return this.invitationTypeCRUD;
    }

    @Override
    protected IntegerBasedCRUD<SimpleInvitation, ?> getInvitationCRUD() {
        return this.invitationCRUD;
    }

    @Override
    protected void updateInvitation(SimpleInvitation invitation) throws SQLException {
        this.invitationDAO.update((Object)invitation);
    }

    @Override
    public boolean checkIfEmailInUse(SimpleInvitation invitation) throws SQLException {
        if (this.systemInterface.getUserHandler().getUserByEmail(invitation.getEmail(), false, false) != null) {
            return true;
        }
        HighLevelQuery query = new HighLevelQuery(this.invitationEmailParamFactory.getParameter((Object)invitation.getEmail()), new Field[0]);
        SimpleInvitation match = (SimpleInvitation)((Object)this.invitationDAO.get(query));
        return match != null && !match.equals((Object)invitation);
    }

    @Override
    protected String getInvitationModuleClass() {
        return SimpleInvitationModule.class.getName();
    }

    @Override
    public void unload() throws Exception {
        if (this.registerInInstanceHandler && this.systemInterface.getInstanceHandler().getInstance(SimpleInvitationAdminModule.class) == this) {
            this.systemInterface.getInstanceHandler().removeInstance(SimpleInvitationAdminModule.class);
        }
        super.unload();
    }
}

