/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.invitation;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.emailutils.framework.Email;
import se.unlogic.emailutils.framework.InvalidEmailAddressException;
import se.unlogic.emailutils.framework.NoEmailSendersFoundException;
import se.unlogic.emailutils.framework.SimpleEmail;
import se.unlogic.emailutils.framework.UnableToProcessEmailException;
import se.unlogic.hierarchy.core.annotations.EnumDropDownSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.ModuleSetting;
import se.unlogic.hierarchy.core.annotations.TextFieldSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.WebPublic;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleResponse;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.enums.PathType;
import se.unlogic.hierarchy.core.exceptions.AccessDeniedException;
import se.unlogic.hierarchy.core.exceptions.ModuleConfigurationException;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleResponse;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.core.utils.CRUDCallback;
import se.unlogic.hierarchy.core.utils.IntegerBasedCRUD;
import se.unlogic.hierarchy.foregroundmodules.AnnotatedForegroundModule;
import se.unlogic.hierarchy.foregroundmodules.invitation.beans.BaseInvitation;
import se.unlogic.hierarchy.foregroundmodules.invitation.beans.BaseInvitationType;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.RequestUtils;
import se.unlogic.webutils.http.URIParser;

public abstract class BaseInvitationAdminModule<I extends BaseInvitation, IT extends BaseInvitationType>
extends AnnotatedForegroundModule
implements CRUDCallback<User> {
    public static final String RECIPIENT_FIRSTNAME = "$recipient-firstname";
    public static final String RECIPIENT_LASTNAME = "$recipient-lastname";
    public static final String RECIPIENT_EMAIL = "$recipient-email";
    public static final String INVITATION_LINK = "$invitation-link";
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Invitation module name", description="Name to be used for the automatically added invitation module", required=true)
    protected String invitationModuleName = "Invitations";
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Invitation module alias", description="Alias to be used for the automatically added invitation module", required=true)
    protected String invitationModuleAlias = "invitation";
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Invitation module XSL path", description="Path to XSL stylesheet used for the automatically added invitation module", required=true)
    protected String invitationModuleXSLPath = "InvitationModule.en.xsl";
    @ModuleSetting
    @EnumDropDownSettingDescriptor(name="Invitation module XSL path type", description="Path type of the XSL stylesheet used for the automatically added invitation module", required=true)
    protected PathType invitationModuleXSLPathType = PathType.Classpath;
    @ModuleSetting(allowsNull=true)
    @TextFieldSettingDescriptor(name="Editor CSS", description="Path to the desired CSS stylesheet for FCKEditor (relative from the contextpath)", required=false)
    protected String cssPath;
    protected SimpleForegroundModuleDescriptor invitationModuleDescriptor;

    @Override
    public void init(ForegroundModuleDescriptor moduleDescriptor, SectionInterface sectionInterface, DataSource dataSource) throws Exception {
        super.init(moduleDescriptor, sectionInterface, dataSource);
        this.checkInvitationModule();
    }

    @Override
    public void update(ForegroundModuleDescriptor moduleDescriptor, DataSource dataSource) throws Exception {
        super.update(moduleDescriptor, dataSource);
        this.checkInvitationModule();
    }

    @Override
    public void unload() throws Exception {
        if (this.invitationModuleDescriptor != null) {
            this.unloadInvitationModule();
        }
        super.unload();
    }

    protected synchronized void checkInvitationModule() {
        if (!this.isProperlyConfigured()) {
            if (this.invitationModuleDescriptor == null) {
                this.log.warn((Object)"Module not properly configured, refusing to create instance of invitation module");
            } else {
                this.log.warn((Object)"Module not properly configured, stopping current instance of invitation module");
                this.unloadInvitationModule();
            }
        } else if (this.invitationModuleDescriptor == null) {
            SimpleForegroundModuleDescriptor invitationModuleDescriptor = new SimpleForegroundModuleDescriptor();
            invitationModuleDescriptor.setSectionID(this.systemInterface.getRootSection().getSectionDescriptor().getSectionID());
            invitationModuleDescriptor.setClassname(this.getInvitationModuleClass());
            invitationModuleDescriptor.setAdminAccess(true);
            invitationModuleDescriptor.setUserAccess(true);
            invitationModuleDescriptor.setAnonymousAccess(true);
            invitationModuleDescriptor.setVisibleInMenu(false);
            invitationModuleDescriptor.setDataSourceID(((ForegroundModuleDescriptor)this.moduleDescriptor).getDataSourceID());
            invitationModuleDescriptor.setAlias(this.invitationModuleAlias);
            invitationModuleDescriptor.setName(this.invitationModuleName);
            invitationModuleDescriptor.setDescription(this.invitationModuleName);
            invitationModuleDescriptor.setXslPath(this.invitationModuleXSLPath);
            invitationModuleDescriptor.setXslPathType(this.invitationModuleXSLPathType);
            invitationModuleDescriptor.setMutableSettingHandler(((ForegroundModuleDescriptor)this.moduleDescriptor).getMutableSettingHandler());
            try {
                this.systemInterface.getRootSection().getForegroundModuleCache().cache(invitationModuleDescriptor);
                this.invitationModuleDescriptor = invitationModuleDescriptor;
            }
            catch (Exception e) {
                this.log.error((Object)"Error caching invitation module", (Throwable)e);
            }
        } else {
            this.log.info((Object)"Updating invitation module");
            this.invitationModuleDescriptor.setDataSourceID(((ForegroundModuleDescriptor)this.moduleDescriptor).getDataSourceID());
            this.invitationModuleDescriptor.setAlias(this.invitationModuleAlias);
            this.invitationModuleDescriptor.setName(this.invitationModuleName);
            this.invitationModuleDescriptor.setDescription(this.invitationModuleName);
            this.invitationModuleDescriptor.setXslPath(this.invitationModuleXSLPath);
            this.invitationModuleDescriptor.setXslPathType(this.invitationModuleXSLPathType);
            try {
                this.systemInterface.getRootSection().getForegroundModuleCache().update(this.invitationModuleDescriptor);
            }
            catch (Exception e) {
                this.log.error((Object)"Error updating invitation module", (Throwable)e);
            }
        }
    }

    private boolean isProperlyConfigured() {
        return !StringUtils.isEmpty((String)this.invitationModuleName) && !StringUtils.isEmpty((String)this.invitationModuleAlias) && !StringUtils.isEmpty((String)this.invitationModuleXSLPath) && this.invitationModuleXSLPathType != null;
    }

    protected void unloadInvitationModule() {
        try {
            if (this.systemInterface.getRootSection().getForegroundModuleCache().isCached(this.invitationModuleDescriptor)) {
                this.systemInterface.getRootSection().getForegroundModuleCache().unload(this.invitationModuleDescriptor);
            }
            this.invitationModuleDescriptor = null;
        }
        catch (Exception e) {
            this.log.error((Object)"Error unloading invitation module", (Throwable)e);
        }
    }

    @Override
    protected void createDAOs(DataSource dataSource) throws Exception {
        super.createDAOs(dataSource);
    }

    @Override
    public ForegroundModuleResponse processRequest(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Throwable {
        if (this.moduleDescriptor == null) {
            throw new ModuleConfigurationException("Module is not properly configured");
        }
        return super.processRequest(req, res, user, uriParser);
    }

    @Override
    public ForegroundModuleResponse defaultMethod(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception, Throwable {
        return this.list(req, res, user, uriParser, null);
    }

    public SimpleForegroundModuleResponse list(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser, List<ValidationError> validationErrors) throws SQLException {
        this.log.info((Object)("User " + user + " listing invitations and invitation types"));
        Document doc = this.createDocument(req, uriParser, user);
        Element invitationListElement = doc.createElement("InvitationList");
        doc.getFirstChild().appendChild(invitationListElement);
        XMLUtils.append((Document)doc, (Element)invitationListElement, (String)"InvitationTypes", this.getInvitationTypes());
        XMLUtils.append((Document)doc, (Element)invitationListElement, (String)"Invitations", this.getInvitations());
        if (validationErrors != null) {
            XMLUtils.append((Document)doc, (Element)invitationListElement, validationErrors);
        }
        return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb());
    }

    protected abstract String getInvitationModuleClass();

    public abstract List<IT> getInvitationTypes() throws SQLException;

    public abstract List<I> getInvitations() throws SQLException;

    @Override
    public Document createDocument(HttpServletRequest req, URIParser uriParser, User user) {
        Document doc = XMLUtils.createDomDocument();
        Element documentElement = doc.createElement("Document");
        documentElement.appendChild(RequestUtils.getRequestInfoAsXML((Document)doc, (HttpServletRequest)req, (URIParser)uriParser));
        documentElement.appendChild(this.sectionInterface.getSectionDescriptor().toXML(doc));
        documentElement.appendChild(((ForegroundModuleDescriptor)this.moduleDescriptor).toXML(doc));
        XMLUtils.appendNewElement((Document)doc, (Element)documentElement, (String)"cssPath", (String)this.cssPath);
        doc.appendChild(documentElement);
        return doc;
    }

    protected abstract IntegerBasedCRUD<IT, ?> getInvitationTypeCRUD();

    protected abstract IntegerBasedCRUD<I, ?> getInvitationCRUD();

    @WebPublic
    public ForegroundModuleResponse addInvitationType(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        return this.getInvitationTypeCRUD().add(req, res, user, uriParser);
    }

    @WebPublic
    public ForegroundModuleResponse updateInvitationType(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        return this.getInvitationTypeCRUD().update(req, res, user, uriParser);
    }

    @WebPublic
    public ForegroundModuleResponse deleteInvitationType(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        return this.getInvitationTypeCRUD().delete(req, res, user, uriParser);
    }

    @WebPublic
    public ForegroundModuleResponse addInvitation(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        return this.getInvitationCRUD().add(req, res, user, uriParser);
    }

    @WebPublic
    public ForegroundModuleResponse updateInvitation(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        return this.getInvitationCRUD().update(req, res, user, uriParser);
    }

    @WebPublic
    public ForegroundModuleResponse deleteInvitation(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        return this.getInvitationCRUD().delete(req, res, user, uriParser);
    }

    @Override
    public String getTitlePrefix() {
        return null;
    }

    @WebPublic
    public SimpleForegroundModuleResponse sendInvitation(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        BaseInvitation invitation = (BaseInvitation)((Object)this.getInvitationCRUD().getRequestedBean(req, res, user, uriParser, (String)null));
        if (invitation == null) {
            return this.list(req, res, user, uriParser, Collections.singletonList(new ValidationError("SendFailedInvitationNotFound")));
        }
        this.sendInvitation(invitation, user, req);
        this.redirectToDefaultMethod(req, res);
        return null;
    }

    @WebPublic(toLowerCase=true)
    public SimpleForegroundModuleResponse sendUnsentInvitations(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        List<I> invitations = this.getInvitations();
        if (invitations != null) {
            for (BaseInvitation invitation : invitations) {
                if (invitation.getLastSent() != null) continue;
                this.sendInvitation(invitation, user, req);
            }
        }
        this.redirectToDefaultMethod(req, res);
        return null;
    }

    @WebPublic(toLowerCase=true)
    public SimpleForegroundModuleResponse resendSentInvitations(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        List<I> invitations = this.getInvitations();
        if (invitations != null) {
            for (BaseInvitation invitation : invitations) {
                if (invitation.getLastSent() == null) continue;
                this.sendInvitation(invitation, user, req);
            }
        }
        this.redirectToDefaultMethod(req, res);
        return null;
    }

    public void sendInvitation(I invitation, User user, HttpServletRequest req) throws SQLException {
        try {
            this.log.info((Object)("User " + user + " sending invitation " + invitation));
            Object invitationType = ((BaseInvitation)((Object)invitation)).getInvitationType();
            SimpleEmail email = new SimpleEmail();
            email.setMessageContentType("text/html");
            email.setSenderName(((BaseInvitationType)((Object)invitationType)).getSenderName());
            email.setSenderAddress(((BaseInvitationType)((Object)invitationType)).getSenderEmail());
            email.addRecipient(((BaseInvitation)((Object)invitation)).getEmail());
            email.setSubject(((BaseInvitationType)((Object)invitationType)).getSubject());
            email.setMessage(this.getInvitationMessage(invitation, user, req));
            this.systemInterface.getEmailHandler().send((Email)email);
            ((BaseInvitation)((Object)invitation)).setLastSent(new Timestamp(System.currentTimeMillis()));
            ((BaseInvitation)((Object)invitation)).setSendCount(((BaseInvitation)((Object)invitation)).getSendCount() + 1);
            this.updateInvitation(invitation);
        }
        catch (NoEmailSendersFoundException e) {
            this.log.error((Object)("Unable to send invitation " + invitation + ", no email senders found!"), (Throwable)e);
        }
        catch (UnableToProcessEmailException e) {
            this.log.error((Object)("Unable to send invitation " + invitation + ", unable to process generated email!"), (Throwable)e);
        }
        catch (InvalidEmailAddressException e) {
            this.log.error((Object)("Unable to send invitation " + invitation + ", " + e.getAddress() + " is not a valid email address!"), (Throwable)e);
        }
    }

    protected abstract void updateInvitation(I var1) throws SQLException;

    protected String getInvitationMessage(I invitation, User user, HttpServletRequest req) {
        String message = ((BaseInvitationType)((Object)((BaseInvitation)((Object)invitation)).getInvitationType())).getMessage();
        message = message.replace(RECIPIENT_FIRSTNAME, ((BaseInvitation)((Object)invitation)).getFirstname());
        message = message.replace(RECIPIENT_LASTNAME, ((BaseInvitation)((Object)invitation)).getLastname());
        message = message.replace(RECIPIENT_EMAIL, ((BaseInvitation)((Object)invitation)).getEmail());
        message = message.replace(INVITATION_LINK, this.getInvitationURL(invitation, req));
        return message;
    }

    public String getInvitationURL(I invitation, HttpServletRequest req) {
        return RequestUtils.getFullContextPathURL((HttpServletRequest)req) + "/" + this.invitationModuleAlias + "/" + ((BaseInvitation)((Object)invitation)).getInvitationID() + "/" + ((BaseInvitation)((Object)invitation)).getLinkID().toString();
    }

    public abstract boolean checkIfEmailInUse(I var1) throws SQLException;

    public IT getInvitationType(Integer invitationTypeID) throws AccessDeniedException, SQLException {
        return (IT)((Object)((BaseInvitationType)((Object)this.getInvitationTypeCRUD().getBean(invitationTypeID))));
    }
}

