/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.invitation;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import se.unlogic.hierarchy.core.beans.MutableUser;
import se.unlogic.hierarchy.foregroundmodules.invitation.BaseInvitationModule;
import se.unlogic.hierarchy.foregroundmodules.invitation.beans.BaseInvitation;
import se.unlogic.hierarchy.foregroundmodules.invitation.beans.BaseInvitationType;
import se.unlogic.standardutils.dao.AnnotatedDAO;
import se.unlogic.standardutils.dao.HighLevelQuery;
import se.unlogic.standardutils.dao.QueryParameterFactory;
import se.unlogic.standardutils.populators.BeanStringPopulator;
import se.unlogic.standardutils.populators.StringPopulator;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.webutils.validation.ValidationUtils;

public abstract class AnnotatedInvitationModule<I extends BaseInvitation, IT extends BaseInvitationType, U extends MutableUser>
extends BaseInvitationModule<I, IT, U> {
    protected AnnotatedDAO<I> invitationDAO;
    protected QueryParameterFactory<I, Integer> invitationIDParamFactory;
    protected QueryParameterFactory<I, UUID> invitationLinkIDParamFactory;

    @Override
    protected void createDAOs(DataSource dataSource) throws Exception {
        this.invitationDAO = this.createDAO(dataSource);
        this.invitationIDParamFactory = this.invitationDAO.getParamFactory("invitationID", Integer.class);
        this.invitationLinkIDParamFactory = this.invitationDAO.getParamFactory("linkID", UUID.class);
    }

    protected abstract AnnotatedDAO<I> createDAO(DataSource var1);

    @Override
    protected U populateUser(HttpServletRequest req) throws ValidationException {
        ArrayList validationErrors = new ArrayList();
        String username = (String)ValidationUtils.validateParameter((String)"username", (HttpServletRequest)req, (boolean)true, (Integer)0, (Integer)40, (BeanStringPopulator)StringPopulator.getPopulator(), validationErrors);
        String password = (String)ValidationUtils.validateParameter((String)"password", (HttpServletRequest)req, (boolean)true, (Integer)0, (Integer)255, (BeanStringPopulator)StringPopulator.getPopulator(), validationErrors);
        if (!validationErrors.isEmpty()) {
            throw new ValidationException(validationErrors);
        }
        U user = this.createNewUserInstance();
        ((MutableUser)user).setUsername(username);
        ((MutableUser)user).setPassword(password);
        return user;
    }

    protected abstract U createNewUserInstance();

    @Override
    protected I getInvitation(Integer invitationID, UUID invitationLinkID) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addParameter(this.invitationIDParamFactory.getParameter((Object)invitationID));
        query.addParameter(this.invitationLinkIDParamFactory.getParameter((Object)invitationLinkID));
        return (I)((Object)((BaseInvitation)((Object)this.invitationDAO.get(query))));
    }

    @Override
    protected void deleteInvitation(I invitation) throws SQLException {
        this.invitationDAO.delete(invitation);
    }
}

