/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.imagegallery.populators;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import se.unlogic.fileuploadutils.BeanMultipartRequestPopulator;
import se.unlogic.fileuploadutils.MultipartRequest;
import se.unlogic.hierarchy.foregroundmodules.imagegallery.beans.Gallery;
import se.unlogic.standardutils.dao.BeanResultSetPopulator;
import se.unlogic.standardutils.io.FileUtils;
import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.validation.ValidationErrorType;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.webutils.http.BeanRequestPopulator;

public class GalleryPopulator
implements BeanResultSetPopulator<Gallery>,
BeanRequestPopulator<Gallery>,
BeanMultipartRequestPopulator<Gallery> {
    public Gallery populate(ResultSet rs) throws SQLException {
        Gallery gallery = new Gallery();
        gallery.setGalleryID(rs.getInt("galleryID"));
        gallery.setName(rs.getString("name"));
        gallery.setDescription(rs.getString("description"));
        gallery.setAlias(rs.getString("alias"));
        gallery.setUrl(rs.getString("url"));
        gallery.setAnonymousAccess(rs.getBoolean("anonymousAccess"));
        gallery.setUserAccess(rs.getBoolean("userAccess"));
        gallery.setAdminAccess(rs.getBoolean("adminAccess"));
        return gallery;
    }

    public Gallery populate(HttpServletRequest req) throws ValidationException {
        return this.populate(new Gallery(), req);
    }

    public Gallery populate(MultipartRequest req) throws ValidationException {
        return this.populate(new Gallery(), req);
    }

    public Gallery populate(Gallery bean, MultipartRequest req) throws ValidationException {
        if (bean == null) {
            return this.populate(new Gallery(), (HttpServletRequest)req);
        }
        return this.populate(bean, (HttpServletRequest)req);
    }

    public Gallery populate(Gallery gallery, HttpServletRequest req) throws ValidationException {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        String name = req.getParameter("name");
        String description = req.getParameter("description");
        String url = req.getParameter("url");
        String autoGenerateDirs = req.getParameter("autogeneratedirs");
        if (StringUtils.isEmpty((String)name)) {
            validationErrors.add(new ValidationError("name", ValidationErrorType.RequiredField));
        }
        if (StringUtils.isEmpty((String)description)) {
            validationErrors.add(new ValidationError("description", ValidationErrorType.RequiredField));
        }
        if (StringUtils.isEmpty((String)url)) {
            validationErrors.add(new ValidationError("url", ValidationErrorType.RequiredField));
        }
        if (!StringUtils.isEmpty((String)url)) {
            boolean autoGenerate = Boolean.parseBoolean(autoGenerateDirs);
            if (autoGenerate) {
                url = url + "/" + req.getParameter("name").toLowerCase().trim();
            }
            File dir = new File(url);
            int i = 0;
            while (autoGenerate && dir.exists()) {
                dir = new File(url + "(" + ++i + ")");
            }
            if (i > 0) {
                url = dir.getAbsolutePath();
            }
            if (!dir.canRead() && !dir.mkdir()) {
                validationErrors.add(new ValidationError("url", ValidationErrorType.Other));
            }
        }
        if (!validationErrors.isEmpty()) {
            throw new ValidationException(validationErrors);
        }
        String[] allowedUserIDs = req.getParameterValues("user");
        ArrayList userIDs = null;
        if (allowedUserIDs != null) {
            userIDs = NumberUtils.toInt((String[])allowedUserIDs);
        }
        gallery.setAllowedUserIDs(userIDs);
        String[] allowedGroupIDs = req.getParameterValues("group");
        ArrayList groupIDs = null;
        if (allowedGroupIDs != null) {
            groupIDs = NumberUtils.toInt((String[])allowedGroupIDs);
        }
        gallery.setAllowedGroupIDs(groupIDs);
        String[] allowedUploadUserIDs = req.getParameterValues("uploaduser");
        ArrayList uploadUserIDs = null;
        if (allowedUploadUserIDs != null) {
            uploadUserIDs = NumberUtils.toInt((String[])allowedUploadUserIDs);
        }
        gallery.setAllowedUploadUserIDs(uploadUserIDs);
        String[] allowedUploadGroupIDs = req.getParameterValues("uploadgroup");
        ArrayList uploadGroupIDs = null;
        if (allowedUploadGroupIDs != null) {
            uploadGroupIDs = NumberUtils.toInt((String[])allowedUploadGroupIDs);
        }
        gallery.setAllowedUploadGroupIDs(uploadGroupIDs);
        gallery.setName(name);
        gallery.setDescription(description);
        gallery.setAlias(FileUtils.toValidHttpFilename((String)name));
        gallery.setUrl(url);
        gallery.setAnonymousAccess(req.getParameter("anonymousAccess") != null);
        gallery.setUserAccess(req.getParameter("userAccess") != null);
        gallery.setAdminAccess(req.getParameter("adminAccess") != null);
        return gallery;
    }
}

