/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.imagegallery.daos;

import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import se.unlogic.hierarchy.core.daos.BaseDAO;
import se.unlogic.hierarchy.foregroundmodules.imagegallery.beans.Gallery;
import se.unlogic.hierarchy.foregroundmodules.imagegallery.beans.Picture;
import se.unlogic.hierarchy.foregroundmodules.imagegallery.populators.PicturePopulator;
import se.unlogic.standardutils.dao.BeanResultSetPopulator;
import se.unlogic.standardutils.dao.TransactionHandler;
import se.unlogic.standardutils.dao.querys.ArrayListQuery;
import se.unlogic.standardutils.dao.querys.ObjectQuery;
import se.unlogic.standardutils.dao.querys.UpdateQuery;
import se.unlogic.standardutils.populators.IntegerPopulator;

public class PictureDao
extends BaseDAO {
    private static PicturePopulator Populator = new PicturePopulator();

    public PictureDao(DataSource ds) {
        super(ds);
    }

    public ArrayList<Picture> findByGalleryID(Integer galleryID, boolean smallThumbs, boolean mediumThumbs) throws SQLException {
        ArrayListQuery query = null;
        query = smallThumbs && mediumThumbs ? new ArrayListQuery(this.dataSource.getConnection(), true, "SELECT * FROM pictures WHERE galleryID = ? ORDER BY name", (BeanResultSetPopulator)Populator) : (smallThumbs && !mediumThumbs ? new ArrayListQuery(this.dataSource.getConnection(), true, "SELECT pictureID, filename, smallThumb, galleryID FROM pictures WHERE galleryID = ? ORDER BY name", (BeanResultSetPopulator)Populator) : (mediumThumbs && !smallThumbs ? new ArrayListQuery(this.dataSource.getConnection(), true, "SELECT pictureID, filename, mediumThumb, galleryID FROM pictures WHERE galleryID = ? ORDER BY name", (BeanResultSetPopulator)Populator) : new ArrayListQuery(this.dataSource.getConnection(), true, "SELECT pictureID, filename, galleryID FROM pictures WHERE galleryID = ? ORDER BY name", (BeanResultSetPopulator)Populator)));
        query.setInt(1, galleryID.intValue());
        return query.executeQuery();
    }

    public Picture get(Integer pictureID, boolean smallThumb, boolean mediumThumb) throws SQLException {
        String queryString = null;
        queryString = smallThumb && mediumThumb ? "SELECT * FROM pictures WHERE pictureID = ?" : (smallThumb && !mediumThumb ? "SELECT pictureID, filename, smallThumb, galleryID FROM pictures WHERE pictureID = ?" : (mediumThumb && !smallThumb ? "SELECT pictureID, filename, mediumThumb, galleryID FROM pictures WHERE pictureID = ?" : "SELECT pictureID, filename, galleryID FROM pictures WHERE pictureID = ?"));
        ObjectQuery query = new ObjectQuery(this.dataSource.getConnection(), true, queryString, (BeanResultSetPopulator)Populator);
        query.setInt(1, pictureID.intValue());
        return (Picture)query.executeQuery();
    }

    public Integer getPictureIDByFilenameAndGallery(String filename, Gallery gallery) throws SQLException {
        String queryString = "SELECT pictureID FROM pictures WHERE filename = ? AND galleryID = ?";
        ObjectQuery query = new ObjectQuery(this.dataSource.getConnection(), true, queryString, (BeanResultSetPopulator)IntegerPopulator.getPopulator());
        query.setString(1, filename);
        query.setInt(2, gallery.getGalleryID().intValue());
        return (Integer)query.executeQuery();
    }

    public Picture getByFilename(String filename, Integer galleryID, boolean smallThumb, boolean mediumThumb) throws SQLException {
        String queryString = null;
        queryString = smallThumb && mediumThumb ? "SELECT * FROM pictures WHERE filename = ? AND galleryID = ?" : (smallThumb && !mediumThumb ? "SELECT pictureID, filename, smallThumb, galleryID FROM pictures WHERE filename = ? AND galleryID = ?" : (mediumThumb && !smallThumb ? "SELECT pictureID, filename, mediumThumb, galleryID FROM pictures WHERE filename = ? AND galleryID = ?" : "SELECT pictureID, filename, galleryID FROM pictures WHERE filename = ? AND galleryID = ?"));
        ObjectQuery query = new ObjectQuery(this.dataSource.getConnection(), true, queryString, (BeanResultSetPopulator)Populator);
        query.setString(1, filename);
        query.setInt(2, galleryID.intValue());
        return (Picture)query.executeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Picture picture) throws SQLException {
        TransactionHandler transactionHandler = new TransactionHandler(this.dataSource);
        try {
            ObjectQuery pictureQuery = transactionHandler.getObjectQuery("SELECT pictureID from pictures WHERE galleryID = ? AND filename = ?", (BeanResultSetPopulator)IntegerPopulator.getPopulator());
            pictureQuery.setInt(1, picture.getGalleryID().intValue());
            pictureQuery.setString(2, picture.getFilename());
            Integer pictureID = (Integer)pictureQuery.executeQuery();
            if (pictureID != null) {
                UpdateQuery updateQuery = transactionHandler.getUpdateQuery("UPDATE pictures SET smallThumb = ?, mediumThumb = ? WHERE pictureID = ?");
                updateQuery.setBlob(1, picture.getSmallThumb());
                updateQuery.setBlob(2, picture.getMediumThumb());
                updateQuery.setInt(3, pictureID.intValue());
                updateQuery.executeUpdate();
            } else {
                UpdateQuery insertQuery = transactionHandler.getUpdateQuery("INSERT INTO pictures VALUES (null,?,?,?,?)");
                insertQuery.setString(1, picture.getFilename());
                insertQuery.setBlob(2, picture.getSmallThumb());
                insertQuery.setBlob(3, picture.getMediumThumb());
                insertQuery.setInt(4, picture.getGalleryID().intValue());
                insertQuery.executeUpdate();
            }
            transactionHandler.commit();
        }
        finally {
            if (transactionHandler != null && !transactionHandler.isClosed()) {
                transactionHandler.abort();
            }
        }
    }

    public void delete(Picture picture) throws SQLException {
        UpdateQuery query = new UpdateQuery(this.dataSource.getConnection(), true, "DELETE FROM pictures WHERE pictureID = ?");
        query.setInt(1, picture.getPictureID().intValue());
        query.executeUpdate();
    }

    public void clear() throws SQLException {
        new UpdateQuery(this.dataSource.getConnection(), true, "DELETE FROM pictures").executeUpdate();
    }
}

