/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.imagegallery;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import javax.sql.rowset.serial.SerialBlob;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.unlogic.fileuploadutils.MultipartRequest;
import se.unlogic.hierarchy.core.annotations.ModuleSetting;
import se.unlogic.hierarchy.core.annotations.TextFieldSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.WebPublic;
import se.unlogic.hierarchy.core.beans.Breadcrumb;
import se.unlogic.hierarchy.core.beans.Group;
import se.unlogic.hierarchy.core.beans.SettingDescriptor;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleResponse;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.beans.ValueDescriptor;
import se.unlogic.hierarchy.core.enums.URLType;
import se.unlogic.hierarchy.core.exceptions.AccessDeniedException;
import se.unlogic.hierarchy.core.exceptions.URINotFoundException;
import se.unlogic.hierarchy.core.interfaces.AccessInterface;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.MutableSettingHandler;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.core.utils.AccessUtils;
import se.unlogic.hierarchy.foregroundmodules.AnnotatedForegroundModule;
import se.unlogic.hierarchy.foregroundmodules.imagegallery.GalleryUploadAccessWrapper;
import se.unlogic.hierarchy.foregroundmodules.imagegallery.SimpleFileFilter;
import se.unlogic.hierarchy.foregroundmodules.imagegallery.beans.Comment;
import se.unlogic.hierarchy.foregroundmodules.imagegallery.beans.Gallery;
import se.unlogic.hierarchy.foregroundmodules.imagegallery.beans.Picture;
import se.unlogic.hierarchy.foregroundmodules.imagegallery.daos.CommentDao;
import se.unlogic.hierarchy.foregroundmodules.imagegallery.daos.GalleryDao;
import se.unlogic.hierarchy.foregroundmodules.imagegallery.daos.PictureDao;
import se.unlogic.hierarchy.foregroundmodules.imagegallery.populators.GalleryPopulator;
import se.unlogic.standardutils.dao.querys.UpdateQuery;
import se.unlogic.standardutils.datatypes.SimpleEntry;
import se.unlogic.standardutils.db.DBUtils;
import se.unlogic.standardutils.image.ImageUtils;
import se.unlogic.standardutils.io.FileUtils;
import se.unlogic.standardutils.mime.MimeUtils;
import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.streams.StreamUtils;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.threads.MutexKey;
import se.unlogic.standardutils.threads.MutexKeyProvider;
import se.unlogic.standardutils.time.TimeUtils;
import se.unlogic.standardutils.validation.PositiveStringIntegerValidator;
import se.unlogic.standardutils.validation.StringFormatValidator;
import se.unlogic.standardutils.validation.StringIntegerValidator;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.validation.ValidationErrorType;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.standardutils.zip.ZipUtils;
import se.unlogic.webutils.http.HTTPUtils;
import se.unlogic.webutils.http.RequestUtils;
import se.unlogic.webutils.http.URIParser;

public class GalleryModule
extends AnnotatedForegroundModule
implements AccessInterface {
    private static final ArrayList<SettingDescriptor> SETTINGDESCRIPTORS = new ArrayList();
    private static final GalleryPopulator GalleryPopulator;
    protected static final SimpleFileFilter fileFilter;
    protected GalleryDao galleryDao;
    protected PictureDao pictureDao;
    protected CommentDao commentDao;
    @ModuleSetting(allowsNull=true)
    @TextFieldSettingDescriptor(name="Base path", description="Path to directory in which gallery directories will automatically created.\r\nIf base path is omitted, auto creation of gallery directories is disabled.\r\nAuto created directories will never use (merge with) existing direcories.", required=false)
    protected String path;
    @ModuleSetting
    protected Integer numOfThumbsPerPage = 15;
    @ModuleSetting
    protected Integer smallImageMaxHeight = 93;
    @ModuleSetting
    protected Integer smallImageMaxWidth = 125;
    @ModuleSetting
    protected Integer mediumImageMaxHeight = 500;
    @ModuleSetting
    protected Integer mediumImageMaxWidth = 500;
    @ModuleSetting
    protected Boolean allowAnonymousComments = false;
    @ModuleSetting
    protected Integer diskThreshold = 100;
    @ModuleSetting
    @TextFieldSettingDescriptor(name="RAM threshold", description="Maximum size of files in KB to be buffered in RAM during file uploads. Files exceeding the threshold are written to disk instead.", required=true, formatValidator=PositiveStringIntegerValidator.class)
    protected Integer ramThreshold = 500;
    @ModuleSetting(allowsNull=true)
    protected List<Integer> adminGroupIDs;
    @ModuleSetting(allowsNull=true)
    protected List<Integer> adminUserIDs;
    protected Integer thumbQuality = 4;
    protected MutexKeyProvider<Gallery> mutexKeyProvider = new MutexKeyProvider();

    @Override
    public void init(ForegroundModuleDescriptor moduleDescriptor, SectionInterface sectionInterface, DataSource dataSource) throws Exception {
        super.init(moduleDescriptor, sectionInterface, dataSource);
        System.setProperty("java.awt.headless", "true");
        this.checkTables(dataSource);
        this.galleryDao = new GalleryDao(dataSource);
        this.pictureDao = new PictureDao(dataSource);
        this.commentDao = new CommentDao(dataSource, sectionInterface.getSystemInterface().getUserHandler());
        this.checkSettings(moduleDescriptor.getMutableSettingHandler());
    }

    @Override
    public void update(ForegroundModuleDescriptor moduleDescriptor, DataSource dataSource) throws Exception {
        super.update(moduleDescriptor, dataSource);
        this.checkTables(dataSource);
        this.galleryDao = new GalleryDao(dataSource);
        this.pictureDao = new PictureDao(dataSource);
        this.commentDao = new CommentDao(dataSource, this.sectionInterface.getSystemInterface().getUserHandler());
        this.checkSettings(moduleDescriptor.getMutableSettingHandler());
    }

    private void checkTables(DataSource dataSource) throws SQLException, IOException {
        String sql;
        this.log.debug((Object)("Checking for gallery tables in datasource " + dataSource + "..."));
        if (!DBUtils.tableExists((DataSource)this.dataSource, (String)"galleries")) {
            this.log.info((Object)(this.moduleDescriptor + " creating galleries table in datasource " + dataSource));
            sql = StringUtils.readStreamAsString((InputStream)this.getClass().getResourceAsStream("daos/dbscripts/GalleryTable.sql"));
            new UpdateQuery(this.dataSource.getConnection(), true, sql).executeUpdate();
        }
        if (!DBUtils.tableExists((DataSource)this.dataSource, (String)"gallerygroups")) {
            this.log.info((Object)(this.moduleDescriptor + " creating gallerygroups table in datasource " + dataSource));
            sql = StringUtils.readStreamAsString((InputStream)this.getClass().getResourceAsStream("daos/dbscripts/GalleryGroupsTable.sql"));
            new UpdateQuery(this.dataSource.getConnection(), true, sql).executeUpdate();
        }
        if (!DBUtils.tableExists((DataSource)this.dataSource, (String)"galleryusers")) {
            this.log.info((Object)(this.moduleDescriptor + " creating galleryusers table in datasource " + dataSource));
            sql = StringUtils.readStreamAsString((InputStream)this.getClass().getResourceAsStream("daos/dbscripts/GalleryUsersTable.sql"));
            new UpdateQuery(this.dataSource.getConnection(), true, sql).executeUpdate();
        }
        if (!DBUtils.tableExists((DataSource)this.dataSource, (String)"galleryuploadgroups")) {
            this.log.info((Object)(this.moduleDescriptor + " creating galleryuploadgroups table in datasource " + dataSource));
            sql = StringUtils.readStreamAsString((InputStream)this.getClass().getResourceAsStream("daos/dbscripts/GalleryUploadGroupsTable.sql"));
            new UpdateQuery(this.dataSource.getConnection(), true, sql).executeUpdate();
        }
        if (!DBUtils.tableExists((DataSource)this.dataSource, (String)"galleryuploadusers")) {
            this.log.info((Object)(this.moduleDescriptor + " creating galleryuploadusers table in datasource " + dataSource));
            sql = StringUtils.readStreamAsString((InputStream)this.getClass().getResourceAsStream("daos/dbscripts/GalleryUploadUsersTable.sql"));
            new UpdateQuery(this.dataSource.getConnection(), true, sql).executeUpdate();
        }
        if (!DBUtils.tableExists((DataSource)this.dataSource, (String)"pictures")) {
            this.log.info((Object)(this.moduleDescriptor + " creating pictures table in datasource " + dataSource));
            sql = StringUtils.readStreamAsString((InputStream)this.getClass().getResourceAsStream("daos/dbscripts/PicturesTable.sql"));
            new UpdateQuery(this.dataSource.getConnection(), true, sql).executeUpdate();
        }
        if (!DBUtils.tableExists((DataSource)this.dataSource, (String)"picturecomments")) {
            this.log.info((Object)(this.moduleDescriptor + " creating picturecomments table in datasource " + dataSource));
            sql = StringUtils.readStreamAsString((InputStream)this.getClass().getResourceAsStream("daos/dbscripts/PictureCommentsTable.sql"));
            new UpdateQuery(this.dataSource.getConnection(), true, sql).executeUpdate();
        }
    }

    private void checkSettings(MutableSettingHandler mutableSettingHandler) {
        Integer thumbQuality = mutableSettingHandler.getInt("thumbQuality");
        if (thumbQuality != null && (thumbQuality == 16 || thumbQuality == 2 || thumbQuality == 8 || thumbQuality == 4)) {
            this.thumbQuality = thumbQuality;
        } else if (thumbQuality != null) {
            this.log.warn((Object)("Illegal thumbQuality setting value detected, " + thumbQuality + " in module " + this.moduleDescriptor));
        }
    }

    @Override
    public SimpleForegroundModuleResponse defaultMethod(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        this.log.info((Object)("User " + user + " listing galleries"));
        ArrayList<Gallery> galleryList = this.galleryDao.getAll();
        Document doc = this.createDocument(req, uriParser, user);
        Element galleriesElement = doc.createElement("galleries");
        doc.getFirstChild().appendChild(galleriesElement);
        if (galleryList != null) {
            for (Gallery gallery : galleryList) {
                if (!this.checkBooleanAccess(user, gallery)) continue;
                Node galleryNode = gallery.toXML(doc);
                SimpleEntry<String, String> pictureEntry = this.getRandomImage(gallery);
                if (pictureEntry != null) {
                    galleryNode.appendChild(XMLUtils.createElement((String)"randomFile", (Object)pictureEntry.getKey(), (Document)doc));
                    galleryNode.appendChild(XMLUtils.createElement((String)"numPics", (Object)pictureEntry.getValue(), (Document)doc));
                } else {
                    galleryNode.appendChild(XMLUtils.createElement((String)"numPics", (Object)"0", (Document)doc));
                }
                galleriesElement.appendChild(galleryNode);
            }
        }
        return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb());
    }

    protected SimpleEntry<String, String> getRandomImage(Gallery gallery) {
        SimpleEntry pictureEntry = null;
        File dir = new File(gallery.getUrl());
        boolean read = dir.canRead();
        if (!read) {
            return null;
        }
        File[] files = dir.listFiles(fileFilter);
        if (files.length == 0) {
            return null;
        }
        Random rand = new Random();
        int idx = rand.nextInt(files.length);
        pictureEntry = new SimpleEntry((Object)files[idx].getName(), (Object)String.valueOf(files.length));
        return pictureEntry;
    }

    protected Document createDocument(HttpServletRequest req, URIParser uriParser, User user) {
        Document doc = XMLUtils.createDomDocument();
        Element document = doc.createElement("document");
        document.appendChild(RequestUtils.getRequestInfoAsXML((Document)doc, (HttpServletRequest)req, (URIParser)uriParser));
        document.appendChild(((ForegroundModuleDescriptor)this.moduleDescriptor).toXML(doc));
        document.appendChild(this.sectionInterface.getSectionDescriptor().toXML(doc));
        document.appendChild(XMLUtils.createElement((String)"isAdmin", (Object)this.checkBooleanAdminAccess(user).toString(), (Document)doc));
        doc.appendChild(document);
        return doc;
    }

    @WebPublic
    public SimpleForegroundModuleResponse gallery(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws IOException, SQLException, URINotFoundException, AccessDeniedException {
        return this.showGallery(req, res, user, uriParser);
    }

    @WebPublic
    public SimpleForegroundModuleResponse showGallery(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws IOException, SQLException, URINotFoundException, AccessDeniedException {
        int pagesInGallery;
        Gallery gallery = null;
        if (uriParser.size() < 3 || uriParser.size() > 4 || (gallery = this.galleryDao.get(uriParser.get(2).toString())) == null) {
            throw new URINotFoundException(uriParser);
        }
        this.checkAccess(user, gallery);
        Integer page = 1;
        if (uriParser.size() == 4 && ((page = NumberUtils.toInt((String)uriParser.get(3))) == null || page <= 0)) {
            throw new URINotFoundException(uriParser);
        }
        this.log.info((Object)("User " + user + " requested page " + page + " in gallery " + gallery));
        File dir = new File(gallery.getUrl());
        if (!dir.canRead()) {
            throw new URINotFoundException(uriParser);
        }
        Object[] allFiles = dir.listFiles(fileFilter);
        int num = allFiles.length;
        int n = pagesInGallery = num % this.numOfThumbsPerPage == 0 ? num / this.numOfThumbsPerPage : num / this.numOfThumbsPerPage + 1;
        if (num == 0) {
            Document doc = this.createDocument(req, uriParser, user);
            Element galleryElement = doc.createElement("showGallery");
            doc.getFirstChild().appendChild(galleryElement);
            Node gNode = gallery.toXML(doc);
            gNode.appendChild(XMLUtils.createElement((String)"pages", (Object)"1", (Document)doc));
            gNode.appendChild(XMLUtils.createElement((String)"currentPage", (Object)"1", (Document)doc));
            gNode.appendChild(XMLUtils.createElement((String)"numPics", (Object)"0", (Document)doc));
            galleryElement.appendChild(XMLUtils.createElement((String)"hasUploadAccess", (Object)this.checkBooleanUploadAccess(user, gallery).toString(), (Document)doc));
            galleryElement.appendChild(gNode);
            return new SimpleForegroundModuleResponse(doc, gallery.getName(), this.getDefaultBreadcrumb(), this.getGalleryBreadcrumb(gallery, req));
        }
        if (page <= pagesInGallery) {
            Arrays.sort(allFiles);
            Integer nextPage = page == pagesInGallery ? null : Integer.valueOf(page + 1);
            Integer prevPage = page == 1 ? null : Integer.valueOf(page - 1);
            int startIndex = this.numOfThumbsPerPage * page - this.numOfThumbsPerPage;
            int endIndex = startIndex + this.numOfThumbsPerPage;
            if (page == pagesInGallery) {
                endIndex = allFiles.length;
            }
            Document doc = this.createDocument(req, uriParser, user);
            Element galleryElement = doc.createElement("showGallery");
            doc.getFirstChild().appendChild(galleryElement);
            galleryElement.appendChild(XMLUtils.createElement((String)"hasUploadAccess", (Object)this.checkBooleanUploadAccess(user, gallery).toString(), (Document)doc));
            Element filesElement = doc.createElement("files");
            Node gNode = gallery.toXML(doc);
            gNode.appendChild(XMLUtils.createElement((String)"pages", (Object)String.valueOf(pagesInGallery), (Document)doc));
            gNode.appendChild(XMLUtils.createElement((String)"currentPage", (Object)String.valueOf(page), (Document)doc));
            gNode.appendChild(XMLUtils.createElement((String)"numPics", (Object)String.valueOf(num), (Document)doc));
            if (nextPage != null) {
                gNode.appendChild(XMLUtils.createElement((String)"nextPage", (Object)nextPage.toString(), (Document)doc));
            }
            if (prevPage != null) {
                gNode.appendChild(XMLUtils.createElement((String)"prevPage", (Object)prevPage.toString(), (Document)doc));
            }
            for (int i = startIndex; i < endIndex; ++i) {
                Element fileElement = doc.createElement("file");
                String filename = ((File)allFiles[i]).getName();
                fileElement.appendChild(XMLUtils.createElement((String)"filename", (Object)filename, (Document)doc));
                Element commentsElement = doc.createElement("comments");
                ArrayList<Comment> comments = this.commentDao.getByFilenameAndGallery(filename, gallery);
                if (comments != null) {
                    for (Comment comment : comments) {
                        commentsElement.appendChild(comment.toXML(doc));
                    }
                    fileElement.appendChild(commentsElement);
                }
                filesElement.appendChild(fileElement);
            }
            gNode.appendChild(filesElement);
            galleryElement.appendChild(gNode);
            return new SimpleForegroundModuleResponse(doc, gallery.getName(), this.getDefaultBreadcrumb(), this.getGalleryBreadcrumb(gallery, req));
        }
        throw new URINotFoundException(uriParser);
    }

    private Breadcrumb getGalleryBreadcrumb(Gallery gallery, HttpServletRequest req) {
        return new Breadcrumb(gallery.getName(), gallery.getDescription(), this.getFullAlias() + "/showGallery/" + gallery.getAlias(), URLType.RELATIVE_FROM_CONTEXTPATH);
    }

    @WebPublic
    public SimpleForegroundModuleResponse image(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws IOException, SQLException, URINotFoundException, AccessDeniedException {
        return this.showImage(req, res, user, uriParser);
    }

    @WebPublic
    public SimpleForegroundModuleResponse showImage(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws IOException, SQLException, URINotFoundException, AccessDeniedException {
        Gallery gallery = null;
        if (uriParser.size() != 4 || (gallery = this.galleryDao.get(uriParser.get(2).toString())) == null) {
            throw new URINotFoundException(uriParser);
        }
        this.checkAccess(user, gallery);
        File dir = null;
        try {
            dir = new File(gallery.getUrl());
        }
        catch (Exception ex) {
            throw new URINotFoundException(uriParser);
        }
        String filename = uriParser.get(3);
        Object[] allFiles = dir.listFiles(fileFilter);
        Arrays.sort(allFiles);
        boolean found = false;
        int currentIdx = -1;
        for (int i = 0; i < allFiles.length; ++i) {
            if (!((File)allFiles[i]).getName().equals(filename)) continue;
            found = true;
            currentIdx = i;
            break;
        }
        int picsInGallery = allFiles.length;
        if (found) {
            Boolean showAll;
            this.log.info((Object)("User " + user + " requested image " + filename + " in gallery " + gallery));
            HttpSession session = req.getSession(true);
            String nextPicture = currentIdx < picsInGallery - 1 ? ((File)allFiles[currentIdx + 1]).getName() : null;
            String prevPicture = currentIdx > 0 ? ((File)allFiles[currentIdx - 1]).getName() : null;
            Document doc = this.createDocument(req, uriParser, user);
            Element pictureElement = doc.createElement("showImage");
            doc.getFirstChild().appendChild(pictureElement);
            Node gNode = gallery.toXML(doc);
            gNode.appendChild(XMLUtils.createElement((String)"numPics", (Object)String.valueOf(picsInGallery), (Document)doc));
            gNode.appendChild(XMLUtils.createElement((String)"currentPic", (Object)String.valueOf(currentIdx + 1), (Document)doc));
            if (currentIdx == 0) {
                ++currentIdx;
            }
            pictureElement.appendChild(XMLUtils.createElement((String)"currentPage", (Object)(currentIdx / this.numOfThumbsPerPage + 1 + ""), (Document)doc));
            if (nextPicture != null) {
                gNode.appendChild(XMLUtils.createElement((String)"nextImage", (Object)nextPicture.toString(), (Document)doc));
            }
            if (prevPicture != null) {
                gNode.appendChild(XMLUtils.createElement((String)"prevImage", (Object)prevPicture.toString(), (Document)doc));
            }
            Element fileElement = doc.createElement("file");
            fileElement.appendChild(XMLUtils.createElement((String)"filename", (Object)filename, (Document)doc));
            Element commentsElement = doc.createElement("comments");
            ArrayList<Comment> comments = this.commentDao.getByFilenameAndGallery(filename, gallery);
            if (req.getMethod().equalsIgnoreCase("POST")) {
                String commentText;
                String commentStatus = req.getParameter("viewComments");
                if (commentStatus != null) {
                    if (commentStatus.equals("true")) {
                        session.setAttribute(((ForegroundModuleDescriptor)this.moduleDescriptor).getModuleID() + ".showAll", (Object)true);
                    } else {
                        session.setAttribute(((ForegroundModuleDescriptor)this.moduleDescriptor).getModuleID() + ".showAll", (Object)false);
                    }
                }
                if ((commentText = req.getParameter("commentText")) != null && (this.allowAnonymousComments.booleanValue() || user != null)) {
                    try {
                        if (StringUtils.isEmpty((String)commentText)) {
                            throw new ValidationException(new ValidationError[]{new ValidationError("commentText", ValidationErrorType.RequiredField)});
                        }
                        Comment comment = new Comment();
                        comment.setComment(commentText);
                        comment.setDate(new Timestamp(System.currentTimeMillis()));
                        comment.setPictureID(this.pictureDao.getPictureIDByFilenameAndGallery(filename, gallery));
                        if (user != null) {
                            comment.setUser(user);
                        }
                        this.log.info((Object)("User " + user + " adding comment " + comment + " to image " + filename + " in gallery " + gallery));
                        this.commentDao.add(comment);
                        res.sendRedirect(req.getRequestURI());
                    }
                    catch (ValidationException e) {
                        fileElement.appendChild(e.toXML(doc));
                    }
                }
            }
            if ((showAll = (Boolean)session.getAttribute(((ForegroundModuleDescriptor)this.moduleDescriptor).getModuleID() + ".showAll")) == null || showAll.booleanValue()) {
                commentsElement.appendChild(XMLUtils.createElement((String)"showAll", (Object)"true", (Document)doc));
                if (comments != null) {
                    for (Comment comment : comments) {
                        commentsElement.appendChild(comment.toXML(doc));
                    }
                }
            }
            if (comments != null) {
                commentsElement.appendChild(XMLUtils.createElement((String)"commentsNum", (Object)String.valueOf(comments.size()), (Document)doc));
            }
            fileElement.appendChild(commentsElement);
            if (this.allowAnonymousComments.booleanValue() || user != null) {
                fileElement.appendChild(doc.createElement("commentsAllowed"));
            }
            gNode.appendChild(fileElement);
            pictureElement.appendChild(gNode);
            return new SimpleForegroundModuleResponse(doc, filename, this.getDefaultBreadcrumb(), this.getGalleryBreadcrumb(gallery, req), this.getImageBreadcrumb(gallery, filename, req));
        }
        throw new URINotFoundException(uriParser);
    }

    private Breadcrumb getImageBreadcrumb(Gallery gallery, String filename, HttpServletRequest req) {
        return new Breadcrumb(filename, filename, this.getFullAlias() + "/showImage/" + gallery.getAlias() + "/" + filename, URLType.RELATIVE_FROM_CONTEXTPATH);
    }

    @WebPublic
    public SimpleForegroundModuleResponse smallThumb(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws IOException, SQLException, URINotFoundException, AccessDeniedException {
        Gallery gallery = null;
        if (uriParser.size() != 4 || (gallery = this.galleryDao.get(uriParser.get(2))) == null) {
            throw new URINotFoundException(uriParser);
        }
        this.checkAccess(user, gallery);
        String filename = uriParser.get(3).toString();
        if (FileUtils.isReadable((String)(gallery.getUrl() + File.separator + filename)) && SimpleFileFilter.isValidFilename(filename)) {
            this.log.debug((Object)("User " + user + " requesting small thumb of image " + filename + " in gallery " + gallery));
            Picture picture = this.pictureDao.getByFilename(filename, gallery.getGalleryID(), true, false);
            if (picture == null) {
                picture = this.createThumbs(filename, gallery);
            }
            try {
                GalleryModule.writePicture(picture, false, res);
            }
            catch (Exception e) {
                this.log.info((Object)("Caught exception " + e + " while sending picture " + picture + " in gallery " + gallery + " to " + user));
            }
        } else {
            this.log.info((Object)("The picture " + filename + " does not exist in gallery " + gallery));
            throw new URINotFoundException(uriParser);
        }
        return null;
    }

    @WebPublic
    public SimpleForegroundModuleResponse mediumThumb(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws IOException, SQLException, URINotFoundException, AccessDeniedException {
        Gallery gallery = null;
        if (uriParser.size() != 4 || (gallery = this.galleryDao.get(uriParser.get(2))) == null) {
            throw new URINotFoundException(uriParser);
        }
        this.checkAccess(user, gallery);
        String filename = uriParser.get(3).toString();
        if (FileUtils.isReadable((String)(gallery.getUrl() + File.separator + filename)) && SimpleFileFilter.isValidFilename(filename)) {
            this.log.debug((Object)("User " + user + " requesting medium thumb of image " + filename + " in gallery " + gallery));
            Picture picture = this.pictureDao.getByFilename(filename, gallery.getGalleryID(), false, true);
            if (picture == null) {
                picture = this.createThumbs(filename, gallery);
            }
            try {
                GalleryModule.writePicture(picture, true, res);
            }
            catch (Exception e) {
                this.log.info((Object)("Caught exception " + e + " while sending picture " + picture + " in gallery " + gallery + " to " + user));
            }
        } else {
            this.log.info((Object)("The picture " + filename + " does not exist in gallery " + gallery));
            throw new URINotFoundException(uriParser);
        }
        return null;
    }

    protected Picture createThumbs(String filename, Gallery gallery) throws SQLException, IOException {
        this.log.info((Object)("Creating thumbs for picture " + filename + " in gallery " + gallery));
        Picture picture = new Picture();
        BufferedImage image = ImageUtils.getImage((String)(gallery.getUrl() + File.separator + filename));
        BufferedImage smallImage = ImageUtils.scaleImage((BufferedImage)image, (int)this.smallImageMaxHeight, (int)this.smallImageMaxWidth, (int)this.thumbQuality, (int)1);
        BufferedImage mediumImage = ImageUtils.scaleImage((BufferedImage)image, (int)this.mediumImageMaxHeight, (int)this.mediumImageMaxWidth, (int)this.thumbQuality, (int)1);
        ByteArrayOutputStream smallThumbStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)smallImage, "jpg", smallThumbStream);
        byte[] smallThumbByteArray = smallThumbStream.toByteArray();
        ByteArrayOutputStream mediumThumbStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)mediumImage, "jpg", mediumThumbStream);
        byte[] mediumThumbByteArray = mediumThumbStream.toByteArray();
        picture.setSmallThumb(new SerialBlob(smallThumbByteArray));
        picture.setMediumThumb(new SerialBlob(mediumThumbByteArray));
        picture.setFilename(filename);
        picture.setGalleryID(gallery.getGalleryID());
        this.pictureDao.set(picture);
        return picture;
    }

    protected void checkAccess(User user, Gallery gallery) throws AccessDeniedException {
        if (!AccessUtils.checkAccess(user, gallery) && !AccessUtils.checkAccess(user, this)) {
            throw new AccessDeniedException("Permission to gallery " + gallery + " denied");
        }
    }

    protected void checkAdminAccess(User user) throws AccessDeniedException {
        if (!AccessUtils.checkAccess(user, this)) {
            throw new AccessDeniedException("Gallery admin access denied");
        }
    }

    private void checkUploadAccess(User user, Gallery gallery) throws AccessDeniedException {
        if (!AccessUtils.checkAccess(user, this) && !AccessUtils.checkAccess(user, new GalleryUploadAccessWrapper(gallery))) {
            throw new AccessDeniedException("Gallery upload access denied in gallery " + gallery);
        }
    }

    protected boolean checkBooleanAccess(User user, Gallery gallery) {
        return AccessUtils.checkAccess(user, gallery) || this.checkBooleanAdminAccess(user) != false;
    }

    protected Boolean checkBooleanAdminAccess(User user) {
        return AccessUtils.checkAccess(user, this);
    }

    private Boolean checkBooleanUploadAccess(User user, Gallery gallery) {
        return AccessUtils.checkAccess(user, new GalleryUploadAccessWrapper(gallery));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePicture(Picture picture, boolean mediumThumb, HttpServletResponse res) throws SQLException, IOException {
        Blob blob = null;
        blob = mediumThumb ? picture.getMediumThumb() : picture.getSmallThumb();
        HTTPUtils.setContentLength((long)blob.length(), (HttpServletResponse)res);
        res.setContentType("image/jpeg");
        res.setHeader("Content-Disposition", "inline; filename=\"" + FileUtils.toValidHttpFilename((String)picture.getFilename()) + "\"");
        InputStream in = null;
        ServletOutputStream out = null;
        try {
            in = blob.getBinaryStream();
            out = res.getOutputStream();
            StreamUtils.transfer((InputStream)in, (OutputStream)out);
        }
        finally {
            StreamUtils.closeStream((InputStream)in);
            StreamUtils.closeStream((OutputStream)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @WebPublic
    public SimpleForegroundModuleResponse getImage(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws SQLException, URINotFoundException, AccessDeniedException {
        block9: {
            String filename;
            Gallery gallery;
            block8: {
                gallery = null;
                if (uriParser.size() != 4 || (gallery = this.galleryDao.get(uriParser.get(2))) == null) {
                    throw new URINotFoundException(uriParser);
                }
                this.checkAccess(user, gallery);
                filename = uriParser.get(3).toString();
                if (!FileUtils.isReadable((String)(gallery.getUrl() + File.separator + filename)) || !SimpleFileFilter.isValidFilename(filename)) break block8;
                FileInputStream in = null;
                ServletOutputStream out = null;
                try {
                    this.log.debug((Object)("User " + user + " requesting image " + filename + " in gallery " + gallery));
                    File file = new File(gallery.getUrl() + File.separator + filename);
                    in = new FileInputStream(file);
                    HTTPUtils.setContentLength((long)file.length(), (HttpServletResponse)res);
                    res.setContentType(MimeUtils.getMimeType((File)file));
                    res.setHeader("Content-Disposition", "inline; filename=\"" + FileUtils.toValidHttpFilename((String)filename) + "\"");
                    out = res.getOutputStream();
                    StreamUtils.transfer((InputStream)in, (OutputStream)out);
                    StreamUtils.closeStream((InputStream)in);
                }
                catch (RuntimeException e) {
                    this.log.debug((Object)("Caught exception " + e + " while sending picture " + filename + " in gallery " + gallery + " to " + user));
                }
                catch (IOException e2) {
                    this.log.debug((Object)("Caught exception " + e2 + " while sending picture " + filename + " in gallery " + gallery + " to " + user));
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    StreamUtils.closeStream(in);
                    StreamUtils.closeStream(out);
                }
                StreamUtils.closeStream((OutputStream)out);
                break block9;
            }
            this.log.info((Object)("The picture " + filename + " in gallery " + gallery + " requested by user " + user + " does not exist"));
            throw new URINotFoundException(uriParser);
        }
        return null;
    }

    @Override
    public List<SettingDescriptor> getSettings() {
        ArrayList<SettingDescriptor> combinedSettings = new ArrayList<SettingDescriptor>();
        List<SettingDescriptor> superSettings = super.getSettings();
        if (superSettings != null) {
            combinedSettings.addAll(superSettings);
        }
        combinedSettings.addAll(SETTINGDESCRIPTORS);
        ArrayList<ValueDescriptor> groupValueDescriptors = new ArrayList<ValueDescriptor>();
        for (Group group : this.sectionInterface.getSystemInterface().getGroupHandler().getGroups(false)) {
            groupValueDescriptors.add(new ValueDescriptor(group.getName(), group.getGroupID().toString()));
        }
        combinedSettings.add(SettingDescriptor.createMultiListSetting("adminGroupIDs", "Admin groups", "Groups that are allowed to administrate the gallery module", false, null, groupValueDescriptors));
        ArrayList<ValueDescriptor> userValueDescriptors = new ArrayList<ValueDescriptor>();
        for (User user : this.sectionInterface.getSystemInterface().getUserHandler().getUsers(false, false)) {
            userValueDescriptors.add(new ValueDescriptor(user.getFirstname() + " " + user.getLastname(), user.getUserID().toString()));
        }
        combinedSettings.add(SettingDescriptor.createMultiListSetting("adminUserIDs", "Admin users", "Users that are allowed to administrate the gallery module", false, null, userValueDescriptors));
        return combinedSettings;
    }

    @WebPublic
    public SimpleForegroundModuleResponse deleteGallery(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws IOException, SQLException, URINotFoundException, AccessDeniedException {
        this.checkAdminAccess(user);
        Gallery gallery = null;
        if (uriParser.size() < 3 || (gallery = this.galleryDao.get(uriParser.get(2))) == null) {
            throw new URINotFoundException(uriParser);
        }
        this.log.info((Object)("User " + user + " deleting gallery " + gallery));
        this.galleryDao.delete(gallery);
        this.redirectToDefaultMethod(req, res);
        return null;
    }

    @WebPublic
    public SimpleForegroundModuleResponse regenerateGalleryThubms(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws IOException, SQLException, URINotFoundException, AccessDeniedException {
        this.checkAdminAccess(user);
        Gallery gallery = null;
        if (uriParser.size() < 3 || (gallery = this.galleryDao.get(uriParser.get(2))) == null) {
            throw new URINotFoundException(uriParser);
        }
        Long currentTime = System.currentTimeMillis();
        this.log.info((Object)("User " + user + " regenerating thumbs for gallery " + gallery + "..."));
        this.createGalleryThumbs(gallery, true);
        this.log.info((Object)("User " + user + " regenerated thumbs for gallery " + gallery + " in " + TimeUtils.millisecondsToString((long)(System.currentTimeMillis() - currentTime))));
        this.redirectToDefaultMethod(req, res);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebPublic(alias="download")
    public SimpleForegroundModuleResponse downloadGallery(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws SQLException, URINotFoundException {
        Gallery gallery = null;
        if (uriParser.size() < 3 || (gallery = this.galleryDao.get(uriParser.get(2))) == null) {
            throw new URINotFoundException(uriParser);
        }
        File dir = new File(gallery.getUrl());
        if (!dir.canRead()) {
            throw new URINotFoundException(uriParser);
        }
        this.log.info((Object)("User " + user + " downloading gallery " + gallery + "..."));
        long startTime = System.currentTimeMillis();
        File[] files = dir.listFiles(fileFilter);
        ZipOutputStream zipOutputStream = null;
        try {
            res.setContentType("application/zip");
            res.setHeader("Content-Disposition", "inline; filename=\"" + FileUtils.toValidHttpFilename((String)gallery.getName()) + ".zip\"");
            res.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, proxy-revalidate");
            zipOutputStream = new ZipOutputStream((OutputStream)res.getOutputStream());
            zipOutputStream.setLevel(0);
            ZipUtils.addFiles((File[])files, (ZipOutputStream)zipOutputStream);
            zipOutputStream.flush();
            this.log.info((Object)("Sent gallery " + gallery + " containing " + files.length + " files to user " + user + " in " + TimeUtils.millisecondsToString((long)(System.currentTimeMillis() - startTime))));
            StreamUtils.closeStream((OutputStream)zipOutputStream);
        }
        catch (IOException e) {
            this.log.info((Object)("Error sending gallery " + gallery + " to user " + user));
        }
        finally {
            StreamUtils.closeStream(zipOutputStream);
        }
        return null;
    }

    @WebPublic
    public synchronized SimpleForegroundModuleResponse regenerateThumbs(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        this.checkAdminAccess(user);
        Long currentTime = System.currentTimeMillis();
        this.log.info((Object)("User " + user + " regenerating thumbs for all galleries..."));
        ArrayList<Gallery> galleries = this.galleryDao.getAll();
        for (Gallery gallery : galleries) {
            this.createGalleryThumbs(gallery, true);
        }
        this.log.info((Object)("User " + user + " regenerated thumbs for all galleries in " + TimeUtils.millisecondsToString((long)(System.currentTimeMillis() - currentTime))));
        this.redirectToDefaultMethod(req, res);
        return null;
    }

    @WebPublic
    public SimpleForegroundModuleResponse updateComment(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws IOException, SQLException, URINotFoundException, AccessDeniedException {
        this.checkAdminAccess(user);
        Comment comment = null;
        if (uriParser.size() < 3 || (comment = this.commentDao.get(Integer.parseInt(uriParser.get(2)))) == null) {
            throw new URINotFoundException(uriParser);
        }
        String commentText = req.getParameter("comment");
        if (!StringUtils.isEmpty((String)commentText)) {
            this.log.info((Object)("User " + user + " updating comment " + comment + " new text " + commentText));
            comment.setComment(commentText);
            this.commentDao.update(comment);
        }
        Picture picture = this.pictureDao.get(comment.getPictureID(), false, false);
        Gallery gallery = this.galleryDao.get(picture.getGalleryID());
        res.sendRedirect(this.getModuleURI(req) + "/showImage/" + URLEncoder.encode(gallery.getAlias(), "UTF-8") + "/" + URLEncoder.encode(picture.getFilename(), "UTF-8"));
        return null;
    }

    @WebPublic
    public SimpleForegroundModuleResponse deleteComment(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws IOException, SQLException, URINotFoundException, AccessDeniedException {
        this.checkAdminAccess(user);
        Comment comment = null;
        if (uriParser.size() < 3 || (comment = this.commentDao.get(Integer.parseInt(uriParser.get(2)))) == null) {
            throw new URINotFoundException(uriParser);
        }
        this.log.info((Object)("User " + user + " deleting comment " + comment));
        Picture picture = this.pictureDao.get(comment.getPictureID(), false, false);
        Gallery gallery = this.galleryDao.get(picture.getGalleryID());
        this.commentDao.delete(comment);
        res.sendRedirect(this.getModuleURI(req) + "/showImage/" + URLEncoder.encode(gallery.getAlias(), "UTF-8") + "/" + URLEncoder.encode(picture.getFilename(), "UTF-8"));
        return null;
    }

    @WebPublic
    public SimpleForegroundModuleResponse deleteImage(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws IOException, SQLException, URINotFoundException, ValidationException, AccessDeniedException {
        this.checkAdminAccess(user);
        Gallery gallery = null;
        if (req.getMethod().equalsIgnoreCase("POST")) {
            if (uriParser.size() < 3 || (gallery = this.galleryDao.get(uriParser.get(2))) == null) {
                throw new URINotFoundException(uriParser);
            }
            String[] filenames = req.getParameterValues("delete");
            if (filenames != null) {
                ArrayList<File> filesToDelete = new ArrayList<File>();
                for (String filename : filenames) {
                    File f = new File(gallery.getUrl() + "/" + filename);
                    if (!f.exists() || !f.canWrite() || f.isDirectory()) {
                        throw new URINotFoundException(uriParser);
                    }
                    filesToDelete.add(f);
                }
                for (File f : filesToDelete) {
                    this.log.info((Object)("User " + user + " deleting image " + f));
                    boolean success = f.delete();
                    Picture picture = this.pictureDao.getByFilename(f.getName(), gallery.getGalleryID(), false, false);
                    this.pictureDao.delete(picture);
                    if (success) continue;
                    throw new ValidationException(new ValidationError[]{new ValidationError("UnableToParseRequest")});
                }
            }
            res.sendRedirect(this.getModuleURI(req) + "/showGallery/" + URLEncoder.encode(gallery.getAlias(), "UTF-8"));
        } else {
            if (uriParser.size() < 4 || (gallery = this.galleryDao.get(uriParser.get(2))) == null) {
                throw new URINotFoundException(uriParser);
            }
            String filename = uriParser.get(3);
            File f = new File(gallery.getUrl() + "/" + filename);
            if (!f.exists() || !f.canWrite() || f.isDirectory()) {
                throw new URINotFoundException(uriParser);
            }
            this.log.info((Object)("User " + user + " deleting image " + f));
            boolean success = f.delete();
            Picture picture = this.pictureDao.getByFilename(filename, gallery.getGalleryID(), false, false);
            this.pictureDao.delete(picture);
            if (!success) {
                throw new ValidationException(new ValidationError[]{new ValidationError("UnableToParseRequest")});
            }
            res.sendRedirect(this.getModuleURI(req) + "/showGallery/" + URLEncoder.encode(gallery.getAlias(), "UTF-8"));
        }
        return null;
    }

    @WebPublic
    public SimpleForegroundModuleResponse addGallery(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        this.checkAdminAccess(user);
        ValidationException validationException = null;
        MultipartRequest requestWrapper = null;
        if (req.getMethod().equalsIgnoreCase("POST")) {
            try {
                requestWrapper = new MultipartRequest(this.ramThreshold * 1024, (long)(this.diskThreshold * 0x100000), req);
                Gallery gallery = GalleryPopulator.populate(requestWrapper);
                this.log.info((Object)("User " + user + " adding gallery " + gallery));
                gallery.setGalleryID(this.galleryDao.add(gallery));
                Boolean zipUpload = requestWrapper.getParameter("uploadCheck") != null;
                if (zipUpload.booleanValue()) {
                    try {
                        FileItem fileItem = requestWrapper.getFile(0);
                        this.uploadGalleryZip(fileItem, gallery);
                    }
                    catch (FileUploadException e) {
                        this.galleryDao.delete(gallery);
                        throw new ValidationException(new ValidationError[]{new ValidationError("UnableToParseRequest")});
                    }
                    catch (IOException e) {
                        this.galleryDao.delete(gallery);
                        throw new ValidationException(new ValidationError[]{new ValidationError("UnableToParseRequest")});
                    }
                    finally {
                        if (requestWrapper != null) {
                            requestWrapper.deleteFiles();
                        }
                    }
                }
                this.createGalleryThumbs(gallery, false);
                res.sendRedirect(this.getModuleURI(req));
                return null;
            }
            catch (ValidationException e) {
                validationException = e;
            }
        }
        Document doc = this.createDocument(req, uriParser, user);
        Element addGalleryElement = doc.createElement("addGallery");
        doc.getFirstChild().appendChild(addGalleryElement);
        if (!StringUtils.isEmpty((String)this.path)) {
            addGalleryElement.appendChild(XMLUtils.createElement((String)"path", (Object)this.path, (Document)doc));
        }
        if (validationException != null) {
            addGalleryElement.appendChild(validationException.toXML(doc));
            addGalleryElement.appendChild(RequestUtils.getRequestParameters((HttpServletRequest)requestWrapper, (Document)doc));
        }
        AccessUtils.appendGroupsAndUsers(doc, addGalleryElement, this.sectionInterface.getSystemInterface().getUserHandler(), this.sectionInterface.getSystemInterface().getGroupHandler());
        return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebPublic
    public SimpleForegroundModuleResponse addImages(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        Gallery gallery = null;
        if (uriParser.size() < 3 || (gallery = this.galleryDao.get(uriParser.get(2))) == null) {
            throw new URINotFoundException(uriParser);
        }
        this.checkUploadAccess(user, gallery);
        ValidationException validationException = null;
        if (req.getMethod().equalsIgnoreCase("POST")) {
            MultipartRequest requestWrapper = null;
            try {
                requestWrapper = new MultipartRequest(this.ramThreshold * 1024, (long)(this.diskThreshold * 0x100000), req);
                FileItem fileItem = requestWrapper.getFile(0);
                if (fileItem.getName() != null && fileItem.getName().toLowerCase().endsWith(".zip")) {
                    this.log.info((Object)("User " + user + " adding images from zip file to gallery " + gallery));
                    int imageCount = this.uploadGalleryZip(fileItem, gallery);
                    this.log.info((Object)("User " + user + " added " + imageCount + " images to gallery " + gallery));
                } else if (fileFilter.accept(fileItem)) {
                    this.log.info((Object)("User " + user + " adding image to gallery " + gallery));
                    File file = new File(gallery.getUrl() + "/" + fileItem.getName());
                    fileItem.write(file);
                    this.log.info((Object)("User " + user + " added 1 image to gallery " + gallery));
                } else {
                    throw new ValidationException(new ValidationError[]{new ValidationError("UnableToParseRequest")});
                }
                this.createGalleryThumbs(gallery, false);
                res.sendRedirect(this.getModuleURI(req));
                SimpleForegroundModuleResponse simpleForegroundModuleResponse = null;
                return simpleForegroundModuleResponse;
            }
            catch (ValidationException e) {
                validationException = e;
            }
            catch (FileUploadBase.FileSizeLimitExceededException e) {
                validationException = new ValidationException(new ValidationError[]{new ValidationError("FileSizeLimitExceeded")});
            }
            catch (FileUploadException e) {
                validationException = new ValidationException(new ValidationError[]{new ValidationError("UnableToParseRequest")});
            }
            finally {
                if (requestWrapper != null) {
                    requestWrapper.deleteFiles();
                }
            }
        }
        Document doc = this.createDocument(req, uriParser, user);
        Element addImageElement = doc.createElement("addImages");
        doc.getFirstChild().appendChild(addImageElement);
        addImageElement.appendChild(gallery.toXML(doc));
        XMLUtils.appendNewElement((Document)doc, (Element)addImageElement, (String)"diskThreshold", (Object)this.diskThreshold);
        if (validationException != null) {
            addImageElement.appendChild(validationException.toXML(doc));
            addImageElement.appendChild(RequestUtils.getRequestParameters((HttpServletRequest)req, (Document)doc));
        }
        AccessUtils.appendGroupsAndUsers(doc, addImageElement, this.sectionInterface.getSystemInterface().getUserHandler(), this.sectionInterface.getSystemInterface().getGroupHandler());
        return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb());
    }

    @WebPublic
    public SimpleForegroundModuleResponse updateGallery(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws IOException, SQLException, URINotFoundException, AccessDeniedException {
        this.checkAdminAccess(user);
        Gallery gallery = null;
        if (uriParser.size() != 3 || (gallery = this.galleryDao.get(uriParser.get(2))) == null) {
            throw new URINotFoundException(uriParser);
        }
        ValidationException validationException = null;
        if (req.getMethod().equalsIgnoreCase("POST")) {
            try {
                gallery = GalleryPopulator.populate(gallery, req);
                this.log.info((Object)("User " + user + " updating gallery " + gallery));
                this.galleryDao.update(gallery);
                res.sendRedirect(this.getModuleURI(req));
                return null;
            }
            catch (ValidationException e) {
                validationException = e;
            }
        }
        Document doc = this.createDocument(req, uriParser, user);
        Element updateGalleryElement = doc.createElement("updateGallery");
        doc.getFirstChild().appendChild(updateGalleryElement);
        if (!StringUtils.isEmpty((String)this.path)) {
            updateGalleryElement.appendChild(XMLUtils.createElement((String)"path", (Object)this.path, (Document)doc));
        }
        updateGalleryElement.appendChild(gallery.toXML(doc));
        if (validationException != null) {
            updateGalleryElement.appendChild(validationException.toXML(doc));
            updateGalleryElement.appendChild(RequestUtils.getRequestParameters((HttpServletRequest)req, (Document)doc));
        }
        AccessUtils.appendGroupsAndUsers(doc, updateGalleryElement, this.sectionInterface.getSystemInterface().getUserHandler(), this.sectionInterface.getSystemInterface().getGroupHandler());
        return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb());
    }

    @WebPublic
    public synchronized SimpleForegroundModuleResponse checkForNewImages(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        this.checkAdminAccess(user);
        this.log.info((Object)("User " + user + " checking for new images in all galleries"));
        ArrayList<Gallery> galleries = this.galleryDao.getAll();
        for (Gallery gallery : galleries) {
            this.createGalleryThumbs(gallery, false);
        }
        this.redirectToDefaultMethod(req, res);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int uploadGalleryZip(FileItem fileItem, Gallery gallery) throws FileNotFoundException, IOException, Exception {
        File file = null;
        int fileCount = 0;
        try {
            file = File.createTempFile("galleryupload-" + System.currentTimeMillis(), ".zip");
            fileItem.write(file);
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                if (ze.isDirectory() || !SimpleFileFilter.isValidFilename(ze.getName())) continue;
                String filename = FilenameUtils.getName((String)ze.getName());
                if (new File(gallery.getUrl() + "/" + filename).exists()) {
                    this.log.info((Object)("Skipping file " + filename + ", already exists in gallery " + gallery + " in directory " + gallery.getUrl()));
                    continue;
                }
                this.log.info((Object)("Adding file " + filename + " to gallery " + gallery + " in directory " + gallery.getUrl()));
                FileOutputStream fileOutputStream = null;
                InputStream zipEntryInputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(gallery.getUrl() + "/" + filename);
                    zipEntryInputStream = zipFile.getInputStream(ze);
                    StreamUtils.transfer((InputStream)zipEntryInputStream, (OutputStream)fileOutputStream);
                    ++fileCount;
                }
                catch (Throwable throwable) {
                    StreamUtils.closeStream(zipEntryInputStream);
                    StreamUtils.closeStream(fileOutputStream);
                    throw throwable;
                    return fileCount;
                }
                StreamUtils.closeStream((InputStream)zipEntryInputStream);
                StreamUtils.closeStream((OutputStream)fileOutputStream);
            }
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createGalleryThumbs(Gallery gallery, boolean overwrite) throws URINotFoundException, SQLException, IOException {
        MutexKey mutexKey = this.mutexKeyProvider.getKey((Object)gallery);
        synchronized (mutexKey) {
            File dir = new File(gallery.getUrl());
            if (!dir.canRead()) {
                return;
            }
            File[] allFiles = dir.listFiles(fileFilter);
            if (allFiles != null) {
                for (File file : allFiles) {
                    if (file.exists() && file.canRead()) {
                        if (overwrite) {
                            this.createThumbs(file.getName(), gallery);
                            continue;
                        }
                        Picture picture = this.pictureDao.getByFilename(file.getName(), gallery.getGalleryID(), false, false);
                        if (picture != null) continue;
                        try {
                            this.createThumbs(file.getName(), gallery);
                        }
                        catch (RuntimeException e) {
                            this.log.error((Object)("Error " + e + " creating thumb for file " + file.getName() + " in gallery " + gallery));
                        }
                        continue;
                    }
                    this.log.warn((Object)("Unable to read file " + file + " in gallery " + gallery));
                }
            }
        }
    }

    @Override
    public boolean allowsAdminAccess() {
        return false;
    }

    @Override
    public boolean allowsAnonymousAccess() {
        return false;
    }

    @Override
    public boolean allowsUserAccess() {
        return false;
    }

    @Override
    public Collection<Integer> getAllowedGroupIDs() {
        return this.adminGroupIDs;
    }

    @Override
    public Collection<Integer> getAllowedUserIDs() {
        return this.adminUserIDs;
    }

    static {
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("numOfThumbsPerPage", "Thumbnails per page", "The number of thumbnails per page (default is 15)", false, "15", (StringFormatValidator)new StringIntegerValidator(Integer.valueOf(1), null)));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("smallImageMaxHeight", "Small image max height ", "The max height of the small thumbnails (default is 93)", false, "93", (StringFormatValidator)new StringIntegerValidator(Integer.valueOf(1), null)));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("smallImageMaxWidth", "Small image max width ", "The max width of the small thumbnails (default is 125)", false, "125", (StringFormatValidator)new StringIntegerValidator(Integer.valueOf(1), null)));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("mediumImageMaxHeight", "Medium image max height ", "The max height of the medium thumbnails (default is 500)", false, "500", (StringFormatValidator)new StringIntegerValidator(Integer.valueOf(1), null)));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("mediumImageMaxWidth", "Medium image max width ", "The max width of the medium thumbnails (default is 500)", false, "500", (StringFormatValidator)new StringIntegerValidator(Integer.valueOf(1), null)));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createCheckboxSetting("allowAnonymousComments", "Allow anonymous comments", "Control wheter or not logged in user can post comments", false));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("diskThreshold", "Max upload size", "Maxmium upload size in megabytes allowed in a single post request", false, "100", (StringFormatValidator)new StringIntegerValidator(Integer.valueOf(1), null)));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createDropDownSetting("thumbQuality", "Thumbnail quality", "Selects which algorithm that should be used when generating thumbnails", true, "4", new ValueDescriptor("SCALE_SMOOTH", "4"), new ValueDescriptor("SCALE_AREA_AVERAGING", "16"), new ValueDescriptor("SCALE_FAST", "2"), new ValueDescriptor("SCALE_REPLICATE", "8")));
        GalleryPopulator = new GalleryPopulator();
        fileFilter = new SimpleFileFilter();
    }
}

