/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.groupproviders.dao;

import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import se.unlogic.hierarchy.core.beans.Group;
import se.unlogic.standardutils.dao.AnnotatedDAO;
import se.unlogic.standardutils.dao.AnnotatedDAOFactory;
import se.unlogic.standardutils.dao.BeanResultSetPopulator;
import se.unlogic.standardutils.dao.HighLevelQuery;
import se.unlogic.standardutils.dao.LowLevelQuery;
import se.unlogic.standardutils.dao.MySQLRowLimiter;
import se.unlogic.standardutils.dao.QueryOperators;
import se.unlogic.standardutils.dao.QueryParameterFactory;
import se.unlogic.standardutils.dao.RelationQuery;
import se.unlogic.standardutils.dao.RowLimiter;
import se.unlogic.standardutils.dao.querys.ArrayListQuery;
import se.unlogic.standardutils.dao.querys.ObjectQuery;
import se.unlogic.standardutils.enums.Order;
import se.unlogic.standardutils.populators.CharacterPopulator;
import se.unlogic.standardutils.populators.IntegerPopulator;

public class AnnotatedGroupDAO<GroupType extends Group>
extends AnnotatedDAO<GroupType> {
    private final QueryParameterFactory<GroupType, Integer> groupIDParamFactory = this.getParamFactory("groupID", Integer.class);
    private final QueryParameterFactory<GroupType, String> nameParamFactory = this.getParamFactory("name", String.class);
    private final Field attributesRelation;
    private final String groupAttributesTableName;

    public AnnotatedGroupDAO(DataSource dataSource, Class<GroupType> beanClass, AnnotatedDAOFactory daoFactory, Field attributesRelation, String groupAttributesTableName) {
        super(dataSource, beanClass, daoFactory);
        this.attributesRelation = attributesRelation;
        this.groupAttributesTableName = groupAttributesTableName;
    }

    public GroupType getGroup(int groupID, boolean attributes) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addParameter(this.groupIDParamFactory.getParameter((Object)groupID));
        this.setQueryRelations((RelationQuery)query, attributes);
        return (GroupType)((Group)this.get(query));
    }

    public List<GroupType> getGroups(boolean attributes) throws SQLException {
        if (attributes) {
            HighLevelQuery query = new HighLevelQuery();
            this.setQueryRelations((RelationQuery)query, attributes);
            return this.getAll(query);
        }
        return this.getAll();
    }

    public List<GroupType> searchGroups(String queryTerm, boolean attributes, Integer maxHits) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addParameter(this.nameParamFactory.getParameter((Object)("%" + queryTerm + "%"), QueryOperators.LIKE));
        this.setQueryRelations((RelationQuery)query, attributes);
        if (maxHits != null) {
            query.setRowLimiter(this.getRowLimiter(maxHits));
        }
        return this.getAll(query);
    }

    protected RowLimiter getRowLimiter(Integer maxHits) {
        return new MySQLRowLimiter(maxHits.intValue());
    }

    public List<GroupType> searchGroups(String queryTerm, boolean attributes, String attributeName, Integer maxHits) throws SQLException {
        if (this.groupAttributesTableName == null) {
            return null;
        }
        LowLevelQuery query = new LowLevelQuery();
        query.setSql("SELECT " + this.getTableName() + ".* FROM " + this.getTableName() + " INNER JOIN " + this.groupAttributesTableName + " ON (" + this.getTableName() + ".groupID=" + this.groupAttributesTableName + ".groupID) WHERE " + this.getTableName() + ".name LIKE ? AND " + this.groupAttributesTableName + ".name = ? ORDER BY name");
        if (maxHits != null) {
            query.setSql(query.getSql() + " LIMIT " + maxHits);
        }
        query.addParameter((Object)("%" + queryTerm + "%"));
        query.addParameter((Object)attributeName);
        this.setQueryRelations((RelationQuery)query, attributes);
        return this.getAll(query);
    }

    public List<GroupType> getGroups(Collection<Integer> groupIDList, boolean attributes) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addParameter(this.groupIDParamFactory.getWhereInParameter(groupIDList));
        this.setQueryRelations((RelationQuery)query, attributes);
        return this.getAll(query);
    }

    public List<GroupType> getGroupsByAttribute(String attributeName, String attributeValue, boolean attributes) throws SQLException {
        if (this.groupAttributesTableName == null) {
            return null;
        }
        return this.getAll(this.getGroupByAttributeQuery(attributeName, attributeValue, "=", attributes));
    }

    public GroupType getGroupByAttribute(String attributeName, String attributeValue, boolean attributes) throws SQLException {
        if (this.groupAttributesTableName == null) {
            return null;
        }
        return (GroupType)((Group)this.get(this.getGroupByAttributeQuery(attributeName, attributeValue, "=", attributes)));
    }

    public GroupType getGroupByAttributes(List<Map.Entry<String, String>> attributeEntries, boolean attributes) throws SQLException {
        if (this.groupAttributesTableName == null) {
            return null;
        }
        return (GroupType)((Group)this.get(this.getGroupByAttributeQuery(attributeEntries, "=", attributes)));
    }

    public Integer getGroupCount() throws SQLException {
        return (Integer)new ObjectQuery(this.dataSource, "SELECT COUNT(groupID) FROM " + this.getTableName(), (BeanResultSetPopulator)IntegerPopulator.getPopulator()).executeQuery();
    }

    public Integer getDisabledGroupCount() throws SQLException {
        return (Integer)new ObjectQuery(this.dataSource, "SELECT COUNT(groupID) FROM " + this.getTableName() + " WHERE enabled = false", (BeanResultSetPopulator)IntegerPopulator.getPopulator()).executeQuery();
    }

    public List<GroupType> getGroups(Order order, char startsWith, boolean attributes) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addParameter(this.nameParamFactory.getParameter((Object)(startsWith + "%"), QueryOperators.LIKE));
        query.addOrderByCriteria(this.getOrderByCriteria("name", order));
        this.setQueryRelations((RelationQuery)query, attributes);
        return this.getAll(query);
    }

    public List<Character> getGroupFirstLetterIndex() throws SQLException {
        return new ArrayListQuery(this.dataSource, "SELECT DISTINCT UPPER(LEFT(name, 1)) as letter FROM " + this.getTableName() + " ORDER BY letter ", (BeanResultSetPopulator)CharacterPopulator.getPopulator()).executeQuery();
    }

    private void setQueryRelations(RelationQuery query, boolean attributes) {
        if (attributes && this.attributesRelation != null) {
            query.addRelation(this.attributesRelation);
        }
    }

    public void add(GroupType group) throws SQLException {
        RelationQuery query = new RelationQuery();
        this.setQueryRelations(query, true);
        this.add(group, query);
    }

    public void update(GroupType group, boolean updateAttributes) throws SQLException {
        RelationQuery query = new RelationQuery();
        this.setQueryRelations(query, updateAttributes);
        this.update(group, query);
    }

    protected LowLevelQuery<GroupType> getGroupByAttributeQuery(String attributeName, String attributeValue, String valueOperator, boolean attributes) {
        LowLevelQuery query = new LowLevelQuery();
        query.setSql("SELECT " + this.getTableName() + ".* FROM " + this.getTableName() + " INNER JOIN " + this.groupAttributesTableName + " ON (" + this.getTableName() + ".groupID=" + this.groupAttributesTableName + ".groupID) WHERE " + this.groupAttributesTableName + ".name = ? AND " + this.groupAttributesTableName + ".value " + valueOperator + " ?");
        query.addParameter((Object)attributeName);
        query.addParameter((Object)attributeValue);
        this.setQueryRelations((RelationQuery)query, attributes);
        return query;
    }

    protected LowLevelQuery<GroupType> getGroupByAttributeQuery(List<Map.Entry<String, String>> attributeEntries, String valueOperator, boolean attributes) {
        LowLevelQuery query = new LowLevelQuery();
        StringBuilder sql = new StringBuilder("SELECT " + this.getTableName() + ".* FROM " + this.getTableName() + " ");
        for (int i = 0; i < attributeEntries.size(); ++i) {
            sql.append("INNER JOIN " + this.groupAttributesTableName + " a" + i + " ON (" + this.getTableName() + ".groupID = a" + i + ".groupID) ");
        }
        sql.append("WHERE ");
        int index = 0;
        for (Map.Entry<String, String> attributeEntry : attributeEntries) {
            sql.append("(a" + index + ".name = '" + attributeEntry.getKey() + "' AND a" + index + ".value " + valueOperator + " '" + attributeEntry.getValue() + "')");
            if (index < attributeEntries.size() - 1) {
                sql.append(" AND ");
            }
            ++index;
        }
        query.setSql(sql.toString());
        this.setQueryRelations((RelationQuery)query, attributes);
        return query;
    }

    public List<GroupType> getGroupsByAttribute(String attributeName, boolean attributes) throws SQLException {
        if (this.groupAttributesTableName == null) {
            return null;
        }
        LowLevelQuery query = new LowLevelQuery();
        query.setSql("SELECT " + this.getTableName() + ".* FROM " + this.getTableName() + " INNER JOIN " + this.groupAttributesTableName + " ON (" + this.getTableName() + ".groupID=" + this.groupAttributesTableName + ".groupID) WHERE " + this.groupAttributesTableName + ".name = ? ORDER BY name");
        query.addParameter((Object)attributeName);
        this.setQueryRelations((RelationQuery)query, attributes);
        return this.getAll(query);
    }
}

