/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.groupproviders;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import se.unlogic.hierarchy.core.beans.MutableGroup;
import se.unlogic.hierarchy.core.handlers.SourceAttributeHandler;
import se.unlogic.hierarchy.core.interfaces.AttributeSource;
import se.unlogic.hierarchy.foregroundmodules.groupproviders.SimpleGroupAttribute;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.dao.annotations.Key;
import se.unlogic.standardutils.dao.annotations.OneToMany;
import se.unlogic.standardutils.dao.annotations.OrderBy;
import se.unlogic.standardutils.dao.annotations.Table;
import se.unlogic.standardutils.reflection.ReflectionUtils;

@Table(name="simple_groups")
public class SimpleGroup
extends MutableGroup
implements AttributeSource {
    private static final long serialVersionUID = -3158065010977262102L;
    public static final Field ATTRIBUTES_RELATION = ReflectionUtils.getField(SimpleGroup.class, (String)"attributes");
    private SourceAttributeHandler attributeHandler;
    @Key
    @DAOManaged(autoGenerated=true)
    protected Integer groupID;
    @DAOManaged
    @OrderBy
    protected String name;
    @DAOManaged
    protected String description;
    @DAOManaged
    protected boolean enabled;
    protected Integer providerID;
    @DAOManaged
    @OneToMany
    private List<SimpleGroupAttribute> attributes;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public Integer getGroupID() {
        return this.groupID;
    }

    @Override
    public void setGroupID(Integer groupID) {
        this.groupID = groupID;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return this.name + " (" + this.groupID + ")";
    }

    public Integer getProviderID() {
        return this.providerID;
    }

    public void setProviderID(Integer providerID) {
        this.providerID = providerID;
    }

    @Override
    public synchronized SourceAttributeHandler getAttributeHandler() {
        if (this.attributeHandler == null) {
            this.attributeHandler = new SourceAttributeHandler(this, 255, 1024);
        }
        return this.attributeHandler;
    }

    public List<SimpleGroupAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<SimpleGroupAttribute> attributes) {
        this.attributes = attributes;
    }

    @Override
    public void addAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<SimpleGroupAttribute>();
        }
        this.attributes.add(new SimpleGroupAttribute(name, value));
    }
}

