/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.groupadmin;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.annotations.ModuleSetting;
import se.unlogic.hierarchy.core.annotations.TextAreaSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.WebPublic;
import se.unlogic.hierarchy.core.beans.AttributeDescriptor;
import se.unlogic.hierarchy.core.beans.Breadcrumb;
import se.unlogic.hierarchy.core.beans.Group;
import se.unlogic.hierarchy.core.beans.MutableGroup;
import se.unlogic.hierarchy.core.beans.MutableUser;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleResponse;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.exceptions.UnableToUpdateUserException;
import se.unlogic.hierarchy.core.handlers.GroupHandler;
import se.unlogic.hierarchy.core.handlers.UserHandler;
import se.unlogic.hierarchy.core.interfaces.AttributeHandler;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleResponse;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.core.utils.AttributeDescriptorUtils;
import se.unlogic.hierarchy.core.utils.CRUDCallback;
import se.unlogic.hierarchy.core.utils.usergrouplist.UserGroupListConnector;
import se.unlogic.hierarchy.foregroundmodules.AnnotatedForegroundModule;
import se.unlogic.hierarchy.foregroundmodules.groupadmin.SimpleGroupFactory;
import se.unlogic.hierarchy.foregroundmodules.groupadmin.cruds.GroupCRUD;
import se.unlogic.hierarchy.foregroundmodules.groupproviders.SimpleGroup;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.factory.BeanFactory;
import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.BeanRequestPopulator;
import se.unlogic.webutils.http.RequestUtils;
import se.unlogic.webutils.http.URIParser;
import se.unlogic.webutils.populators.annotated.AnnotatedRequestPopulator;

public class GroupAdminModule
extends AnnotatedForegroundModule
implements CRUDCallback<User> {
    @ModuleSetting(allowsNull=true)
    @TextAreaSettingDescriptor(name="Supported attributes", description="The attributes to show in the form. The format is [name][*/!]:[display name]:[max length]:[StringFormatValidator] (without brackets). Only the name is required. The * sign indicates if the attribute is required or not. The ! sign indicates that the attribute is read only")
    protected String supportedAttributes;
    protected List<AttributeDescriptor> attributes;
    protected GroupCRUD<? extends GroupAdminModule> groupCRUD;
    protected UserGroupListConnector userGroupListConnector;

    @Override
    public void init(ForegroundModuleDescriptor moduleDescriptor, SectionInterface sectionInterface, DataSource dataSource) throws Exception {
        super.init(moduleDescriptor, sectionInterface, dataSource);
        this.groupCRUD = this.getGroupCRUD();
        this.userGroupListConnector = new UserGroupListConnector(this.systemInterface);
    }

    @Override
    protected void moduleConfigured() throws Exception {
        super.moduleConfigured();
        this.attributes = AttributeDescriptorUtils.parseAttributes(this.supportedAttributes);
    }

    protected GroupCRUD<? extends GroupAdminModule> getGroupCRUD() {
        AnnotatedRequestPopulator populator = new AnnotatedRequestPopulator(MutableGroup.class);
        populator.setBeanFactory((BeanFactory)new SimpleGroupFactory());
        return new GroupCRUD<GroupAdminModule>((BeanRequestPopulator<MutableGroup>)populator, "Group", "group", this);
    }

    @Override
    public ForegroundModuleResponse defaultMethod(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        return this.list(req, res, user, uriParser, null);
    }

    public ForegroundModuleResponse list(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser, List<ValidationError> validationErrors) throws Exception {
        this.log.info((Object)("User " + user + " listing groups"));
        Document doc = this.createDocument(req, uriParser, user);
        Element groupListElement = doc.createElement("Groups");
        doc.getFirstChild().appendChild(groupListElement);
        if (validationErrors != null) {
            XMLUtils.append((Document)doc, (Element)groupListElement, validationErrors);
        }
        XMLUtils.append((Document)doc, (Element)groupListElement, this.systemInterface.getGroupHandler().getGroups(false));
        XMLUtils.appendNewElement((Document)doc, (Element)groupListElement, (String)"canAddGroup", (Object)this.canAddGroup());
        return new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb());
    }

    @Override
    public Document createDocument(HttpServletRequest req, URIParser uriParser, User user) {
        Document doc = XMLUtils.createDomDocument();
        Element document = doc.createElement("Document");
        document.appendChild(RequestUtils.getRequestInfoAsXML((Document)doc, (HttpServletRequest)req, (URIParser)uriParser));
        document.appendChild(this.sectionInterface.getSectionDescriptor().toXML(doc));
        document.appendChild(((ForegroundModuleDescriptor)this.moduleDescriptor).toXML(doc));
        doc.appendChild(document);
        return doc;
    }

    @WebPublic(alias="show")
    public ForegroundModuleResponse showGroup(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        Group group;
        if (uriParser.size() != 3 || !NumberUtils.isInt((String)uriParser.get(2)) || (group = this.systemInterface.getGroupHandler().getGroup(NumberUtils.toInt((String)uriParser.get(2)), true)) == null) {
            return this.list(req, res, user, uriParser, Collections.singletonList(new ValidationError("RequestedGroupNotFound")));
        }
        this.log.info((Object)("User " + user + " viewing group " + group));
        Document doc = this.createDocument(req, uriParser, user);
        Element showGroupElement = doc.createElement("ShowGroup");
        doc.getFirstChild().appendChild(showGroupElement);
        Element groupElement = group.toXML(doc);
        showGroupElement.appendChild(groupElement);
        AttributeHandler attributeHandler = group.getAttributeHandler();
        if (attributeHandler != null && !attributeHandler.isEmpty()) {
            groupElement.appendChild(attributeHandler.toXML(doc));
        }
        this.appendShowFormData(group, showGroupElement, doc);
        XMLUtils.appendNewElement((Document)doc, (Element)showGroupElement, (String)"canAddGroup", (Object)this.canAddGroup());
        XMLUtils.append((Document)doc, (Element)showGroupElement, (String)"GroupUsers", this.systemInterface.getUserHandler().getUsersByGroup(group.getGroupID(), false, false));
        XMLUtils.append((Document)doc, (Element)showGroupElement, (String)"AttributeDescriptors", this.attributes);
        SimpleForegroundModuleResponse moduleResponse = new SimpleForegroundModuleResponse(doc, this.getTitlePrefix(), new Breadcrumb[0]);
        moduleResponse.addBreadcrumbFirst(this.getDefaultBreadcrumb());
        return moduleResponse;
    }

    protected void appendShowFormData(Group group, Element showGroupElement, Document doc) throws SQLException {
    }

    @WebPublic(alias="setusers")
    public ForegroundModuleResponse setUser(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        Group group;
        if (uriParser.size() != 3 || !NumberUtils.isInt((String)uriParser.get(2)) || (group = this.systemInterface.getGroupHandler().getGroup(NumberUtils.toInt((String)uriParser.get(2)), false)) == null) {
            return this.list(req, res, user, uriParser, Collections.singletonList(new ValidationError("UpdateFailedGroupNotFound")));
        }
        if (req.getMethod().equalsIgnoreCase("POST")) {
            this.setUsers(group, req);
            this.log.info((Object)("User " + user + " updated users of group " + group));
            this.redirectToDefaultMethod(req, res);
            return null;
        }
        this.log.info((Object)("User " + user + " updating users of group " + group));
        Document doc = this.createDocument(req, uriParser, user);
        Element showGroupElement = doc.createElement("SetGroupUsers");
        doc.getFirstChild().appendChild(showGroupElement);
        showGroupElement.appendChild(group.toXML(doc));
        UserHandler userHandler = this.systemInterface.getUserHandler();
        XMLUtils.append((Document)doc, (Element)showGroupElement, (String)"GroupUsers", userHandler.getUsersByGroup(group.getGroupID(), false, false));
        XMLUtils.append((Document)doc, (Element)showGroupElement, (String)"Users", userHandler.getUsers(true, false));
        SimpleForegroundModuleResponse moduleResponse = new SimpleForegroundModuleResponse(doc, this.getTitlePrefix(), new Breadcrumb[0]);
        moduleResponse.addBreadcrumbFirst(this.getDefaultBreadcrumb());
        return moduleResponse;
    }

    public void setUsers(Group group, HttpServletRequest req) {
        UserHandler userHandler = this.systemInterface.getUserHandler();
        List<User> currentUsers = userHandler.getUsersByGroup(group.getGroupID(), true, false);
        ArrayList postedUsersID = NumberUtils.toInt((String[])req.getParameterValues("user"));
        List<User> postedUsers = null;
        if (postedUsersID != null) {
            postedUsers = userHandler.getUsers(postedUsersID, true, false);
        }
        if (currentUsers != null && postedUsers == null) {
            this.removeUsersFromGroup(currentUsers, group);
        } else if (currentUsers == null && postedUsers != null) {
            this.addUsersToGroup(postedUsers, group);
        } else if (currentUsers != null && postedUsers != null) {
            ArrayList<User> removeList = new ArrayList<User>(currentUsers.size());
            ArrayList<User> addList = new ArrayList<User>(postedUsers.size());
            Iterator<User> currentUserIterator = currentUsers.iterator();
            while (currentUserIterator.hasNext()) {
                User user = currentUserIterator.next();
                if (postedUsers.contains(user)) continue;
                removeList.add(user);
                currentUserIterator.remove();
            }
            for (User user : postedUsers) {
                if (currentUsers.contains(user)) continue;
                addList.add(user);
            }
            this.removeUsersFromGroup(removeList, group);
            this.addUsersToGroup(addList, group);
        }
    }

    public void addUsersToGroup(List<User> users, Group group) {
        for (User currentUser : users) {
            if (!(currentUser instanceof MutableUser)) continue;
            if (currentUser.getGroups() != null) {
                currentUser.getGroups().add(group);
            } else {
                ((MutableUser)currentUser).setGroups(CollectionUtils.getList((Object[])new Group[]{group}));
            }
            try {
                this.systemInterface.getUserHandler().updateUser(currentUser, false, true, false);
                this.log.info((Object)("User " + currentUser + " added to group " + group));
            }
            catch (UnableToUpdateUserException e) {
                this.log.error((Object)("Error adding user " + currentUser + " to group " + group), (Throwable)e);
            }
        }
    }

    public void removeUsersFromGroup(List<User> users, Group bean) {
        if (users != null) {
            for (User currentUser : users) {
                if (!(currentUser instanceof MutableUser) || currentUser.getGroups() == null) continue;
                currentUser.getGroups().remove(bean);
                try {
                    this.systemInterface.getUserHandler().updateUser(currentUser, false, true, false);
                    this.log.info((Object)("User " + currentUser + " removed from group " + bean));
                }
                catch (UnableToUpdateUserException e) {
                    this.log.error((Object)("Error removing user " + currentUser + " from group " + bean), (Throwable)e);
                }
            }
        }
    }

    @Override
    public String getTitlePrefix() {
        return ((ForegroundModuleDescriptor)this.moduleDescriptor).getName();
    }

    public boolean canAddGroup() {
        return this.systemInterface.getGroupHandler().canAddGroupClass(SimpleGroup.class);
    }

    @WebPublic
    public ForegroundModuleResponse add(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        return this.groupCRUD.add(req, res, user, uriParser);
    }

    @WebPublic
    public ForegroundModuleResponse update(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        return this.groupCRUD.update(req, res, user, uriParser);
    }

    @WebPublic
    public ForegroundModuleResponse delete(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Exception {
        return this.groupCRUD.delete(req, res, user, uriParser);
    }

    @WebPublic(alias="users")
    public ForegroundModuleResponse getUsers(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws Throwable {
        return this.userGroupListConnector.getUsers(req, res, user, uriParser);
    }

    public GroupHandler getGroupHandler() {
        return this.systemInterface.getGroupHandler();
    }

    public UserHandler getUserHandler() {
        return this.systemInterface.getUserHandler();
    }

    public List<AttributeDescriptor> getSupportedAttributes() {
        return this.attributes;
    }
}

